package jcm.mod.ogas;

import jcm.core.*;
import static jcm.gui.gen.colfont.*;

import jcm.mod.data.*;
import jcm.mod.obj.futbasescen;
import jcm.mod.reg.region;
import jcm.mod.soc.*;
import jcm.mod.obj.controller;
import jcm.mod.carbon.carboncycle;



public class othgasemit extends module  {
    
    
  
    
    //*******************************************************
    //INTERACTIONS
    public void setinteractions() {
	follows(get(futbasescen.class), emitoption.chosen=="sresfix" || emitoption.chosen=="sresscale"); 
		// ||  ((region) (get(socreg.class).regions.chosen)).name.equals("EDGAR") ); this was for Match P1
	follows(get(controller.class), (emitoption.chosen=="sresscale" && get(controller.class).objective.chosen!="nopolicy") || emitoption.chosen=="2000scale");
    }
    
    //*******************************************************
    //PARAMETERS
    
    String[] emitoptions={	"sresfix", "sresscale", "2000fix", "2000scale"};
    
    public param
	    emitoption=new param("othgasemitoptions", emitoptions, "sresscale");
    
    
    
    //*******************************************************
    //PLOTARRAYS
    public qt
	    ch4emit=new qt( "ch4" , green ),
	    n2oemit=new qt( "n2o" , brown ),
	    soxemit=new qt( "sox" ,  blue ),
	    coemit=new qt(  "co" , dkgrey ),
	    vocemit=new qt( "voc" ,  yellowgreen ),
	    noxemit=new qt(  "nox",  orange);
    
    public qtset conc=new qtset( 	ch4emit, n2oemit, soxemit, coemit, vocemit, noxemit, "othgasemitcurves", "tera&gram&per&yr");
    
    
    //*******************************************************
    //LOOP CALCS
    
    public void initsetup() {
	//must come after loaddata
	//ch4emit, coemit, soxemit filled by loaddata
	//adjust methane to match sres at 2000
	for (int i=0; i<251; i++) ch4emit.a[i]*=323f/380f;
	//fill 1750-1860
	for (int j=0; j<110; j++) ch4emit.a[j]=ch4emit.a[110]*j/110f;
	//adjust soxemit to match sres at 1990 (70.9) and connect linearly to 2000 (69.0)
	for (int i=0; i<241; i++) soxemit.a[i]*=70.9f/soxemit.a[240];
	for (int i=241; i<251; i++) soxemit.a[i]=((i-240)*69.0f+(250-i)*soxemit.a[240])/10f;
	histnoxvoc();
	super.initsetup();
    }
    
    public void precalc() { scaleis92a();    }
    //note histn2o in atchem
    
    public void calcstep() {
	if (year>=2000) scalesresemit();
	
	//scaling N2O emissions prior to 1890
	if (((region) (get(socreg.class).regions.chosen)).name.equals("EDGAR") && year==1890)  {
	    float emit1890=get(socreg.class).emitn2o.calctot();
	    for (int n=0; n<=(1890-gsy); n++)  n2oemit.a[n]=emit1890*((float)n/(float)(1890-gsy));
	}
	
    }
    
    //*******************************************************
    //EMISSIONS
    //(future only)
    
    float scale; float[] scgas=new float[6];
    
    //scale is92a to same 2000 values as SRES to match TAR calculations
    float[][][] scgasdata={	sres.soxemit, sres.ch4emit, sres.n2oemit, sres.coemit, sres.vocemit, sres.noxemit};
    void scaleis92a() {	for (int i=0; i<6; i++) {
	if (get(futbasescen.class).scenario.getchosenindex()==6) scgas[i]=(float)(scgasdata[i][0][0]/scgasdata[i][6][0]);
	else scgas[i]=1f;
    }}
    
    void scalesresemit() {
	//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
	scale =1f;
	int sc=get(futbasescen.class).scenario.getchosenindex();
	if (year>2000 && emitoption.chosen=="sresscale") scale=get(carboncycle.class).fossil.a[ns]/(1000f*sres.interp(sres.fosemit, sc, year));
	if (year>2000 && emitoption.chosen=="2000scale" ) scale=get(carboncycle.class).fossil.a[ns]/get(carboncycle.class).fossil.a[250];
	
	int year1= (emitoption.chosen=="2000fix" ||  emitoption.chosen=="2000scale")  ? 2000 : year;
	
	soxemit.a[ns]=sres.interp(sres.soxemit, sc, year1)*scale*scgas[0];
	ch4emit.a[ns]=sres.interp(sres.ch4emit, sc, year1)*scale; //*scgas[1]; //scgas doesn't help for CH4 is92a!
	n2oemit.a[ns]=sres.interp(sres.n2oemit, sc, year1)*scale*scgas[2];
	coemit.a[ns]=sres.interp(sres.coemit, sc, year1)*scale*scgas[3];
	vocemit.a[ns]=sres.interp(sres.vocemit, sc, year1)*scale*scgas[4];
	noxemit.a[ns]=sres.interp(sres.noxemit, sc,  year1)*scale*scgas[5];
	
	//hfcs -note cfcs constant
	//interpolation unnecessarily complicated as only use in 5-yr intervals?
	int schfc=(sc<3 ? 0 : sc<7 ? sc-2 : 2); //all A1 same, for TGCIA450 use B1
	int yeara=ns+gsy+5, yearb=((emitoption.chosen=="sresfix" ||  emitoption.chosen=="sresscale") ? yeara : 2000);
	if ((yeara%5)==0 && yeara>1930 && yeara<=gey)
	    for (int g=0; g<12; g++) {
	    get(fgas.class).fgemit[g].a[(yeara/5)-386] =  (sc==6 && (g<4 || g>6)) ?  0 :  interpolator.interphfc(sres.hfcemit, g, schfc, yearb)*scale;
	    //note is92a only has data for 3 gases
	    }
    }
    
    //calculate historical nox & voc by scaling to CO, only for plot not further calculations
    
    void histnoxvoc() {
	noxemit.a[250]=sres.interp(sres.noxemit, 0, 2000);
	vocemit.a[250]=sres.interp(sres.vocemit, 0, 2000);
	for (int ns=0; ns<250; ns++) {
	    noxemit.a[ns]=noxemit.a[250]*coemit.a[ns]/coemit.a[250];
	    vocemit.a[ns]=vocemit.a[250]*coemit.a[ns]/coemit.a[250];
	}}
    
} //end class
