/*
F GASES (HFCs CFCs etc)

first 12 PFC/HFC emissions vary with sres, are included in kyoto etc.
SF6, CF4, C2F6, HFC23,   				(yearly data pre 1960-1989)
HFC134a, HFC152a, HFC125, 			(only 3 included in is92a, 152a not in sres)
HFC32, HFC143a, HFC227ea, HFC245ca, HFC4310mee,

14 montreal protocol gases (contain Cl/Br damages ozone)
concentrations prescribed by data, emissions calc by inverse
HCFC22, HCFC141b, HCFC142b, HCFC123, CH3CCl3, hcfcs h=> shorter lifetimes
CFC11, CFC12, CFC113, CFC114, CFC115, CCl4, cfcs
CF2BrCl, CF3Br, 							(br gases data to 2100 only)
EESCL 		effective equivalent stratospheric chlorine -affects ozone loss -data to 2100 only

note chemical formulae for CFCs: first digit = # C - 1 (missing if zero) ; second digit = # H + 1; third digit = # F

 P3 CHECK: is it right that EESCL starts so high?

 */

package jcm.mod.ogas;
import jcm.mod.data.*;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import java.awt.Color;
import jcm.mod.cli.radfor;

public class fgas extends module  {
    
    //*******************************************************
    //INTERACTIONS
    public void setinteractions() {
        follows(get(othgasemit.class)); //scaling
    }
    
    //PARAM
    
    public param strato3base1930=new param("o3s1930", false) { public void precalc() { cfcrf(); }    }; //if not 1930, 1970 as ipcc
    
    
    //*******************************************************
    //PLOTARRAYS
    public	qt[] fgemit=new qt[26], fgconc=new qt[26], fgrf=new qt[26];
    //fgas emit/conc/rf arrays in 5 year intervals from 1930 to end
    //filled in makeqt
    
    //totals below are in 1-year timesteps
    public	qt
            cfcrf= new qt( "cfc", pink),
            hfcrf= new qt("hfc" , magenta),
            strato3rf=new qt("strato3" , lilac),
            fgasrf= new qt( "fgas",  purple, qt.Type.total);
    
    public qtset emit, conc, rf;
    public qtset sumrf=new qtset(	cfcrf, hfcrf, strato3rf, fgasrf, this.name+"&rf&totals", "w&per&m2");
    
    
        /*
        //SCALES
        //xscale
        int[] fgy=new int[(gey-1925)/5]; for (int i=0; i<(gey-1925)/5; i++) fgy[i]=1930+i*5;
         */
    
    //LOOP CALCS
    //emit in get(othgasemit.class)?
    
    //unusually, this module has a constructor, so that qts exist before loaddata has to fill them
    public fgas() {
        makeqt();
    }
    
    public void initsetup() {
        super.initsetup(); //must come after made qt - so get put in list
        fgashist();
        cfcrf();
    }
    
    public void calcstep(){
        if (ns>=250) hfcconc();
        hfcrf();
        fgasrf.a[ns]=cfcrf.a[ns]+ hfcrf.a[ns]+strato3rf.a[ns] ;
    }
    
    
    //*******************************************************
    
    
    void makeqt() {
        //name and color based on chemical formulae
        Color gcolor; String gname;
        for (int g=0; g<26; g++) {
            if (g==25) {	gcolor=yellow; gname="eescl"; } else {
                //0=S 1=C 2=H 3=F 4=Cl 5=Br
                byte[] f=fo[g];
                float tot= f[2]+f[3]+f[4]+f[5], cs=(0.5f+f[1]+1.5f*f[0])/1.5f;
                float	green=f[3], blue=(f[4]+f[5])*(2f+1f/(1f+green)), red=f[2]*(2f+1f/(1f+green)),
                        max=(green>red ? green>blue ? green : blue : red>blue ? red : blue );
                gcolor=new Color(red/(cs*max),green/(cs*max),blue/(cs*max));
                gname=""; for (int i=0; i<6; i++) gname+= (f[i]>0 ? atom[i]+ (f[i]>1 ? String.valueOf(f[i]) :"") :"");
            }
            fgemit[g]=new qt(gname, gcolor, 1930, gey, 5); //new float[(gey-1925)/5],
            fgconc[g]=new qt(gname, gcolor, 1930, gey, 5);
            fgrf[g]=new qt(gname, gcolor, 1930, gey, 5);
        }
        emit=new qtset(fgemit, this.name+"&emit", "kilo&ton&per&yr");
        conc=new qtset(fgconc, this.name+"&conc", "ppt");
        rf=new qtset(fgrf, this.name+"&rf", "w&per&m2");
    }
    
    
    //note info below used to make labels and colors on plot
    public String[] atom={	"S","C","H","F","Cl","Br"};
    public byte[][] fo={
        {	1,0,0,6,0,0},{	0,1,0,4,0,0},{	0,2,0,6,0,0},{	0,1,1,3,0,0},
        {	0,2,2,4,0,0},{	0,2,4,2,0,0},{	0,2,1,5,0,0},
        {	0,1,2,2,0,0},{	0,2,3,3,0,0},{	0,3,1,7,0,0},{	0,3,3,5,0,0},{	0,5,2,10,0,0},
        {	0,1,1,2,1,0},{	0,2,3,1,2,0},{	0,2,3,2,1,0},{	0,2,1,3,2,0},{	0,2,3,0,3,0},
        {	0,1,0,1,3,0},{	0,1,0,2,2,0},{	0,2,0,3,3,0},{	0,2,0,4,2,0},{	0,2,0,5,1,0},{	0,1,0,0,4,0},
        {	0,1,0,2,1,1},{	0,1,0,3,0,1},
        {	0,0,0,0,1,0}
    };
    
    //radiative forcing impact W/m2/ppb, note concs in ppt (now including eescl!)
    double[] fgrfalpha={
        0.52, 0.08, 0.26, 0.16,
                0.15, 0.09, 0.23,
                0.09, 0.13, 0.30, 0.23, 0.40,
                0.20, 0.14, 0.20, 0.20, 0.06,
                0.25, 0.32, 0.30, 0.31, 0.18, 0.13,
                0.30, 0.32,
                -0.07317
    };
    
    //lifetime years
    double[] fglt={
        3200, 50000, 10000, 257,
                13.7, 1.4, 29.4,
                5.0, 51.6, 33.0, 5.9, 1.56,
                11.9, 9.3, 19, 1.4, 4.8,
                45, 100, 85, 300, 1700, 35,
                11, 65,
                0
    };
    
    //kiloton per ppt or Tg/ppb or Gt/ppm
    double[] fgktpppt={
        25.3, 15.3, 23.9, 12.1, 17.7, 10.9, 20.8, 8.56, 14.6, 29.5, 22.1, 41.5, //hfcs joos data slightly higher than equiv to CO2(C)=2.123 ?
                15.31, 20.71, 17.79, 32.92, 23.6, 24.34, 21.41, 33.17, 30.27, 27.35, 27.26, 29.28, 26.36, 0  //cfcs (used for inverse emit only) -scaled to C=2.123
    };
        /*
        chemical formulae for CFCs: first digit = # C - 1 (missing if zero); second digit = # H + 1; third digit = # F
        so mol mass xyz = 12(x+1) + (y-1) +19z +35.5(5+ 2x -y -z) = 188.5 + 83x -34.5y - 16.5z  Note Br=79.9
        F11 =137.5 , F12=121 , F113=187.5 , F114=171 , F115=154.5 ,
        F10(CCl4)=154, F140(CH3CCl3)=133.5,  F22 =86.5, F141=117, F142=100.5, F123=186
        CF2BrCl=165.4, CF3Br=148.9
         */
    
    float cf4natconc=44; //preindustrial background concn CF4 =44 ppt
    //cf4natemit=15.3*44f/50000f; 0.01 so small we can ignore compared to anthropogenic
    //note c4f10 removed as only in old sres-p
    //CH3Br = 9.06 ppt constant (so no rf?)
    
    //holds yearly concentration data for sf6, cf4, c2f6, hfc23 from 1960-1990
    public static final float[][] hfchistconc=new float[4][31];
    
    //***********************
    //HFCHIST
    void fgashist() {
        //historical concentrations for hfcs and cfcs
        //note original data for montreal gases 5-yr, and sres 10-yr intervals
        
        //1930-1955 -only CF4
        for (int i=0; i<6; i++) for (int g=0; g<12; g++) fgconc[g].a[i]= (g==1 ? cf4natconc :0);
        //1960-1990 -use historical conc data for first 4 gases, otherwise zero
        for (int i=6; i<13; i++) for (int g=0; g<12; g++) fgconc[g].a[i]= (g<4 ? hfchistconc[g][5*(i-6)] : 0);
        //data for 2000 for first six, otherwise zero, interpolate 1995
        float[] hfc2000={	4.4f, 80f, 3.1f, 15f, 10f, 0.5f};
        for (int g=0; g<6; g++) {	fgconc[g].a[14]=hfc2000[g]; fgconc[g].a[13]=(fgconc[g].a[14]+fgconc[g].a[12])/2f; }
        for (int g=6; g<12; g++) {	fgconc[g].a[14]=0; fgconc[g].a[13]=0; }
        
        //calc emissions by inverse: just history for hfcs, all for cfcs (except eescl)
        for (int g=0; g<25; g++) {
            if (g<12) fgemit[g].a[14]=(float)sres.hfcemit[g][0][0]; //but note different for hfc134a in is92a!
            else fgemit[g].a[(gey-1930)/5]=0;
            //hfcs 4-12 emissions zero pre 2000, 0.001 makes line start
            if (g>3 && g<12) {	for (int i=0; i<14; i++) fgemit[g].a[i]=0; fgemit[g].a[14]=0.001f; } else {	//not zero
                double fac1=Math.exp(-5.0/fglt[g]), fac2=(1.0-fac1)*fglt[g]/5.0;
                for (int i=(g<12 ? 13 : 73); i>=0; i--) {
                    double fac3=fgktpppt[g]*(fgconc[g].a[i+1]-fac1*fgconc[g].a[i]);
                    if (fac3>0.001) fgemit[g].a[i]=0.5f*(float)( (fac3 + fgemit[g].a[i+1]*fglt[g]*(fac2 - 1.0) ) / (fglt[g]*(fac2 - fac1)) );
                    else fgemit[g].a[i]=0;
                    if (fgemit[g].a[i]<0) fgemit[g].a[i]=0;
                }
            } //else
        } //g
        
        //smooth oscillations
        for (int g=0; g<25; g++) {
            float[] fgemit2=(float[])(fgemit[g].a.clone());
            for (int i=2; i<(g<12 ? 13 : 72); i++) fgemit[g].a[i]=(fgemit2[i-2] +4f*fgemit2[i-1] +6f*fgemit2[i] +4f*fgemit2[i+1] +fgemit2[i+2])/12f;
        }
    } //end fgashist
    
    //***********************
    //future hfc emissions=>concentration
    //calculates in 5 years steps AHEAD
    //(using reloh for starting year, but little difference)
    void hfcconc() {
        if ((year % 5)==0 && year>=2000) {
            int i=(year-1930)/5; if (i<(gey-1930)/5) {
                for (int g=0; g<12; g++) {
                    double deltaemit=(fgemit[g].a[i+1]-fgemit[g].a[i]);
                    double fglta=(g<4 ? fglt[g] : fglt[g]/get(atchem.class).reloh.a[ns]); //scale to reloh except for sf6, cf2, c2f6
                    double fac=Math.exp(-5.0/fglta);
                    fgconc[g].a[i+1]=(float)(fac*fgconc[g].a[i]+(fglta/fgktpppt[g])*(deltaemit+(1.0-fac)*(fgemit[g].a[i]-deltaemit*fglta/5.0)) );
                } //g
            }} //ifs
    } //end calchfc
    
    void cfcrf() {
        //if change eesclbaseyear, still get correct 2000rf
        float eesclbase=fgconc[25].a[((strato3base1930.istrue() ? 1930 : 1970)-1930)/5];
        fgrfalpha[25]=-0.15f*1000f/(fgconc[25].a[14]-eesclbase);
        //eescl scale to cfc12 after 2100
        for (int i=34; i<(gey-1925)/5; i++) fgconc[25].a[i]=eesclbase +(fgconc[25].a[34]-eesclbase)*fgconc[18].a[i]/fgconc[18].a[34];
        
        //calc radiative forcing
        for (int i=0; i<(gey-1925)/5; i++) {
            for (int g=12; g<25; g++) fgrf[g].a[i]=fgconc[g].a[i]*(float)fgrfalpha[g]/1000f;
            fgrf[25].a[i]=(fgconc[25].a[i]-eesclbase)*(float)fgrfalpha[25]/1000f;
            if (fgrf[25].a[i]>0) fgrf[25].a[i]=-0.0001f;
        }
        //fill cfcrf & strato3rf (interpolating linearly)
        for (int i=0; i<(gey-1925)/5; i++) {
            int ns=i*5+(1930-gsy);
            cfcrf.a[ns]=0; for (int g=12; g<25; g++) cfcrf.a[ns]+=fgrf[g].a[i];
            strato3rf.a[ns]=fgrf[25].a[i];
            if (i>0) for (int j=1; j<5; j++) cfcrf.a[ns-j]=(cfcrf.a[ns]*(5-j)+cfcrf.a[ns-5]*j)/5f;
            if (i>0) for (int j=1; j<5; j++) strato3rf.a[ns-j]=(strato3rf.a[ns]*(5-j)+strato3rf.a[ns-5]*j)/5f;
        }
    } //end  cfcrf
    
    void hfcrf() {
        //works in 5 year steps AHEAD (note concs also calculated 5yr ahead)
        if ((ns%5)==0) {
            int i=(ns+gsy-1930)/5;
            if (i>=-1 && i<(gey-1930)/5) {
                //calc radiative forcing
                hfcrf.a[ns+5]=0;
                for (int g=0; g<12; g++) {
                    fgrf[g].a[i+1]=(fgconc[g].a[i+1]-(g==1 ? cf4natconc : 0)) *(float)fgrfalpha[g]/1000f;
                    hfcrf.a[ns+5]+=fgrf[g].a[i+1];
                } //g
                if (i>=0) for (int j=1; j<5; j++) hfcrf.a[ns+j]=(hfcrf.a[ns]*(5-j)+hfcrf.a[ns+5]*j)/5f;
            }} //ifs
    } //end hfcrf
    
    
    
    //*******************************************************
}//end class


