/*
Other (non co2) greenhouse gases and aerosols,
CH4, N2O, O3, Nox, SOx, VOC, CO, SF6, HFCs, PFCs, CFCs, HCFCs
SRES Emissions which may be scaled to CO2 reduction)
Atmospheric chemistry including Ozone/OH
Radiative forcing for these gases
Applies formula from Bern-CC / IPCC WG1ch6

//Developed February 2002, Bern

P3 CHECK observation - switch off CH4 lifetime => concn starts too high =>temp spike =>co2 spike
 */
package jcm.mod.ogas;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.cli.radfor;

public class atchem extends module  {
    
    
    //*******************************************************
    //INTERACTIONS
    
    public void setinteractions() {
        follows(othgasemit.class);
    }
    
    //PARAMS
    public param
            oheffect=new param("OHef", true, expert), 	 //note this also controls N2O life
            taro3=new param("TARO3", false, expert);
    
    //PLOTARRAYS
    public qt
            ch4conc=new qt( "ch4", green ),
            n2oconc=new qt( "n2o" , brown ),
            tropo3du=new qt(  "tropo3du", grey ),
            reloh =new qt( "reloh" ,  dkgrey ); //OH relative to 2000
        
    public qt
            ch4rf= new qt( "ch4", green  ),
            n2orf= new qt("n2o" , brown),
            tropo3rf= new qt( "tropo3", grey),
            strath2orf= new qt( "strath2o" , yellowgreen ,  expert),
            othgasrf =new qt( "otherghg",  dkgreen, qt.Type.total );
    
    public qtset conc=new qtset( 	ch4conc, n2oconc, tropo3du, reloh, this.name+"&conc", "ppbppm");
    public qtset rf=new qtset(	ch4rf, n2orf, tropo3rf, strath2orf, othgasrf,  this.name+"&rf", "w&per&m2");
    
    
    
    //*******************************************************
    //LOOP CALCS
    
    //before step-loop
    public void initsetup() {
        super.initsetup();
        initialdata();
        rf.add(  get(fgas.class).fgasrf );
    }
    
    public void calcstep(){
        calcreloh();
        //used to fix historical concentrations of CH4, N2O, now vary them to show effect of lifetime, and for consistency with responsibility calculations
        if (ns>0) {	ch4conc(); n2oconc(); }
        if (ns>=250) tropo3conc();
        oghgrf();
        calctot();
    } //end calcstep
    
    
    //*******************************************************
    void initialdata() {	//put here because should come after loaddata precalc
        //need more precision than provided by loaddata if marginal d(rf)/d(conc) in responsibility
        //ppb 1750-2000
        float[] ch4concdata =	{732.46f, 733.18f, 733.89f, 734.59f, 735.29f, 735.97f, 736.65f, 737.31f, 737.96f, 738.60f, 739.23f, 739.85f, 740.46f, 741.05f, 741.64f, 742.22f, 742.78f, 743.34f, 743.90f, 744.44f, 744.97f, 745.50f, 746.02f, 746.54f, 747.05f, 747.56f, 748.06f, 748.56f, 749.05f, 749.54f, 750.03f, 750.51f, 751f, 751.49f, 751.99f, 752.49f, 753f, 753.51f, 754.03f, 754.57f, 755.11f, 755.67f, 756.25f, 756.84f, 757.44f, 758.07f, 758.71f, 759.38f, 760.07f, 760.78f, 761.51f, 762.28f, 763.08f, 763.90f, 764.76f, 765.65f, 766.57f, 767.51f, 768.48f, 769.48f, 770.49f, 771.53f, 772.58f, 773.65f, 774.74f, 775.84f, 776.95f, 778.08f, 779.21f, 780.36f, 781.51f, 782.68f, 783.85f, 785.02f, 786.20f, 787.38f, 788.57f, 789.75f, 790.93f, 792.12f, 793.29f, 794.47f, 795.63f, 796.79f, 797.94f, 799.07f, 800.20f, 801.31f, 802.40f, 803.47f, 804.53f, 805.56f, 806.59f, 807.59f, 808.59f, 809.59f, 810.58f, 811.58f, 812.59f, 813.60f, 814.63f, 815.68f, 816.74f, 817.82f, 818.93f, 820.06f, 821.20f, 822.36f, 823.54f, 824.74f, 825.95f, 827.18f, 828.43f, 829.70f, 830.98f, 832.27f, 833.59f, 834.91f, 836.26f, 837.62f, 839f, 840.39f, 841.80f, 843.24f, 844.69f, 846.17f, 847.66f, 849.19f, 850.73f, 852.31f, 853.91f, 855.55f, 857.21f, 858.92f, 860.66f, 862.44f, 864.27f, 866.14f, 868.06f, 870.04f, 872.07f, 874.15f, 876.30f, 878.51f, 880.78f, 883.12f, 885.53f, 888f, 890.55f, 893.16f, 895.85f, 898.61f, 901.44f, 904.35f, 907.33f, 910.39f, 913.53f, 916.75f, 920.04f, 923.42f, 926.87f, 930.41f, 934.03f, 937.74f, 941.53f, 945.41f, 949.38f, 953.43f, 957.58f, 961.82f, 966.15f, 970.59f, 975.12f, 979.75f, 984.49f, 989.34f, 994.30f, 999.39f, 1004.59f, 1009.93f, 1015.41f, 1021.03f, 1026.81f, 1032.75f, 1038.85f, 1045.13f, 1051.59f, 1058.24f, 1065.08f, 1072.13f, 1079.39f, 1086.87f, 1094.58f, 1102.53f, 1110.72f, 1119.17f, 1127.88f, 1136.86f, 1146.11f, 1155.65f, 1165.48f, 1175.60f, 1186.03f, 1196.76f, 1207.79f, 1219.13f, 1230.77f, 1242.71f, 1254.94f, 1267.47f, 1280.29f, 1293.39f, 1306.75f, 1320.37f, 1334.24f, 1348.35f, 1362.70f, 1377.27f, 1392.05f, 1407.03f, 1422.20f, 1437.53f, 1452.99f, 1468.57f, 1484.22f, 1499.92f, 1515.60f, 1531.23f, 1546.76f, 1562.13f, 1577.29f, 1592.20f, 1606.79f, 1621.02f, 1634.83f, 1648.17f, 1661.02f, 1673.37f, 1685.24f, 1696.69f, 1707.78f, 1718.63f, 1729.34f, 1723.5f, 1728.7f, 1733.9f, 1739.1f, 1744.3f, 1749.6f, 1754.8f, 1760.0f};
        //ppb 1750-2000 (data to 1998f, added last 2 by extrapolate)
        float[] n2oconcdata=	{271.68f, 271.70f, 271.72f, 271.74f, 271.77f, 271.79f, 271.81f, 271.84f, 271.86f, 271.88f, 271.91f, 271.93f, 271.95f, 271.98f, 272f, 272.02f, 272.05f, 272.07f, 272.09f, 272.12f, 272.14f, 272.17f, 272.19f, 272.21f, 272.24f, 272.26f, 272.29f, 272.31f, 272.34f, 272.36f, 272.38f, 272.41f, 272.44f, 272.46f, 272.49f, 272.51f, 272.54f, 272.56f, 272.59f, 272.62f, 272.64f, 272.67f, 272.70f, 272.72f, 272.75f, 272.78f, 272.81f, 272.83f, 272.86f, 272.89f, 272.92f, 272.95f, 272.98f, 273.01f, 273.04f, 273.07f, 273.10f, 273.13f, 273.16f, 273.19f, 273.22f, 273.26f, 273.29f, 273.32f, 273.36f, 273.39f, 273.43f, 273.46f, 273.50f, 273.53f, 273.57f, 273.61f, 273.64f, 273.68f, 273.72f, 273.76f, 273.80f, 273.84f, 273.88f, 273.92f, 273.96f, 274.01f, 274.05f, 274.09f, 274.14f, 274.19f, 274.23f, 274.28f, 274.33f, 274.37f, 274.42f, 274.47f, 274.52f, 274.57f, 274.63f, 274.68f, 274.73f, 274.79f, 274.84f, 274.90f, 274.96f, 275.01f, 275.07f, 275.13f, 275.19f, 275.25f, 275.32f, 275.38f, 275.44f, 275.51f, 275.57f, 275.64f, 275.71f, 275.78f, 275.85f, 275.92f, 275.99f, 276.07f, 276.14f, 276.22f, 276.29f, 276.37f, 276.45f, 276.53f, 276.61f, 276.69f, 276.78f, 276.86f, 276.95f, 277.03f, 277.12f, 277.21f, 277.30f, 277.39f, 277.49f, 277.58f, 277.68f, 277.77f, 277.87f, 277.97f, 278.07f, 278.18f, 278.28f, 278.38f, 278.49f, 278.60f, 278.71f, 278.82f, 278.93f, 279.05f, 279.16f, 279.28f, 279.40f, 279.52f, 279.64f, 279.76f, 279.88f, 280.01f, 280.14f, 280.27f, 280.39f, 280.53f, 280.66f, 280.79f, 280.93f, 281.07f, 281.20f, 281.34f, 281.48f, 281.63f, 281.77f, 281.91f, 282.05f, 282.20f, 282.34f, 282.48f, 282.63f, 282.77f, 282.92f, 283.07f, 283.21f, 283.36f, 283.51f, 283.66f, 283.81f, 283.97f, 284.13f, 284.28f, 284.45f, 284.61f, 284.78f, 284.95f, 285.13f, 285.32f, 285.51f, 285.70f, 285.90f, 286.11f, 286.33f, 286.55f, 286.78f, 287.02f, 287.28f, 287.54f, 287.81f, 288.09f, 288.38f, 288.69f, 289.01f, 289.34f, 289.68f, 290.04f, 290.42f, 290.80f, 291.21f, 291.63f, 292.07f, 292.52f, 292.99f, 293.48f, 293.99f, 294.52f, 295.06f, 295.63f, 296.21f, 296.82f, 297.45f, 298.10f, 298.77f, 299.47f, 300.18f, 300.92f, 301.68f, 302.45f, 303.24f, 304.03f, 304.82f, 305.61f, 306.39f, 307.16f, 307.93f, 308.69f, 309.44f, 310.19f, 310.92f, 311.65f, 312.38f, 313.11f, 313.83f, 314.55f, 315.27f}; //last 2 added
        for (int j=0; j<251; j++) ch4conc.a[j]=ch4concdata[j];
        for (int j=0; j<251; j++) n2oconc.a[j]=n2oconcdata[j];
        //loaddata also fills tropo3du
        for (int j=0; j<100; j++) tropo3du.a[j]=25; //fill gap before 1850
        histn2o();
        oghgrf0();
    }
    
    
    //*******************************************************
    //CHEMISTRY
    //CH4, CO, VOC, NOX, => OH, tropO3
    float tropo3prein=25;
    
    //calculate OH relative to 2000
    void calcreloh() {
        if (oheffect.istrue()) {
            //note ch4 <=> oh, calc oh first using previous year's ch4 projected
            float projectch4conc= ns>1 ? 2*ch4conc.a[ns-1]-ch4conc.a[ns-2] : ch4prein;
            othgasemit othgasemit=get(othgasemit.class);
            reloh.a[ns]= (float)Math.exp(
                    -0.32 * Math.log(projectch4conc/ch4conc.a[250])
                    +0.0042 *(othgasemit.noxemit.a[ns]-othgasemit.noxemit.a[250])
                    -0.000105 *(othgasemit.coemit.a[ns]-othgasemit.coemit.a[250])
                    -0.000315 *(othgasemit.vocemit.a[ns]-othgasemit.vocemit.a[250])
                    );
        } else reloh.a[ns]=1f;
    }
    
    //TROP O3 calculate tropospheric ozone (dobson units)
    void tropo3conc() {
        othgasemit othgasemit=get(othgasemit.class);
        tropo3du.a[ns]=tropo3du.a[250]+(float)(
                taro3.istrue() ? ( 	//coefficients used in TAR -too sensitive, can go below preindustrial level (hence rf<0) if emissions drop a lot
                6.7 * Math.log(ch4conc.a[ns]/ch4conc.a[250])
                +0.17 *(othgasemit.noxemit.a[ns]-othgasemit.noxemit.a[250])
                +0.0014 *(othgasemit.coemit.a[ns]-othgasemit.coemit.a[250])
                +0.0042 *(othgasemit.vocemit.a[ns]-othgasemit.vocemit.a[250])
                ) : ( 	//later corrected coefficients from Prather -see also Joos paper
                5.0 * Math.log(ch4conc.a[ns]/ch4conc.a[250])
                +0.125 *(othgasemit.noxemit.a[ns]-othgasemit.noxemit.a[250])
                +0.0011 *(othgasemit.coemit.a[ns]-othgasemit.coemit.a[250])
                +0.0033 *(othgasemit.vocemit.a[ns]-othgasemit.vocemit.a[250])
                )
                );
        if (tropo3du.a[ns]<0) tropo3du.a[ns]=0;
    }
    
    //N2O
    
    public float  ppbpmtn=0.20789f, n2oprein=272f;
    //n2o lifetime: affected by n2o concentration or emissions (as implied in IPCC / Joos / Prather ?)
    //float n2olife() {return 120f*(float)Math.pow((n2oconc.a[ns])/(n2oconc.a[250]),-0.055);}
    public float n2olife(int ns) {
        othgasemit othgasemit=get(othgasemit.class);
        return 120f * (oheffect.istrue() ? (float)Math.pow((n2oemitnat()+othgasemit.n2oemit.a[ns])/(n2oemitnat()+othgasemit.n2oemit.a[250]),-0.055) : 1f) ;
    } //note constant if OHeffect false - added for ACCC default
    
    public float n2oemitnat() {	return oheffect.istrue() ? 10.6f : 10.9f; /*9.5f*/ }
                        /*
                        n2o emit in 2000 is about 7.1,
                        so if no anthrop emissions, to balance n2oemitnat and n2olife (variable), need n2oemitnat()=10.6
                        but original figure from TAR methods was 9.5
                        if no feedback on lifetime, need to start with 10.9
                         */
    
    //calculate future n2o conc from emit
    void n2oconc() {
        n2oconc.a[ns]=n2oconc.a[ns-1]*(1f-1f/n2olife(ns-1))+ppbpmtn*(n2oemitnat()+get(othgasemit.class).n2oemit.a[ns]);
    }
    
    //calculate historical n2o emit from conc
    void histn2o() {
        for (int ns=250; ns>0; ns--) get(othgasemit.class).n2oemit.a[ns-1]=
                ( (n2oconc.a[ns]-n2oconc.a[ns-1]*(1f-1f/n2olife(ns))) /ppbpmtn)-n2oemitnat();
    }
    
    //CH4
    //puzzle regarding ppbpmtch4: derived from ppmpmtc should be 0.35325, joos paper has ppbpmtch4=0.3603, tar says 1/2.78 =0.35971
    public static float ppbpmtch4=0.36f, ch4prein=742.2f;
    
    public float ch4emitnat() {
        if (oheffect.istrue()) return 301f; //original TAR
        else return ch4prein  / (ch4life(0) *ppbpmtch4); //consistent with initial lifetime and concentration:
    }
    
    public float ch4life(int ns){	return 1f/((reloh.a[ns]/9.58f)+(1f/68.2f)); }
    
    void ch4conc() {	ch4conc.a[ns]=ch4conc.a[ns-1]*(1f-1f/ch4life(ns))+ppbpmtch4*(ch4emitnat()+get(othgasemit.class).ch4emit.a[ns]); }
    //note, if no OH effect, would need to use a different natural CH4 flux to start in steady state
    
    //*******************************************************
    //OGHG FORCING
    
    
    float overlap0, ch4rf0, n2orf0;
    
    void oghgrf0() {
        overlap0=overlap(ch4conc.a[0], n2oconc.a[0]);
        ch4rf0=(float)(0.036 * Math.pow(ch4conc.a[0],0.5));
        n2orf0=(float)(0.12 * Math.pow(n2oconc.a[0],0.5));
    }
    
    void oghgrf() {
        ch4rf.a[ns]=(float)(0.036*Math.pow(ch4conc.a[ns],0.5) -ch4rf0) -(overlap(ch4conc.a[ns],n2oconc.a[0])-overlap0);
        n2orf.a[ns]=(float)(0.12*Math.pow(n2oconc.a[ns],0.5) -n2orf0) -(overlap(ch4conc.a[0],n2oconc.a[ns])-overlap0);
        tropo3rf.a[ns]=(float) (0.042*(tropo3du.a[ns]-tropo3prein));
        strath2orf.a[ns]=-0.05f*ch4rf.a[ns];
    }
    
    //overlap between ch4 and n2o rf
    float overlap(float ch4, float n2o) {
        return (float)(0.47* Math.log(
                1.0 + 2.01e-5 * Math.pow(ch4*n2o,0.75)
                + 5.31e-15 * ch4 * Math.pow(ch4*n2o,1.52)
                ));
    }
    
    void calctot() {
        othgasrf.a[ns]= ch4rf.a[ns]+n2orf.a[ns] +tropo3rf.a[ns]+strath2orf.a[ns];
    }
    
} //end class




