/*
 STABILISATION
 
 ***************** Stabilisation Todo  *****************
OK P5 BUG  stabilisation kinks in 2002  - related to solar=>temperature and feedbacks, and initial gradients
OK P3 ENH Adapt Stabilisation to vary start slope in all variants (allow more cost-effective curve shape?)
P2 Document maths of stabilisation method
P1 CHECK when kyoto put back, adjust the stabemit integral (as old system)
P1 IDEA could add alternative stabemit quartic controlling half-way point
P1 IDEA adapt Stabilisation definition for Peaking then falling curves
P1 IDEA Idea for paper: Explore probabilistic for 1.5 and 2.5C?
 
(OLD INFO:)
stabilise emissions, concentration, forcing, temperature, SLR
Stabilise concentration can generate IPCC "S"/"WRE" scenarios, initially developed Arendal autumn 2001
stabilise temperature iteration method improved Bern March 2002, extended to forcing/SLR LLN March 2003
stabilise emissions originally developed spring 2000 based on GCI-C&C
 */

package jcm.mod.obj;
import jcm.core.*;
import jcm.mod.data.*;
import jcm.mod.math.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.*;
import jcm.mod.soc.*;

public class stabilisation extends module implements Runnable  {
    
    //*****************************************************
    //INTERACTIONS
    
    
    public void setinteractions() {
	follows(history.class);
	setaffectedby(get(controller.class).objective);
	//setaffectedby(get(shares.class), get(shares.class).kyotop.istrue());
	//setaffectedby(get(shares.class).kyotop);
	setaffectedby(get(carboncycle.class), indicator.chosen=="stabconc");
	setaffectedby(get(radfor.class), indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg");
	setaffectedby(get(glotemp.class), indicator.chosen=="stabtemp");
	setaffectedby(get(glotemp.class).baseyear, indicator.chosen=="stabtemp");
	setaffectedby(get(sealevel.class), indicator.chosen=="stabsea");
	setaffectedby(get(stabtempfuzzy.class), indicator.chosen=="stfuzzy");
	setaffects(get(stabtempfuzzy.class), indicator.chosen=="stfuzzy");
	affectsfutureonly=true;
	
	setaffectedby(stabyear, indicator.chosen== "stabconc"||  indicator.chosen== "stabrf&allghg"  || indicator.chosen== "stabrf&allghgaero"  || indicator.chosen== "stabtemp"  || indicator.chosen=="stfuzzy");
	setaffectedby(stabconcinitslope, indicator.chosen=="stabconc" ||  indicator.chosen== "stabrf&allghg"  || indicator.chosen== "stabrf&allghgaero"  || indicator.chosen== "stabtemp");
	setaffectedby(stabconclevel, indicator.chosen== "stabconc");
	setaffectedby(concscenmenu,  indicator.chosen== "stabconc");
	setaffectedby(stabrflevel,  indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg");
	setaffectedby(stabtemplevel, indicator.chosen=="stabtemp" || indicator.chosen=="stfuzzy");
	setaffectedby(wre, indicator.chosen!="constant"); //always, as default, just here for clarity
	setaffectedby(stabconcstartyear, wre.istrue());
	setaffectedby(stabemityear, indicator.chosen=="stabemit");
	setaffectedby(stabemitlevel, indicator.chosen=="stabemit");
	setaffectedby(sygrowth, indicator.chosen=="stabemit");
	setaffectedby(quartic, indicator.chosen=="stabemit");
	setaffectedby(integralgt, indicator.chosen=="stabemit" && quartic.istrue());
	setaffectedby(stabseayear, indicator.chosen== "stabsea");
	setaffectedby(stabsealevel, indicator.chosen== "stabsea");
	setaffectedby(damp, indicator.chosen== "stfuzzy");
    }
    
    //**************************************************
    //ADJUSTABLE PARAMETERS
    
    String[] indicators={	"stabemit", "stabconc",  "stabrf&allghg", "stabrf&allghgaero",  "stabtemp", "stabsea", "constant", "stfuzzy" };
    String[] concscenname={	"400ppm", "450ppm", "500ppm", "550ppm", "600ppm", "650ppm", "750ppm", "850ppm", "1000ppm", "user"};
    
    int[] concscenlevel={	400, 450, 500, 550, 600, 650, 750, 850, 1000};
    
    public param  indicator=new param("indicator", indicators, "stabconc") { public void precalc() {
	if (chosen=="reduceintensity") get(shares.class).kyotop.flag=false;
	resetguess();
    }   };
    
    //IPCC-scenario menu
    //P1 can be confusing, when the scenario menu not consistent with the chosen levels - should all have a precalc
    public param  	    concscenmenu=new param("stabconcmenu", concscenname, "user") {  public void precalc() { if (chosen!="user") {
	stabconclevel.setval(concscenlevel[getchosenindex()]);
	stabyear.setval(2100+(concscenlevel[getchosenindex()] -450)/2.0); //set endyear as a func of endlevel as per IPCC S/WRE
    } }   };
    
    public param
	    //for stabilise concentration, forcing, temperature
	    stabyear=new param("stabyear", "", 2125, 2030, (gey)-20), //stabilisation year
	    stabconclevel=new param("stabconc&atlevel", "ppm", 500, 300, 1000, stabyear), 	//final concentration
	    stabconcinitslope=new param("stabconcinitslope", "ppm&per&year&squared", 0.02, -0.1, 0.1, expert),
	    stabrflevel=new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, stabyear), 	//final total rf
	    stabtemplevel=new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, stabyear), 	//final temperature
	    
	    wre=new param("wreopt", false), 					//delay start year as Wigley-Richels-Edmonds proposal
	    stabconcstartyear=new param("stabconcstartyear", "", 2003, 1990, 2050, expert), 					//startyear fixed by WRE
	    
	    //for stabilise emissions
	    stabemityear=new param("stabemityear", "", 2080, 2010, (gey)-20), 	//stabilisation year
	    stabemitlevel=new param("stabemit&atlevel", "mega&ton&carbon&per&yr", 2000, 0, 12000, stabemityear), 		//final emissions
	    sygrowth=new param("initgrow", "percent&per&yr", 1.5, -3.5, 3.5, expert), 		//initial growth rate
	    quartic=new param("integralopt", false, expert),				//control integral (quartic curve)
	    integralgt=new param("integral", "giga&ton&carbon", 500, 150, 2000, expert),		//total emissions 2000-endyear in GtC
	    //P2 FIX note stabemit integral label incorrectly specifies to 2200!
	    
	    //for stabilise get(sealevel.class)
	    stabseayear=new param("stabseayear", "", 2250, 2030, (gey)-20, expert), //stabilisation year
	    stabsealevel=new param("stabsea&atlevel", "metres", 0.75, 0.5, 3.0, stabseayear, expert),	//final total rf
	    
	    damp=new param("dampopt", false,  expert); 						//use damping in fuzzy control
    
    
    //*****************************************************
    //MAIN LOOP CALCULATIONS
    
    public void precalc() {
	if (!running) setstartyear();
    }
    
    public void calcstep() {
	carboncycle carboncycle=get(carboncycle.class);
	/*
	 if start year,  set target stabilisation curves ( must be within calcstep loop as kyoto may affect start)
	note: for stabtemp sy >= get(glotemp.class).baseyear+3, to get baseyear offset correction right (done in climate module at baseyear+2)
	 */
	if (year==sy) {
	    if (indicator.chosen=="stabemit") emittarget((int)stabemityear.getval(), stabemitlevel.getval());
	    if (  indicator.chosen=="stabconc") conctarget((int)stabyear.getval(), stabconclevel.getval());
	    //what was this for? if (!get(carboncycle.class).histdeforbymassbal.istrue()) enclosing all conctarget method
	    
	    if  ((indicator.chosen=="stabtemp" ||  indicator.chosen=="stabrf&allghgaero" ||  indicator.chosen=="stabrf&allghg" || indicator.chosen=="stabsea")  ) {
		setlevel();  //do this even within iteration, in case parameters continuously adjusted by user
		if (!running) { initialguess(); new Thread(this).start(); }
		conctarget( scy, co2stab, co2stabslope, co2end); //make new target co2 curve
	    }
	}
	
	if (indicator.chosen=="stfuzzy") get(stabtempfuzzy.class).calcstep();
	
	if (year>=sy) {
	    
	    if (indicator.chosen=="stabemit") carboncycle.totemit.set(year, target[year-gsy]);
	    else  if (indicator.chosenname().startsWith("stab") ) carboncycle.totemit.set(year, carboncycle.inverseco2(target[ns], 1));
	    //(year-sy)<10 ? 5 : 1));
	    //try to remove initial oscillations (due to feedbacks) by averaging with emissions trend - doesn't help - just increases wavelength
	    //if ((year-sy)<=10)  get(carboncycle.class).totemit.set(year, (get(carboncycle.class).totemit.get(year)+2f*get(carboncycle.class).totemit.get(year-1) - get(carboncycle.class).totemit.get(year-2))/2f);
	    
	    if  (indicator.chosen=="constant")  carboncycle.totemit.set(year, carboncycle.totemit.get(year-1));
	    
	}
	
    } //end calcstep
    
    public void postcalc() {
	//correct target curve, and check whether goodenough
	if (indicator.chosen=="stabrf&allghgaero" ||  indicator.chosen=="stabrf&allghg" || (indicator.chosen=="stabtemp") || indicator.chosen=="stabsea") applycorrection();
    }
    
    //*****************************************************
    //target curve
    public float[] target= new float[glos2];
    float[] curvetocheck;
    
    //variables relating to initial gradient
    public int x0, sy=fsy;
    float y0, dy0, d2y0;
    
    //iteration variables to be remembered between calls
    double targetlevel=0;
    double co2stab=0, co2staborig=0, stabcor=1.0, oldstabcor=1.0;
    double co2stabslope=0, co2stabslopeorig=0, stabslopecor=1.0, oldstabslopecor=0;
    //double co2mid=0, co2midorig=0, midcor=1.0, oldmidcor=1.0;
    double co2end=0, co2endorig=0, endcor=1.0, oldendcor=1.0;
    //	double co2endslope=0, co2endslopeorig=0, endslopecor=1.0, oldendslopecor=0;
    double olditw=Float.MAX_VALUE, oldco2stab;
    
    int sys, scy;
    
    public boolean goodenough=false, running=false;
    public int stit=0; //number of iterations
    
    
    //**************************
    //INITIAL YEAR/GRADIENT
    
    void setstartyear() {
	//P1 CHECK land use in futbasescen now uses fsy instead of sy, this might cause problem in WRE/kyoto variants
	//set startyear for stabilisation curve, 2000 or after kyoto or after WRE delay
	sy=(get(shares.class).kyotop.istrue() ? 2013 : fsy);
	if (wre.istrue() && !get(shares.class).kyotop.istrue() ) delaystart();
    }
    
    void delaystart() {
/*
 P3 Tidyup WRE Delaystart, and make consistent with get(socreg.class) corrfac
	Old note?:  WRE started by following IS92a *(6.7/7.1) to connect with 2000 historical data
 */
	if (wre.changed) stabconcstartyear.setval(2002+(int)((stabconclevel.getval()-350.0)/23.0) );
	int dsy=(int)stabconcstartyear.getval();
	int oldsc=get(futbasescen.class).scenario.getchosenindex(); get(futbasescen.class).scenario.choose(6);
	for (int year=sy; year<=dsy; year++) get(carboncycle.class).fossil.a[year-gsy]=1000f*sres.interp(sres.fosemit, get(futbasescen.class).scenario.getchosenindex(), year)*(6.7f/7.1f);
	get(futbasescen.class).scenario.choose(oldsc);
	sy=dsy;
    }
    
    //work out initial gradient and d2y/dx2
    float[] gradient(qt q, int x0) {
	int  x0s=x0 - gsy;
	float y=q.a[x0s];
	/* if start before 2010 fix d2y0 to avoid effect of kinks in historical data
	 note this will only work for q=carboncycle.atppm
	 dy shouldn't be fixed because makes step in emissions if change carboncycle parameters, but we need to smooth it - use 5 years to avoid Pinatubo effect.
	 */
	float d2y= (x0s<260) ? (float)stabconcinitslope.getval()  /*0.02f 0.016f*/ :  (y -2f*q.a[x0s-1]+q.a[x0s-2]);
	float dy=2.5f*d2y + (q.a[x0s] - q.a[x0s - 5])/5f;
	return new float[] { y, dy, d2y};
    }
    
    
    //***************************************************
    //STABILISE EMISSIONS
    
    
    void emittarget(int xs, double ys) {
	double y0=get(carboncycle.class).totemit.get(sy), dy0=y0*sygrowth.getval()/100f;
	if (quartic.istrue()) mathcurve.quarticend(target, sy, xs, y0, dy0, ys, 0,  integralgt.getval()*1000f );
	else mathcurve.cubicend(target, sy, xs, y0, dy0, ys, 0) ;
	for (int x=xs; x<=gey; x++) target[x-gsy]= target[x-gsy]=(float)ys; //flat
    }
    
    
    //**************************
    //SET CONCN TARGET
    void conctarget(int xs, double ys) {	conctarget(xs, ys, 0, ys); }
    
    void conctarget(int xs, double ys,  double dys, double ye) {
	float[] gr=gradient(get(carboncycle.class).co2atppm, sy-1); //returns y0, dy0, d2y0
	//make the pade curve
	mathcurve.padequintic( target, sy-1,  xs, gr[0],  gr[1], gr[2], ys, dys, 0); //final 0 is d2ys
	//after CO2 stabilisation point
	if (xs<gey) {
	    if (dys==0 || (gey-xs<20)) for (int x=xs; x<=gey; x++) target[x-gsy]=(float)ye; //flat
	    else mathcurve.flatquadratic(target, xs, gey, ys, dys, ye);
	}
    } //end conctarget
    
	/* variants :
	growth 2000 = (7.77-4.20)*.471 =1.68 (emit-sink)*(ppmpgtc) ,	growth 1990 = (7.75-3.84)*.471 =1.84 ,	so d2y0 =  (1.68-1.84)/10 = -0.016
	could also fix dy0 =d2y0+1.65;
	double d2ys = padequartic( target, x0, xs, get(carboncycle.class).co2atppm[x0s],  dy0, d2y0, ys, dys);
	mathcurve.expdecay(target, xs, ys, dys, d2ys);
	mathcurve.simplepade (target, xs,  gey, ys, dys, d2ys, ye);
	 */
    
    //*****************************
    //STABILISE get(radfor.class) or TEMPERATURE by ITERATE CO2: guess CO2 stabilisation
    
    
    void setlevel() {
	if (indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg") {
	    curvetocheck= indicator.chosen=="stabrf&allghgaero" ? get(radfor.class).anthrorf.a : get(radfor.class).ghgrf.a;
	    targetlevel=stabrflevel.getval();
	    setstabconcyear(stabyear.getval());
	}
	if (indicator.chosen=="stabtemp") {
	    curvetocheck=get(glotemp.class).avchange.a;
	    targetlevel=stabtemplevel.getval()+get(glotemp.class).offset; //offset because model temperature relative to 1750 but parameter relative to baseyear!
	    setstabconcyear(stabyear.getval());
	}
	if (indicator.chosen=="stabsea") {
	    curvetocheck=get(sealevel.class).total.a;
	    targetlevel=stabsealevel.getval();
	    setstabconcyear(stabseayear.getval());
	}
    }
    
    void setstabconcyear(double stabconcyear) {
	sys=(int)stabconcyear-gsy;
	scy=fsy+(int)(1.0*(stabconcyear-fsy)); //note here can experiment setting co2 stab earlier than temp stab year
    }
    
    //**************************
    //INITIAL GUESS
    //initial guesses for CO2 concentration target curve for stabilise get(radfor.class) or temp iterations
    //if first step of iteration set co2stab, scy, co2end, co2slope (otherwise these reset in correct method called from postcalc)
    
    
    void initialguess() {
	if (indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg") {
	    guessconcfromrf( targetlevel *  get(radfor.class).totalrf.a[sys] /  (indicator.chosen=="stabrf&allghgaero" ? get(radfor.class).anthrorf.a[sys] : get(radfor.class).ghgrf.a[sys]));
	}
	if (indicator.chosen=="stabtemp") {
	    guessconcfromrf(guessrffromtemp(targetlevel));
	}
	if (indicator.chosen=="stabsea") {
	    guessconcfromrf(guessrffromtemp(guesstempfromsealevel(targetlevel)));
	}
	//		stabtemplevel.min=1.0-get(glotemp.class).offset; stabtemplevel.max=7.0-get(glotemp.class).offset; //set permitted range relative to 1750
    }
    
    
    
    double guesstempfromsealevel(double sealeveltarget) {
	return (get(sealevel.class).total.a[sys]>0 ?  get(glotemp.class).avchange.a[sys] * sealeveltarget / get(sealevel.class).total.a[sys] : 2.0); //first guess - assume get(sealevel.class) proportional to temperature (in same year) - if get(sealevel.class) not yet calculated guess 2
    }
    double guessrffromtemp(double stabtemplevel) {	//called from precalc() -before steps
	//first guess - use ratio temp/get(radfor.class) if already calculated once, else use climate sensitivity assuming equilibrium
	return stabtemplevel*(get(glotemp.class).avchange.a[sys]>0 ? get(radfor.class).totalrf.a[sys]  / get(glotemp.class).avchange.a[sys] : get(udebclimod.class).rfco2double.getval()/get(udebclimod.class).climsens.getval() );
    }
    
    void guessconcfromrf(double guesstotrf) {
	double co2rf = guesstotrf * (get(radfor.class).totalrf.a[sys]>0 ?  get(carboncycle.class).co2rf.a[sys] / get(radfor.class).totalrf.a[sys]  : 0.85); //guess CO2 rf is same frac as current, or 85% if first time
	
	co2staborig= get(carboncycle.class).atppmprein * Math.exp(Math.log(2.0) * co2rf /get(udebclimod.class).rfco2double.getval() ); //find corresponding co2 concentration
	
	//note: old corrections remembered from previous solution -faster when dragging control
	co2stab=co2staborig*oldstabcor;
	//if (co2stab<stabconclevel.min) {	co2stab=stabconclevel.min; debug("can't drop CO2 below "+stabconclevel.min); } 	//catch impossible target
	co2stabslopeorig=0;
	co2stabslope=oldstabslopecor;
	co2endorig=co2stab;
	co2end=co2endorig*oldendcor;
    }
    
    
    //**************************
    //APPLY CORRECTION
    //for iteration: correct according to calculated rf or temp, called from postcalc()
    
    void applycorrection() {
	
	//correct level in stabilisation year
	stabcor=targetlevel / curvetocheck[sys];
	
	//gradient should be flat at stabilisation point (check twenty years gradient)
	stabslopecor= -0.05*(curvetocheck[sys+10]-curvetocheck[sys-10])  / curvetocheck[sys-1];
	
	//end level should be same as stab level: (check penultimate step - note use actual stab level rather than target level)
	endcor=curvetocheck[sys] / curvetocheck[(gey-gsy)-1];
	
	//end gradient should be flat (check last twenty years gradient)
	//endslopecor = -0.05*(curvetocheck[(gey-gsy)-1]-curvetocheck[(gey-gsy)-21]) / curvetocheck[sys-1];
	
	
	co2stab=carboncycle.atppmprein+(co2stab-carboncycle.atppmprein)*stabcor; if (co2stab<300) co2stab=300;
	if (stit<=6 || stabslopecor/oldstabslopecor <1.0)  	co2stabslope+=stabslopecor * (co2stab-carboncycle.atppmprein); //only use if iteration 0 - 6 or correction is getting smaller - avoid instability
	co2end=carboncycle.atppmprein+(co2end-carboncycle.atppmprein)*endcor; if (co2end<300) co2end=300;
	//if (stit<=4 || endslopecor/oldendslopecor <1.0)  co2endslope+=endslopecor * (co2stab-carboncycle.atppmprein);
	
	//stop iteration if impossible targets
	boolean impossible=(Double.isInfinite(co2stab) || Double.isInfinite(co2end) || Double.isNaN(co2stab) || Double.isNaN(co2end) || co2stab<300 || co2end<300) ;
	
	goodenough=( impossible || (
		(stabcor<1.01) && (stabcor>0.99) 	&& (stabslopecor<0.01) && (stabslopecor>-0.01)
		&& (endcor<1.01) && (endcor>0.99)  //&& (endslopecor<0.05) && (endslopecor>-0.05)
		) )	;
	/*
	 (stabcor<1.005) && (stabcor>0.995) 	&& (stabslopecor<0.02) && (stabslopecor>-0.02)
	&& (endcor<1.005) && (endcor>0.995) // && (endslopecor<0.01) && (endslopecor>-0.01)
	 */
	
	stit++;
	savecorrect();
	
    } //end applycorrection
    
    
    void savecorrect() {	//saving oldcorrect  makes iteration faster if dragging arrow
	oldstabcor=co2stab/co2staborig; oldstabslopecor=(co2stabslope-co2stabslopeorig) /  (co2stab-carboncycle.atppmprein);
	//oldmidcor=co2mid/co2midorig;
	oldendcor=co2end/co2endorig; //oldendslopecor=(co2endslope-co2endslopeorig) /   (co2stab-carboncycle.atppmprein);
    }
    void resetcorrect() {	oldstabcor=1.0; oldstabslopecor=0; /*oldmidcor=1.0;*/ oldendcor=1.0; /* oldendslopecor=0; */ }
    void resetguess() {	resetcorrect(); goodenough=false; } //see climate module
    
    
    public void run() {
	running=true;
	System.out.println(	"Stabilisation iteratation starting");
	//Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	Thread.currentThread().yield();
	try {
	    while (loop.inmainloop)  Thread.currentThread().sleep(100);
	} catch (InterruptedException e) { System.out.println("stab loop interrupted");} ;
	
	
	while (!goodenough && stit<20) {
	    changed=true;    loop.changeinteractions=false; loop.go();
	}
	System.out.println(	"Stabilisation iteratated "+stit+" times");
	stit=0;
	running=false;
	/*if (objective.chosen=="stabsea") resetcorrect(); else */
    }
    
       /*
     info for debugging - put after calc goodenough
    + " STAB= " + aa(co2stab) 	+" corr= " + aa(stabcor) + " slope= " + aa(co2stabslope) +" corr= "+aa(stabslopecor) 	//+ "MID= " + aa(co2mid) +" corr= "+ aa(midcor)
    + " END= " + aa(co2end) +" corr= "+ aa(endcor) 	+ " slope= " + aa(co2endslope) +" corr= "+aa(endslopecor)
    +" ok? "+goodenough+"\n" );
	double aa(double d) {	return ((int) (d*10000.0))/10000.0; }
	*/
    
} //end stabilisation class.







