/*
OK P2 STRUC move futbasescen parameters to jcm.mod.obj?
P1 STRUC (in longer term) futbasescen code/qtsets belong in soc because it has regional detail (bottom-up), whereas topdown scenario choice should be in obj
P1 CHECK topdownscaling in futbasescen
P2 CHECK correct2000
P2 CHECK  fixedfrac effect
P2 STRUC move params (and code) related to stabilisation elsewhere?
 
 OK (elsewhere?) fixed regional future LUC for SRES and quota, using potentials
 OK P3 check regional potentials does not go negative! esp for  B1 and after 2100
 OK P4 fix LUC after 2100, uisng potentials
 P2 CHECK algebra of LUC scaling, eg should alpha be same for quota
 P2 table of parameters for LUC after 2100, consistent with each SRES
 P3 total emitfosquota start not accounting for bunker! = > step => spikes
 P2 put back fixed frac option for regional (works for global)
 
 P1 STRUC: move carbon stocks into socreg, or into carbonstorage plot?
P1 maybe "current" LUC emissions should be averaged over decade?
 */
package jcm.mod.obj;
import jcm.core.*;
import jcm.mod.reg.*;
import jcm.mod.data.*;
import static jcm.core.complexity.*;
import java.util.*;
import jcm.mod.carbon.CalcLucEmit;
import jcm.mod.carbon.carboncycle;
import jcm.mod.soc.*;

public class futbasescen extends module {
    
    public static qtset lucscenario = new qtset("LUC SRES", "mega&ton&carbon", 2000, 2100, experimental); //temporary, just to check totals OK
    
    public param scenario=new param("sresmenu", sres.scenname, "B2");
    public param correctstart=new param("correct2000fos", false), correctlucstart=new param("correct2000luc", true);
    public param extend=new param("extend", new String[] {	"fixed", "linear", "exp-const", "exp-reg"}, "exp-reg", experimental);
    
    public param potlucfrac=new param("potlucfrac%",  "", jcm.gui.gen.colfont.green, 1.0, 0, 2); //fraction of accumulated luc emissions that is potential sink in one year
    public param potlucconvergence=new param("potlucfracConverg%",  "", jcm.gui.gen.colfont.green, 1.0, 0, 5); //fraction of emissions/sink decrease
    public param fixedfrac=new param("fix luc/fossil stab", false, experimental);
    
    float globalcorrfac, globalcorrfacluc;
    int sc, scre, scp, scg, sce;
    Map<region, Float> popfac=new HashMap(), gpcfac=new HashMap(), epgfac=new HashMap();
    qtset emitfosbase, emitlucbase, emitlucquota, emitch4, emitn2o, pop, gdp, energy,
	    regpotlucbase, regpotlucquota; //delete globpotluc
    region regset;
    CalcLucEmit cle;
    interpolator  sreslucinterpolator, sresfosinterpolator;
    
    //*****************************
    //INTERACTIONS
    
    
    public void initsetup() {
	follows(get(history.class));
	setaffectedby(get(socreg.class).regions);
    }
    public void setinteractions() {
	setaffectedby(get(controller.class).objective);
	//for the total/fossil/landuse division
	follows(stabilisation.class, get(controller.class).objective.chosen=="stabilisation");
	follows(optimisation.class, get(controller.class).objective.chosen=="optimisation");
    }
    
    public void precalc() {

	scenequiv();
	
	socreg socreg=get(socreg.class); cle=get(CalcLucEmit.class);
	emitfosbase=socreg.emitfosbase;
	emitlucbase=socreg.emitlucbase;
	emitch4=socreg.emitch4; emitn2o=socreg.emitn2o;
	emitlucquota=socreg.emitlucquota;
	
	pop=socreg.pop; gdp=socreg.gdp; energy=socreg.energy;
	regset=(region)socreg.regions.chosen;
	sresreg=regman.allreg.find("SRES4");
	sreslucinterpolator=new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f);
	sresfosinterpolator=new interpolator(sres.sres4fos, "SRES4", 1990, 10, scre, 1000f);
	
	regpotlucbase=socreg.regpotlucbase; //delete
	regpotlucquota=socreg.regpotlucquota; //delete
	
	new interpolator(sres.jcm12pop, "JCM12IMAGE", 2000, 10, scp, 1f).fill(pop, regset, 2003, 2100, history.hydepop);
	new interpolator(sres.jcm12gdppc, "JCM12IMAGE", 2000, 10, scg, 1f).fill(gdp, regset, 2001, 2100, history.hydepop);
	new interpolator(sres.jcm12enpc, "JCM12IMAGE", 2000, 10, sce, 1f).fill(energy, regset, 2001, 2100, history.hydepop);
	new interpolator(sres.jcm12fos, "JCM12IMAGE", 2000, 10, scre, 1f).fill(emitfosbase, regset, 2003, 2100, history.fosCO2);
//	new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 2003, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 1991, 2100, histdata.lucCO2);
//    new interpolator(sres.sres4luc, "SRES4", 2002, 10, scre, 1000f).fill(emitluc, regset, startscenluc, 2100, CalcLucEmit.lucCO2IVIG);
	new interpolator(sres.sres4ch4, "SRES4", 1990, 10, scre, 1f).fill(emitch4, regset, 2001, 2100, history.hydepop);
	new interpolator(sres.sres4n2o, "SRES4", 1990, 10, scre, 1f).fill(emitn2o, regset, 2001, 2100, history.hydepop);
	
	//note: no longer using sres4 fos, pop, gdp
	
    }
    
    //***********************************************
    public void calcstep() {
	if (year<fsy) for (region r : regset.reg)  emitlucquota.set(r, emitlucbase.get(r));
	if (year==cle.startscenluc-1) calcweights();
	if (year>=cle.startscenluc && year<=2100) getsresdata();
	
	if (year==fsy) globpotlucemitquota=globpotlucemitbase;
//note we have to calculate scaledown based on previous year, because there is a feedback (luc=>fossil=>sd=>luc)
	scaledown= (get(carboncycle.class).lucf.get(year-1)+ globpotlucemitquota) / (globlucemitbase+globpotlucemitbase);
	
//	    if (year>2000 && year<2010) System.err.println(year+" " +scaledown+" "+globpotlucemitquota+" "+globlucemitbase+" "+globpotlucemitbase);
	if (year>=cle.startscenluc) regluc();
	
	
	/*
	 P2 tidy up duplicate SRES data here
	 top-down scaling for fossil and luc emissions because sres4 data was not consistent with TAR sres totals (due to correction in TAR)
	  note for CH4 and N2O  top-down scaling  -see also othgasemit and shares
	 */
	
	if (year>=fsy && year<=2100) { //
	    if (year==fsy) globalcorrfac=1000f*sres.interp(sres.fosemit, sc, 2002) - emitfosbase.calctot(2002);
	    globfosemitbase=1000f*sres.interp(sres.fosemit, sc, year) -(correctstart.istrue() ?  globalcorrfac : 0);
	    globlucemitbase=1000f*sres.interp(sres.lucemit, sc, year);
	    topdownscale(emitfosbase, globfosemitbase);
	    topdownscale(emitlucbase, globlucemitbase);
	}
	if (year>=2100) sresext();
	if (year>=2000) {pop.calctot(); energy.calctot(); gdp.calctot(); globfosemitbase = emitfosbase.calctot(); }
	if (year>=fsy) globalco2(); //this sets fossil => emitfosquota in shares
	
	//temporary, for checking original SRES LUC
	if (year>=2000 && year<=2100) for (region sr : sresreg.reg)    lucscenario.set(sr, sreslucinterpolator.getdata(sr, year));
	if (year==2000) lucscenario.reg(regman.allreg.find("TOTAL")).type=qt.Type.total;
	
    }
    
    //***********************************************
    //GLOBAL CO2 EMISSIONS AND FUTURE LANDUSE
    Map<region, Float> potlucregbase=new HashMap(),  potlucregquota=new HashMap(),  potlucsres=new HashMap(), srinitial=new HashMap(), sreslucemit=new HashMap(), sresfosemit=new HashMap(), potbiomestock=new HashMap();
    Map<region, Map<region, Float>> weight=new HashMap();
    region sresreg;
    float alpha, trend, scaledown, globfosemitbase, globlucemitbase, globlucemitquota, globpotlucemitbase, globpotlucemitquota;
    
    void getsresdata() {
	//might simplify using qtset calctot() methods instead, if first import into qtsets, noting to avoid "TOTAL"
	
	globfosemitbase=0; globlucemitbase=0; globpotlucemitbase=0;
	
	for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
	    sreslucemit.put(sr,sreslucinterpolator.getdata(sr, (year < 2100 ? year : 2100)));
	    sresfosemit.put(sr,sresfosinterpolator.getdata(sr, (year < 2100 ? year : 2100)));
	    potlucsres.put(sr, potlucsres.get(sr) +  sreslucemit.get(sr) * (float)potlucfrac.getval()/100f );
	    globlucemitbase+=sreslucemit.get(sr);
	    globfosemitbase+=sresfosemit.get(sr);
	    globpotlucemitbase+=potlucsres.get(sr);
	}
    }
    
    public void globalco2() {
	
	qt fossil=get(carboncycle.class).fossil, lucf=get(carboncycle.class).lucf, totemit=get(carboncycle.class).totemit;
	
	if (get(controller.class).objective.chosen.equals("nopolicy")) {
	    fossil.set(globfosemitbase);
	    
	    lucf.set(globlucemitbase);
	    
	    totemit.set(fossil.get()+lucf.get());
	    
	    for (region r : regset.reg) {
		potlucregbase.put(r, potlucregbase.get(r)+emitlucbase.get(r,year-1)*(float)potlucfrac.getval()/100f);
		potlucregquota.put(r, potlucregbase.get(r)); //same for no-policy
	    }
	} else {
	    //stabilisation or optimisation, assume totemit has been set
	    //P2 CHECK this is OK with optimisation!
	    
	    globpotlucemitquota=0;
	    for (region r : regset.reg) {
		potlucregbase.put(r, potlucregbase.get(r)+emitlucbase.get(r,year-1)*(float)potlucfrac.getval()/100f);
		potlucregquota.put(r, potlucregquota.get(r)+emitlucquota.get(r,year-1)*(float)potlucfrac.getval()/100f);
		
		globpotlucemitquota+=potlucregquota.get(r);
	    }
	    
	    alpha=(globlucemitbase+globpotlucemitbase)/globfosemitbase;
	    
	    lucf.set(
		    fixedfrac.istrue()  ?  totemit.get()*lucf.get(fsy-1)/totemit.get(fsy-1)
		    :  (year<=2100)  ?     (totemit.get()*alpha - globpotlucemitquota)/(1f+alpha)
		    :   globlucemitquota
		    );
	    
	    //correct for jump in LUC scenario vs history, fade out correction 5% per year
	    globalcorrfacluc= (year==fsy) ? lucf.get()-lucf.get(year-1) : globalcorrfacluc*0.95f;
	    if(correctlucstart.istrue() && !fixedfrac.istrue() ) lucf.set(lucf.get()- globalcorrfacluc);
	    
	    fossil.set(totemit.get() -lucf.get());
	    
	    if (fossil.get()<0) { fossil.set(0); lucf.set(totemit.get()); }
	    
	}
    }
    
    void regluc() {
	//regional, sres and stabn

	if (year<=2100 ) {
	    for (region r : regset.reg) { // is it neceessary? it can be in the central loop
		emitlucbase.set(r,  - potlucregbase.get(r));
		emitlucquota.set(r, - potlucregquota.get(r));
	    }
	    
	    for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
		
		trend =  (sreslucemit.get(sr) + potlucsres.get(sr)) /  srinitial.get(sr);
//		System.err.println(year+" "+scaledown+" "+trend);
		
		for (region r : regset.reg) {
		    emitlucbase.set(r, emitlucbase.get(r) + weight.get(r).get(sr) * trend );
		    emitlucquota.set(r, emitlucquota.get(r) + weight.get(r).get(sr) * scaledown * trend );
		    regpotlucbase.set(r, potlucregbase.get(r)); //delete
		    regpotlucquota.set(r, potlucregquota.get(r)); //delete
		}
	    }
	} // if <=2100 under SRES
	
	if (year>2100){
	    globlucemitbase=0; globlucemitquota=0;
	    for (region r : regset.reg) {
		float factorbase = emitlucbase.get(r, year-1) < -potlucregbase.get(r) ? 1f : (float)potlucconvergence.getval()/100f;
		float factorquota = emitlucquota.get(r, year-1) < -potlucregquota.get(r) ? 1f : (float)potlucconvergence.getval()/100f;
		if (potlucregbase.get(r)>0)
		    emitlucbase.set(r, emitlucbase.get(r, year-1) - factorbase *( potlucregbase.get(r) + emitlucbase.get(r, year-1)));
		if (emitlucbase.get(r, year)<0 && potlucregbase.get(r)<=0) emitlucbase.set(r,0);
		
		if (fixedfrac.istrue() ) emitlucquota.set(r, emitlucquota.get(r, year-1)*get(carboncycle.class).lucf.get()/get(carboncycle.class).lucf.get(year-1));
		
		else if (potlucregquota.get(r)>0)
		    emitlucquota.set(r, emitlucquota.get(r, year-1) - factorquota *( potlucregquota.get(r) + emitlucquota.get(r, year-1)));
//		    	emitlucquota.set(r, -potlucreg.get(r) + emitlucbase.get(r,year-1) * (float)potlucfrac.getval()/100f * scaledown);
		
		
		if (emitlucquota.get(r, year)<0 && potlucregquota.get(r)<=0) emitlucquota.set(r,0);
		
		potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year)*(float)potlucfrac.getval()/100f);
		potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year)*(float)potlucfrac.getval()/100f);
		
		regpotlucbase.set(r, potlucregbase.get(r) ); //delete?? Ben has suggested to keep it for checking and explanations
		regpotlucquota.set(r, potlucregquota.get(r) ); //delete?? Ben has suggested to keep it for checking and explanations
		
		globlucemitbase+=emitlucbase.get(r);
		globlucemitquota+=emitlucquota.get(r);
	    }
	}//year>2100
    } //regluc
    
    void calcweights() {
	
	for (region r : regset.reg) {
	    weight.put(r, new HashMap<region, Float>());
	    for (region sr : sresreg.reg) weight.get(r).put(sr, 0f);
	    for (region rr : r.subreg(regman.nations)) {
		//fix for cait/houghton
		for (region sr : sresreg.reg)  if (sr.contains(rr)) weight.get(r).put(sr, weight.get(r).get(sr) +
			cle.potluc.get(rr) * (float)potlucfrac.getval()/100f +(cle.lucsource.chosen.equals("IVIGmodel") ? cle.lucemit.get(rr, cle.startscenluc-1)/1000f : 0f)
			);
	    }
//	    for (region sr : sresreg.reg) System.err.println(""+r+" "+sr+" "+weight.get(r).get(sr));
	} //r
	
	//fill srespotluc and regpotluc
	for (region sr : sresreg.reg) {
	    potlucsres.put(sr,0f);
	    for (region rr : sr.subreg(regman.nations)) {
		potlucsres.put(sr, potlucsres.get(sr)+ cle.potluc.get(rr) * (float)potlucfrac.getval()/100f );
	    }
	    //OK fix for cait/houghton
	    float emitlucsresbase=0; for (region rr : sr.subreg(regman.nations)) emitlucsresbase+= cle.lucemit.get(rr, cle.startscenluc-1)/1000f;
	    srinitial.put(sr, emitlucsresbase+potlucsres.get(sr));
	}
	
	for (region r : regset.reg) {
	    potlucregbase.put(r,0f);
	    
	    for (region rr : r.subreg(regman.nations)) {
		potlucregbase.put(r, potlucregbase.get(r)+ cle.potluc.get(rr) * (float)potlucfrac.getval()/100f );
	    }
	    potlucregquota.put(r, potlucregbase.get(r));
	}
	
    }
    
//********************************
//SRES extension beyond 2100 for fossil
    void sresext() {
	for (region r : regset.reg)  {
	    pop.setreg(r); gdp.setreg(r); energy.setreg(r); emitfosbase.setreg(r);
	    
	    //calculate rates of change at end of SRES
	    if (year==2101) {
		if (extend.chosen.equals("linear")) {
		    popfac.put(r, (pop.get(2100) - pop.get(2090))/10f);
		    gpcfac.put(r, ((gdp.get(2100)/pop.get(2100)) - (gdp.get(2090)/pop.get(2090)) )/10f);
		    epgfac.put(r, ((emitfosbase.get(2100)/gdp.get(2100)) - (emitfosbase.get(2090)/gdp.get(2090)) )/10f);
		}
		if (extend.chosen.equals("exp-const") || extend.chosen.equals("exp-reg")  ){
		    popfac.put(r, pop.get(2100) / pop.get(2099));
		    gpcfac.put(r, (gdp.get(2100)/pop.get(2100)) / (gdp.get(2099)/pop.get(2099)));
		    epgfac.put(r, (emitfosbase.get(2100)/gdp.get(2100)) / (emitfosbase.get(2099)/gdp.get(2099)));
		}
	    }
	    
	    if (year>2100) {
		if (extend.chosen.equals("fixed")) {	//could replace this with linear and facs set to zero
		    pop.set(pop.get(year-1));
		    gdp.set(gdp.get(year-1));
		    energy.set(energy.get(year-1));
		    emitfosbase.set(emitfosbase.get(year-1));
		    
		}
		if (extend.chosen.equals("linear")) {
		    pop.set(pop.get(year-1)+popfac.get(r));
		    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1)+gpcfac.get(r)));
		    emitfosbase.set(gdp.get()*(emitfosbase.get(year-1)/gdp.get(year-1)+epgfac.get(r)));
		}
		if (extend.chosen.equals("exp-const") || extend.chosen.equals("exp-reg")  ){
		    pop.set(pop.get(year-1)*popfac.get(r));
		    gdp.set(pop.get()*(gdp.get(year-1)/pop.get(year-1))* gpcfac.get(r));
		    emitfosbase.set(gdp.get()*(emitfosbase.get(year-1)/gdp.get(year-1))*epgfac.get(r));
		}
		
		if (extend.chosen.equals("exp-reg") ){
		    float gpc=gdp.get()/pop.get();
		    popfac.put(r, (1f-sfpop)*popfac.get(r)+ sfpop*(popreg1-popreg2*(float)Math.log(gpc)));
		    gpcfac.put(r,  (1f-sfgpc)*gpcfac.get(r)+ sfgpc*(1f+gpcgrow0[sc]*(float)Math.exp(-gpc*gpcgrowk[sc])));
		    epgfac.put(r, (1f-sfepg)*epgfac.get(r)+ sfepg*(1f+epggrow0[sc]*(float)Math.exp(-gpc*epggrowk[sc])));
		}
		
		
	    } //>2100
	} //reg
	
    } //sresext
    
//**************************************
    void topdownscale(qtset regional, float global) {
	float regtot=regional.calctot();
	if (regtot>0) for (qt q : regional.map.values()) q.set(q.get()*global/regtot);
    }
    
//**************************************
    
    void scenequiv() {
	sc=scenario.getchosenindex();
	scre= (sc==7 ? 4 : sc==6 ? 0  : sc); // use A1B for IS92A, B1 for TCGIA450 regional
	if (sc<8) {
	    scp=(sc==3 ? 1 : sc==5 ? 2 : 0); //pop is same for all A1+B1 (and TGCIA450)
	    scg=(sc==7 ? 2 : sc==6 ? 0  : sc>2 ? sc-2 : 0); //gdp is same for all A1T,F,B, IS92A, for TCGIA450 use B1
	    sce=(sc==7 ? 4 : sc==6 ? 0  : sc); //energy use A1B for IS92A, B1 for TCGIA450
	}
    }
    
//***************************************************
// regressions based on 2045-2095 (all 12 JCM regions together), for six scenarios A1B, T, F, A2, B1, B2
    float[] gpcgrow0={	0.075f, 0.075f, 0.075f, 0.030f, 0.064f, 0.030f }; //growth in gdp/cap (frac) if gdp/cap=0
    float[] gpcgrowk={	0.0143f, 0.0143f, 0.0143f, 0.0179f, 0.0255f, 0.0179f }; //exp decay rate of growth as function of 0.001*gdp/cap
    float[] epggrow0={	-0.033f, -0.037f, -0.025f, -0.018f, -0.042f, -0.018f }; //decline in emit/gdp (frac) if gdp/cap=0
    float[] epggrowk={	0.00606f, 0.00114f, 0.00916f, 0.0128f, 0.0110f, 0.00944f }; //exp decay rate of decline as function of 0.001*gdp/cap
    
    
    float popreg1=1.013f , popreg2=0.004f; //as gpcreg but for popn growth, based on B2 scenario only
//note: for other scenarios there is no clear correlation
//eventually should replace these with UN2300 scenarios
    
    float sfgpc=0.05f, sfepg=0.05f, sfpop=0.02f; // amount by which growth rates tend towards regression function each year
    
    
} //end class


