//loads historical and sres data
/*
P2 Aim to load data from textfiles, abandon old loaddata (although keep compression/uncompression methods) see also data.todo

 othergas emissions & concentrations, 
 temperature-data & proxy, (needs updating anyway, inc new hockey-sticks)
 historical gdp & en, (could easily replace by gdp from elsewhere?)
 sres global, 12-regional (soc&fos), 4regional (othgas), IPCC-TAR data for circles
 
P2 CHECK Old Loaddata notes
What need to replace with text files before can get rid of it?
Maybe can split by receiving module

Hist-global emit CO2, LUCO2, CH4, SOX, CO
Hist-global conc CO2, N2O, O3, HFC, CFC, 
Hist global RF Solar, Volcano
Hist global temp -measured, proxy

Hist-JCM12 CO2, pop, gdp, en
Hist-EDGAR  CH4, N20, LUC

Note also the matchdata class
CH4fos, luc, n2o, ch4 for 13 regions, 1890-1970 in 10yr blocks, then every year until 2100 (for scenario A2)

SRES IMAGE regional emit CO2, POP, GDP/cap, EN/cap
SRES 4-region CO2, CO2LUC, CH4, N2O, POP, GDP

SRES IPCC global emit CO2, LUCO2, SOX, CH4, N2O, NOX, CO, VOC, HFC
SRES IPCC global conc, rf, temp: BERN-C02, 10x forcings, global temp

 *
 */  

package jcm.mod.data;
import java.io.*;
import jcm.core.*;
import jcm.tls.fileio;
import jcm.mod.*;
import jcm.mod.soc.*;
import jcm.mod.carbon.*;
import jcm.mod.ogas.*;
import jcm.mod.cli.glotemp;

public class loaddata  {
    
    static DataInputStream datain;
    

    
    public static void getdata(world w)  {	try {
	

	datain = fileio.getDIS("data/data.dat");
	
	//historical global
	loadarray(null);
        loadarray(null);
//        loadarray(w.get(carboncycle.class).fossil.a,110);
//	loadarray(w.get(carboncycle.class).lucf.a,100); //1850-1990
	
	loadarray(w.get(othgasemit.class).ch4emit.a,110);
	loadarray(w.get(othgasemit.class).soxemit.a,100);
	loadarray(w.get(othgasemit.class).coemit.a,15);
	
        loadarray(null);
//	loadarray(carboncycle.co2atppmdata.a,110); //note this now inside carboncycle code
	
	loadarray(w.get(atchem.class).ch4conc.a);
	loadarray(w.get(atchem.class).n2oconc.a);
	loadarray(w.get(atchem.class).tropo3du.a,100);
	
	loadarray2(fgas.hfchistconc);  
	loadarrayQ(w.get(fgas.class).fgconc,12,0); //startyr 1930=0 cfcs 12-26
	
	loadarray(aerosol.solarrfdata);
	loadarray(aerosol.volcorig);
	
	loadarray(glotemp.tempdata.a,110); //1860 up to 2002 !
	loadarray(glotemp.proxytemp.a); //up to 1991
	
	System.out.println("loaded hist-glob-data-ok");
	
	//historical regional -start 1900
	loadarray2(null); //regemit.jcm12fos);
	loadarray2(history.jcm12pop); //need for remake gdp & en, temporarily
	loadarray2(history.jcm12gdp, 70);
	loadarray2(history.jcm12en, 71);
	
	System.out.println("loaded hist-reg-data-ok");
	
	//sres global
	loadarray2(sres.fosemit);
	loadarray2(sres.lucemit);
	loadarray2(sres.soxemit);
	loadarray2(sres.ch4emit);
	loadarray2(sres.n2oemit);
	loadarray2(sres.noxemit);
	loadarray2(sres.coemit);
	loadarray2(sres.vocemit);
	loadarrayset3(sres.hfcemit);
	
	System.out.println("loaded sres-glob-data-ok");
	
	//sres regional
	loadarray3(sres.jcm12fos);
	loadarray3(sres.jcm12pop);
	loadarray3(sres.jcm12gdppc);
	loadarray3(sres.jcm12enpc);
	
	System.out.println("loaded sres-reg-data-ok");
	
	//sres calculated for comparison only
	loadarray2(sres.bernmid);
	for (int i=0; i<6; i++) loadarray2(sres.rfdata[i]);
	loadarray(sres.rfdata[6][0]); for (int j=1; j<7; j++) sres.rfdata[6][j]=sres.rfdata[6][0]; //cfc same for all
	for (int i=7; i<10; i++) loadarray2(sres.rfdata[i]);
	loadarray2(sres.tempchange);
	for (int i=0; i<7; i++) loadarray2(sres.sldata[i]);
	
	System.out.println("loaded sres-calc-data-ok");
	
	//historical responsibility data - for brazilian proposal exercise
	loadarray2(null); //regemit.ehch4);
	loadarray2(null); //regemit.ehn2o);
	loadarray2(null); //history.houghton);
	loadarray3(sres.sres4fos);
	loadarray3(sres.sres4luc);
	loadarray3(sres.sres4ch4);
	loadarray3(sres.sres4n2o);
	loadarray3(sres.sres4pop);
	loadarray3(sres.sres4gdp);
	
	System.out.println("loaded responsibility-data-ok");
	
	datain.close();
    } catch (IOException e) {	System.err.println("loaded Caught IOException: " + e); }//.getMessage()); }
    
    
    } //end getdata
    
    
    
    //********************************
    //general methods to load an array:
    
    static int getlen() {	int l=0; try {	l=datain.readShort(); } catch (IOException e) {	System.out.println(e); } return l; }
    
    //simplest 1D array
    static void loadarray(float[] id) {	loadarray(id,0); }
    
    //1D with offset start
    static void loadarray(float[] id, int s) {	int l=getlen(); loadarray(id, s, l); }
    
    //1D array, start and length
    static void loadarray(float[] id, int s, int l) {
	try {
	    float min=datain.readFloat(), max=datain.readFloat(), rf=(max-min)/255f;
	    
		for (int i=0; i<l; i++) { if (id==null)  datain.readUnsignedByte(); else id[i+s]=min+rf*datain.readUnsignedByte(); }
	} catch (IOException e) {	System.out.println(e); }
    } //end load
    
    
    //2D array
    static void loadarray2(float[][] id) {	loadarray2(id,0); }
    
    //2D array, starting id[][] at s
    static void loadarray2(float[][] id, int s) {	loadarray2(id, 0, s); }
    
    //2D array, starting id[] at si, id[][] at sj
    static void loadarray2(float[][] id, int si, int sj) {
	int li=getlen(); int lj=getlen();
	for (int i=si; i<(si+li); i++) loadarray(id !=null ? id[i] : null, sj, lj);
    }
    
    //QT array, starting at si, a[] at sj
    static void loadarrayQ(qt[] q, int si, int sj) {
	int li=getlen(); int lj=getlen();
	for (int i=si; i<(si+li); i++) loadarray(q[i].a, sj, lj);
    }
    
    
    //3D array regular
    static void loadarray3(float[][][] id) {
	int li=getlen(); int lj=getlen(); int lk=getlen();
	for (int i=0; i<li; i++) for (int j=0; j<lj; j++) loadarray(id !=null ? id[i][j] : null, 0, lk);
    }
    
    //3D array, set of irregular 2D
    static void loadarrayset3(float[][][] id) {
	int li=getlen();
	for (int i=0; i<li; i++) {
	    int lj=getlen(); int lk=getlen();
	    for (int j=0; j<lj; j++) loadarray(id !=null ? id[i][j] : null, 0, lk);
	}
    }
    
} //end class

