


package jcm.mod.data;

import java.io.*;
import java.util.*;
import jcm.core.*;
import jcm.mod.reg.*;
import jcm.tls.fileio;

public class histdata {
    
    public static void loaddata(qtset qq, String filename, String separator, boolean transposed,  float scalar, int sy, int ey, int usefromy) {
        String[][] tab=fileio.loadtab("data/"+filename, separator); //row, column
        //assume that first two rows are information only, to be ignored
        //transposed means that names go across third row, otherwise down first column
        int nreg=transposed ? tab[2].length-1 : tab.length-3;
        Set<qt> cleared=new HashSet();
        for (int i=0; i<nreg; i++) {
            String regname=transposed ? tab[2][1+i] : tab[3+i][0];
            //if (!regman.allreg.checkfind(regname)) System.err.println(filename+" "+regname+" : not in countrynames file");
            
            qt q=qq.reg(regman.allreg.find(regname));
            
            boolean clear=!cleared.contains(q); cleared.add(q);
            for (int y=usefromy; y<=ey; y++) try {
                float f=scalar*Float.parseFloat(transposed ?  tab[3+y-sy][1+i] : tab[3+i][1+y-sy]);
                q.set(y, f +(clear && f>0 ? 0 : q.get(y) ) );
                //add to previous, unless first time for this dataset, and valid data >0
            } catch (RuntimeException e) { System.err.println(filename+" "+q.name +" "+y); e.printStackTrace(); }
        }
    }
    
    
        public static void oldsplit(qtset qq) {
        //split emissions from former regions FSU, FYU, etc.
        
        for (region rs : regman.allreg.find("OLDSPLIT").reg) {
            Set<region> sub=rs.subreg(qq);
            //for (region r : sub) System.err.println(r);
            
            //find y =last year of sr data, then calc frac of emissions y+1
            Map<region, Float> frac=new HashMap(sub.size());
            int y=2000; while (qq.reg(rs).get(y)<=0) y--;
            float sum=0; for (region r : sub) sum+=qq.reg(r).get(y+1);
            for (region r : sub) frac.put(r, qq.reg(r).get(y+1)/sum);
            
            float f; while ((f=qq.reg(rs).get(y))>0) {
                for (region r : sub) qq.reg(r).set(y,  f * frac.get(r)); //beware fill not add, so other contributions won't be counted!
                y--;
            }
            qq.map.remove(rs);
        }
    }
    
  

    
    
} //end class

