package jcm.mod.cli;
import jcm.mod.*;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

public class udebclimod extends module  {
    
	/*
	split from glotemp so that the eigenvectors are only recalculated (slow!) when the model setup changes
	also to make the code more managable
	 
	could solve anomaly that adjust is called from glotemp calcstep by moving the setup precalc to inner class?
	then can call all in normal loop?
	move sealevel part to sealevel and add adjustable parameters?
	but then must move thermal-exp before loop not after!
	 
	 */
    
    //*****************************************************
    //INTERACTIONS
    
    
    public void setinteractions() {
	for (int i=0; i<climodparam.length; i++)  climodparam[i].setaffectedby(climod);
	rfco2double.setaffects(get(radfor.class));
	
    } //end interactions
    
    //*****************************************************
    //PARAMETERS
    //adjustable parameters -may be changed by controls on the graphs
    
    //climate model parameters from IPCC TAR WG1 Appx 9.1
    //last two rows are maximum and minimum for adjustable controls
    //note 9999 means effectively no upwelling feedback
    
    double[][] cmp={
	{	3.71, 4.2, 8.0,    2.3, 1.2, 1.0, 1.0, 60, 0.2, 1.25},
	{	3.45, 3.7, 5.0,    1.6, 1.2, 1.0, 1.0, 60, 0.2, 1.25},
	{	3.74, 3.0, 25.0,   1.9, 1.4, 0.5, 0.5, 60, 0.2, 1.25},
		/*
		Note - use 3.691 in third row first column for consistency with ACCC
		RF CO2double HadCM3=3.74 =>/log2 => 5.396 but ACCC has 5.325 (RF2x=3.691, 1.33% less)  and TAR says 5.35
		 */
	{	3.47, 2.5, 12.0,   1.7, 1.4, 0.5, 0.5, 60, 0.2, 1.25},
	{	3.8,  2.6, 20.0,   9.0, 1.4, 0.5, 0.5, 60, 0.2, 1.25},
	{	3.6,  1.9, 9999.0, 2.3, 1.4, 0.5, 0.5, 60, 0.2, 1.25},
	{	3.6,  1.7, 14.0,   2.3, 1.4, 0.5, 0.5, 60, 0.2, 1.25},
	{	4.37, 2.5, 7.0,    1.0, 1.3, 1.0, 1.0, 90, 0.2, 1.0},
	{	3, 	 1.5, 0, 	  0.05,0.7, 0,   0,   1,   0,  0.8},
	{	5, 	 4.5, 30, 	  4,   1.5, 4,   2,   120, 1,  1.6}
    };
    
    int model=2; //hadcm3 default - note, if change the default, should also change the [2] in sealevel ansebs/glsens
    String[] climodname={	"gfdl", "csiro", "hadcm3", "hadcm2", "echam4", "csm", "doe", "ipccsar"};
    
    public param    climod=new param("climodmenu", climodname, "hadcm3") {
	public void precalc() {  changeclimod(getchosenindex()); get(sealevel.class).seticecaptomod(getchosenindex()); }
    };
    //note below doesn't work because maybe called after main precalc
    //also if put precalc in the module rather than the param, it doesn't calculate if module not output
    //public void precalc(iob p) {	if (p==climod) {	changeclimod(climod.getchosenindex()); sealevel.seticecaptomod(climod.getchosenindex()); }}
    
    public param
	    //climate model parameters
	    rfco2double=new param("rfco2d", "w&per&m2", cmp[model][0], cmp[8][0], cmp[9][0]),
	    climsens=new param("climsens", "degc", cmp[model][1], 1, 7, red, simplest), //cmp[8][1], cmp[9][1]),
	    heatdiffusivity=new param("teddydiff", "cm2&per&s", cmp[model][3], cmp[8][3], cmp[9][3], dkblue),
	    landoceantempratio=new param("lotr", "", cmp[model][4], cmp[8][4], cmp[9][4], orange, expert),
	    knorthsouth=new param("kns", "", cmp[model][5], cmp[8][5], cmp[9][5], dkgreen, expert),
	    klandocean=new param("klo", "", cmp[model][6], cmp[8][6], cmp[9][6], yellowgreen, expert),
	    mixlaydepth=new param("tmixlay", "metres", cmp[model][7], cmp[8][7], cmp[9][7], grey, expert),
	    polarsinktempratio=new param("psi", "", cmp[model][8], cmp[8][8], cmp[9][8], blue, expert),
	    seaice=new param("seaice", "", cmp[model][9], cmp[8][9], cmp[9][9], cyan, expert),
	    varupwell=new param("tufbopt", true, magenta, expert),
	    zeroupwelltemp=new param("tnoupwell", "degc", cmp[model][2], cmp[8][2], cmp[9][2], "lilac", expert),
	    upwellreducefrac=new param("uwredfrac", "", 0.3, 0, 1, dkpurple, expert),
	    upwellbaserate=new param("uwbaserate", "m&per&yr", 4, 0, 8, pink, expert);
    
    
    param[] climodparam={	rfco2double, climsens, zeroupwelltemp, heatdiffusivity, landoceantempratio, knorthsouth, klandocean, mixlaydepth, polarsinktempratio, seaice };
    
    void changeclimod(int mod) { model=mod; for (int i=0; i<climodparam.length; i++)  climodparam[i].setval(cmp[mod][i]);  setupfluxes();    }
    
    
    public void precalc() {
	if (!climod.changed) setupfluxes(); //if ! to avoid doing it twice
    }
    
    
    
    //****************************************************
    //working variables
    //[2] is for two oceans, 0=N, 1=S (although they only differ at surface)
    
    //nhl =num ocean layers (excluding surface), nhb=total num boxes
    //can try varying this - increasing it doesn't make much difference
    public static final int nhl=34, nhb=nhl+1;
    
    double[][] hbox(){	return new double[2][nhb]; }
    
    //hiq stores data, hiqi for iteration, hrML for querying mixed layer, hicML column for input , premultiplied by stepf and rampf
    public double[][] hiq=hbox(), hiqi=hbox(), hiq99=hbox(), hpropf=hbox(), hrML=hbox(),  shicML=hbox(), rhicML=hbox();
    //for sea level rise
    public double[][] hrsl=hbox();
    
    //*****************************************************
    //for surface temperatures
    //area fractions, nl, no, so, sl (also needed by radfor module)
    //note 0=nl, 1=no, 2=so, 3=sl;
    public double[] frac={	0.199, 0.301, 0.406, 0.094};
    //swap with below for equal n-s areas
    //{0.293/2.0, 0.707/2.0, 0.293/2., 0.707/2.0};
    double fracl=frac[0]+frac[3], fraco=1.0-fracl;
    double[][] khi=new double[4][4]; //inverse of conductivity matrix * frac
    double[] khir=new double[4]; //sum of each row of above
    
    public double tstart=18.17; // average mix layer temp consistent with hilda
    
    //*****************************************************
    //for non-linear fluxes etc.
    public double kls, kos, klo, kns, nstd, nstdold, dqin, qpt, sl, cice;
    double[] qin=new double[2], qinbase=new double[2], qinold=new double[2], qinold99=new double[2], mlt=new double[2];
    public double[] spaceflux=new double[2];
    double totrf99, nstd99, nstdold99;
    
    //****************************************************
    //various working variables
    double dt, hu, pi, diffu, dml, rvu, rv, rjff, polsink, mlbaserate, hiquc, reftemp=0;
    double[] dl, vec;
    double[][] rate;
    public double[][] hiqstart=new double[2][nhb];
    
    Matrix M, U; Matrix[] MV=new Matrix[2], MVI=new Matrix[2];
    double upwellstep[][][] =new double[2][nhb][nhb];
    int startyear, tstep;
    double guess, nit, ciqr, diff;
    
    //**********************************************
    //heat flux system setup
    //note units: rates per year, ocean boxes contain watt-years per m2, distances in metres
    //note ocean boxes contain heat (per m2), not temperature, for rate formulae same as carbon model,
    
    public void setupfluxes() {
	
	//**********************
	//setup various constants
	dt=1.0;
	dml=mixlaydepth.getval(); // mixed layer depth 90 is IPCCSAR, 60 for IPCCTAR, note hilda (carboncycle)is 75!
	dl=new double[nhl]; // depth of ocean layers
	
	for (int n=0; n<nhl; n++) {	dl[n]=(n<20 ? 49.0 : 196.0)*(34.0/nhl); } //two thicknesses as hilda
	//		for (n=0; n<nhl; n++) {	dl[n]=3724/nhl; } //for evenly spaced layers
	
	diffu=heatdiffusivity.getval()*(365*24*3600)/10000; // diffusivity -fixed, converted from cm2 s-2 to m2 yr-1
	
	hu=upwellbaserate.getval(); // upwelling m yr-1 -fixed for now, but note >> hilda!
	pi=polarsinktempratio.getval(); // PI factor for calculating temperature of high-latitude downwelling water
	
	double cw=4100000.0/(24.0*365.0*3600.0); // 0.13, watt-year per m3 ocean per K -function of heat capacity
	qpt=cw*dml; //heat uptake by mixed layer watt-year per m2 per K
	
	klo=klandocean.getval(); kns=knorthsouth.getval(); // land-ocean and north-south conductivities
	double lotr=landoceantempratio.getval(); // eqm land-ocean temperature ratio
	cice=seaice.getval(); // sea-ice parameter (see raper et al 2000)
	
	//set area fractions moved to reset method cos used by radfor setup which is called before climate setup!
	
	
	//*********************************
	//iteration to find conductivities for ocean-space and land-space (klo and kls)
	//checked works with my mathcad file, takes about 7 loops
	
	//kos=2.26589, kls=0.78311;	consistent with fracs and lo=0.5, ns=0.5, climsens=2.5, lotr=1.3
	
	double clotr, oldclotr=1.0, newkos, oldkos=-99.0; //-99 is just a flag for first loop
	kos=0.9; //first guess
	
	do{
	    
	    kls=((rfco2double.getval()/climsens.getval())*(lotr*fracl + fraco)/(lotr*fracl))-((kos*fraco)/(lotr*fracl));
	    
	    khi= new Matrix(new double[][]{
		{	frac[0]*kls+klo, -klo, 0, 0},
		{	-klo, frac[1]*kos+klo+kns, -kns, 0},
		{	0, -kns, frac[2]*kos+klo+kns, -klo},
		{	0, 0, -klo, frac[3]*kls+klo}
	    },4,4).inverse().getArray();
	    
	    //multiply khi by the area fracs, and sum to calculate temp/rf
	    for (int i=0; i<4; i++){	khir[i]=0; for (int j=0; j<4; j++) {	khi[i][j]*=frac[j]; khir[i]+=khi[i][j]; }}
	    //calc land-ocean temp ratio
	    clotr=((frac[0]*khir[0]+frac[3]*khir[3])/fracl)/((frac[1]*khir[1]+frac[2]*khir[2])/fraco);
	    //adjust kos
	    if (oldkos==-99.0) newkos=1.0;
	    else newkos=kos+(lotr-clotr)*(kos-oldkos)/(clotr-oldclotr);
	    oldkos=kos; kos=newkos; oldclotr=clotr;
	    
	} while (Math.abs(lotr-clotr)>0.0001);
	
	//modloop.debug.write("kos "+kos+" kls "+kls);
	
	//*********************************
	//make rates for exchange between boxes (gross rates per year)
	
	//boxes 0 to nhl-1 are the layers below mixed layer, nhl is the surface (note nhb=nhl+1)
	//this numbering is for consistency with carbon setup
	//rate[i][j] is the amount by which you have multiply box j to get the change in box i
	
	
	rate=new double[nhb][nhb]; for (int i=0; i<nhb; i++) {	for (int j=0; j<nhb; j++) {	rate[i][j]=0; }}
	
	//go through layers
	for (int n=1; n<nhl; n++) {
	    rvu=(2.0*diffu-hu*dl[n])/(dl[n-1]*(dl[n-1]+dl[n]));
	    rv =(2.0*diffu+hu*dl[n-1])/(dl[n]*(dl[n-1]+dl[n]));
	    rate[n][n-1]+=rvu; rate[n-1][n-1]-=rvu;
	    rate[n-1][n]+=rv; rate[n][n]-=rv;
	}
	
	//top layer 0 and mixed layer nhl
	rvu=(8.0*diffu/(3.0*dl[0]*dml))-hu/dml;
	rv =3.0*diffu/(dl[0]*dl[0]);
	rjff=diffu/(3.0*dl[0]*dl[0]); //joos funny flux -see carbon model
	rate[0][nhl]+=rvu; rate[nhl][nhl]-=rvu;
	rate[nhl][0]+=rv; rate[0][0]-=rv;
	rate[0][1]+=rjff; rate[nhl][1]-=rjff;
	
	//polar water sinking to bottom
	polsink=pi*hu/dml;
	rate[nhl-1][nhl]+=polsink; rate[nhl][nhl]-=polsink;
	
	//record this before adding heat flux to mixed layer later
	mlbaserate=rate[nhl][nhl];
	
	M=new Matrix(rate,nhb,nhb);
	
	//*******************************
	if (varupwell.istrue()) {
	    //calculate function for changing upwelling
	    //matrix stepf/zut*(S-1.U.S) for *(S-1.Q) where zut is zeroupwelltemp
	    
	    double[][] urate=new double [nhb][nhb];
	    for (int n=0; n<nhb; n++) for (int m=0; m<nhb; m++) urate[n][m]=0;
	    
	    //go through layers
	    for (int n=1; n<nhl; n++) {
		rvu=(-hu*dl[n])/(dl[n-1]*(dl[n-1]+dl[n]));
		rv =(hu*dl[n-1])/(dl[n]*(dl[n-1]+dl[n]));
		urate[n][n-1]+=rvu; urate[n-1][n-1]-=rvu;
		urate[n-1][n]+=rv; urate[n][n]-=rv;
	    }
	    
	    //top layer 0 and mixed layer nhl
	    rvu=-hu/dml;
	    urate[0][nhl]+=rvu; urate[nhl][nhl]-=rvu;
	    
	    //polar water sinking to bottom
	    polsink=pi*hu/dml;
	    urate[nhl-1][nhl]+=polsink; urate[nhl][nhl]-=polsink;
	    
	    U=new Matrix(urate,nhb,nhb);
	} //end if varupwell
	
	//*******************************
	//calculate starting mixed later heat contents -assuming same for both oceans
	double mlstart=tstart*qpt;
	
	//find initial box contents
	//assume all net fluxes zero except for surface layer
	//use inverse of submatrix excluding mixed layer (rest same for both oceans)
	//since M(nhl,nhl) excluded, doesn't matter it's not set yet!
	Matrix veclay=M.getMatrix(0,nhl-1,0,nhl-1).inverse().times(M.getMatrix(0,nhl-1,nhl,nhl)).times(-mlstart);
	double[] hss=veclay.transpose().getArray()[0];
	
	//the section below -up to vec is for sea-level rise
	//note this method assumes volume expansion coeff constant within one box (i.e. based on initial t,p)
	
	//convert to temperatures
	double[] tss=new double[nhb]; tss[nhl]=tstart;
	for (int n=0; n<nhl; n++) tss[n]=hss[n]/(cw*dl[n]);
	//to check initial temps ok //for (n=0;n<nhl;n++) System.out.println(""+n+" "+tss[n]);
	
	//pressure: note pr[0]= depth of first layer
	double pr[]=new double[nhb]; double pz= 9.8 * 1035.0 / 2.0; //should really vary!
	pr[nhl]=101325.0+pz*dml; pr[0]=pr[nhl]+pz*(dml+dl[0]);
	for (int n=1; n<nhl; n++) pr[n]=pr[n-1]+pz*(dl[n-1]+dl[n]);
	
	//calculate volume expansion coefficient -this approximate formula found by fitting to curves in mathcad file
	//note divide by cw so it can be multiplied by watt-yr per m2, the layer depth will cancel
	vec=new double[nhb];
	for (int n=0; n<nhb; n++) vec[n]=(1.0/cw)*(1.0e-4*(0.5 + 0.12*tss[n] - 0.0008*tss[n]*tss[n] + 2.8*(1.0 - 0.027*tss[n])*(pr[n]*1.0e-8 - 0.24*pr[n]*pr[n]*1.0e-16)));
	
	//check for (n=0;n<nhb;n++) modloop.debug.write(n+" "+tss[n]+" "+pr[n]+" "+vec[n]);
	
	//*******************************
	//work out prop, ramp, step functions, including heat loss to space
	
	double[] Eig=new double[nhb], stepf=new double[nhb], rampf=new double[nhb], hicML=new double[nhb];
	
	for (int  o=0; o<2; o++) {	//for each ocean -different surface losses considering neighbouring land!
	    
	    //flux lost to space from mixed layer -note still per m2, o*3 gives land box (N or S)!
	    spaceflux[o]=(1/qpt)*cice*(kos + (klo/frac[o+1])*(kls*frac[o*3]/(kls*frac[o*3]+klo)));
	    M.set(nhl,nhl,mlbaserate - spaceflux[o]);
	    
	    // now put this into a jama Matrix R
	    EigenvalueDecomposition ED=new EigenvalueDecomposition(M);
	    MV[o]=ED.getV(); MVI[o]=MV[o].inverse();
	    
	    //set hiqstart for initial state in 1750
	    for (int n=0; n<nhb; n++) {
		hiqstart[o][n]=0;
		for (int m=0; m<nhb; m++) hiqstart[o][n]+=(MVI[o].getArray()[n][m])*(m<(nhb-1) ? hss[m] : mlstart);
	    }
	    
	    //make hpropf, hstepf, hrampf functions
	    Eig= ED.getRealEigenvalues();
	    for (int n=0; n<nhb; n++) {
		hpropf[o][n]=Math.exp(Eig[n]*dt);
		if (Math.abs(Eig[n])<0.000001) {	stepf[n]=dt; rampf[n]=dt/2.0; } else {	stepf[n]=(hpropf[o][n]-1.0)/Eig[n]; rampf[n]=(stepf[n]-dt)/(Eig[n]*dt); }
	    }
	    
	    //also need the row of S for the mixedlayer box, and column of S-1 premultiplied by step or ramp
	    hrML[o]=MV[o].getArray()[nhl];
	    hicML=MVI[o].transpose().getArray()[nhl];
	    for (int n=0; n<nhb; n++) {	rhicML[o][n]=rampf[n]*hicML[n]; shicML[o][n]=stepf[n]*hicML[n]; }
	    
	    //also make a vector for calculating total sea-level rise (per m2 ocean)
	    for (int n=0; n<nhb; n++) {
		for (int i=1; i<nhb; i++) hrsl[o][n]+=MV[o].getArray()[i][n];
		hrsl[o][n]*=vec[n]; // *v.e.c./cw (layer depths cancel)
		hrsl[o][n]*=frac[o+1]/(frac[1]+frac[2]); //to enable adding the two oceans
	    }
	    
	    //now make the SIUS matrices for changing upwelling
	    if (varupwell.istrue()) {
		upwellstep[o]=(MVI[o].times(U.times(MV[o]))).getArray();
		for (int n=0; n<nhb; n++) for (int m=0; m<nhb; m++) upwellstep[o][n][m]*=stepf[m]/zeroupwelltemp.getval();
		//check is this the right way round?? was stepf[n] before
	    }
	    
	} //end for each ocean loop
	
	//don't need these any more -save memory
	//M=null; //MVI=null; MV=null; rate=null; //we do need these if changing upwelling!
	//ED=null;
	Eig=null; rampf=null; stepf=null; hicML=null;
	
    } //end setupfluxes
    
    //****************************
    //reset the boxes according to startyear
    
    public void startstate(int startyear) {
	this.startyear=startyear;
	
	if (startyear==1750) {
	    nstd=0; nstdold=0;
	    for (int o=0; o<2; o++) {
		qinold[o]=spaceflux[o]*qpt*tstart;
		for (int n=0; n<nhb; n++) hiq[o][n]=hiqstart[o][n];
	    }
	    
	    //checked hiqstart[o][n] givesw correct temps inc 18 at surface
	} //end 1750
	
	//Note the 1999 data is set by running it from 1750 initially
	else {	startyear=2000; //just in case it isn't!
	nstd=nstd99; nstdold=nstdold99; qinold[0]=qinold99[0]; qinold[1]=qinold99[1];
	for (int o=0; o<2; o++) {	for (int n=0; n<nhb; n++) hiq[o][n]=hiq99[o][n]; }
	} //end 2000
	
    } //end startyear
    
    
    //save 1999 state for adjusting future only -called from time loop
    public void save99() {	for (int o=0; o<2; o++) {	nstd99=nstd; nstdold99=nstdold; qinold99[o]=qinold[o]; for (int n=0; n<nhb; n++) hiq99[o][n]=hiq[o][n]; }}
    
    //**************************************
    //this is called from glotemp calcstep when forcing changes
    
    public float adjust(float[] rf) {
	
	//assuming dt=1 for the moment
	//note o+1 gives ocean frac, o*3 gives neighboring land!
	
	//assume nstd increases same as last step
	guess=nstd+(nstd-nstdold); nstd=guess; nstdold=nstd;
	
	for (int o=0; o<2; o++) {	//for each ocean
	    
	    //apply prop and step functions to oceans
	    for (int n=0; n<nhb; n++) {	hiq[o][n]= hpropf[o][n]*hiq[o][n] + shicML[o][n]*qinold[o]; }
	    
	    //calc heat input to each ocean mixed layer (watt-year per m2)
	    //direct input from rf
	    qinbase[o] = rf[o+1];
	    //add input via land
	    qinbase[o] += rf[o*3]*(frac[o*3]/frac[o+1])*klo/(kls*frac[o*3]+klo);
	    
	    //correct for steady-state flux at starting temp
	    qinbase[o] +=spaceflux[o]*qpt*tstart;
	    
	}// end o
	
	//now iterate to find north-south temp diff
	nit=0; do {
	    
	    for (int o=0; o<2; o++) {
		//subtract north-south flux from qin
		qin[o] =qinbase[o] +(o==0 ? -1.0 : 1.0) * nstd * kns / frac[o+1];
		
		dqin=qin[o]-qinold[o];
		
		//apply ramp function and calc new surface temperature
		mlt[o]=0;
		for (int n=0; n<nhb; n++) {	hiqi[o][n]=hiq[o][n] + rhicML[o][n]*dqin; mlt[o]+=hrML[o][n]*hiqi[o][n]; }
		mlt[o]/=qpt; //convert units to temp
	    } //end o loop
	    
	    //now calculate real nstd
	    diff=(mlt[0]-mlt[1])*cice -nstd; nstd+=diff;
	    
	    //keep iterating until negligible temp diff
	    nit++; } while(Math.abs(diff)>0.001 && nit<10);
	
	hiq=hiqi;
	qinold=qin;
	
	//correct for start temp converts mlt to change not total
	for (int o=0; o<2; o++) mlt[o]-=tstart;
	
	//store arrays of "output" data for plotting
	float[][] bt=get(glotemp.class).boxtemp;
	bt[0][ns]=(float)((mlt[0]*cice*klo + frac[0]*rf[0])/(kls*frac[0]+klo));
	bt[3][ns]=(float)((mlt[1]*cice*klo + frac[3]*rf[3])/(kls*frac[3]+klo));
	bt[1][ns]=(float)(mlt[0]*cice);
	bt[2][ns]=(float)(mlt[1]*cice);
	
	float globavtemp=0.0f; for (int i=0; i<4; i++) globavtemp+=(float)(	bt[i][ns]*frac[i]);
	return globavtemp;
    } //end adjust
    
    
    //*******  sea-level rise due to thermal expansion **********
    public double sealevteinit;
    float  thermalexpansion() {
	float thermexp=0; for (int o=0; o<2; o++) for (int n=0; n<nhb; n++) thermexp+=hrsl[o][n]*hiq[o][n];
	//subtract initial value
	if (ns==0) sealevteinit=thermexp;
	thermexp-=sealevteinit;
	return thermexp;
    }
    
    //******* temperature- upwelling feedback******
    void  tempupwellfb(double ut) {
	if (varupwell.istrue()) {
	    
	    //note this is calculated *after* the rest, i.e. affects next years Q -not iterated
	    //but should not precede calc sealevel thermexp in calcstep loop!
	    
	    //beware slow -whole matrix multiplication
	    if (ut>zeroupwelltemp.getval()) ut=zeroupwelltemp.getval();
	    for (int o=0; o<2; o++) for (int n=0; n<nhb; n++) {
		hiquc=0; for (int m=0; m<nhb; m++) hiquc+=hiq[o][m]*upwellstep[o][n][m];
		hiq[o][n]-=hiquc*ut*upwellreducefrac.getval();
		//note minus because this is decreasing upwelling!
		//note upwellreducefrac following IPCC appx9.1 "the proportion of upwelling which is scaled..."
	    }
	} //end if varupwell
    }
    
    
} //end class