//Sea-level rise
//adds ice-melt (glaciers and icecaps) 
//to the thermal expansion calculated in heatflux module 

//P1  SeaLevel Update: update greenland, add freshwater storage,  historical data, possible effect of WAIS, strom surges, 
	

package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import jcm.mod.*;

public class sealevel extends module {
	
	//*****************************************************
	//icecap sensitivities from IPCCTAR chap11 table 11.11
	//climodname={"GFDL_R15_a","CSIRO Mk2","HadCM3","HadCM2", "ECHAM4/OPYC", "CSM 1.0", "DOE PCM", "IPCC SAR"};
	double[] glsens={	0.12,0.16,0.09,0.10,0.03,0.15,0.14,0.3}; 
	double[] ansens={	-0.18,-0.37,-0.35,-0.21,-0.48,-0.31,-0.48,-0.21}; 
	
        //note glsens[get(udebclimod.class).model] gives an initialisation exception - as world is not created yet
	public param greenlandsens=new param("greenland-sensitivity", "", glsens[2], -0.5,  0.5, green ); 
	public param antarcticasens=new param("antarctica-sensitivity", "", ansens[2], -0.5,  0.5, cyan ); 
	
	public void seticecaptomod(int m) {	greenlandsens.setval(glsens[m]); antarcticasens.setval(ansens[m]); } //called from climod
	
	//*****************************************************
	public void initsetup() {
		follows(get(glotemp.class)); 
		follows(get(udebclimod.class)); 
		greenlandsens.setaffectedby(get(udebclimod.class).climod); 
		antarcticasens.setaffectedby(get(udebclimod.class).climod); 
	}
	
	//*******************************************************
	//curves for plotting
	public qt
		thermexp=new qt("thermexp",  red),
		glacier=new qt("glaciers",  grey),
		longterm=new qt("rfia",  black),
		antarctica=new qt("antarctica",  cyan),
		greenland=new qt("greenland", green),
		freshwater=new qt("freshwater",  dkgreen, expert),
		other=new qt("Other",  brown),
		total=new qt("totsl", dkblue, simplest, qt.Type.total)
		; 
	
   public qtset sealevel=new qtset( thermexp, glacier, greenland, antarctica, longterm, freshwater, other, total, "sealevelrise", "metres");
 

	
	//*******************************************************
	//LOOP CALCULATIONS
	
	public void precalc() {	
	    glaciersetup(); 
	}
	
	public void calcstep() {
		
	    //note thermal expansion is calculated in udebclimod.thermalexpansion called from glotemp, since it depends on temporary state data inside other udebclimod arrays
		
		if (ns>0) {
			glaciermelt(); 
			polarmelt(); 
			
			longterm.a[ns]=(float)(longterm.a[ns-1]+0.00025); //recovery from ice age
			
			//other factors: sedimentation and permafrost about 0.0002/yr
			//permafrost see tar11.2.6 0-0.23 mm/yr 1990-2100 and 0-0.05 1900-1990, +sedimentation 0-0.05 (constant?)
			other.a[ns]=(float)(other.a[ns-1]+(ns<240 ? 0.00005 : 0.00017 ) ); 
			
			freshwater.a[ns]=0; //0.001f*ns;
		}
		
		//add up total
		total.a[ns]=
			thermexp.a[ns]
			+glacier.a[ns]+longterm.a[ns]
			+antarctica.a[ns]+greenland.a[ns]
			+freshwater.a[ns]+other.a[ns]; 
		
	} //********* end calcstep **************
	
	
	public void save99() {	for (n=0; n<ng; n++) glac99[n]=glac[n]; }
	
	public void startstate(int startyear) {
		longterm.a[0]=0; antarctica.a[0]=0; greenland.a[0]=0; freshwater.a[0]=0; glacier.a[0]=0; other.a[0]=0; 
		if (startyear==2000) for (n=0; n<ng; n++) glac[n]=glac99[n]; 
		else for (n=0; n<ng; n++) glac[n]=totglac/ng; 
	}
	
	
	//*******************************************************
	//GLACIERS
	//glacier groups as per jesper interpretation of SAR method
	double totglac=0.5; //total glacier ice as m sea-level
	double taul=70, tauh=130, deltatl=0.7, deltath=3.0; //tau is lifetime, deltat is temp for melting
	
	int ng=10, n; double eqglac; 
	double[] glac=new double[ng], glac99=new double[ng], tau=new double [ng], deltat=new double[ng]; 
	
	void glaciersetup() {
		//set up glacier groups
		for (n=0; n<ng; n++) {
			tau[n]=taul+(tauh-taul)*(double)n/(double)(ng-1); 
			deltat[n]=deltatl+(deltath-deltatl)*(double)n/(double)(ng-1); 
		}
	}
	void glaciermelt() {
		//small glaciers
		glacier.a[ns]=(float)totglac; 
		for (n=0; n<ng; n++) {
			//calc equilibrium left at this temperature
			eqglac=(totglac/ng)*(1.0-get(glotemp.class).avchange.a[ns]/deltat[n]); 
			if (eqglac<0) eqglac=0; 
			//then slow melting towards equilibrium
			//the 0.3 is a factor to match rates of melting in TAR -won't affect final melt (used to be 0.4)
			glac[n]-=0.3*(glac[n]-eqglac)/tau[n]; 
			glacier.a[ns]-=glac[n]; 
		}
	}
	//*******************************************************
	//POLAR ICECAPS
	
	
	void polarmelt() {
		double glsensfac=1.0+(get(glotemp.class).avchange.a[ns]-1.5)*0.3; //to be multiplied, i.e. sens up by 25% per degree
		double ansensfac=get(glotemp.class).avchange.a[ns]*0.05; //to be added not multiplied!
		/*
		need greenland and antarctica responding to longer term warming -see TARWG1 sec11.5.4.3
		from TAR fig 11.16 greenland melt mm/yr in 3000: 3C: 0.5 = 0.17/C, 5.5C: 1.8 =0.33/C , 8C: 2.4 = 0.3 /C
		text mentions 1mm/yr for 3C =0.33/C and 7 for 12C! = 0.57/C not inc precipitation
		av sensitivity from models 1990-2090 is 0.13/C (for about 1.5C avg rise)
		antarctica av sensitivity from models 1990-2090 is about -0.3C! (for about 1.5C avg rise)
		max loss total antarctic 2.5mm/yr for 8C = +0.32/C
		so sens increase could be about 0.6/6.5C ? but be conservative, use half this
		
		apply sensfacs only after 2100 to aim for consistency with tar!
		thought: could use boxtemp[ns][2] and [1] i.e. south or north ocean temp rather than the global average, since this will determine precipitation or ice-edge melting better,
		but TAR parameters already adjust global to local temps
		
		*/
		
		antarctica.a[ns]=(float)(antarctica.a[ns-1] + ((ns>350 ? ansensfac : 0) + antarcticasens.getval()) * get(glotemp.class).avchange.a[ns] * 0.001); 
		greenland.a[ns]=(float)(greenland.a[ns-1] + (ns>350 ? glsensfac : 1) * greenlandsens.getval() * get(glotemp.class).avchange.a[ns] * 0.001); 
		
	}
	
} //end sealevel class
	//************** end *******************
	

	