//Radiative forcing:
//add all the forcing together
//also split between l/o n/s boxes of glotemp model

package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.ogas.*;


public class radfor extends module  {
    
    carboncycle carboncycle;     atchem atchem;     fgas fgas;     aerosol aerosol;
    
    //*****************************************************
    //INTERACTIONS
    
    public void initsetup() {
        super.initsetup();
        carboncycle=get(carboncycle.class); atchem=get(atchem.class); aerosol=get(aerosol.class); fgas=get(fgas.class);
        follows(carboncycle);         follows(atchem);        follows(aerosol);        follows(fgas);
        
        allrf.add(carboncycle.co2rf, atchem.othgasrf,  fgas.fgasrf,  aerosol.aerorf, aerosol.natvrf);
        allrf2.add(
                carboncycle.co2rf,
                atchem.ch4rf, atchem.n2orf, atchem.tropo3rf, atchem.strath2orf,
                fgas.cfcrf, fgas.hfcrf, fgas.strato3rf,
                aerosol.sulfdirrf, aerosol.sulfindrf,   aerosol.bcrf, aerosol.ocrf,   aerosol.solarrf, aerosol.volcanorf
                );
    }
    
    //*****************************************************
    //PARAMETERS
    
    public param unifdist=new param("unif", false, expert) { public void precalc() { distribute(); }};
    public param only4gas=new param("4gas", false, experimental)	;  //not working-see note below
    
    
    //*******************************************************
    //PLOTARRAYS
    public float[][] splitrf=new float[4][glos2];
    
    public qt
            totalrf= new qt("totrf" ,red , simplest, qt.Type.total),
            anthrorf = new qt( "allghgaero",dkred , expert, qt.Type.total),
            ghgrf= new qt("allghg" , greygreen, expert, qt.Type.total),
            nlrf=new qt( splitrf[0], "rfnl"  , red ,  expert ),
            norf=new qt( splitrf[1], "rfno" , blue ,  expert  ),
            sorf =new qt(  splitrf[2], "rfso" ,  cyan ,  expert   ),
            slrf =new qt( splitrf[3], "rfsl"  ,  orange , expert   );
    ;
    
    
    public qtset allrf=new qtset( totalrf, anthrorf, ghgrf, "allrf", "w&per&m2"); //note others added in expert
    public qtset allrf2=new qtset( totalrf, "allrf_detail", "w&per&m2");
    public qtset regrf=new qtset( totalrf, nlrf, norf, sorf, slrf,  "regrf", "w&per&m2");
    
   
    //************ mainloop calculations **********************************
    //LOOP CALCULATIONS
    
    public void calcstep(){
        calctotals();
        calcsplit();
    }
    
    //****************************************************
    //DISTRIBUTE
    //distribute radiative forcing between N/S & L/O boxes of UDEB-climod
    //now this code become complex, could tidy using Jama matrices?
    
    double[] frac, splitnls=new double[4], splitnlw=new double[4], splitl=new double[4], splitsl=new double[4], splits=new double[4];
    
    void distribute() {
        if (unifdist.istrue()) {
            for (int i=0; i<4; i++) {	splitnls[i]=1f; splitnlw[i]=1f; splitl[i]=1f; splitsl[i]=1f; splits[i]=1f; }
        } else {
            frac=get(udebclimod.class).frac;
            //new N/S  and L/O splits based roughly on table 6.4 , 6.11 in TAR
            splitnls[0]=0.8*0.75/(0.75*frac[0]+0.25*frac[1]); splitnls[1]=splitnls[0]/3;
            splitnls[3]=0.2*0.75/(0.75*frac[3]+0.25*frac[2]); splitnls[2]=splitnls[3]/3;
            splitnlw[0]=0.6667*0.6667/(0.6667*frac[0]+0.3333*frac[1]); splitnlw[1]=splitnlw[0]/2;
            splitnlw[3]=0.3333*0.6667/(0.6667*frac[3]+0.3333*frac[2]); splitnlw[2]=splitnlw[3]/2;
            splitl[0]=0.6667/frac[0]; splitl[1]=0; splitl[3]=0.3333/frac[3]; splitl[2]=0;
            splitsl[0]=0.3333*0.75/(0.75*frac[0]+0.25*frac[1]); splitsl[1]=splitsl[0]/3;
            splitsl[3]=0.6667*0.75/(0.75*frac[3]+0.25*frac[2]); splitsl[2]=splitnls[3]/3;
            splits[0]=0.25/0.5; splits[1]=0.25/0.5; splits[2]=0.75/0.5; splits[3]=0.75/0.5;
        }
    } //end distribute
    
    //old distribution of sulphate forcing:
    //fsul[0]=0.6667*0.9/(0.9*udebclimod.frac[0]+0.1*udebclimod.frac[1]); fsul[1]=fsul[0]/9;
    //fsul[3]=0.3333*0.9/(0.9*udebclimod.frac[3]+0.1*udebclimod.frac[2]); fsul[2]=fsul[3]/9;
    
    void calcsplit() {
        
        for (int i=0; i<4; i++) {
            splitrf[i][ns]=(float)(
                    carboncycle.co2rf.a[ns]+atchem.ch4rf.a[ns]+atchem.strath2orf.a[ns]+atchem.n2orf.a[ns] //well mixed ghgs - excluding tropo O3
                    +fgas.cfcrf.a[ns]+fgas.hfcrf.a[ns]	//well mixed ghgs - excluding strato O3
                    +aerosol.natvrf.a[ns]  			//solar & volcano - maybe volcano should split too?
                    +(aerosol.sulfdirrf.a[ns]+ aerosol.bcrf.a[ns]+aerosol.ocrf.a[ns]/*+aerosol.aircontrf.a[ns]*/)*splitnls[i]  	//strong bias to northern land
                    +(aerosol.sulfindrf.a[ns]+ atchem.tropo3rf.a[ns])*splitnlw[i] 				//weaker bias to northern land
                    +fgas.strato3rf.a[ns]*splits[i]							//bias to south
                    //				+albedorf.a[ns]*splitl[i]								//all on land
                    //				+bioburnrf.a[ns]*splitsl[i]							//bias to southern land
                    );
        }
    }
    //******************************
    //TOTALS
    
    void calctotals() {
        if (get(radfor.class).only4gas.istrue()) {
            ghgrf.a[ns]= carboncycle.co2rf.a[ns]+ atchem.ch4rf.a[ns]+ atchem.n2orf.a[ns];
            anthrorf.a[ns]= ghgrf.a[ns]+ aerosol.sulfdirrf.a[ns]+  aerosol.sulfindrf.a[ns];
            totalrf.a[ns]= anthrorf.a[ns];
            //P2 CHECK / FIX only4gas option does not affect the calcsplit, so it is not useful, if it changes the totals from other classes, need to affect them, in order to restore after set false.
        } else {
            ghgrf.a[ns]= carboncycle.co2rf.a[ns] + atchem.othgasrf.a[ns]+fgas.fgasrf.a[ns];
            anthrorf.a[ns]= ghgrf.a[ns] + aerosol.aerorf.a[ns];
            totalrf.a[ns]=  anthrorf.a[ns] + aerosol.natvrf.a[ns];
        }
    }
    
    
    
//*******************************************************
} //end radfor class



