package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import java.awt.Color;
import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

import jcm.mod.*;

public class oceantemp extends module  {
    
 	/*
	this module just includes the extra curves and calcs needed for an ocean temp plot
	separated from the main calc in get(glotemp.class) because multiplying out the whole matrix is rather slow
	 */
    
    public void setinteractions() {
	follows(get(glotemp.class));
	//see also precalc
    }
    
    public void precalc() {
	if (changed && needed) get(glotemp.class).changed=true; //force get(glotemp.class) to recalculate because depends on transient fields in get(glotemp.class) calcstep
    }
    
    //"real" box contents for viewbox  -beware about 150K memory!
    int nhb=udebclimod.nhb;
    public float[][] hq=new float[2*nhb][glos2];
    
    //curves for plotting
    public qt[] curve=new qt[hq.length];
    public qtset oceantemp=new qtset("oceantempcurves", "degc");
    
    //note the surface boxes moved from end to beginning of array
    public void initsetup() {
	int cd=(int)(get(udebclimod.class).mixlaydepth.getval()), cd2;
	for (int i=0; i<(nhb-1); i++) {
	    int r= (int) (127+127.0*Math.cos((Math.PI*2)*0.3*i/nhb));
	    int b= (int) (127+127.0*Math.cos((Math.PI*2)*(i-nhb/2)/nhb));
	    cd2=cd+(i<20 ? 49 :196);
	    cd=cd2;
	    curve[i+1]=new qt(hq[i], "N_"+cd+"-"+cd2+"m", new Color(r,0,b));
	    curve[i+nhb+1]=new qt(hq[i+nhb], "S_"+cd+"-"+cd2+"m", new Color(0,r,b));
	}
	
	curve[0]=new qt(hq[nhb-1], "N surface", red);
	curve[nhb]=new qt(hq[nhb+nhb-1], "S surface", green);
	for (qt q : curve) oceantemp.add(q);
	super.initsetup();
    }
    
    
    //********************************************
    
    public void calcstep() {
	//below is whole matrix multiplication : beware will be slow - so should only calc if needed for plot/table
	for (int o=0; o<2; o++) {	for (int n=0; n<nhb; n++) {
	    hq[n+o*nhb][ns]=0; for (int m=0; m<nhb; m++) hq[n+o*nhb][ns]+=get(udebclimod.class).MV[o].getArray()[n][m]*get(udebclimod.class).hiq[o][m];
	    //convert units from heat to temp
	    hq[n+o*nhb][ns]/=(get(udebclimod.class).qpt*(n<(nhb-1) ? get(udebclimod.class).dl[n]/get(udebclimod.class).mixlaydepth.getval() : 1) );
	}}
    } //calcstep
    
    
} //end class
