//Climate model to calculate global temperature rise from radiative forcing
//Based on Wigley-Raper Upwelling-Diffusion Energy Balance model
//fitted to GCMs as documented in IPCC-TAR WG1 Appx 9.1
//and solved using eigenvector method
//also calculates thermal expansion due to sea-level rise

//Developed in Copenhagen spring 2001

//note need to check effect of initial temperature profile on variable upwelling

package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.
import jcm.mod.*;

public class glotemp extends module  {
    
    //*****************************************************
    //INTERACTIONS
    
    public void setinteractions() {
	follows(get(radfor.class));
	setaffectedby(get(udebclimod.class));
    } //end interactions
    
    
    //temperature baseyear: just affect temp-plot (& temps shown on regclimap) not model calculations
    //note must be at least 3 less than stabtemp startyear!
    public param baseyear=new param("baseyear", "", 1860, 1760, 1997, blue);
    
    //*******************************************************
    //QTs
    //avchange is the average without offset to baseyear, all the rest are adjusted to zero at baseyear
    
    public static qt
	    proxytemp=new qt( "tempproxy" ,  greygreen, 1750, 1991  ),
	    tempdata=new qt( "tempdata" , dkgreen, 1750, 2002 ),
	    temptrend=new qt( "temptrend"  , green, 1750, 1999 );
    
    public qt
	    avchange=new qt(	"tempavfrom1750", brown , experimental),
	    avchangeby=new qt(	"tempav", brown , simplest),
	    tempnl=new qt( "tempnl"  , red ,  expert ),
	    tempno=new qt( "tempno" , blue ,  expert  ),
	    tempso	=new qt(  "tempso" ,  cyan ,  expert   ),
	    tempsl	=new qt( "tempsl"  ,  orange , expert   );
    
    public  float[][] boxtemp= {	tempnl.a, tempno.a, tempso.a, tempsl.a } ; //four temps, nl, no, so, sl
    
   public qtset temp=new qtset( avchange, avchangeby, tempnl, tempno, tempsl, tempso, tempdata, proxytemp, temptrend ,  "glotempcurves", "degcbase");
 
    
    /*****************************************************
     * OK P2 STRUC glotemp set qtset inc yscale instead of default qtset,
     * P3 CHECK whether need to revive old adjust yscale origin depending on baseyear (old codebelow)
     * //new scalemodel(scalemodel.Type.Y, "degcbase", -1.2, 3.2, 0.4, 1.0);
     *
     * //this isn't working - affects only the hist data and not the scale!!
     * //scale moves up/down with baseyear so that curve doesn't move -but can be many instances of it
     *
     * public scalemodel getyscale() {	return new  scalemodel(allqt, getunits()) {
     * float oldoffset=avchangeby.a[200]-avchange.a[200];
     * public void setinteractions() {  setaffectedby(baseyear); super.setinteractions(); }
     * public void precalc() {
     * float offset=avchangeby.a[200]-avchange.a[200], change=offset-oldoffset; oldoffset=offset;
     * min.val+=change*scaleu; max.val+=change*scaleu;
     * }
     * }; }
     *
     */
    
    //************************************
    // CALCULATION STEPS
    
    
    public void initsetup() {
	super.initsetup();
	for (int j=0; j<110; j++) tempdata.a[j]=0;
	//normalise tempdata.a and proxytemp.a to 1960-90
	for (int i=110; i<253; i++) tempdata.a[i]-=0.42;
	for (int i=0; i<242; i++) proxytemp.a[i]+=0.04;
    }
    
    public void startstate(int startyear) {	get(udebclimod.class).startstate(startyear); }
    public void save99() {	get(udebclimod.class).save99(); }
    
    public void calcstep() {
	if (ns>0)	get(udebclimod.class).tempupwellfb(avchange.a[ns]); //a feedback on self, using last-year temp
	avchange.a[ns]=get(udebclimod.class).adjust(new float[] {get(radfor.class).splitrf[0][ns], get(radfor.class).splitrf[1][ns], get(radfor.class).splitrf[2][ns], get(radfor.class).splitrf[3][ns]} );
	if (year==((int)baseyear.getval()  + 2))  calcoffset(); //do this at baseyear +2 (as 5yr average) Need in loop because used for stabilisation target
	get(sealevel.class).thermexp.a[ns]=get(udebclimod.class).thermalexpansion();
    }
    
    public void postcalc() {
	applyoffset(); calcerror();
	if (baseyear.changed) histtemptrend();
    } //have to do at end because affects curve before baseyear too
    
    //*******************************************************
    public double error=0;
    
    
    public void calcerror() {
	//error for probabilistic calculations
	// must do after both avchangeby and histdata have been offset
	//assume proxy temp error 0.5C, measured temp error 0.05C+0.0015*(1950-year) up to 1950 (based on info from CRU faq)
	float sumdiff=0, sumdata=0, sumcalc=0, n=0, ct, mt, e;
	for (int ns=0; ns<252; ns++)  {
	    ct=avchangeby.a[ns];
	    if (ns<110) {	mt=proxytemp.a[ns]; e=0.5f; } else {	mt=tempdata.a[ns]; e=0.05f+0.0015f*(ns<200 ? 200-ns : 0); }
	    sumdiff+=(ct-mt)*(ct-mt)/e;
	    sumcalc+=ct/e;
	    sumdata+=mt/e;
	    n+=1f/e;
	}
	error= Math.pow(sumdiff/n - (sumcalc/n - sumdata/n)* (sumcalc/n - sumdata/n), 0.5);
    }
    
    //********** normalise to baseyear ****************
    public double offset=0, oldoffset=1.0;
    
    //store offsets outside loop so remember old value if calcfutureonly
    float[] boxoffset=new float[4];
    
    public void calcoffset() {
	//normalise to baseyear temps -or actually +/-2yr average due to odd peaks
	//now apply to all the boxtemps separately
	//note hist data normalised in temptrend method as doesn't change unless baseyear changed
	oldoffset=offset; offset=0; for (int b=0; b<4; b++) boxoffset[b]=0;
	for (int i=0; i<5; i++) {
	    int dy=((int)baseyear.getval()-gsy)+i-2; if (dy<0) dy=0;
	    offset+=(float)((avchange.a[dy])/5.0);
	    for (int b=0; b<4; b++) boxoffset[b]+=(float)((boxtemp[b][dy])/5.0);
	}
    } //end calcoffset
    
    void applyoffset() {
	
	for (int ns=0; ns<=glos; ns++) {
	    for (int b=0; b<4; b++) boxtemp[b][ns]-=boxoffset[b];
	    avchangeby.a[ns]=(float)(avchange.a[ns]-offset);
	}
    }
    
    
    //******************************************
    //make historical tempdata trend
    
    void histtemptrend() {
	for (int ns=0; ns<=3; ns+=1) temptrend.a[ns]=0;
	for (int ns=0; ns<=6; ns+=1) temptrend.a[3]+=proxytemp.a[ns] / 7.0f;
	for (int ns=7; ns<=(1860-gsy); ns+=1) temptrend.a[ns-3]=temptrend.a[ns-4]+(proxytemp.a[ns]-proxytemp.a[ns-7]) /7.0f;
	for (int ns=1860-gsy; ns<=(1867-gsy); ns+=1) temptrend.a[ns-3]=temptrend.a[ns-4]+(tempdata.a[ns]-proxytemp.a[ns-7]) /7.0f;
	for (int ns=1868-gsy; ns<=2002-gsy; ns+=1) temptrend.a[ns-3]=temptrend.a[ns-4]+(tempdata.a[ns]-tempdata.a[ns-7]) /7.0f;
	
	//normalising to baseyear
	float htoffset=0;
	for (int i=0; i<5; i++) {
	    int dy= ((int)baseyear.getval()-gsy)+i-2; if (dy<0) dy=0;
	    htoffset+=(float)((baseyear.getval()>1862 ? tempdata.a[dy] : proxytemp.a[dy])/5.0);
	}
	
	for (int ns=0; ns<=1991-gsy; ns++) proxytemp.a[ns]-=htoffset;
	for (int ns=0; ns<=2002-gsy; ns++) tempdata.a[ns]-=htoffset;
	for (int ns=0; ns<=1999-gsy; ns++) temptrend.a[ns]-=htoffset;
	
	//flags for no data
	for (int ns=0; ns<3; ns++) temptrend.a[ns]=-999;
	for (int ns=0; ns<1860-gsy; ns++) tempdata.a[ns]=-999; //tempdata.a[hiss]=-999;
//	for (int ns=hiss; ns<=hiss+2; ns++) temptrend.a[ns]=-999;
//	for (int ns=1991-gsy; ns<=hiss+2; ns++) proxytemp.a[ns]=-999;
    }
    
	   /*
	     //****************************************************
	     //TEMPERATURE -  CARBONCYCLE FEEDBACK
	     these methods are called from carboncycle feedbacks
	     Need a temperature rise relative to preindustrial, based on the previous year,
	     because carboncycle precedes this module in the calculation loop
	    
	     Beware temperature normalisation to baseyear which isn't done until postcalc!
	     so if calcfutureonly boxtemp[0] and boxtemp[249] are still normalised (prev loop)
	     but boxtemp[250] isn't yet
	    
	     Actually taking sum/2 isn't correct - should weight by areas of N / S boxes!
	    
	     note october 2004: this isn't working with calcfutureonly in initial startup in period 1990-2000!
	    
	    
	    beware - these methods called even when this module is not changed so doesn't run loop methods!
	    eg when call carbonstorage - makes carboncycle run but doesn't change this
	    then problem is to undo the normalisation
	    
	    */
    public boolean usehisttempdata=false; //for feedbacks note: called from some scripts
    
    public double getoceantemprise() { return(gettemprise(1)); }
    public double getlandtemprise() { return (gettemprise(0)); }
    
    double gettemprise(int b) {
	if (usehisttempdata && ns<252) {     	//option for history use data normalised to 1850
	    float nfac=0, temprise;
	    for (int s=98; s<103; s++) nfac+=proxytemp.a[s]/5f;
	    temprise=(ns<110 ? proxytemp.a[ns] : tempdata.a[ns])-nfac;
	    return temprise* (b==0 ?  1.356 : 0.847); //higher on land than ocean
	} else {
	    return (ns>0? ((boxtemp[b][ns-1]+boxtemp[3-b][ns-1])
	    +(	((loop.calcfutureonly && ns<=250) || !changed) ? (boxoffset[b]+boxoffset[3-b]) : 0)
	    ) /2.0: 0);
	}
    }
    
    
} //end  class


