
package jcm.mod.carbon;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;

import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.
import jcm.mod.*;
import jcm.mod.cli.glotemp;


public class berncarbon extends module {
    
     
    public void setinteractions() {
	setaffectedby(carbonatechemistry.class);
	setaffectedby(glotemp.class, respq10.getval()!=1.0); //for temp-biosphere feedback
    }
    
    //adjustable parameters
    public param
	    diffufac=new param("ceddydiff", "", blue, 1, 0, 2), 			//to multiply by vertical diffusivity
	    sidemix=new param("csidemix", "", yellow,  1000.0/538.0, 0, 5), 	//ocean sideways mixing - note *1000
	    upwell=new param("cupwell", "m&per&yr", red, 0.44, 0, 1), 		//ocean upwelling
	    hlmix=new param("chighlat", "m&per&yr", cyan, 38, 0, 70), 		//ocean high-lat mixing
	    beta=new param("fertbeta", "", green, 0.287, 0, 0.6), 			//tb fertilisation
	    fbchfut=new param("fbchfut", false), 		//change fertbeta only after 2000
	    respq10=new param("resp_q10","", brown,1.2, 0.5, 2.5); //respiration q10 - note highly uncertain! 
    //stepsperyear=new param("stepsperyear", "steps", 1, 1, 20);	//!not currently used
    
    
    public void precalc() { setupfluxes();    }
    
    
    //*******************************************************
    //CONSTANTS
    
    static final double ocdepth=3725.0, ocarea=3.616e14;
    static final double dml=75.0; //mixed layer depth
    static final double hfrac=0.16, lhf=(1.0-hfrac)/hfrac; //hfrac= fraction of area in high-lat b
    int steps=1; double dt=1.0/steps; //timestepand stepsperyear.getval();
    
    
    //*******************************************************
    //BOX DATA
    
    //system boxes
    //neb =total boxes with extra non-linear flux, nqb = total boxes we need to query
    //int neb=4, nqb=3;
    
    //ncl =num low-lat ocean layers (excluding surface) ncb=total num boxes
    static final public int ncl=34, ncb=ncl+4+5;
    double[] dl=new double[ncl]; // depth of layer
    double[] diffu=new double[ncl]; // diffusivity for top of layer
    
    
    //make standard arrays
    double[] cbox(){	return new double[ncb]; }
    
    //Matrix for converting back  to get real box contents if viewbox (see carbonstorage)
    Matrix MV;
    
    public double[]
	    cpropf=cbox(), ciq=cbox(), ciqi=cbox(), ciq99=cbox(), //ciq stores the box contents, i for iteration, 99 for starting at 2000
	    crBIO=cbox(), crOC=cbox() 	//for total tbio & ocean sinks
	    ;
    
    public double[]
	    crAT=cbox(), crLS=cbox(), crHS=cbox(), //rows for querying boxes
	    scicAT=cbox(), scicLS=cbox(), scicHS=cbox(), scicNP=cbox(),  //columns for adding to them, premultiplied by step function
	    rcicAT=cbox(), rcicLS=cbox(), rcicHS=cbox(), rcicNP=cbox(),  //ditto for ramp function
	    crSO=cbox(), scicSO=cbox(), rcicSO=cbox(), crHU=cbox(), scicHU=cbox(), rcicHU=cbox() 		//extra for soil respiration
	    ;
    
    //various working variables
    //could tidy up variables by making a nonlin-"box" class, and then just go through all of them.
    
    //note these may be accessed from other modules such as responsibility
    public double totemit,  oldtotemit, oldatinc, atinc, oldlsinc, lsinc, oldhsinc, hsinc, oldnpinc, npinc;
    
    //box contents (of interest)
    public double at, ls, hs,  oldls, oldhs, tb, oldtb, oc, oldoc;
    public double dat ,dls, dhs, dnp;
    //double odls, odhs, odnp, ndls, ndhs, ndnp;
    //store box contents and non-linear fluxes for starting at 2000
    double atinc99, lsinc99, hsinc99, npinc99, totemit99, dls99, dhs99, dnp99;
    double atppmy=carboncycle.atppmprein;
    
    double guess, nit, ncit, oldnit=1, ciqr, diff, wit, check;
    String err="";
    //added for vary soil respiration
    public double  soinc, huinc, oldsoinc, soinc99, huinc99, oldhuinc, so, hu, oldso, oldhu, dso, dhu, dso99, dhu99;
    
    double nplin, betab; //linear part of terrestial fertilisation
    
    
    //**************************************************************
    //ocean-atmosphere-biosphere carbon cycle system setup
    //note units: rates per year, boxes contain Mt C, distances in m
    
    void setupfluxes() {
	
	
	//setup various constants, for carbon chemistry and gas-exchange etc.
	
	//linear part of new production due to fertilisation
	nplin=60000*beta.getval()*get(carboncycle.class).ppmpmtc/get(carboncycle.class).atppmprein;
	
	double dtot=0.0;
	double ocu=upwell.getval(), ocw=hlmix.getval(), srate=sidemix.getval()/1000.0;
	
	for (int n=0; n<ncl; n++) {
	    dl[n]=(n<20 ? 49.0 : 196.0); if (n>0) dtot+=dl[n];
	    diffu[n]=diffufac.getval()*(465.0+7096.0*Math.exp(-dtot/253.0));
	}
	
	//*********************************
	//make rates for exchange between boxes (gross rates per year)
	//rate[i][j] is the amount by which you have multiply box j to get the change in box i
	
	//ocean system: 0 to ncl-1 are LD layers, ncl is LS, ncl+1 is HS, ncl+2 is HD,
	//ncl+3 is atmosphere
	//biosphere system: ncl+4 is green, ncl+5 is wood, ncl+6 is soil, ncl+7 is humus, ncl+8 is new-production (temporary box)
	
	double[][] rate=new double[ncb][ncb]; for (int i=0; i<ncb; i++) {	for (int j=0; j<ncb; j++) {	rate[i][j]=0; }}
	
	//go through layers
	double rvu, rv, rh, rjff;
	for (int n=1; n<ncl; n++) {
	    rvu=(2.0*diffu[n]-ocu*dl[n])/(dl[n-1]*(dl[n-1]+dl[n]));
	    rv =(2.0*diffu[n]+ocu*dl[n-1])/(dl[n]*(dl[n-1]+dl[n]));
	    rh = srate*lhf*dl[n]/ocdepth;
	    rate[n][n-1]+=rvu; rate[n-1][n-1]-=rvu;
	    rate[n-1][n]+=rv; rate[n][n]-=rv;
	    rate[n][ncl+2]+=rh; rate[ncl+2][ncl+2]-=rh;
	    rate[ncl+2][n]+=srate; rate[n][n]-=srate;
	}
	
	//top layer and ls exchange:
	rvu=(8.0*diffu[0]/(3.0*dl[0]*dml))-ocu/dml;
	rv =3.0*diffu[0]/(dl[0]*dl[0]);
	rjff=diffu[0]/(3.0*dl[0]*dl[0]);
	rate[0][ncl]+=rvu; rate[ncl][ncl]-=rvu;
	rate[ncl][0]+=rv; rate[0][0]-=rv;
	rate[0][1]+=rjff; rate[ncl][1]-=rjff;
	//rjff is joos funny flux. To make like other layers, remove and replace with below:
	//rvu=(2.0*diffu[0]-ocu*dl[0])/(dml*(dml+dl[0]));
	//rv =(2.0*diffu[0]+ocu*dml)/(dl[0]*(dml+dl[0]));
	//rate[0][ncl]+=rvu; rate[ncl][ncl]-=rvu;
	//rate[ncl][0]+=rv; rate[0][0]-=rv;
	
	rh = srate*lhf*dl[0]/ocdepth;
	rate[0][ncl+2]+=rh; rate[ncl+2][ncl+2]-=rh;
	rate[ncl+2][0]+=srate; rate[0][0]-=srate;
	
	//ls and hs exchange:
	rate[ncl][ncl+1]+=srate*lhf*dml/ocdepth; rate[ncl+1][ncl+1]-=srate*lhf*dml/ocdepth;
	rate[ncl+1][ncl]+=srate+ocu/dml; rate[ncl][ncl]-=srate+ocu/dml;
	//bottom u-flow:
	rate[ncl-1][ncl+2]+=ocu*lhf/ocdepth; rate[ncl+2][ncl+2]-=ocu*lhf/ocdepth;
	//hs surf <=> deep
	rate[ncl+1][ncl+2]+= ocw/ocdepth; rate[ncl+2][ncl+2]-=ocw/ocdepth;
	rate[ncl+2][ncl+1]+=(ocw+ocu/lhf)/dml; rate[ncl+1][ncl+1]-=(ocw+ocu/lhf)/dml;
	
	//make sure this is called after get(carbonatechemistry.class) in precalc loop!
	get(carbonatechemistry.class).setupchemistry();
	double[] saflin=get(carbonatechemistry.class).saflin, alpha=get(carbonatechemistry.class).alpha;
	
	//sea-air flux, saflin component only
	rate[ncl+3][ncl]+=saflin[0]; rate[ncl][ncl]-=saflin[0];
	rate[ncl+3][ncl+1]+=saflin[1]; rate[ncl+1][ncl+1]-=saflin[1];
	
	//air-sea flux
	rate[ncl][ncl+3]+=alpha[0]; rate[ncl+3][ncl+3]-=alpha[0];
	rate[ncl+1][ncl+3]+=alpha[1]; rate[ncl+3][ncl+3]-=alpha[1];
	
	//terrestrial biosphere fluxes
	rate[ncl+7][ncl+5]+=0.01; rate[ncl+5][ncl+5]-=0.01; //wood-humus
	rate[ncl+7][ncl+6]+=0.08333; rate[ncl+6][ncl+6]-=0.08333; //soil-humus
	rate[ncl+6][ncl+5]+=0.04; rate[ncl+5][ncl+5]-=0.04; //wood-soil
	rate[ncl+6][ncl+4]+=0.35; rate [ncl+4][ncl+4]-=0.35; //green-soil
	rate[ncl+5][ncl+8]+=0.41667; rate [ncl+8][ncl+8]-=0.41667; //newprodn-wood
	rate[ncl+4][ncl+8]+=0.58333; rate [ncl+8][ncl+8]-=0.58333; //newprodn-green
	rate[ncl+3][ncl+6]+=0.375; rate[ncl+6][ncl+6]-=0.375; //soil-atmosphere
	rate[ncl+3][ncl+7]+=0.01; rate[ncl+7][ncl+7]-=0.01; //humus-atmosphere
	rate[ncl+8][ncl+3]+=nplin; rate[ncl+3][ncl+3]-=nplin; //linear part of atmosphere-newprodn
	
	//*******************************
	
	double[] cicAT=cbox(), cicLS=cbox(), cicHS=cbox(), cicNP=cbox();
	double[] cicSO=cbox(), cicHU=cbox(); //extra for varying soil respiration
	
	// now put this into a jama Matrix
	EigenvalueDecomposition ED=new EigenvalueDecomposition(new Matrix(rate,ncb,ncb));
	MV=ED.getV();
	Matrix MVI=MV.inverse().transpose();
	
	//I need the rows of S for the 3 boxes LS,HS,AT, and the equiv columns of S-1
	//also need S-1 for terrestrial newproduction, and S for sum of all bio sink
	crLS=MV.getArray()[ncl];
	crHS=MV.getArray()[ncl+1];
	crAT=MV.getArray()[ncl+3];
	//added for soil respiration
	crSO=MV.getArray()[ncl+6];
	crHU=MV.getArray()[ncl+7];
	
	crBIO=new double[ncb]; crOC=new double[ncb];
	for (int n=0; n<ncb; n++){
	    crBIO[n]=0; for (int i=0; i<5; i++) crBIO[n]+=MV.getArray()[ncl+4+i][n];
	    crOC[n]=0; for (int i=0; i<ncl+3; i++) crOC[n]+=MV.getArray()[i][n];
	}
	cicLS=MVI.getArray()[ncl];
	cicHS=MVI.getArray()[ncl+1];
	cicAT=MVI.getArray()[ncl+3];
	cicNP=MVI.getArray()[ncl+8];
	//added for soil respiration
	cicSO=MVI.getArray()[ncl+6];
	cicHU=MVI.getArray()[ncl+7];
	
	//check diagonalization works
	//R.eig().getV().print(10,6);
	//MV.times(ED.getD().times(MV.inverse())).print(10,6);
	//R.eig().getV().times(R.eig().getV().inverse()).print(10,6);
	//MV.print(10,6);
	
	//make cpropf, cstepf, crampf functions
	double[] Eig= ED.getRealEigenvalues(); double stepf,rampf;
	for (int n=0; n<ncb; n++) {
	    cpropf[n]=Math.exp(Eig[n]*dt);
	    if (Math.abs(Eig[n])<0.000001) {	stepf=dt; rampf=dt/2.0; } else {	stepf=(cpropf[n]-1.0)/Eig[n]; rampf=(stepf-dt)/(Eig[n]*dt); }
	    
	    String dummy="ok here "+n;
	    
	    scicLS[n]=stepf*cicLS[n];
	    scicHS[n]=stepf*cicHS[n];
	    scicAT[n]=stepf*cicAT[n];
	    scicNP[n]=stepf*cicNP[n];
	    rcicLS[n]=rampf*cicLS[n];
	    rcicHS[n]=rampf*cicHS[n];
	    rcicAT[n]=rampf*cicAT[n];
	    rcicNP[n]=rampf*cicNP[n];
	    //added for soil respiration
	    scicSO[n]=stepf*cicSO[n];
	    scicHU[n]=stepf*cicHU[n];
	    rcicSO[n]=rampf*cicSO[n];
	    rcicHU[n]=rampf*cicHU[n];
	}
	
	//if (!carbonstorage.needed) MV=null; //beware this may not work!
	ED=null; MVI=null; Eig=null; rate=null; //don't need these any more -save memory
    } //end setup
    
    
    //**************************************
    //reset the boxes according to startyear
    //Note the 1999 data is set by running it from 1750 initially
    
    public void startstate(int startyear) {
	at=0; ls=0; hs=0; oldls=0; oldhs=0; oc=0; tb=0;
	so=0; hu=0;
	if (startyear==1750) {
	    for (int n=0; n<ncb; n++) ciq[n]=0;
	    atinc=0; lsinc=0; hsinc=0; npinc=0; oldtotemit=0;
	    dls=0; dhs=0; dnp=0;
	    //added for soil respiration
	    soinc=0; huinc=0; dso=0; dhu=0;
	} //end 1750
	
	else {	//assume startyear is 2000
	    //not yet fixed fror soil respiration!
	    for (int n=0; n<ncb; n++) {	ciq[n]=ciq99[n]; }
	    atinc=atinc99; lsinc=lsinc99; hsinc=hsinc99; npinc=npinc99; oldtotemit=totemit99;
	    dls=dls99; dhs=dhs99; dnp=dnp99;
	    //added for soil respiration
	    soinc=soinc99; huinc=huinc99; dso=dso99; dhu=dhu99;
	} //end 2000
	
	oldatinc=atinc; oldlsinc=lsinc; oldhsinc=hsinc; oldnpinc=npinc;
	oldsoinc=soinc; oldhuinc=huinc;
	//odls=dls; odhs=dhs; odnp=dnp;
	for (int n=0; n<ncb; n++) ciqi[n]=ciq[n];
	tb=0; oc=0; for (int n=0; n<ncb; n++) {	tb+=ciq[n]*crBIO[n]; oc+=ciq[n]*crOC[n]; }
	
	//temp fix: force run history even if start 2000
	//if (startyear==2000) for (int ns=0; ns<hiss; ns++) calcstep(ns);
	
    } //end startstate
    
    
    
    //*************************************************
    //MAIN LOOP CALC
    // called from get(carboncycle.class) calcstep
    //can't make it a calcstep here because doesn't store any state
    
    float[] addemit(float totemit) {
	
	this.totemit=totemit;
	//TEMPERATURE-FEEDBACK
	//re-calculate "constants" for carbonate chemistry if considering feedback from temp change
	get(carbonatechemistry.class).temperaturefeedback();
	//feedback from temperature on soil respiration
	double soilresptempfbfac=(1.0-Math.pow(respq10.getval(), get(glotemp.class).getlandtemprise()/10.0));
	
	//********inner steps loop**********
	//usually steps=1, use more only to test the rampfunction assumption works ok
	for (int step=0; step<steps; step++) {
	    
	    //first apply the prop & step functions to calculate base change (using data for beginning of year)
	    for (int n=0; n<ncb; n++) {	ciq[n]= cpropf[n]*ciq[n] +scicAT[n]*atinc + scicLS[n]*lsinc + scicHS[n]*hsinc +scicNP[n]*npinc +scicSO[n]*soinc + scicHU[n]*huinc; }
	    
	    //first guess assumes dls, dhs, dnp same as last time
	    //or enable 2 lines below for changed by same as last time -but encourages minor oscillations!
	    //ndls=2*dls-odls; ndhs=2*dhs-odhs; ndnp= 2*dnp-odnp;
	    //odls=dls; odhs=dhs; odnp=dnp; dls=ndls; dhs=ndhs; dnp=ndnp;
	    
	    //store for use in attribution scaling
	    oldls=ls; oldhs=hs; oldso=so; oldhu=hu;
	    
	    //******** start of iteration loop ********
	    nit=0; do {
		
		dat= (totemit-oldtotemit) -(dls+dhs+dnp+dso+dhu);
		
		//apply ramp function and work out new contents of at, ls and hs
		if (nit==0) wit=1.0; else wit=0.3; //arbitrary iteration parameter
		
		at=0; ls=0; hs=0; so=0; hu=0;
		for (int n=0; n<ncb; n++) {
		    ciqr=rcicAT[n]*dat + rcicLS[n]*dls + rcicHS[n]*dhs +rcicNP[n]*dnp  +rcicSO[n]*dso +rcicHU[n]*dhu;
		    ciqi[n]=wit*(ciq[n]+ciqr)+(1.0-wit)*ciqi[n];
		    at+=crAT[n]*ciqi[n]; ls+=crLS[n]*ciqi[n]; hs+=crHS[n]*ciqi[n]; so+=crSO[n]*ciqi[n]; hu+=crHU[n]*ciqi[n];
		}
		
		//work out non-linear part of sea-air fluxes, 0 for low-lat box, 1 for high-lat box
		lsinc=-get(carbonatechemistry.class).safnonlin(ls, 0); hsinc=-get(carbonatechemistry.class).safnonlin(hs, 1);
		
		//terrestrial biosphere fertilisation
		betab= (fbchfut.istrue() && ns<250 ? beta.getdef() : beta.getval() );
		npinc=60000*betab*Math.log((at*get(carboncycle.class).ppmpmtc/get(carboncycle.class).atppmprein)+1.0)-at*nplin;
		
		//vary soil respiration
		//note 45000 and 15000 are the pre-ind steady-state fluxes, which depend on the inter-box rate constants (see setup below)
		soinc= (so*0.375+45000)*soilresptempfbfac;
		huinc= (hu*0.01 +15000)*soilresptempfbfac;
		//effect of nonlin fluxes on atmosphere
		atinc= totemit-(lsinc+hsinc+npinc+soinc+huinc);
		
		guess=dls+ dhs+ dnp +dso +dhu;
		dls=lsinc-oldlsinc; dhs=hsinc-oldhsinc; dnp=npinc-oldnpinc; dso=soinc-oldsoinc; dhu=huinc-oldhuinc;
		check=dls+ dhs+ dnp +dso + dhu;
		
		nit++;
	    } while (Math.abs(guess-check)>10 && nit<10);
	    //if difference >10MtC and no more than 10 iterations
	    //********* end of iteration loop *********
	    
	    //permanently update ciq and record old values
	    for (int n=0; n<ncb; n++) {	ciq[n]=ciqi[n]; }
	    oldatinc=atinc; oldlsinc=lsinc; oldhsinc=hsinc; oldnpinc=npinc; oldsoinc=soinc; oldhuinc=huinc;
	    oldtotemit=totemit;
	    
	}  //********** end inner steps loop ***********
	
	//work out new total biosphere and ocean contents
	oldtb=tb; tb=0; oldoc=oc; oc=0;
	for (int n=0; n<ncb; n++) {	tb+=ciq[n]*crBIO[n]; oc+=ciq[n]*crOC[n]; }
	
	atppmy=get(carboncycle.class).atppmprein+(get(carboncycle.class).ppmpmtc*at);
	
	//"output" data for plotting and further calculations
	return new float[]{(float) atppmy, (float)(tb-oldtb), (float)(oc-oldoc)};
    } //end addemit
    //*************************************************
    
    
    //save 1999 state for adjusting future only -called from loop
    
    public void save99() {
	atinc99=atinc; lsinc99=lsinc; hsinc99=hsinc; npinc99=npinc;
	soinc99=soinc; huinc99=huinc; dso99=dso; dhu99=dhu;
	totemit99=totemit; dls99=dls; dhs99=dhs; dnp99=dnp;
	for (int n=0; n<ncb; n++) {	ciq99[n]=ciq[n]; }
    }
    
    //***********************************************
    
} //end class

//prob with adding extra bio-feedbacks is
//1: need total carbon
//2: inefficiencies as start to query many rows etc.
//3: wd be better to seperate ocean and tbio 2 systems


