//OK P1 check correcfac of country areas and refine country borders
//P2 FIX reescale countries to have the same areas of agriculture and pasture HYDE/FAO
//P2 include SAGE database
//P2 fix ocean to agric to past
//NOTE Israel has population since 1700; but palestine since 1997

//OK P2 regression of  CAIT using houghton, but it is in socreg
//OK P3 do a class with all historical LUC datasets for comparing differente sources 2005-11-08
//OK P2 FIX Verify countries that areas finish and carbon stocks in 1970 as Panama 2005-11-06
//OK P4 check biome 1 brazil 2005-11-06
//OK P3 check time spent 2005-10-25
//OK FIX chagne qtset countryareas to map 2005-10-14
//OK P5 correct country areas 2005-10-09
//OK P5 Split module 2005-10-5
//OK P5 Fix the FAO x HYDE correcfac 20005-10-09
//OK P1 change country qtareas to float 2005-10-14


/*
 * CalcAreasCountries.java
 *
 * Created on 4 juillet 2005, 17:57
 */

   /*
    Note Ben 16/09
    Removed most of the statics so that it can work with parallel worlds
    Also changed BiomeClass param to a list
    Setup of biomestock changed likewise, so can run different classifications simultaneously - check notes inside class
    Comparing LUC in two worlds with different params seems to work OK, but further checking needed
     Noe it might be more efficient to keep 2 static copies of biomechangemap (one each for both LU A & B), so can swap these or set-up parallel copy without reloading data
    */

package jcm.mod.carbon;

import java.util.*;
import jcm.mod.reg.*;
import jcm.core.*;
import jcm.tls.*;
import jcm.mod.data.*;
import static jcm.gui.gen.colfont.*;
import static java.lang.Math.*;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.*;
import jcm.mod.soc.socreg;

public class CalcLucEmit extends module {
    Map<Integer , int[][]> luTables = new HashMap();
    Map<Integer, biomestock> biomestocks = new HashMap();
    Map<Integer, Map<Integer, Float>> bcm = new HashMap();
    Set<cell> cellset = new HashSet();
    static Map<region, Float> countryArcviewAreas = new HashMap();
    
    //*************************************
    
    public qtset lucemit = new qtset("IVIG32 model LUC emission", "kilo&ton&carbon", 1700, 2002, 1);
    public qtset carbonstock = new qtset("IVIG32 model Carbon Stocks", "kilo&ton&carbon", 1700, 2002, 1);
    
    public static qtset lucCO2Houghton = new qtset("Houghton LUC emit", "kilo&ton&carbon", 1700, 2002);
    public static qtset lucCO2UNFCCC = new qtset("UNFCCC LUC emit","kilo&ton&carbon", 1990, 2002);
    public static qtset lucCO2CAIT = new qtset("CAIT LUC emit", "kilo&ton&carbon", 1950,2000);
    public static qtset lucCO2CAIT1 = new qtset("CAIT-1 LUC emit", "kilo&ton&carbon", 1850,2000);
    public static qtset faoagr = new qtset("FAO Agriculture Area", "mega&m2", 1961, 2002);
    public static qtset faopast = new qtset("FAO Pasture Area", "mega&m2", 1961, 2002);
    public qtset biomeChosenCountries = new qtset("1 Biome area all countries plot", "mega&m2", 1700, 2002, complexity.expert);
    public qtset countryChosenBiomes = new qtset("1 Country all biomes areas plot ", "mega&m2", 1700, 2002, complexity.expert);
    public qtset countryChosenAP = new qtset("1 Country FAOxModel areas plot","mega&m2", 1961, 2002, complexity.expert);
    public qtset countryChosenEmission = new qtset("1 Country all emissions datasets","kilo&ton&carbon", 1700, 2002, complexity.expert);
    static public qtset edgarff = new qtset("EDGAR fossil", "kilo&ton&carbon", 1890, 2000, complexity.experimental);  //method to read the grid files from EDGAR, need some fix in the contry/ocean borders
    static public qtset edgarluc = new qtset("EDGAR LUC", "kilo&ton&carbon", 1890, 2000, complexity.experimental);  //method to read the grid files from EDGAR, need some fix in the contry/ocean borders
    //FAO data are constant so qtsets can remain static
    
    //historical landusechange options
    public String[] lucsources = new String[] {"IVIGmodel", "Houghton",  "Inverse"} ; //, "EDGAR"}; // "MATCH", "EDGAR", }; "IVIGdata", P1 remove IVIGdata
    public param lucsource = new param("LUC emit dataset", lucsources, "IVIGmodel", complexity.simplest);
    
    String[] biomeNameA = {  "Ocean","Cultivated land","Pasture","X","X","Ice","Tundra","Wooded tundra",  "Boreal forest","Cool conifer forest","Temperate mixed forest","Temperate deciduous forest",    "Warm mixed forest","Grassland/Steppe","Hot desert","Scrubland","Savanna","Tropical woodland", "Tropical forest"};
    String[] biomeNameB = { "Ocean","Cultivated land","Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland", "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland", "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland", "Savanna", "Grassland/Steppe", "Dense Shrubland", "Open Shrubland", "Tundra", "Hot Desert", "Polar Deser/Rock/Ice" };
    public param biomeclass = new param("Biome classification", new String[]{"A","B"}, "B") {
        public void precalc() {
            biomeList.menulist = biomeclass.chosen.equals("A") ? biomeNameA : biomeNameB;
            biomeList.choose("Cultivated land");
            countryChosenBiomes.map.clear();
            loadHYDEdata() ;
        }
    };
    
    //*****************************
    public param biomeList = new param("Biome chosed plot", biomeclass.chosen.equals("A") ? biomeNameA : biomeNameB, "Cultivated land", complexity.expert);
    public param countryList = new param("Country chosed plot", (region[]) regman.nations.reg.toArray(new region[0]) , regman.nations.find("Brazil"), complexity.expert);
    public param FAO2002 = new param("FAO agric/past rates of change", true, complexity.expert);
    public param vegetationCarbon = new param("Vegetation Carbon uncertainty" ,"",  1, 0.8, 1.2, complexity.expert);
    public param isam = new param("Biome B/ISAM carbon content", false, complexity.expert);
    public param soildecayrate = new param("95% soil decay time" ,"",  20, 0.1, 30, complexity.expert); // name, default, maximum, minum
    public param soillossagric = new param("LUC agriculture carbon loss from soil" ,"",  0.2, 0.1, 0.3, complexity.expert);
    public param soillosspast = new param("LUC pasture carbon loss from soil" ,"",  0.05, 0.01, 0.1, complexity.expert);
    public param simplemethod = new param("Simple soil emissions (IVIG31)", false, complexity.experimental);
    public param grassyon = new param("Grassy soil carbon", false, complexity.experimental);
    public param shiftcultivation = new param("Shifting cultivation", false, complexity.experimental);
    public param shiftcultfrac = new param("Shifting cultivation fraction" ,"",  0.05, 0.01, 0.1, complexity.experimental);
    //land use emissions in 1990, MtCyr-1 Use 2158 for consistency with Houghton data (rather high), 1600 for old JCM setting to fit concn
    public param landuseemit=new param("lucfemit1990", "mega&ton&carbon&per&yr", 2158.09, 0, 3000, complexity.expert);
    //*************************************
    
    static int[] periodsHYDE = {1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990};
    static int[] periods =     {1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2002};
    float oldstock, newstock, countryModelArea, correcAFAO1970, correcPFAO1970;
    
    public static Color[] colsA= { //new colorset
        black, // sea
        red, pink, black, black,// 1agriculture, 2pasture, 3XX, 4X
        white, cyan, dkcyan, // 5ice, 6tundra, 7wooded tundra
        browngreen, dkredgreen, dkyellowgreen, // 8Boreal forest, 9Cool conifer forest, 10Temperate mixed forest
        yellowgreen, olive, orange, // 11Temperate deciduous forest, 12Warm mixed forest, 13Grassland/Steppe
        yellow, brown, ltgreen,// 14Hot desert, 15Scrubland, 16Savanna
        green, dkgreen// 17Tropical woodland, 18Tropical forest
    };
    
    public static Color[]  colsB = { //new colorset
        black, // sea
        red, pink, dkgreen, green, // 1agriculture, 2pasture, 3Tropical Evergreen Forest / Woodland, 4Tropical Deciduous Forest / Woodland
        dkgrey, olive, yellowgreen,  // 5Temperate Broadleafed Evergreen Forest / Woodland, 6Temperate Needleleafed Evergreen Forest / Woodland, 7Temperate Decidous Forest / Woodland
        dkredgreen, dkyellowgreen, browngreen,// 8Boreal Evergreen Forest / Woodland, 9Boreal Deciduous Forest / Woodland, 10Evergreen / Deciduous Mixed Forest / Woodland
        ltgreen, orange, brown,  // 11Savanna, 12Grassland / Steppe,  13Dense Shrubland
        dkbrown, cyan, yellow, // 14Open Shrubland, 15Tundra, 16Hot Desert
        white, black// 17Polar Deser / Rock / Ice, 18
    };
    
    //*************************
    //potential for calculating future LUC scenarios
    public Map<region, Float> potluc=new HashMap();
    public int startscenluc;
    public int cc; //for carbon content array biome A, B and B/ISAM
    //********************************************
    
    static boolean loadeddata=false; 
    
    static void getdata() { //only do once, and same for all worlds
        reporttime("begin CLE loaddata");
        for (region r : regman.nations.reg) r.makepolys(); //this is essential if not done already
        System.err.println("Running CalcLucEmit");
        loadStaticData();
        reporttime("end CLE loaddata");
	loadeddata=true;
    }
    
   
    public void precalc() {
	if (!loadeddata) getdata();
        switch(biomeclass.getchosenindex()) {
            case 0 : cc = 0; break;
            case 1 : cc = !isam.istrue() ? 1 : 2;
        }
        if (lucsource.chosen.equals("IVIGmodel"))  runmodel();
        calcpots();
    }
    
    public static void main(String[] args) {
        for (region r : regman.nations.reg) r.makepolys();
        CalcLucEmit c = new CalcLucEmit();
        c.loadHYDEdata();
        c.runmodel();
    }
    
    public void runmodel() {
        reporttime("begin CLE runmodel");
        countryChosenBiomes.map.clear();
        countryChosenAP.map.clear();
        for (region r : regman.nations.reg) { //nations    allreg.find("SRES4") CAI
            //System.err.print(r+"\t");
            findCells(r);
            calcInitialStock(r);
            setqtcolors(r);
            
            for (int i = 0; i < periods.length; i++) if (i != 0) { // if from 1750 to 1990
                if (i<8) calcBiomeChangeMap(i, i-1, r);
                for (int year = periods[i-1]+1; year <= periods[i]; year += lucemit.xstep) {
                    calcAreaChange(i, r, year);
                    calcEmit(i,r, year);
                } //years loop
            } // if 1750 to 1990
        } // regions
        reporttime("end CLE runmodel");
    } // runmodel
    
    void calcAreaChange(int i, region r, int year)  {
        
        float area, totachange=0, totpchange=0, totFAOachange, totFAOpchange, totHYDEachange=0, totHYDEpchange=0,
                correcfaca, correcfacp, totaptransfer=0, available;
        
        //if (year>1700 && year < 1962) {} //TODO interpolation for the areas according to the history.hydepop
        
        if (year>1961 && FAO2002.istrue()) {
            //calc FAO total change
            totFAOachange = faoagr.get(r, year) - faoagr.get(r, year-1);
            totFAOpchange = faopast.get(r, year) - faopast.get(r, year-1);
            
            //-----------------setting the tot(a)change the correcfac(a) and transfer from 1 to 2 when totHYDEachange == 0
            totHYDEachange = 0; totHYDEpchange = 0;
            
            for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
                area = bcm.get(f).get(t);
                if (t==1) totHYDEachange += area;
                if (f==1) totHYDEachange -= area;
            } //f t loop
            
            if (totHYDEachange == 0){ //change bcm to have some flags when totHYDEachange == 0
                float flag = 10;
                if ( !bcm.containsKey(1)) bcm.put(1, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
                if ( !bcm.get(1).containsKey(2)) bcm.get(1).put(2, flag); // setting bcm 1 <=> 2
                totHYDEachange -= flag;
            } //if totHYDEachange == 0
            
            correcfaca = totFAOachange/totHYDEachange; //NOTE Should not have case where totHYDEachange is zero and there is always transfers from to biome 1
            
            //summing all transfer from 1<=>2
            for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0) { // >0 ignore ocean changes
                area = bcm.get(f).get(t);
                if (t==1 && f==2) totaptransfer -= area*correcfaca;
                if (f==1 && t==2) totaptransfer += area*correcfaca;
            } //f t loop
            
            //-----------------setting the tot(p)change the correcfac(p) and without transfer from 1 to 2
            for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>1 && t>1 ) { // >0 ignore ocean changes and agric
                area = bcm.get(f).get(t);
                //if (f==2 && t!=1) totHYDEpchange -= area;
                if (f==2) totHYDEpchange += area; //NOTE it is being summed because it is necessary that all biomes change to 2 have the same pattern
                if (t==2) totHYDEpchange += area;
            } //f t loop
            
            if (totHYDEpchange==0 ){ //if there is no biomes under change for pasture
                int biomeC=0; //biomeChosed
                float areaB=0;
                for (int b = 3; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++) // choose the biggest biome
                    if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
                    areaB = biomestocks.get(b).totarea; biomeC = b;
                    }
                float flag = 10;
                if ( !bcm.containsKey(biomeC)) bcm.put(biomeC, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
                if ( !bcm.get(biomeC).containsKey(2)) bcm.get(biomeC).put(2, flag); // setting bcm 1 <=> 2
                totHYDEachange -= flag;
            }
            
            correcfacp = (totHYDEpchange != 0) ? (totFAOpchange-totaptransfer)/totHYDEpchange : 1; //NOTE There are several cases where totHYDE(p)change is zero and there is transfers from to biome 2
            
            //main transfer loop
            for (Integer f: bcm.keySet() ) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0) {
                
                area = bcm.get(f).get(t);
                if (f==1 || t==1) area *= correcfaca;
                if (f==2 && t!=1) area *= -correcfacp; //NOTE it is being subtracted because it is necessary that all biomes change to 2 have the same pattern
                if (f!=1 && t==2) area *= correcfacp;
                
                available = area >= 0 ? biomestocks.get(f).totarea : biomestocks.get(t).totarea; //because if neg later swap f && t in transfer
                
                if (available<abs(area)) {//checking if biome is going to zero
                    int biomeC=0; //biomeChosed
                    float areaB=0;
                    
                    for (Integer from: bcm.keySet()) for (Integer to : bcm.get(from).keySet()) { //checking other biomes under change to assign the change
                        if (from>2 && areaB<biomestocks.get(from).totarea && biomestocks.get(from).totarea>area){biomeC = from; areaB=biomestocks.get(from).totarea; }
                        if (to>2   && areaB < biomestocks.get(to).totarea && biomestocks.get(to).totarea>area){biomeC = to; areaB=biomestocks.get(to).totarea; }
                    }
                    
                    if (biomeC == 0) for (int b = 3; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++) //if there is no biomes under change choose the biggest
                        if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
                        areaB = biomestocks.get(b).totarea; biomeC = b;
                        }
                    
                    if (area>0) if (biomeC > 2) f = biomeC;
                    if (area<0)if (biomeC > 2) t = biomeC;
                } //if checking negative biomes
                
                if(area>1 || area<-1) transfer(area, f, t);
                
            } //for ft transfer loop
            shiftcultivation();
            //########################################################3
        } else { // !=fao2002
            for (Integer f: bcm.keySet() ) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
                area = bcm.get(f).get(t);
                
                available = area >= 0 ? biomestocks.get(f).totarea : biomestocks.get(t).totarea; //because if neg later swap f && t in transfer
                if (available<abs(area)) {//checking if biome is going to zero
                    int biomeC=0; //biomeChosed
                    float areaB=0;
                    
                    for (Integer from: bcm.keySet()) for (Integer to : bcm.get(from).keySet()) { //checking other biomes under change to assign the change
                        if (from>2 && areaB<biomestocks.get(from).totarea && biomestocks.get(from).totarea>area){biomeC = from; areaB=biomestocks.get(from).totarea; }
                        if (to>2   && areaB < biomestocks.get(to).totarea && biomestocks.get(to).totarea>area){biomeC = to; areaB=biomestocks.get(to).totarea; }
                    }
                    
                    if (biomeC == 0) for (int b = 3; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++) //if there is no biomes under change choose the biggest
                        if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
                        areaB = biomestocks.get(b).totarea; biomeC = b;
                        }
                    
                    if (area>0) if (biomeC > 2) f = biomeC;
                    if (area<0)if (biomeC > 2) t = biomeC;
                } //if checking negative biomes
                
                transfer(area, f, t);
                shiftcultivation();
            } // for loop
        } //else !=fao2002
        
    } //calcAreaChange
    
    void calcEmit(int i, region r, int year)  {
        
        //decayregrow
        newstock = 0;
        for (biomestock s : biomestocks.values()) {
            s.decayregrow(lucemit.xstep);
            newstock += s.totstock();
        }
        
        //emissions
        float emit = (oldstock - newstock)/(lucemit.xstep);
        if(Float.isNaN(emit) || Float.isInfinite(emit)) emit = 0;
        oldstock = Float.isNaN(newstock) ? oldstock : newstock; //correct problems in small islands
        
        //setting the qtsets
        lucemit.set(r, year, emit);
        carbonstock.set(r, year, oldstock);
        
        setcountryqts(r, year);
        
    } //calcAreaChange
    
    void transfer(float area, int f, int t) {
        if ( area<0 ) { int ff=f; f=t; t=ff; area=-area; }
        biomestocks.get(f).cutdown(area, biomestocks.get(t));
        biomestocks.get(t).setregrow(area, biomestocks.get(f));
    }
    
    void calcInitialStock(region r)  {
        
        biomestocks.clear();
        
        biomestocks.put(1, new biomestock(1, 0, this));
        biomestocks.put(2, new biomestock(2, 0, this));
        
        for (cell c : cellset) {
            int x = (int)(c.lon*2+359.5), y=(int)(-c.lat*2+180.5);
            try {
                int biome = luTables.get(1700) [x][y];
                if (biome != 0) {
                    if (!biomestocks.containsKey(biome)) biomestocks.put(biome,new biomestock(biome,0, this));
                    biomestocks.get(biome).addarea(c.area);
                }
            } catch (Exception e) {System.err.println(x + " " +y + e); e.printStackTrace();}
        }
        
        setcountryqts(r, 1700);
        
        countryAreasCorrection(r);
        
        oldstock = 0f;
        
        for (biomestock bs : biomestocks.values()) {
            oldstock += bs.totstock();
            bs.potvegstock = bs.vegstock;
            bs.potsoilstock = bs.soilstock;
        }
    }
    
    void calcBiomeChangeMap(int b, int a, region r)  {
        
        int nstep = (periods[b] - periods[a])/lucemit.xstep; // step has to fit in the years difference
        
        bcm.clear();
        for (cell c : cellset) { // run all cells in region r
            int x = (int)(c.lon*2+359.5), y = (int)(-c.lat*2+180.5); // locates x and y
            int biomeTo = luTables.get(periods[b]) [x][y]; //store the biome number to
            int biomeFrom = luTables.get(periods[a]) [x][y]; // store the biome number from
            
            if (biomeTo != biomeFrom){
                //returns tru if conainskey (returns true if there is map for the key) return false
                
                if ( !bcm.containsKey(biomeFrom)) bcm.put(biomeFrom, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
                
                if ( !bcm.get(biomeFrom).containsKey(biomeTo)) bcm.get(biomeFrom).put(biomeTo, 0f);
                
                bcm.get(biomeFrom).put(biomeTo, bcm.get(biomeFrom).get(biomeTo) + c.area / nstep); //TODO .put(method) alredy sum
                //bcm.get(biomeFrom).put(biomeTo, c.area / nstep);
                
            } // if
        } // cell
    }//calcBiomeChangeMap
    
    public void calcpots() {
        startscenluc=lucsource.chosen.equals("Houghton") ? 2001 : 2003;
        System.err.println("CALCPOTSRUN");
        for (region r: regman.nations.reg) {
            potluc.put(r,0f);
            //fix the houghton/cait option
            if (lucsource.chosen.equals("IVIGmodel")) for (int y=1700; y<startscenluc; y++)
                potluc.put(r, potluc.get(r)+ lucemit.get(r,y)/1000f);
            if (lucsource.chosen.equals("Houghton")) for (int y=1850; y<startscenluc; y++)
                potluc.put(r, potluc.get(r)+ lucCO2CAIT1.get(r,y)/1000f);
            
        }
    }
    
    void shiftcultivation(){
        if (shiftcultivation.istrue() && biomestocks.get(1).totarea>100000) {
            float areaB = 0;
            int B = 0;
            for (int b = 3; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++)
                if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea) B = b;
            
            transfer(biomestocks.get(1).totarea * (float)shiftcultfrac.getval()/100, 1, B);
            transfer(biomestocks.get(1).totarea * (float)shiftcultfrac.getval()/100, B, 1);
        }
    }
    
    //********************************************
    static void loadStaticData(){
        histdata.loaddata(faopast, "FAO_pasture.csv", "\t", true, 1f, 1961, 2002, 1961);
        histdata.loaddata(faoagr, "FAO_agriculture.csv", "\t", true, 1f, 1961, 2002, 1961);
        histdata.loaddata(lucCO2Houghton, "houghtondata2000.csv", ";", true, 1000f, 1850, 2000, 1850);
        
        String[][] countrya = fileio.loadtab("data/"+"Country_areas.csv", "\t");
        for (int y = 3; y < countrya.length; y++) {
            region r = regman.allreg.find(countrya[y][0]);
            float area =  Float.parseFloat(countrya[y][1]);
            countryArcviewAreas.put(r, !countryArcviewAreas.containsKey(r) ? area : countryArcviewAreas.get(r)+area);
        }
        histdata.loaddata(lucCO2UNFCCC, "UNFCCC_LUC_emit.tab", "\t", true, 12f/44f, 1990, 2002, 1990);
        histdata.loaddata(lucCO2CAIT, "CAIT_LUC_emit.tab", "\t", true, 1f, 1950, 2000, 1950);
        
        new interpolator(lucCO2Houghton, "HOUGHTON", 1950, 1f).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
        //new interpolator(jcm12en, "JCM12", 1900, 1, false).fill(energy, regset, 1900, 2000, hydepop);
//	loadEDGAR(); //metrhod to read the grid files from EDGAR, need some fix in the contry/ocean borders
    }
    
    void loadHYDEdata() {
        for  (int j : periodsHYDE) {
            String filename = "lu_"+biomeclass.chosen+"_"+j;
            int [][] data = pngdata.load(filename+".png",  biomeclass.chosen.equals("A") ? colsA : colsB );
            luTables.put(j,data); //row, column
        } //year
        
    }
    
    static void loadEDGAR(){ //fire grid maps?? //metrhod to read the grid files from EDGAR, need some fix in the contry/ocean borders
//        int w = 360, h = 180;
//        int[] EDGARperiods = new int[]{1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990, 1995, 2000};
//        //Map<edgar, int[]> fileperiod = new HashMap(); /P1 make as enumeration enum edgar{EDGAR13, EDGAR32, EDGAR32FT}
//
//        Map<Integer, int[]> fileperiod = new HashMap();
//        fileperiod.put(0, new int[]{1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990}); //kg CO2-C 0.000001f,
//        fileperiod.put(1, new int[]{1995}); //kg CO2  12f/44000000f,
//        fileperiod.put(2, new int[]{2000}); //kg CO2 12f/44000000f
//
//        Map<Integer, String[]> fileroot = new HashMap();
//        fileroot.put(0, new String[] {"CO2FC", "CO2FP", "CO2IN", "CO2DF"}); //11 periods //CO2BC is not included because has changed a lot in different versions of EDGAR and IPCC include in LULUC
//        fileroot.put(1, new String[] {"f1095co2.1x1", "f2095co2.1x1", "f3095co2.1x1", "f4095co2.1x1", "f5195co2.1x1", "f5495co2.1x1", "f5795co2.1x1", "f5895co2.1x1", "f6195co2.1x1", "f6295co2.1x1", "f8095co2.1x1", "i4195co2.1x1", "l4195co2.1x1"}); //f57XXco2, aviation has data just for 95 //13 items /1 period
//        fileroot.put(2, new String[] {"f1000co2.1x1", "f2000co2.1x1", "f3000co2.1x1", "f4000co2.1x1", "f5100co2.1x1", "f5400co2.1x1", "f5700co2.1x1", "f5800co2.1x1", "f6000co2.1x1", "f8000co2.1x1", "i4100co2.1x1", "l4100co2.1x1"}); //f60 = f 61+f62 //12 items /period /file:"l4100co2.1x1" is tab separated not comma, the original was changed
//
//        float[] fac = new float[]{0.000001f, 12f/44000000f, 12f/44000000f};
//
//        Map< Integer, float[][]> co2fosgrid = new HashMap();
//        Map< Integer, float[][]> co2lucgrid = new HashMap();
//
//        for (int i = 0; i < 3; i++) //edgar version
//            for (int p = 0; p < fileperiod.get(i).length; p++) // number of periods in edgar version
//                for (int n = 0; n < fileroot.get(i).length; n++) {//number of ff sectors + luc sector in edgar version
//            String gridname="";
//            String sp=""; //separator
//            int st; //start line
//            if(i==0){ gridname += fileroot.get(i)[n] + fileperiod.get(i)[p]+ ".txt"; st = 1; sp+="\t";
//            } else{ gridname += fileroot.get(i)[n]; st = 12; sp+=",";
//            }
//
//            if (n!=fileroot.get(i).length-1){ //just fossil until the last, then luc sector
//                float [][] data = griddata.load(gridname, sp, st, fac[i]);
//                for (int y=0; y<h; y++) for (int x = 0; x<w; x++) if (n!=0) data[x][y] = data[x][y] + co2fosgrid.get(fileperiod.get(i)[p])[x][y];
//                co2fosgrid.put(fileperiod.get(i)[p], data);
//            } else{
//                float [][] data = griddata.load(gridname, sp, st, fac[i]);
//                co2lucgrid.put(fileperiod.get(i)[p], data);
//            }
//
//                }//for EDGAR version, periods, and sectors(files)
//        Set<cell> cellseta = new HashSet();
//
//        for (region r : regman.nations.reg){
//            cellseta.clear();
//            int xo,yo, xd, yd, cell;
//            //double emit;
//            float xi, yi;
//            boolean inbox;
//
//            for (regpoly p : r.polyset) {
//                Area a = new Area(p);
//                Rectangle box=a.getBounds();
//
//                int step=5; // degree steps
//
//                for (xo=box.x; xo<(box.x+box.width); xo+=step) {
//                    xd=Math.min((box.x+box.width)-xo, step);
//                    for (yo=box.y; yo<(box.y+box.height); yo+=step) {
//                        yd=Math.min((box.y+box.height)-yo, step);
//                        if (a.intersects(xo,yo,xd,yd)) {
//                            inbox=a.contains(xo,yo,xd,yd);
//                            for (yi=+yo; yi<(yo+yd); yi+=1) {
//                                for (xi=xo; xi<(xo+xd); xi+=1) {
//                                    if (inbox || a.contains(xi,yi)) {
//                                        cell c = new cell();
//                                        c.lon = xi;
//                                        c.lat = yi;
//                                        cellseta.add(c);
//                                    }
//                                }
//                            }
//                        }
//                    }
//                } //polys
//            } //regav
//            int p0 =  1890;//to initialize the interpolator.linearinterp(edgarff, p0, p);
//            for (int p : EDGARperiods){ //perid index 1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990, 1995, 2000
//                float emitff = 0;
//                float emitluc = 0;
//
//                for (cell c : cellseta) {
//                    int x = (int)(c.lon+180), y=(int)(-c.lat+90);
//                    try {
//                        emitff += co2fosgrid.get(p)[x][y];
//                        emitluc += co2lucgrid.get(p)[x][y];
//                    } catch (Exception e) {System.err.println(x + " " +y + e); e.printStackTrace();}
//                }//cellseta loop
//
//                edgarff.set(r, p, emitff);
//                edgarluc.set(r, p, emitluc);
//
//                if (p > 1890) for (int y = p0+1; y<p; y++) { // initialized before the periods loop
//                    interpolator.linearinterp(edgarff, p0, p);
//                    interpolator.linearinterp(edgarluc, p0, p);
//                }
//                p0 = p;
//            }//edgarperiods
//        }//regnations loop
//
//
    } // load edgar  //method to read the grid files from EDGAR, need some fix in the contry/ocean borders
    
    void countryAreasCorrection(region r){
        float area, totHYDEachange=0, totHYDEpchange=0, prop, agricArea, pastArea, correcArea; // prop = proportion a/p change 1961-1700
        //calcBiomeChangeMap(6, r); //calc agric+past but it has to acummulate all bcm until that point!!! so from 0 to 6!!
        //if country has zero agric or past?
        //rule to increase as the population has increased history.hydepop
        //could apply to the interpolation of land use change for the periods?
        if (countryArcviewAreas.containsKey(r) && countryModelArea!= 0) {
            //            calcBiomeChangeMap(6, 0, r); //bcm for 1970 to 1700
            //            prop=1970-1700;
            //            for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
            //                area = bcm.get(f).get(t) * prop;
            //                if (t==1) totHYDEachange += area;
            //                if (f==1) totHYDEachange -= area;
            //                if (t==2) totHYDEpchange += area;
            //                if (f==2) totHYDEpchange -= area;
            //            } //f t loop
            //            agricArea = totHYDEachange+biomestocks.get(1).totarea;
            //            pastArea = totHYDEpchange+biomestocks.get(2).totarea;
            //            correcAFAO1970 = agricArea!=0 ? faoagr.get(r, 1970) / agricArea : 1;
            //            correcPFAO1970 = pastArea !=0 ? faopast.get(r, 1970)/ pastArea : 1;
            //            biomestocks.get(1).addarea(biomestocks.get(1).totarea*(correcAFAO1970-1));
            //            biomestocks.get(2).addarea(biomestocks.get(2).totarea*(correcPFAO1970-1));
            //            correcArea = ( ((countryArcviewAreas.get(r)-agricArea*correcAFAO1970-pastArea*correcPFAO1970) /
            //                    (countryModelArea-agricArea*correcAFAO1970-pastArea*correcPFAO1970)) )-1;
            //            for (int b = 3; b < 19; b++) if(biomestocks.containsKey(b)) biomestocks.get(b).addarea(correcArea*biomestocks.get(b).totarea);
            correcArea = ((countryArcviewAreas.get(r)/countryModelArea)-1);
            for (int b = 1; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++)
                if(biomestocks.containsKey(b)) biomestocks.get(b).addarea(correcArea*biomestocks.get(b).totarea);
        } // if !=0
    }// countryAreasCorrection
    
    void setcountryqts(region r, int year){
        //output areas
        float carea=0;
        
        biomeChosenCountries.set(r, year, biomestocks.containsKey(biomeList.getchosenindex()) ? biomestocks.get( biomeList.getchosenindex()).totarea : 0) ;
        
        if (r == countryList.getchosen()){
            countryChosenAP.set("Model Agric",year, biomestocks.get(1).totarea);
            countryChosenAP.set("FAO Agric",year, faoagr.get(r, year));
            countryChosenAP.set("Model Past",year, biomestocks.get(2).totarea);
            countryChosenAP.set("FAO Past",year, faopast.get(r, year) );
            if (year<2003) countryChosenEmission.set("IVIG32 model",year, lucemit.get(r, year));
            if (year>1989 && year<2003) countryChosenEmission.set("UNFCCC",year, lucCO2UNFCCC.get(r, year));
            if (year>1949 && year<2001) countryChosenEmission.set("CAIT",year, lucCO2CAIT.get(r, year));
            if (year>1850 && year<2001) countryChosenEmission.set("CAIT-1",year, lucCO2CAIT1.get(r, year));
            
        }
        
        for (int b = 1; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++) if(biomestocks.containsKey(b)) { //
            carea += biomestocks.get(b).totarea;// loop to setting the country areas
            if(r == countryList.getchosen() && biomestocks.containsKey(b))
                countryChosenBiomes.set(biomeList.getname(b), year, biomestocks.get(b).totarea);
        } // loop biome areas
        
        
        countryModelArea = carea;
    } //output
    
    void setqtcolors(region r){
        if (r == countryList.getchosen()) {
            countryChosenAP.add(new qt("Model Agric", red, 1962, 2002));
            countryChosenAP.add(new qt("FAO Agric", dkred, 1962, 2002));
            countryChosenAP.add(new qt("Model Past", pink, 1962, 2002));
            countryChosenAP.add(new qt("FAO Past", magenta, 1962, 2002));
            countryChosenEmission.add(new qt("IVIG32 model", red, 1700, 2002));
            countryChosenEmission.add(new qt("UNFCCC", blue, 1990, 2002));
            countryChosenEmission.add(new qt("CAIT", pink, 1950, 2000));
            countryChosenEmission.add(new qt("CAIT-1", yellow, 1850, 2000));
            
            for (int b = 1; b < (biomeclass.chosen.equals("A") ? 19 : 18); b++) if(biomestocks.containsKey(b))
                countryChosenBiomes.add(new qt(biomeList.getname(b), (biomeclass.equals("A")? colsA[b] : colsB[b]), 1700, 2002));
        }// getchosen if countryChosenEmission
    }
    
    void findCells(region r) {
        cellset.clear();
        int xo,yo, xd, yd, cell;
        double area=0, sum=0, sumarea=0, dudarea=0; float xi, yi;
        boolean inbox;
        
        for (regpoly p : r.polyset) {
            Area a = new Area(p);
            Rectangle box=a.getBounds();
            
            int step=5; //degree steps
            
            for (xo=box.x; xo<(box.x+box.width); xo+=step) {
                xd=Math.min((box.x+box.width)-xo, step);
                for (yo=box.y; yo<(box.y+box.height); yo+=step) {
                    yd=Math.min((box.y+box.height)-yo, step);
                    if (a.intersects(xo,yo,xd,yd)) {
                        inbox=a.contains(xo,yo,xd,yd);
                        for (yi=-0.25f+yo; yi<(-0.25f+yo+yd); yi+=0.5) {
                            area=Math.cos((Math.PI*yi)/180.0);
                            for (xi=0.25f+xo; xi<(0.25f+xo+xd); xi+=0.5) {
                                if (inbox || a.contains(xi,yi)) {
                                    cell c = new cell();
                                    c.lon = xi;
                                    c.lat = yi;
                                    c.area = (float)(area * pow(1.8521 * 30, 2)); //IUGG equatorial radius Earth  6378.137 km, equatorial circumference 40,075 km // 1 nautical miles  = 1.852 kilometres  http://www.thetipsbank.com/convert.htm
                                    cellset.add(c);
                                }
                            }
                        }
                    }
                }
            }
        } //polys
    } //regav
    
} // end Calclucemit class

class cell {
    int potential, x, y;
    float lon, lat, area;
    int getx(float lon) { return 0;}
}

class biomestock {
    /*
     These fields used to be set static for one biome classification, as this is constant for all regions within one world,
     But now with parallel worlds we might have two classifications running in parallel, so can't be fixed statically
    Instead we refer to the parameter in CalcLucEmit to choose which set to use,
    !! Note check the order still the right way around: classification A should be first! (note old code had b=true => LUC_A, was this right?)
     */
    CalcLucEmit CLE; //this is a reference to the instance of CalcLucEmit which contains this biomestock, since there may be several CalcLucEmit with different parameters
    
    static float[] decaytime= new float[]{0.5f, 1f, 10f, 1000f};
    
    static int[][] vegCarbon = new int[][]{{0,5,10,0,0,1,6,7,64,81,106,117,69,7,2,18,29,80,147},
    {0,5,10,114,100,110,100,117,64,81,84,29,7,18,10,6,2,0},
    {0,16,15,209,165,215,215,213,71,71,71,20,3,8,8,7,6,0}}; // (t C/ha) !!!!
    static int[][] soilCarbon = new int[][]{{0,1,1,0,0,1,127,167,206,170,134,134,98,153,2,77,153,63,116},
    {0,1,1,89,130,150,160,134,206,170,170,153,153,77,60,127,2,0},
    {0,16,29,106,60,140,140,110,263,263,263,192,47,88,88,217,56,116}}; // (t C/ha)
    
    static int[][] vegRegTime = new int[][]{{0,2,2,0,0,100,100,100,80,42,25,25,18,2,2,2,2,20,40},
    {0,2,2,30,11,21,22,25,61,80,49,10,13,5,6,71,2,0}}; // (years)
    static int[][] soilRegTime = new int[][]{{0,2,10,0,0,100,100,100,80,42,25,40,18,2,2,2,2,20,40},
    {0,2,10,30,11,29,22,33,61,80,49,10,13,5,6,71,2,0}}; //Soil regeneration time (years)
    
    float[] decay = new float[4];
    float totarea, vegstock, soilstock, soildecay, potvegstock, potsoilstock;
    int type;
    
    
    biomestock(int t, float f, CalcLucEmit creator){
        type = t; vegstock = f; potvegstock = vegstock; CLE=creator;
    } // constructor
    
    float getdecayfrac(int box){
        boolean grassy =  CLE.biomeclass.equals("A") ? (type<3 || type>12 && type <17) : (type<3 || type>10);
        if (CLE.biomeclass.equals("A")) switch(box) {
            case 0 : return grassy ? 0.5f : type == 17 ? 0.38f : 0.33f;
            case 1 : return grassy ? 0.48f : 0.3f;
            case 2 : return grassy ? 0 : type == 17 ? 0.3f : 0.35f;
            case 3 : return 0.02f;
        } else switch(box) {
            case 0 : return grassy ? 0.5f : type == 4 ? 0.38f : 0.33f;
            case 1 : return grassy ? 0.48f : 0.3f;
            case 2 : return grassy ? 0 : type == 4 ? 0.3f : 0.35f;
            case 3 : return 0.02f;
        }
        return 0;
    }
    
    void decayregrow(int dt){
        for(int i=0; i<4; i++) decay[i] *= (float)exp((float)-dt/decaytime[i])  ;
        soildecay *= (float)exp((float)-dt*(-log(0.05)/CLE.soildecayrate.getval()))  ; //20 is the default decay time
        //for(int i=0; i<4; i++) decay[i] = 0; //instant decay
        vegstock = potvegstock - (potvegstock - vegstock) * (float)exp((float)-dt/vegRegTime[CLE.biomeclass.getchosenindex()][type]);
        soilstock = potsoilstock - (potsoilstock - soilstock) * (float)exp((float)-dt/soilRegTime[CLE.biomeclass.getchosenindex()][type]);
        //stock= pstock; //instant regrow
    }
    
    void cutdown(float area, biomestock biometo){
        boolean grassy =  CLE.biomeclass.equals("A") ? (type<3 || type>12 && type <17) : (type<3 || type>10);// ADDED
        float change = (area / totarea) * vegstock ;
        vegstock -= change;
        potvegstock -= change;
        for (int i=0; i<4; i++) decay[i] += getdecayfrac(i) * change;
        
        float soilchange, soilloss=0;
        soilchange = (area/totarea) * soilstock;
        
        if (CLE.simplemethod.istrue()) soilloss = soilchange *  0.2f ;
        else {
            if (!CLE.grassyon.istrue()) if (type >  2) soilloss = soilchange * (biometo.type == 1 ? (float)CLE.soillossagric.getval() : (float)CLE.soillosspast.getval()); //0.2f : 0.05f);
            if (CLE.grassyon.istrue()) if (type >  2 && !grassy) soilloss = soilchange * (biometo.type == 1 ? (float)CLE.soillossagric.getval() : (float)CLE.soillosspast.getval()); //0.2f : 0.05f);
            if (CLE.grassyon.istrue()) if (type >  2 && grassy) soilloss = soilchange * (biometo.type == 1 ? (float)CLE.soillossagric.getval() : 0); //ADDED
            if (type == 2) soilloss = soilchange * (biometo.type == 1 ? (1f/(1f-(float)CLE.soillosspast.getval())) * ((float)CLE.soillossagric.getval() - (float)CLE.soillosspast.getval()) : 0 );
            if (type == 1) soilloss = 0;
        }
        
        soildecay += soilloss;
        soilstock -= soilchange;
        potsoilstock -= soilchange;
        biometo.soilstock += soilchange - soilloss;
        totarea -= area;
    }
    
//     void transfer(float area, int f, int t) {
//        if ( area<0 ) { int ff=f; f=t; t=ff; area=-area; }
//        biomestocks.get(f).cutdown(area, biomestocks.get(t), biomestocks.get(f));
//        biomestocks.get(t).setregrow(area, biomestocks.get(f), biomestocks.get(t));
//    }
    
    void setregrow(float area, biomestock biomefrom){
        
        potvegstock += area * vegCarbon[CLE.cc][type] * 0.1 * CLE.vegetationCarbon.getval(); // * 0.1 converts tC/ha to k tC/km2
        
        if (type > 2) potsoilstock += area * soilCarbon[CLE.cc][type] * 0.1; // * 0.1 converts tC/ha to ktC/km2
        
        if (type == 1 || (type == 2 && biomefrom.type != 1)) potsoilstock = soilstock;
        
        if (!CLE.simplemethod.istrue() && type == 2 && biomefrom.type == 1)
            potsoilstock += (1f+(100f/80f)*0.15f) * (area/biomefrom.totarea) * biomefrom.soilstock;
        
        totarea += area;
    }
    
    void addarea(float area){
        totarea += area;
        vegstock += area  * vegCarbon[CLE.cc][type] * 0.1 * CLE.vegetationCarbon.getval(); // * 0.1 converts tC/ha to ktC/km2
        soilstock += area * soilCarbon[CLE.cc][type] * 0.1; // * 0.1 converts tC/ha to ktC/km2
    }
    
    float totstock() {
        float totstock = vegstock + soilstock + soildecay;
        for(float f : decay) totstock += f;
        return totstock;
    }
}//end of biomestock class