package jcm.gui.plot;

import jcm.core.*;
import jcm.gui.*;
import jcm.gui.doc.labman;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import static jcm.core.time.*;

public class scatterplot extends baseplot {
    
    qtset qq2;
    
    public scatterplot(Object[] args) {
        qq=(qtset)args[0]; qq2=(qtset)args[1];
        setup(qq);
        xsv.setMinimumSize(new Dimension(0,40));
    }
    
    void makeplot() { plot =new scatter(); };
    
    void makescales() {
        yscale=qq.getyscale();
        xscale= qq2.getyscale(); xscale.type=param.Type.Xscale;
        ysv=new scaleview(yscale);
        xsv=new scaleview(xscale);
        register.addlink(this, xscale, yscale);
    }
    
    
    class scatter extends JPanel{
        
        public void paintComponent(Graphics g) {
            super.paintComponent(g); //paint background
            
            Graphics2D g2 = (Graphics2D) g;
            //g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_SPEED); //QUALITY);
            
            AffineTransform oldat = g2.getTransform();
            float xsf=getWidth()/xscale.range(), ysf=-getHeight()/yscale.range(), xyf=xsf/ysf;
            g2.scale( ysf, ysf);   //Have to scale same for x and y, otherwise relation pixel:real is not same for x and y,  therefore get distorted line shape
            g2.translate(-xscale.min()*xyf, -yscale.max());
            g2.setStroke(new BasicStroke(Math.abs(yscale.range())/250));
            
            int sy=Math.max(qq.sy, qq2.sy), ey=Math.min(qq.ey, qq2.ey);
            
            GeneralPath line = new GeneralPath();
            for (Object o : qq.map.keySet()) if (qq2.map.containsKey(o)) {
                line.reset();
                line.moveTo(qq2.get(o,sy)*xyf, qq.get(o,  sy) );
                for (int year=sy+1; year<=ey; year++) {
                    line.lineTo(qq2.get(o,year)*xyf, qq.get(o,  year) );
                }
                try {
                    g2.setColor(qq.map.get(o).color );
                    g2.draw(line);
                    System.err.println(o);
                } catch (Error e) { System.err.println("line drawing error"); }
                
            } //qq
            
//                for (qt q : qq.map.values()) if (q.checkcomplexity()) {
//                    GeneralPath line = new GeneralPath(); //GeneralPath.WIND_EVEN_ODD, c.a.length);
//                    boolean haddata=false;
//                    int xstep=(int)(Math.max(q.xstep, xscale.range()/getWidth())); if (xstep<1) xstep=1;
//                    for (int x=(int)xscale.min(); x<=(int)xscale.max(); x+=xstep) {
//                        if (!q.gotdata(x)) haddata=false;
//                        if (q.gotdata(x) && !haddata) {	line.moveTo(x*xyf, q.get(x)); haddata=true; }
//                        if (q.gotdata(x) && haddata) line.lineTo(x*xyf, q.get(x));
//                        //root.debug(" "+x+" "+ q.get(x));
//                    }
            
            g2.setTransform(oldat); g2.dispose();
            ready=true;
        }
        
    } //scatter
}