package jcm.gui.plot;
import jcm.core.*;
import jcm.gui.*;
import jcm.gui.doc.labman;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import jcm.gui.gen.colfont;

public class scaleview extends JPanel implements MouseInputListener {
    
    public static param
            linkx=new param("linkx", false),
            showscales=new param("showscales", true);
    
    param sp;
    float fac=baseplot.bigfont ? 2f : 1f;
    
    public scaleview(param sp) {
        this.sp=sp;
        origin=(sp.type==sp.type.Xscale) ? 2000 : 0 ;
        
        setBackground(Color.white);
        setPreferredSize((sp.type==sp.type.Xscale) ? new Dimension(0, (int)(24*fac)) : new Dimension((int)(36*fac),0));
        setToolTipText(labman.getTitle(sp.getstate())); //name+"&"+sp.units.units)
        
        addMouseListener(this);
        addMouseMotionListener(this);
        setCursor(new Cursor(sp.type==sp.type.Xscale ? Cursor.E_RESIZE_CURSOR : Cursor.N_RESIZE_CURSOR));
        
        if (sp.type==sp.type.Xscale) sp.setaffectedby(linkx);
    }
    
    
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g); //paint background
        if (baseplot.bigfont) g.setFont(colfont.vbigbold); 
        
        int w=getWidth(), h=getHeight();
        
        if (sp.type==sp.type.Xscale) g.drawLine(0, 0, w, 0);
        if (sp.type==sp.type.Yscale) g.drawLine(w-1, 0, w-1, h);
        
        if (sp.units.scales!=0)     for (double v=sp.units.minstep(sp.min()); v<=sp.max(); v+=sp.units.scales) {
            int p=pixel(v);
            String s=sp.units.round(v); int sw=sw(g,s);
            if (sp.type==sp.type.Xscale)  {	g.drawLine(p, 0, p, 5); if (h>8) g.drawString(s, p-sw/2, h-4); }
            if (sp.type==sp.type.Yscale) {	g.drawLine(w-5, p, w, p); if (w>8) g.drawString(s, w-(sw+5), p+4); }
        }
        
        if (sp.type==sp.type.Yscale) {
            Graphics2D g2=(Graphics2D) g;
            g.translate((int)(8*fac), 20+getHeight()/2);
            g2.rotate(-Math.PI/2.0);
            g.drawString(labman.getTitle(sp.units.units), 0,0);
        }
    }
    
    int pixel(double v) {
        if 	(sp.type==sp.type.Xscale)   return (int)(getWidth()*(v-sp.min())/sp.range());
        else return getHeight() - (int)(getHeight() *(v-sp.min())/sp.range());
    }
    
    double real(int p) {
        if 	(sp.type==sp.type.Xscale)   return sp.min()+p*sp.range()/getWidth();
        else return  sp.min()+(getHeight()-p)*sp.range() / getHeight();
    }
    
    
    public int sw(Graphics g, String s) {	try {	return g.getFontMetrics(g.getFont()).stringWidth(s); }catch (Exception e) {	return 8; } }
    
    
    //**********************************************
    //adjusting by drag
    
    //for dragging scales
    public double origin, dp; int ep, op; boolean dragorigin=false;
    
    public void mouseDragged(MouseEvent e) {
        ep=  (sp.type==sp.type.Xscale ? e.getX() : e.getY());
        if (dragorigin) {
            dp=(double)((ep-op)*sp.range())/(double)(sp.type==sp.type.Xscale ? -getWidth() : getHeight());
            sp.max += dp; sp.min+=dp;
        } else {
            dp= ((double)op - pixel(origin)) / ((double)ep - pixel(origin));
            sp.max = origin + (sp.max()-origin)*dp; sp.min = origin + (sp.min()-origin)*dp;
        }
        op= ep;
        sp.respond(true);
        setToolTipText(labman.getTitle(sp.getstate())); //name+"&"+sp.units.units)
        sp.units.checkunitfac(sp.max()-sp.min());
        sp.units.checkunitcancel();
        repaint();
    }
    
    public void mousePressed(MouseEvent e) {
        op= (sp.type==sp.type.Xscale ? e.getX() : e.getY());
        dragorigin= e.getClickCount()>1; if (dragorigin) origin=real(op);
        //		dragorigin= (op - pixel(origin))<40 && (op - pixel(origin))>-40; // && !((graph)holder).stacked.istrue();
    }
    
    public void mouseReleased(MouseEvent e) {	dragorigin=false; }
    public void mouseClicked(MouseEvent e) {	}
    public void mouseMoved(MouseEvent e) {	}
    public void mouseExited(MouseEvent e) {	}
    public void mouseEntered(MouseEvent e) {	}
    
    
} //end class

/*
 
 P1 TIDY old scaleview methods
 
Note: in principle this should have an iob to catch affectedby scalemodel,
but unnecessary while this is only changed by mouse-drag
 
        //*******************
        //linkx -adjust all plots x-axis together
 
        static {	linkx.owner=new scale(); showscales.owner=new scale(); }
 
//at end of drag		if (linkx.istrue() && this.type==Xscale) linkx();
 
        this is causing an error because no max/min for linkx dummy owner! linkx still works once start dragging a scale
        public void precalc(iob iob) {
        if (iob==linkx) if (linkx.istrue()) linkx();
}
 
 
        void linkx() {
                for (int p=0; p<holder.holder.cpl.np; p++) 	if (holder.holder.cpl.pan[p] instanceof graph) {
                        graph gpan=(graph) holder.holder.cpl.pan[p];
                        if (gpan!=owner && gpan.output) {
                                gpan.xscale.min.val=min.val; gpan.xscale.max.val=max.val; gpan.xscale.min.changed=true;
}}
}
 
//******************************************
                Could in principle replace the pixel, real and conversions etc. with translate/scale g2
                Beware lines could come out too thick!
 
                Graphics2D g2 = (Graphics2D) g;
                AffineTransform oldat = g2.getTransform();
                if (sp.type=sp.type.Xscale) { g2.scale(getWidth()/sp.range(), 1);  g2.translate(-xscale.min(), -yscale.max());  }
                else { g2.scale(1, -getHeight()/sp.range()); g2.translate(-xscale.min(), -yscale.max());  }
 */

