 /*
  *********MAPS TODO *************
OK P4 FIX Open map sometimes get black - related to region param in socreg?
OK P3 FIX colorscale not included when image is saved
P2 FIX Regional climate "mix" does not have good colorscale -
for change better 2dimensional red-blue=temp, green=prec?, no change should be grey (ie RGB equal)
P2 IDEA show socioeconomic data in map too (code a bit like scaled glotemp)
P1 IDEA Distorted map algorithm to weight by population etc. (or use spots?)
P2 FIX need to put back the rescale option somewhere in gui
  */

package jcm.gui.plot;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.doc.*;
import jcm.gui.nav.*;
import jcm.gui.gen.*;
import jcm.mod.reg.*;

public class mapplot extends JPanel implements menuFiller  {
    
    
    mapprojection getprojection() { return  (mapprojection)(projection.chosen); }
    
    public param startlon=new param("mapstartlongitude", "degrees", 349, 0, 360)  ;
    public param projection=mapprojection.getparam();
    public param<region> regions;
    
    //public param colorset= new param("colors", new String[]{"regcol", "regcli"},   "regcol" );
    //can later extend to option to show socioeconomic data?
    
    public double mx, oldmx, my;
    public region insidereg;
    JPanel intpan;
    map map;
    
    public boolean  firsttime=true,	needtoclear=true, addedyet=false, leftmap=false, /* gotevent=false,*/  inside=false, newpolys=true, updatecolorscale=false, ownregions=false;
    
    public mapplot(regcli rc) {
	if (regions==null) {regions=regman.makeregionparam(); ownregions=true; }
	setName(labman.getTitle(rc.getFullName()+"&map"));
	map=new map(rc);
	setup();
    }
    
    public mapplot(param<region> p) {
	regions=p;
	map=new map(null);
	setName(labman.getTitle(p.getFullName()+"&map"));
	setup();
    }
    
    void setup() {
	setToolTipText(getName());
	setPreferredSize(new Dimension(400,300));
	JMenuBar mb =new JMenuBar();
	mb.add(projection.getMenuItem());
	mb.add(regions.getMenuItem());
	//mb.add(new parammenu(colorset));
	
	setLayout(new BorderLayout());
	add(mb, BorderLayout.NORTH);
	intpan=new JPanel(); intpan.setLayout(new BorderLayout());
	intpan.add(map);
	if (map.cols!=null) intpan.add(map.cols, BorderLayout.SOUTH);
	add(intpan);
	
	setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	new contextMenu(map, this);
    }
    
    public void fillMenu(JPopupMenu popup) {
	popup.add(imagesaver.copyaction(intpan));
	popup.add(imagesaver.saveimagemenu(intpan, "JCM-map"));
	popup.add(showpan.pan("Show doc", docview.class, "mapplot") );
	//P1 should add table option to map?
    }
    
    class map extends JPanel implements MouseInputListener, plotlink {
	
	JLabel info=new JLabel();
	
	regcli rc;
	colorscale cols;
	boolean ready=false;
	
	map(regcli mapsource) {
	    setLayout(null);
	    setBackground(Color.white);
	    add(info);
	    addMouseListener(this);
	    addMouseMotionListener(this);
	    register.addlink(this, regions, projection,startlon);
	    if (mapsource!=null) {
		rc=mapsource;
		cols= new colorscale(rc);
		register.addlink(this,  rc,  cols.rescale); //colorset)
	    }
	    //{ public void setinteractions() {   setaffectedby(rc, colorset.chosen.equals("regcli")); } }   ;
	    loop.go();
	    ready=true;
	}
	
	public void doplot() { makepolys(); repaint(); }
	//beware: repaint only calls paintcomponent AFTER the loop finished so changed flags reset!
	public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
	
	public void removeNotify() {  //called when plot is closed
	    super.removeNotify();
	    projection.dispose(); startlon.dispose(); if (cols!=null)  cols.rescale.dispose(); //colorset.dispose();
	    if (ownregions) regions.dispose();
	    loop.go();
	}
	
	
	//**********************************
	
	Polygon[] plotpoly;
	Color[] plotcolor;
	int ow=0, oh=0;
	
	
	//***************************
	//PAINT
	
	void makepolys() {
	    int w=getWidth(), h=getHeight();
	    
	    boolean sizechanged=(w!=ow) || (h!=oh) || startlon.changed || projection.changed;
	    boolean regchanged=firsttime || regions.changed; //note: when regions is borrowed from another module, can be false when this map is created
	    if (sizechanged)    {
		getprojection().setsize(0, 0, w, h , (int)startlon.val); }
	    ow=w; oh=h;
	    
	    region rs=(region)(regions.chosen);
	    
	    if(regchanged ) { rs.makepolys(); for (region r : rs.reg)  r.makepolys(); }
	    
	    if(regchanged || plotpoly==null) {
		plotcolor=new Color[rs.reg.size()];
		int np=0; for (region r : rs.reg) np+=r.polyset.size();
		plotpoly=new Polygon[np];
	    }
	    
	    if (regchanged || sizechanged) {
		mapprojection mp=getprojection();
		int np=0; for (region r : rs.reg)   for (Polygon p : r.polyset) { plotpoly[np]=mp.translate(p);  np++; }
	    }
	    
	    if (rc!=null) {
		if  (rc.dataset.changed || rc.quantity.changed) updatecolorscale=true;
		
		if ((rc.ready && updatecolorscale) ) {   cols.setdata(rc.d1); cols.repaint();  updatecolorscale=false; } //|| colorset.changed
		
		
		if (regchanged || (rc.changed && rc.ready) ) { //|| colorset.changed
		    int nr=0; for (region r : rs.reg) {
			if (rc.quantity.chosen.equals("mix&tmx&tmn&pre"))  plotcolor[nr]= cols.mixregcolor(r);
			else plotcolor[nr]= cols.getcolor(r.avg(rc.d1)) ;
			nr++;
		    }
		}
	    } else if (regchanged ) { //if  (colorset.chosen.equals("regcol"))
		int nr=0; for (region r : rs.reg) {  plotcolor[nr]= r.getColor(); nr++; }
	    }
	    // if (colorset.changed) if (colorset.chosen.equals("regcli")) cols.show(); else cols.hide();
	    firsttime=false;
	}
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g); //paint background
	    
	    makepolys();
	    region rs=(region)(regions.chosen);
	    
	    int  nr=0, np=0;
	    for (region r : rs.reg)  {
		g.setColor(plotcolor[nr]); nr++;
		for (Polygon p : r.polyset) {  g.fillPolygon(plotpoly[np]);    np++; }
		
	    }
	    g.setColor(Color.black);
	    np=0; for (region r : rs.reg)  for (Polygon p : r.polyset) {  g.drawPolygon(plotpoly[np]);    np++; }
	    
	} //paint
	
	
	
	
	
	//***********************************
	//Event handling
	
	public void mouseDragged(MouseEvent e) {
	    findpos(e);
	    if (inside) {
		startlon.val=(int)(((int)startlon.val+(mx-oldmx)+360)%360);
		newpolys=true;
		startlon.respond(true); //doesn't work because not output!
	    }
	}
	
	public void mouseMoved(MouseEvent e) {  findpos(e); if (inside) writepos();  }
	// if (inside) {	cleartext(); writepos(); leftmap=false; } else  {	if (!leftmap) cleartext(); leftmap=true; }
	public void mousePressed(MouseEvent e) {  findpos(e); if (inside) oldmx=mx; }
	public void mouseReleased(MouseEvent e) {	 }
	public void mouseClicked(MouseEvent e) {	}
	public void mouseExited(MouseEvent e) {	}
	public void mouseEntered(MouseEvent e) {	}
	
	
	//**********************************
	//FIND/WRITE POS
	
	void findpos(MouseEvent e) { findpos(e.getX(), e.getY()); }
	void findpos(int x, int y) {	//work out lat & lon corresponding to mouse position
	    Point p=getprojection().translateback(x,y);
	    mx=p.x; my=p.y;
	    inside= (my<90 && my>-90 && mx<180.0 && mx>-180);
	    insidereg= findreg(x,y);
	    info.setLocation(x+4, y+4);
	}
	
	public region findreg(int x, int y) {
	    for(region r : ((region)(regions.chosen)).reg) if (r.contains(getprojection().translateback(x,y))) return r;
	    //for grid can do directly without check contains!
	    return null;
	}
	
	public void writepos() {
	    info.setText( inside ? (latlon()+" "+ ( insidereg!=null ?  reginfo(insidereg) : "" )) : "") ;
	    info.setSize(info.getPreferredSize());
	}
	
	public String latlon() { return (int)Math.abs(my)+ ( my>0 ? " N" : " S") + " "+ (int)Math.abs(mx)+ ( mx>0 ? " E" : " W"); }
	
	//**************************
	//REG INFO
	public String reginfo(region r) {
	    //if (colorset.chosen.equals("regcol"))
	    if (rc==null) return insidereg.getName();
	    else return  insidereg.getName()  +   " " + dp(r.avg(rc.d1), 100f)  + "    "  ;
	    // -rc.tempbase() //delta "\u0394: "
	}
	public float dp(float f, float g) {return ((int)(g*f)) /g ; }
	
    } //map
}  //end class


