package jcm.gui.plot;

import jcm.core.*;
import jcm.gui.*;
import jcm.gui.doc.labman;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;


import static jcm.core.time.*;

//P4 triangle problem at end of stack

public class lineplot extends baseplot   {
    
    enum Type { normal, rate, ratio, difference };
    Type mytype=Type.normal;
    
    boolean stacked=false;
    
    public lineplot(Object[] args) {
	for (Object o : args) {
	    if (o.toString().equals("stacked")) stacked=true;
	    for (Type t : Type.values())  if (o.toString().equals(t.name())) mytype=t;
	    if (o instanceof qtset) {
		if (qq==null) qq=(qtset)o;
		else if (mytype==Type.ratio) { qq=qq.divby((qtset)o); temporaryqq=true; }
	    }
	}
	if (mytype==Type.rate) { qq=qq.differentiate(); temporaryqq=true;}
	setup(qq);
    }
    
    public lineplot(qtset qq) { setup(qq); }
    
    void makeplot() { plot =new lineplotmainpan(); };
    
    public void fillMenu(JPopupMenu popup) {
	if (!temporaryqq) {
	    popup.add(new AbstractAction("Stack Curves")  { public void actionPerformed(ActionEvent e) { changestack(); }});
	    popup.addSeparator();
	}
	super.fillMenu(popup);
    }
    
    //P1 fix stacked persistence on reloading setup and unstacking
    //problem is that original register stores only one Object[] instead of a list of objects
    public void changestack() {
	stacked=!stacked; yscale.max=qq.getmax(stacked); ysv.repaint();  doplot();
	if (stacked) register.getargs(this).add("stacked"); else register.getargs(this).remove("stacked");
    }
    
    
//*****************************************************
//MAIN PLOT
    public static int thin = 250;
    class lineplotmainpan extends JPanel implements MouseMotionListener {
	
	JLabel info=new JLabel();
	
	public  lineplotmainpan() {
	    setLayout(null); //setLayout(new BorderLayout());
	    add(info);
//            setBackground(Color.white);
	    info.setOpaque(true); info.setBackground(getBackground());
	    // P1 CHECK why is it necessary that lineplot info is opaque and that paintComponent calls it to repaint, when this is not necessary in mapplot?
	    addMouseMotionListener(this);
	    
	    setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	}
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g); //paint background
	    
	    Graphics2D g2 = (Graphics2D) g;
	    //g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_SPEED); //QUALITY);
	    
	    AffineTransform oldat = g2.getTransform();
	    float xsf=getWidth()/xscale.range(), ysf=-getHeight()/yscale.range(), xyf=xsf/ysf;
	    g2.scale( ysf, ysf);
	    /*
	     Have to scale same for x and y, otherwise relation pixel:real is not same for x and y,
	     therefore get distorted line shape
	     */
	    g2.translate(-xscale.min()*xyf, -yscale.max());
	    g2.setStroke(new BasicStroke(Math.abs(yscale.range())/thin));
	    
	    if (stacked) {
		//note assumes all curves have same x-range/step
		
		int xmin=(int)xscale.min(), xmax=(int)xscale.max();
		int xstep=(int)(Math.max(qq.map.values().iterator().next().xstep, xscale.range()/getWidth())); if (xstep<1) xstep=1;
		int ns=(xmax-xmin) / xstep;
		
		float[] totpos=new float[1+ns], totneg=new float[1+ns];
		GeneralPath linepos, lineneg, basepos = new GeneralPath(), baseneg = new GeneralPath();
		basepos.moveTo(xmin*xyf, 0); baseneg.moveTo(xmin*xyf, 0);
		for (int x=xmin, i=0; x<=xmax; x+=xstep, i++) {
		    totpos[i]=0; totneg[i]=0; basepos.lineTo(x*xyf, 0);  baseneg.lineTo(x*xyf, 0);
		}
		boolean even=true;
		
		for (qt q : qq.mapwithouttotal().values()) if (q.checkcomplexity()) {
		    even=!even;
		    linepos=basepos; lineneg=baseneg;
		    basepos= new GeneralPath(); baseneg= new GeneralPath();
		    boolean first=true;
		    for (int x=(even ? xmin : xmax), i=(even ? 0 : ns); (even ? x<=xmax : x>=xmin); x+=(even ? xstep : -xstep), i+= (even ? 1 : -1)) {
			if (q.gotdata(x)) {
			    float dy=q.get(x);
			    totpos[i]+= (dy>0 ?  dy : 0);    totneg[i]+= (dy<0 ?  dy : 0);
			    linepos.lineTo(x*xyf, totpos[i]); lineneg.lineTo(x*xyf, totneg[i]);
			    if (first) 	basepos.moveTo(x*xyf, totpos[i]); else basepos.lineTo(x*xyf, totpos[i]);
			    if (first)  baseneg.moveTo(x*xyf, totneg[i]); else baseneg.lineTo(x*xyf, totneg[i]);
			    first=false;
			}
		    }
		    g2.setColor(q.color);
		    g2.fill(linepos);   g2.fill(lineneg);
		}
	    } else { //not stacked
		for (qt q : qq.map.values()) if (q.checkcomplexity()) {
		    GeneralPath line = new GeneralPath(); //GeneralPath.WIND_EVEN_ODD, c.a.length);
		    boolean haddata=false;
		    int xstep=(int)(Math.max(q.xstep, xscale.range()/getWidth())); if (xstep<1) xstep=1;
		    for (int x=(int)xscale.min(); x<=(int)xscale.max(); x+=xstep) {
			if (!q.gotdata(x)) haddata=false;
			if (q.gotdata(x) && !haddata) {	line.moveTo(x*xyf, q.get(x)); haddata=true; }
			if (q.gotdata(x) && haddata) line.lineTo(x*xyf, q.get(x));
			//root.debug(" "+x+" "+ q.get(x));
		    }
		    g2.setColor(q.color);
		    try {
			g2.draw(line);
		    } catch (Error e) { System.err.println("line drawing error"); }
		}
	    }
	    
	    g2.setTransform(oldat); g2.dispose();
	    info.repaint();
	    
	    ready=true;
	}
	
	//shows the x,y info
	public void mouseMoved(MouseEvent e) {
	    try {
		
		qt best=null;
		float x=xscale.min()+xscale.range()*e.getX()/getWidth(), y=yscale.max()-yscale.range()*e.getY()/getHeight();
		if (x>xscale.min() && x<xscale.max() && y>yscale.min() && y<yscale.max())
		    info.setText("<html>"+(int)(x+0.5)+"<br>"+yscale.units.round(y,2));
		//info.setText(String.format("<html>%1$.4g<p>%2$.3g", x, y));
		else info.setText("");
		
		//note moving info may make painting slower!
		info.setLocation(e.getX()+4, e.getY()+4);
		info.setSize(info.getPreferredSize());
		
		if (!stacked) {
		    for (qt q : qq.map.values()) if (
			    //q.checkcomplexity() && //P1 CHECK lineplot mousemoved checkcomplexity causing null pointer exception  -why?
			    best==null || (Math.abs(q.get((int)x)-y)<Math.abs(best.get((int)x)-y))
			    ) best=q;
		    setToolTipText(
			    ( Math.abs(best.get((int)x)-y)<yscale.range()/20) ?
				"<html>"+best.hashcolor() +labman.getTitle( best.name )
				: null );
		}
	    } catch (Exception ex) { System.err.println("lineplot mouse moved exception");}
	}
	
	public void mouseDragged(MouseEvent e) {	}
	
	
    } //end lineplotmain
    
    
} //end class




