

package jcm.gui.plot;

import java.awt.Color;
import java.util.*;
import javax.swing.*;
import jcm.core.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.tls.cs;


public class legend extends JPanel {
    
    HashMap<qt,JLabel> leglab=new HashMap();
    
    qtset qq;
    
    legend(qtset qq) {
	this.qq=qq;
	setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	setBackground(Color.white);
	makelabs();
    }
    
    public void makelabs() {
	for (qt q : qq.map.values()) if (q.checkcomplexity()) {
	    if (!leglab.containsKey(q)) {
		JLabel l=new JLabel( breaklines(labman.getShort(q.name)));
		if (baseplot.bigfont) l.setFont(colfont.vbigbold);
		leglab.put(q, l);
		l.setForeground(q.color);
		add(l);
		l.setToolTipText(labman.getTitle(q.name));
	    }
	}
	for (Iterator<qt> it=leglab.keySet().iterator(); it.hasNext(); ) {
	    qt q=it.next();
	    if (!(qq.map.values().contains(q) && q.checkcomplexity() )) {
		remove(leglab.get(q)); it.remove();
	    }
	}
	revalidate(); repaint();
    }
    
    public String breaklines(String s) {
	if (s.length()>20) {
	    cs cs=new cs("<html>"+s); int i=20;
	    while ((i=cs.nextspace(i))<cs.s.length()) {cs.s.insert(i,"<br>"); i+=24; }
	    return cs.s.toString();
	}
	return s;
    }
    
    public void expand() {   for (qt q : leglab.keySet()) if (q.checkcomplexity()) { leglab.get(q).setText( breaklines(labman.getTitle(q.name))); } }
    public void contract() {  for (qt q : leglab.keySet()) if (q.checkcomplexity()) { leglab.get(q).setText( breaklines(labman.getShort(q.name))); } }
    
    
} //legend

