
package jcm.gui.plot;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import jcm.core.*;
import jcm.gui.*;
import jcm.gui.nav.paramValueChooser;



public class histoplot extends baseplot {
    
    qtset[] sets;
    param year;
    paramValueChooser yc;
    java.util.List regs=new ArrayList();
    Comparator comp=new Comparator() {
	public int compare(Object a, Object b) {return calcratio(a, 0) > calcratio(b, 0) ? 1 : calcratio(a, 0) < calcratio(b, 0)  ? -1 : 0; }
    };
    
    public histoplot(Object[] args) {
	int i=0; for (Object o : args) if (o instanceof qtset) i++; 	sets=new qtset[i]; 
	i=0; for (Object o : args) if (o instanceof qtset) { sets[i]=(qtset)o;  System.err.println(sets[i]);  i++; }
	year =new param("year", 2002, sets[1].sy, sets[1].ey, "year");
	//year =new param("year", Math.min(qqs.ey, sets[1].ey), Math.max(qqs.sy, sets[1].sy), Math.min(qqs.ey, sets[1].ey), "year");
	
	yc=new paramValueChooser(year, "modview");
	
	register.addlink(this, year);
	for (i=0; i<sets.length; i++) if (i!=1) register.addlink(this, sets[i]); //note sets[1] already covered in setup
	setup(sets[1]);
	sort();
    }
    
    //******************************
    //override baseplot
    void makeplot() {   plot=new histo();  }
    
    void setname() { setName("histoplot: "+sets[0].getFullName()+"&per&"+sets[1].getFullName()); }
    
    public void doplot() { sort(); super.repaint(); }
//    public void setSize(Dimension d) { 	super.setSize(d); scale();     }
    
    void makescales() {
	for (Object o : sets[1].mapwithouttotal().keySet()) regs.add(o);
	//for (Object o : sets[1].map.keySet()) if (sets[0].map.containsKey(o)) regs.add(o);
	
	float sum=0, max=0;
	for (Object o : regs) {sum+=sets[1].reg(o).get((int)year.val); float f=calcratio(o);   if (f>max) max=f; }
	
	yscale=new param(param.Type.Yscale,  "Yscale", sets[0].units+"&per&"+sets[1].units,  0, 0, max);
	ysv=new scaleview(yscale);
	ysv.setPreferredSize(new Dimension(100, 400));
	xscale=new param(param.Type.Xscale,  "Xscale", sets[1].units,  0, 0, sum);
	xsv=new scaleview(xscale);
	register.addlink(this, xscale, yscale);
    }
    
    void setlayout() {
	super.setlayout(); plot.add(yc, BorderLayout.NORTH);
    }
    
    //******************************
    //RATIO
    float calcratio(Object o, int i) {
	float fr= sets[1].reg(o).get((int)year.val); if (fr<=0) return 0;
	return sets[i].reg(o).get((int)year.val) / fr;
    }
    
    float calcratio(Object o) {
	float fr= sets[1].reg(o).get((int)year.val); if (fr<=0) return 0;
	float f=0; for (int i=0; i<sets.length; i++) if (i!=1) f+=sets[i].reg(o).get((int)year.val);
	return   f/fr;
    }
    
    
    void sort() {
	Collections.sort(regs, comp);
	//for (Object o : regs) System.err.println(o.toString()+ " "+calcratio(o,1)); //" "+calcratio(o,2)+" "+calctotratio(o));
    }
    
    
    
    //**************************
    //PLOT HISTOGRAM
    class histo extends JPanel implements  MouseMotionListener {
	public  histo() {
	    addMouseMotionListener(this);
	}
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g);
	    int w=getSize().width, h=getSize().height;
	    float xx=-xscale.min()*w/xscale.range(), x, yy, y;
	    for (Object o : regs) {
		if (o instanceof hasinfo) g.setColor(((hasinfo)o).getColor()) ;
		x=(sets[1].reg(o).get((int)year.val)*w/xscale.range());
		yy=h;
		for (int i=0; i<sets.length; i++) if (i!=1) {
		    y=(int)(calcratio(o, i)*h / yscale.max());
		    if (y<0) {
			g.setColor(Color.white);
			g.fillRect((int)xx+1, (int)yy+1, (int)x-2,  (int)-y-1);
		    } else g.fillRect((int)xx, (int)(yy-y)-1, (int)x,  (int)y-1);
		    g.setColor(variant(g.getColor()));
		    yy-=y;
		}
		xx+=x;
	     /*
	    y=(int)(calcratio(o, 1)*h/max);
	    g.fillRect((int)xx, (int)(yy-y), (int)x,  (int)y);
	    yy-=y;
	    y=(int)(calcratio(o, 2)*h/max);
	    if (y<0) g.setColor(Color.white);
	    g.fillPolygon(new int[]{(int)xx, (int)(xx+x), (int)(xx+x/2) }, new int[] {(int) yy, (int)yy, (int)(yy-y)}, 3 );
	      */
		
	    }
	    ready=true;
	} //paint
	
	
	//**************************
	//MOUSE
	public void mouseMoved(MouseEvent e) {
	    float xx=0, x;
	    findreg: for (Object o : regs) {
		x=(sets[1].reg(o).get((int)year.val)*getSize().width/xscale.max());
		if (xx+x > e.getX() && o instanceof infob) {
		    setToolTipText( "<html>"+((infob)o).hashcolor() +((infob)o).getName()+" "+ calcratio(o,0)+(sets.length>2 ? " "+calcratio(o,2) : "") );
		    return;
		} else xx+=x;
	    }
	}
	
	public void mouseDragged(MouseEvent e) {	}
	
    } //histo class
    
}

//SortedMap<Object, Float> ratio=new TreeMap();
    /*
    class ratio implements Comparable<ratio> {
	Object o; Float f;
	ratio(Object o, Float f) {this.o=o; this.f=f;}
	public int compareTo(ratio r) { return (int)(f-r.f); }
    }
     */

