
//tool for viewing graph data

package jcm.gui.plot;
import jcm.core.plotlink;
import jcm.gui.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.tls.*;
import jcm.core.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.io.*;

public class datable extends JScrollPane implements plotlink  {
    
    jcmTM tm; boolean ready=false;
    
    public datable(qtset qq) {
	setName(qq.getLongTitle());
	setToolTipText(getName());
	
	register.addlink(this, qq);
	loop.go(); //for regional modules, qq.map.values() are made only after loop.go
	
	tm=new jcmTM(qq);
	JTable 	tab=new JTable(tm);
	tab.setColumnSelectionAllowed(true);
	setcolor(tab, 0, Color.black);
	int c=1; for (qt q: qq.map.values()) { setcolor(tab, c, q.color); c++; }
	
	//for (int i=0; i<tm.getColumnCount(); i++)  tab.getColumnModel().getColumn(i).setMinWidth(80);
	//setPreferredSize(new Dimension(400,300));
	//setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	
	tab.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	//could specify a menu of options for resizing?
	
	setViewportView(tab);
	
	new contextMenu(tab, qq);
	ready=true;
    }
    
    void setcolor(JTable tab, int column, final Color color) {
	tab.getColumnModel().getColumn(column).setCellRenderer(new DefaultTableCellRenderer() {
	    public void setValue(Object value) {	setForeground(color); super.setValue(value); }
	});
    }
    
    
    public void doplot() { try {
	tm.fireTableDataChanged(); repaint();
    } catch (Exception e) { System.out.println("table plot problem"); }
    }
    
    public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
    
    //*******************************************
    //SAVE TABLE
    public static JMenu savetablemenu(final qtset qq) {
	JMenu savetable=new JMenu("Save table");
	for (final String s : new String[]{"csv", "tab"})  savetable.add( new AbstractAction(s) {  public void actionPerformed(ActionEvent e) {
	    qq.forcecalc(); savetable(qq.name, new jcmTM(qq), s);
	}});
	return savetable;
    }
    
    public static JMenu savetablemenu(final String name, final TableModel tm) {
	JMenu savetable=new JMenu("Save table");
	for (final String s : new String[]{"csv", "tab"})  savetable.add( new AbstractAction(s) {  public void actionPerformed(ActionEvent e) {
	    savetable(name, tm, s);
	}});
	return savetable;
    }
    
    public static void  savetable(String name, TableModel tm, String type) {
	File f=fileio.getFileFromDialog( "user", name+"."+type, "Save Table", "save");
	if (f!=null) savetable(f, tm, type);
    }
    public static void  savetable(File f, qtset qq, String type) { savetable(f, new jcmTM(qq), type);    }
    
    public static void  savetable(File f, TableModel tm, String type) {
	
	if (f!=null) {
	    try {
		FileWriter fw=new FileWriter(f);
		int rows=tm.getRowCount(), cols=tm.getColumnCount();
		String line;
		for (int row=0; row<rows; row++) {
		    line="";
		    for (int col=0; col<cols; col++)   line+=tm.getValueAt(row, col)+ (type=="csv" ? ", " : "\t");
		    fw.write(line+"\n");
		    //System.out.println(line+"\n");
		}
		fw.close();
		System.out.println("saved table: "+f);
	    } catch (IOException e) {	System.out.println("IO Exception\n"+e); };
	} //if
    } //savetable
    
}//end class

//*******************************************

class jcmTM extends AbstractTableModel  {
    
    //note this assumes that all data have same sy & xstep as first column!
    
    
    Vector<qt> curves;
    jcmTM(qtset qq) {   curves=new Vector<qt>(qq.map.values()); }
    
    public String getColumnName(int col) {	return (col==0 ? "year" : labman.getTitle(curves.get(col-1).name)); }
    public int getRowCount()  {  int rc=0; for (qt c : curves) {int rcc= c.getlength(); if (rcc>rc) rc=rcc; } return rc+1; 	}
    public int getColumnCount() { return 1+curves.size(); }
    public Object getValueAt(int row, int col) {
	int year=curves.get(0).getyear(row-1);
	return  (row==0 ? getColumnName(col) :  col==0 ?  year : curves.get(col-1).get(year) );
    }
    public boolean isCellEditable(int row, int col) {	return ( col==0 || row==0 ? false : true ); }
    public void setValueAt(Object value, int row, int col) {
	curves.get(col-1).a[row-1]=Float.parseFloat(value.toString());
	fireTableCellUpdated(row, col);
    }
}
