/* 
 P2 CHECK autosetmin/range works
 P2 CHECK need to reimplement colorscale rescale - but note no longer in mapplot linkiob!
P1 STRUC colorscale could use another type of param (double param), as plot-scales?
P1 ENH make colorscale adjustable
P1 ?? ENH change color-autoscale according to regions
*/

package jcm.gui.plot;
import java.awt.*;
import javax.swing.*;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.*;
import jcm.gui.gen.colfont;
import jcm.mod.reg.mapdata;
import jcm.mod.reg.regcli;
import jcm.mod.reg.region;

public class colorscale extends JPanel implements colfont, plotlink {
    
    public param rescale=new param("rescale");
    
    regcli rc;
    public colorscale(regcli rc) {
	this.rc=rc; setdata(rc.d1);
	register.addlink(this, rescale);
    }
    
    public void setdata(mapdata md) {
	makecolors();
	autosetminandrange(md);
	setBackground(white);
	setPreferredSize(new Dimension(400, 32));
    }
    
    public void doplot() {  autosetminandrange(rc.d1) ; }
    
    //ex regclimap    public void reset() {	rescale.changed=true; }
    //setaffectedby(rc.quantity);
    
    //affects colourscale
    double min, range;
    int r,g,b;
    public static	Color[] c =new Color[256];
    
    
    //make the colourscale, just at start
    public void makecolors() {
	for (int i=0; i<256; i++) {
	    b= (int) (127+127.0*Math.cos((Math.PI*2)*(i-43)/256));
	    g= (int) (127+127.0*Math.cos((Math.PI*2)*(i-128)/256));
	    r= (int) (127+127.0*Math.cos((Math.PI*2)*(i-213)/256));
	    c[i]=new Color(r,g,b);
	}
    }
    
    //note: adjusted from +/-3*sd to -2 - +4 sd
    //not consistent with documentation!
    public void autosetminandrange(mapdata d) { setminandrange(d.fac*(d.av-2.0*d.sd), d.fac*(6.0*d.sd)); }
    public void setminandrange(double m, double r) {	min=m; range=r; }
    
    public Color getcolor(float f) {
	if (f<=-999) return white;
	int q=(int)(256.0 * (f-min)/range + 4096.0)%256;
	if (q>0) return c[q]; else return white;
    } // if (c<0) c=0;
    
    public Color getcolor(int i) {
	if (rc.quantity.chosen.equals("mix&tmx&tmn&pre")) return mixcolor(i);
	else return getcolor(rc.d1.r[i]);
    }
    
    public Color mixcolor(int i) {	return mixcolor(rc.d1,rc.d2,rc.d3, rc.d1.r[i], rc.d2.r[i], rc.d3.r[i]); }
    
    public Color mixregcolor(region r) {	return mixcolor(rc.d1,rc.d2,rc.d3, r.avg(rc.d1), r.avg(rc.d2), r.avg(rc.d3) ) ; }
    
    public Color mixcolor(mapdata d1, mapdata d2, mapdata d3, float v, float v2, float v3) {
	if (v<=-999 || v2<=-999 || v3<=-999) return Color.white; else {
	    int r=(int)((v-(d1.av-2.0*d1.sd))*(128.0/(2.0*d1.sd))); if (r<0) r=0; if (r>255) r=255;
	    int g=(int)(Math.log(1.0+(v2-d2.min)/(d2.av-d2.min)) *256.0 /Math.log(1.0+(3.0*d2.av-d2.min)/(d2.av-d2.min)) ); if (g<0) g=0; if (g>255) g=255;
	    int b=(int)(((d3.av+2.0*d3.sd)-v3)*(128.0/(2.0*d3.sd))); if (b<0) b=0; if (b>255) b=255;
	    return new Color(r,g,b);
	}
    }
    
    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	int bw=16, w=getSize().width-2*bw, h=getSize().height;
	for (int x=bw; x<=(w+bw); x++) {
	    float f=(float) (min+((x-bw)*range)/w );
	    g.setColor(getcolor(f));
	    g.drawLine(x, 0, x, h/2);
	    if (x==bw || (x-bw)%(w/(w/80))==0) {
		g.setColor(black);
		g.drawLine(x, h/2, x, h/2+4);
		g.drawString(units.round(f,1,2), x-12, h-4);
	    }
	}
    }
    
} //end class