package jcm.gui.plot;


import java.awt.*;
import javax.swing.*;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.imagesaver;
import jcm.gui.nav.menuFiller;


public class baseplot  extends JPanel implements plotlink, menuFiller  {
    
    JPanel plot;
    legend legend;
    contextMenu popup;
    
    public param xscale, yscale;
    scaleview xsv, ysv;
    static boolean bigfont=false;
    
    qtset qq;
    boolean ready=false, temporaryqq=false;
    
    void setup(qtset qq) {
	this.qq=qq;
	register.addlink(this, qq); loop.go();
	/*note:  for some (esp regional) modules, curves are made only after loop.go,    so autoscale only only works after link has set output force calc    */
	setname();
	makescales();
	legend = new legend(qq);
	makeplot();
	setlayout();
	setcolor();
	setToolTipText(getName());
	new contextMenu(plot,  this, qq);
	show();
    }
    
    void makeplot() { } //does nothing - must override
    
    void setname() {  setName(qq.getLongTitle()); } //+"&ob&"+ yscale.units.units+"&cb");
    
    //*****************************************************
    //POPUP
    
    
    public void fillMenu(JPopupMenu popup) {
	popup.add(imagesaver.copyaction(this));
	popup.add(imagesaver.saveimagemenu(this, qq.name));
    }
    
    //*****************************************************
    //SCALES
    
    void makescales() {
	yscale=qq.getyscale();
	xscale=qq.getxscale();
	ysv=new scaleview(yscale);
	xsv=new scaleview(xscale);
	register.addlink(this, xscale, yscale);
    }
    
    //*****************************************************
    //PLOTLINK
    public void doplot() {
	if (ready) plot.repaint();
	if (ready) legend.makelabs();
    }
    public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
    
    //*****************************************************
    //LAYOUT
    void setlayout() {
	GridBagLayout g= new GridBagLayout();
	GridBagConstraints c=new GridBagConstraints();
	setPreferredSize(new Dimension(400,300));
	setLayout(g);
	ysv.setMinimumSize(new Dimension(40,0));
	xsv.setMinimumSize(new Dimension(0,20));
	legend.setMinimumSize(new Dimension(40,0) );
	plot.setMinimumSize(new Dimension(60,60) );
	plot.setPreferredSize(new Dimension(200,200) );
	//gridy=0 left for adding a top-bar if needed
	c.gridx=0; c.gridy=1; c.fill = c.VERTICAL; c.weightx=0; c.weighty=1; g.setConstraints(ysv, c); add(ysv);
	c.gridx=1; c.gridy=1; c.fill = c.BOTH; c.weightx=1; c.weighty=1; g.setConstraints(plot, c); add(plot);
	c.gridx=2; c.gridy=1; c.fill = c.BOTH; c.weightx=0; c.weighty=0; g.setConstraints(legend, c); add(legend);
	c.gridx=1; c.gridy=2; c.fill = c.HORIZONTAL; c.weightx=1; c.weighty=0; g.setConstraints(xsv, c); add(xsv);
    }
    //*****************************************************
//RESPONSE TO RESIZING
    int ow=0;
    public void repaint() {
	super.repaint();
	int w=getSize().width;
	if (w>500 && ow<=500) legend.expand();
	if (w<=400 && ow>400) legend.contract();
	ow=w;
    }
    //*****************************************************
    //CLOSE
    public void removeNotify() { //called when plot is closed
	super.removeNotify();
	xscale.dispose(); yscale.dispose();
	//get rid of curves if created temporarily for divby or differentiate
	if (temporaryqq) qq.dispose();
	loop.go();
    }
    
    
    
    //*****************************************************
    //COLOR
    void setcolor() {
	Color bcol= Color.white;
	if (qq.owner instanceof module) bcol= brighter(((module)qq.owner).world.color);
	setBackground(bcol);
	plot.setBackground(bcol);
	ysv.setBackground(bcol);
	xsv.setBackground(bcol);
	legend.setBackground(bcol);
	
	
//        setOpaque(false);
//        plot.setOpaque(false);
//        ysv.setOpaque(false);
//        xsv.setOpaque(false);
//        legend.setOpaque(false);
    }
    
    
    Color brighter(Color c) {
	if (c==Color.black) return Color.white;
	return new Color(255-(255-c.getRed())/8, 255-(255-c.getGreen())/8, 255-(255-c.getBlue())/8);
    }
    
    Color variant(Color c) { return new Color(vary(c.getRed()), vary(c.getGreen()), vary(c.getBlue()) ); }
    int vary(int c) { if (c<127) return (int)(c*1.5); return (int)(c*0.67); }
    
    //note also rcol(Color) in infob
    
}