

package jcm.gui.nav;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.gen.*;
import jcm.gui.doc.*;

public class treeMaker extends JScrollPane implements plotlink, TreeExpansionListener {
    
    
    //**********************************
       /*
     Note JTree works by copying images of  components, not displaying them directly
    So to force changed display we use TreeListener to check for changes in what's visible , and call treeDidChange
	
     Need a separate register-link for each param,  because cannot detect which param calls isShowing,
     Link only to currently visible params, otherwise every param would be set output
     Note links use weak-references so will be garbage-collected if unattached to visible objects!
	
	Changing complexity and additional worlds imply mutable tree structure
	- from complexity or worlds we know when structure changes,
	problem is to force a redrawing
	-only easy way is to make an enitrely new tree, and reopen paths
	
	Due to complexities and frequent restruc might be simpler and even more efficient to make own tree from scratch, using absolute layout, infob components (destroyed when folded)
	Then param infobs would be showing regardless of selection, so would still need checkenabledforplotexcept, but not special plotlinks to tree
	Would also lose specific look&feel implementations of the hooks, but could make them bigger
	
	See also notes in oldenabledcode.java
	***********************
	*/
    
    JTree tree;
    jcmTreeModel tm;
    final treeMaker treemaker=this;
    boolean insetup=false, firstsetup=true;
    
    Map<param, TreePath> visparams = new HashMap();
    infob io=null, oldio=null; //keeps track of current  iob clicked
    JPopupMenu pop=new JPopupMenu();
    
    //note these params might belong to one tree (be not static?) ditto complexity
    public static param helpmode=new param("helpmode", true);
    public static param filterenabled=new param("filterenabled", true);
    
    plotlink restruc=new plotlink() {
	//called when complexity or world structure changed, or any interactions changed if filterenabled
	//beware this is slow!
	
	public void doplot()  {
	    if (filterenabled.istrue()) filterenabled.needed=false; //prevents loop from clearing filterenabled.changed, to force refresh tree after next loop.go
	    if (loop.changeinteractions) { //set by param set(),  skip  this when dragging a value parameter since doesn't change structure
		System.err.println("Tree Refreshed");
		TreePath[] paths=getOpenPaths();
		for (param p : visparams.keySet())  register.removelink(this, p);
		for (TreePath tp : paths) if (tree.isVisible(tp)) tree.collapsePath(tp);
		infob root=tm.root;    tm=new  jcmTreeModel();    tm.root=root;
		//although tm doesn't actually change, it seems to help Tree to find that it's a different object
		tree.setModel(tm);
		tree.treeDidChange();
		expandpaths(paths);
	    }
	}
	
	public boolean  isShowing() { return tree.isShowing(); }
    };
    
    
    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	if (filterenabled.istrue()) filterenabled.changed=true;
    }
    
    //called when a parameter inside tree changes (if remake whole tree, it scrolls up and you lose the focus)
    public void doplot()  {  tree.treeDidChange(); }
    
    //********************************
    //CONSTRUCTOR
    public treeMaker(Object  arg) { 	setup(new Object[]{arg});    }
    public treeMaker(Object [] args) { 	setup(args);    }
    public treeMaker() { tm=new  jcmTreeModel(); newtree(); setup(); }
    
    public void setup(Object[] args) {
	tm=new  jcmTreeModel();
	setroot(args);
	newtree();
	setup();
	expandpaths(args);
    }
    
    void setroot(Object[] args) {
	if (args.length==0) tm.root=world.worldsob; else {
	    String s=args[0].toString().substring(1, args[0].toString().length()-1); //remove [] brackets
	    infob i= (s.equals(world.worldsob.name)) ? world.worldsob : (infob) world.worldsob.find(s);
	    if (i!=null) 	tm.root=i;
	}
    }
    
    void expandpaths(Object[] args) {
	insetup=true;
	for (int row=0; row<tree.getRowCount(); row++) {
	    for (Object o : args) try {
		if (o.toString().equals(tree.getPathForRow(row).toString())) tree.expandRow(row);
	    } catch (Exception e) { System.err.println("Exception Expanding Tree Path:  "+o.toString()); e.printStackTrace();}
	}
	insetup=false;
    }
    
    void setup() {
	setPreferredSize(new Dimension(300,500));
	setName(tm.root.getName());
	setViewportView(tree);
	setBackground(showpan.mf.getBackground());
	tree.setBackground(showpan.mf.getBackground());
	tree.setOpaque(false); setOpaque(false);
	
	register.addlink(restruc, complexity.defaultcomplexity);
	register.addlink(restruc, labman.language);
	register.addlink(restruc, filterenabled);
    }
    
    
    void savesetup() {
	List al=register.getargs(this);
	if (al!=null) { al.clear(); for (Object o :  getOpenPaths()) al.add(o); }
    }
    
    public TreePath[] getOpenPaths() {
	List<TreePath> openPaths=new ArrayList();
	for (int row=0; row<tree.getRowCount(); row++) if (tree.isExpanded(row)) openPaths.add(tree.getPathForRow(row));
	//Enumeration<TreePath> e=tree.getExpandedDescendants(tree.getPathForRow(0));
	//while (e.hasMoreElements()) openPaths.add(e.nextElement());
	return openPaths.toArray( new TreePath[0]);
    }
    
    //***********************
    
    public void newtree() {
	tree=new JTree(tm);
	tree.setShowsRootHandles(true);
	jcmTreeCellRenderer  tcr=new jcmTreeCellRenderer();
	tree.setCellRenderer(tcr);
	tree.setCellEditor(tcr);
	tree.setRowHeight(0); //control to Renderer
	tcr.addCellEditorListener(new CellEditorListener() {
	    public void editingStopped(ChangeEvent e) { System.out.println("edit stopped"); }
	    public void editingCanceled(ChangeEvent e) {  }
	});
	tree.setScrollsOnExpand(true);
	tree.setEditable(true);
	tree.setExpandsSelectedPaths(true);
	tree.setLargeModel(true);
	tree.addTreeExpansionListener(this);
	new contextMenu(tree, this);
	addClickEffect();
	tree.addMouseListener(showpan.moulist);
	tree.addMouseMotionListener(showpan.moulist);
    }
    
    
    
    void addClickEffect() {
	tree.addMouseMotionListener(new  MouseMotionAdapter()  {
	    public void mouseMoved(MouseEvent e) {
		TreePath tp=tree.getPathForLocation(e.getX(), e.getY() );
		if (tp==null) tp=tree.getPathForLocation(e.getX()-100, e.getY() );
		if (tp!=null) {
		    Object o=   tp.getLastPathComponent();
		    io= (o!=null && o instanceof infob) ?  (infob)o : null;
		} else io=null;
		
		if (oldio!=io)   {
		    pop.removeAll(); pop.setVisible(false);
		    if (io!=null) { io.fillMenu(pop);  } else if (e.getX()>100) {
			pop.add(showpan.pan("About&treeMaker", docview.class, "treeMaker"));
			pop.add(imagesaver.copyaction(tree));
			pop.add(imagesaver.saveimagemenu(tree, "JCMtree"));
		    }
		    if (pop.getComponentCount()>0)  pop.show(tree, Math.min(e.getX()+24, tree.getWidth()), e.getY()-16);
		    oldio=io;
		}
	    }
	});
	
	tree.addMouseListener(new  MouseAdapter()  {
	    public void mouseExited(MouseEvent e)  {
		if (!tree.contains(e.getPoint())) { pop.removeAll(); pop.setVisible(false);}
	    }
	    public void mouseReleased(MouseEvent e)  {
		TreePath tp=tree.getPathForLocation(e.getX(), e.getY() );
		if (tp!=null) { if (tree.isExpanded(tp)) tree.collapsePath(tp); else   tree.expandPath(tp); }
		if (helpmode.istrue()  && io!=null) {
		    if (docview.current==null) {
			SwingUtilities.invokeLater(new Runnable(){  public void run()  {  showpan.makepan(docview.class, io.getName());  } } );
		    } else { docview.current.setpage(io.getName()); showpan.toFront(docview.current); }
		}
	    }
	});
    }
    
    public void treeCollapsed(TreeExpansionEvent event) {
	for (param p : visparams.keySet())   if (!tree.isVisible(visparams.get(p))  || !tree.isExpanded(visparams.get(p) )   ) {
	    register.removelink(this, p);
	}
	if (!insetup) savesetup();
    }
    
    public void treeExpanded(final TreeExpansionEvent event) {
	addlinkpath(event.getPath());
	Enumeration<TreePath> e=tree.getExpandedDescendants(event.getPath()) ;
	while (e.hasMoreElements()) addlinkpath(e.nextElement());
	if (!insetup) loop.golater();
	if (!insetup) savesetup();
    }
    
    
    void addlinkpath(TreePath tp) {
	Object oe=tp.getLastPathComponent();
	if (oe instanceof infob) for (Object o : ((infob)oe).getEnabledObs(true, filterenabled.istrue()))   if (o instanceof param) {
	    param p=(param)o; register.addlink(this, p); visparams.put(p, tp);
	}
    }
    
    public infob getRoot() {return tm.root; }
    
//**********************************
    class jcmTreeModel implements TreeModel  {
	
	public infob root=(infob)(world.worldsob.find("World 1"));
	
	public Object getChild(Object parent, int index) {   return ((infob)parent).getEnabledObs(true, filterenabled.istrue()).get(index); }
	
	//when change complexity level, EnabledObs can become null
	public int getChildCount(Object parent) { if (isLeaf(parent)) return 0; return ((infob)parent).getEnabledObs(true, filterenabled.istrue()).size(); }
	
	public int getIndexOfChild(Object parent, Object child) { return  ((infob)parent).getEnabledObs(true, filterenabled.istrue()).indexOf(child); }
	
	public Object getRoot(){ return root; }
	
	public boolean 	isLeaf(Object node) { return !(node instanceof infob) || ((infob)node).getEnabledObs(true, filterenabled.istrue())==null; }
	
	public void	addTreeModelListener(TreeModelListener l) {}
	public void 	removeTreeModelListener(TreeModelListener l) {}
	public void 	valueForPathChanged(TreePath path, Object newValue) {}
    }
    
    
    class jcmTreeCellRenderer implements TreeCellRenderer, TreeCellEditor {
	
	public Component getTreeCellRendererComponent(JTree tree,  Object value, boolean selected,boolean expanded,boolean leaf,int row,boolean hasFocus) {
	    return getc(value);
	}
	public Component getTreeCellEditorComponent(JTree tree,  Object value, boolean selected,boolean expanded,boolean leaf,int row) {
	    return getc(value);
	}
	
	Component getc( Object value)	 {
	    if (value instanceof infob)  return ((infob)value).getComponent("tree");
	    if (value instanceof Action) return new JButton((Action)value); //should no longer beused
	    return new JLabel( value.toString());
	}
	
	public void removeCellEditorListener(CellEditorListener c) {}
	public void addCellEditorListener(CellEditorListener c) {}
	public void cancelCellEditing() {}
	public boolean  stopCellEditing() { return true; }
	public Object getCellEditorValue() {return null; }
	public boolean isCellEditable(EventObject anEvent) {return true; };
	public boolean shouldSelectCell(EventObject anEvent) {return true; }
	
    }
    
} //end worldtree


