
package jcm.gui.nav;
import jcm.core.*;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;


import java.awt.*;
import java.awt.event.*;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.*;
import javax.swing.tree.TreePath;
import jcm.gui.*;
import jcm.gui.doc.docview;
import jcm.gui.doc.sourceview;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.sysout;

public class showpan  {
    
    
    //********************************
    //FIELDS
    
    public static JFrame mf;
    public static moulist moulist=new moulist();
    
    
    //******* SCREEN ************************
    
    public static Dimension screensize() { return Toolkit.getDefaultToolkit().getScreenSize(); };
    public static Point screencenter(Component c) { return new Point((screensize().width-c.getSize().width)/2, (screensize().height-c.getSize().height)/2);  }
    
    //**************SETUP *****************
    
    public static JFrame setuppan() {
	
	mf=new JFrame("Java Climate Model");
	mf.addWindowListener(new WindowAdapter() {	public void windowClosing(WindowEvent e) {	close(); }} );
	
	JSplitPane
		right=new JSplitPane(JSplitPane.VERTICAL_SPLIT, new jcmTabbedPane(), new jcmTabbedPane()),
		main=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new jcmTabbedPane(), right);
	
	right.setResizeWeight(0.5); main.setResizeWeight(0.3);
	mf.setContentPane(main);
	
	mf.setLocation(new Point(screensize().width/6, screensize().height/6) );
	mf.setPreferredSize(new Dimension(600,400));
	try { 	mf.setIconImage(((ImageIcon)iconFinder.findIcon("World 1")).getImage()); } catch (Exception e) {}
//	mf.setBackground(new Color(217,255,217));
	
	mf.pack(); mf.show();
	System.err.println("JCM Main Window Ready");
	
	return mf;
	
    }
    
    //************ MAKEJDP ***************
    
    public static  JDesktopPane makejdp() {
	JDesktopPane jdp=new JDesktopPane();
	showpan.addpanmenu(jdp);
	return jdp;
    }
    
    
    //************** CLOSE ******************************
    
    public static void close() {
	try {
	    labman.saveonexit();
	    setup.savesetupdefault();
	} catch (Exception e) { e.printStackTrace(); }
	System.exit(0);
    }
    
    
    // ************** FIND / DISPOSE / TOFRONT***************
    //Note might simplify using SwingUtilities convert methods?
    
    public static JComponent findContainer(Point p) { return findContainer(mf.getRootPane().findComponentAt(p));   }
    
    public static JComponent findContainer(Component c) {
	while (c!=null && c!=c.getParent() && !(c instanceof jcmTabbedPane || c instanceof JDesktopPane)) c=c.getParent();
	return (JComponent) c;
    }
    
    public static jcmTabbedPane findTabbedPane(Component c) {
	return (jcmTabbedPane) findContainer(c);
    }
    
    public static void dispose(JComponent c) {
	try {
	    Container cont=c.getRootPane().getParent();
	    if (cont instanceof JInternalFrame) { ((JInternalFrame)cont).dispose();  return ; }
	    if ((cont instanceof JFrame) && cont !=mf)  { ((JFrame)cont).dispose();  return ; }
	    //so it must be in a tabbed pane:
	    findTabbedPane(c).remove(c);
	    c.removeNotify(); c=null;
	    //((JSplitPane)jtp.getParent()).resetToPreferredSizes();
	} catch (Exception e) { System.err.println("error disposing "+c+" "+e); }
    }
    
    public static void toFront(JComponent c) {
	try {
	    Container cont=c.getRootPane().getParent();
	    if (cont instanceof JInternalFrame) { ((JInternalFrame)cont).toFront();  return ; }
	    if ((cont instanceof JFrame) && cont !=mf)  { ((JFrame)cont).toFront();  return ; }
	    //so it must be in a tabbed pane
	    findTabbedPane(c).setSelectedComponent(c);
	    //jtp.setPreferredSize(c.getPreferredSize());
	    //((JSplitPane)jtp.getParent()).resetToPreferredSizes();
	} catch (Exception e) { System.err.println("error toFront "+c+" "+e); }
    }
    
    //******************* SHOW **********************
    public static Container show(JComponent c, Object ... args) {
	String name=c.getName(); Point po=null; Icon i=null;
	Component cont=null;
	
	for (Object o : args) {
	    if (o instanceof String) name=(String)o;
	    if (o instanceof Point) po=(Point)o;
	    if (o instanceof Icon) i =(Icon)o;
	    if (o instanceof Component) cont=(Component)o;
	    if (o instanceof infob && i==null) i=((infob)o).getIcon();
	}
	
	if (i==null) i=iconFinder.findIcon(name);
	if (i==null) i=iconFinder.findIcon(c);
	
	if (cont==null) {
	    if (po==null) po=
		    c instanceof treeMaker ? new Point(100,100)
		    :  c instanceof docview || c instanceof sourceview ? new Point(mf.getWidth()-100,100)
		    : c instanceof sysout ||  c instanceof Box ? new Point(mf.getWidth()/2, mf.getHeight()-100)
		    : new Point(mf.getWidth()/2, mf.getHeight()/2);
	    
	    
	    cont=findContainer(po);
	    
	    // in case it lands on a bar - try moving up and left
	    if (cont==null) { po.translate(-20, -20); cont=findContainer(po); }
	    if (cont==null) { po.translate(40, 40); cont=findContainer(po); }
	    //spot shows where it tries
	    if (cont==null) {   mf.getGlassPane().show();   mf.getGlassPane().getGraphics().fillRect(po.x-10, po.y-10, 20,20); }
	    
	    System.err.println("Try to Show " + c + "\n in " + cont +"\n at "+po);
	}
	
	if (cont instanceof jcmTabbedPane) {
	    
	    jcmTabbedPane jtp=(jcmTabbedPane)cont;
	    if (i!=null) jtp.addTab(labman.getTitle(name)+"  ", i, c); else jtp.addTab(labman.getTitle(name)+"  ", c);
	    toFront(c);
	    return jtp;
	}
	
	if (cont instanceof JDesktopPane) {
	    JDesktopPane jdp=(JDesktopPane)cont;
	    //if (po==null) { //note po now used for position in whole mf
	    JInternalFrame[] fa=jdp.getAllFrames();
	    po=(fa.length>0 ? new Point((fa[fa.length-1].getX()+40) % jdp.getWidth(), (fa[fa.length-1].getY()+40) % jdp.getHeight() ) : new Point(20,20)) ;
	    //}
	    
	    JInternalFrame f=new JInternalFrame(labman.getTitle(name), true, true, true);
	    f.add(c); f.pack();
	    if (i!=null) f.setFrameIcon(i);
	    jdp.add(f);   f.setLocation(po); f.show();
	    toFront(c);
	    return f;
	}
	
	if (cont instanceof JFrame) {
	    JFrame f=(JFrame)cont;
	    f.add(c); f.pack();
	    if (i!=null && i instanceof ImageIcon) f.setIconImage(((ImageIcon)i).getImage());
	    if (po!=null) f.setLocation(po);
	    f.show();
	    toFront(c);
	    return f;
	}
	
	return null;
    }
    
    
//********************************
    /*ACTIONS & MAKEPAN
     The idea is to return Actions without making the components before the menu item is clicked
     (since making components can be slow, calls loop and consumes memory)
    && using Object... args below could simplify panel constructors and help with save/load windows ?
     */
    
    
    public static Action pan(final Class<? extends JComponent> c) { return pan(c.getSimpleName(), c, null); }
    public static Action pan(final Class<? extends JComponent> c, Object o) { return pan(o.toString(),  c, o);  }
    
    //note: now got SwingUtilities invokeLater in both makepan and action
    public static Action pan(String name, final Class<? extends JComponent> c, final Object o)  {
	Action a= new AbstractAction(labman.getShort(name)) { public void actionPerformed(ActionEvent e) {
	    SwingUtilities.invokeLater(new Runnable(){  public void run()  {  makepan(c, o); }});
	} } ;
	Icon i= iconFinder.findIcon(name); 
	if (i==null && o instanceof infob) i= iconFinder.findIcon((infob)o);
	if (i==null) i= iconFinder.findIcon(c.getSimpleName());
	a.putValue( a.SMALL_ICON , i); //a.getValue(a.NAME).toString()
	return a;
    }
    
    
    
//can this be extended to varargs Object ...  ?
//problem is that register stores only one Object[] instead of a list of objects, harder to manipulate later
//public static JComponent makepan(Class<? extends JComponent> c, final Object o) { return makepan(c,o,null);  }
    public static JComponent makepan(Class<? extends JComponent> c, final Object o, final Object ... args) {
	try {
	    JComponent com;
	    if (o==null) com=c.newInstance();
	    else {
		Class ic=o.getClass();
		Constructor<? extends JComponent> con=null;
		findconstructor : do {
		    try {
			con=c.getConstructor(ic);  break findconstructor;
		    } catch (Exception ex) { }
		    if (ic.isArray()) {
			Class ac=ic.getComponentType().getSuperclass();
			ic=  ac!=null ? Array.newInstance(ac, 1).getClass() : null;
		    } else ic=ic.getSuperclass();
		} while (ic!=null);
		if (con==null) { System.err.println("can't find constructor for "+c+ " / "+o); return null; }
		com=con.newInstance(o);
	    }
	    final JComponent com2=com;
	    SwingUtilities.invokeLater(new Runnable(){  public void run()  {  show(com2, args);   } } );
	    register.addwin(com, o);
	    return com;
	}    catch (Exception ex) { System.err.println(ex); ex.printStackTrace(); return null; }
    } //makepan
    
    
// **************** CHANGE / SPLIT  FRAME **********
    public static void  addpanmenu(final JComponent c) {
	new contextMenu(c, new menuFiller() {
	    public void fillMenu(JPopupMenu pop) {
		
		if (c instanceof jcmTabbedPane) pop.add(new AbstractAction("Convert to Internal Frames"){ public void actionPerformed(ActionEvent e) {
		    JDesktopPane jdp=makejdp();
		    JSplitPane jsp=(JSplitPane) c.getParent();
		    jcmTabbedPane jtp=(jcmTabbedPane)c;
		    //remap(jtp, jdp);
		    if (jsp.getTopComponent()==c) jsp.setTopComponent(jdp);    else jsp.setBottomComponent(jdp);  mf.validate();
		    for (int i=0; i< jtp.getTabCount(); /*i++*/ ) show((JComponent) jtp.getComponentAt(i), jdp, jtp.getIconAt(i), jtp.getTitleAt(i));
		    //it seems that showing the component elsewhere automatically removes it from the tabbed pane (and shifts the indexing accordingly)
		    //but beware, if this is not the case, loop will get stuck!
		    //for (int i=0; i< jtp.getTabCount(); i++)  jtp.remove(jtp.getComponentAt(i));
		}});
		
		if (c instanceof JDesktopPane) pop.add(new AbstractAction("Convert to Tabbed Pane"){ public void actionPerformed(ActionEvent e) {
		    jcmTabbedPane jtp=new jcmTabbedPane();
		    JSplitPane jsp=(JSplitPane) c.getParent();
		    //remap(c, jtp);   pc.put(findpan(c), jtp);
		    if (jsp.getTopComponent()==c) jsp.setTopComponent(jtp);   else jsp.setBottomComponent(jtp); mf.validate();
		    for (JInternalFrame jif : ((JDesktopPane)c).getAllFrames()) {
			show((JComponent)jif.getContentPane(), jtp, jif.getFrameIcon(), jif.getTitle());
			jif.dispose();
		    }
		}});
		
		
		pop.add(new AbstractAction("Remove Panel"){public void actionPerformed(ActionEvent e) {
		    JSplitPane jsp=(JSplitPane) c.getParent(),  jsp2=(JSplitPane) jsp.getParent();
		    JComponent other=(JComponent) (jsp.getTopComponent()==c ? jsp.getBottomComponent() :  jsp.getTopComponent());
		    // remap(c, other);
		    if (jsp2.getTopComponent()==jsp)  jsp2.setTopComponent(other);   else jsp2.setBottomComponent( other);
		}});
		
		pop.add(new AbstractAction("Split Vertical"){ public void actionPerformed(ActionEvent e) { split(c, true); }});
		pop.add(new AbstractAction("Split Horizontal"){ public void actionPerformed(ActionEvent e) { split(c, false); }});
	    }
	});
    }
    
//Component split(boolean vertical) { return split(vertical,  getTabCount()>0 ? (JComponent)getComponentAt(getTabCount()-1) : null );  }
    
    
    static JComponent split(JComponent c, boolean vertical) {
	JSplitPane jsp=(JSplitPane) c.getParent();
	JSplitPane  jspn=new JSplitPane(vertical ? JSplitPane.VERTICAL_SPLIT : JSplitPane.HORIZONTAL_SPLIT);
	jspn.setResizeWeight(0.5);
	jcmTabbedPane jtpn=new jcmTabbedPane();
	if (jsp.getTopComponent()==c) jsp.setTopComponent(jspn); else jsp.setBottomComponent(jspn);
	jspn.setTopComponent(c);
	jspn.setBottomComponent(jtpn);
	return jtpn;
    }
    
//jspn.setPreferredSize(jsp.getTopComponent().getPreferredSize());
//jtpn.setPreferredSize(jspn.getBottomComponent().getPreferredSize());
    
    
    
//********* EXTERNAL WINDOWS *******************
//used by circmenu
    
    public static void addwindow( JComponent c) { addwindow( c, new Point(200,200));   }
    public static void addwindow( JComponent c, Point p) {
//	if (pantype.chosen.equals("external windows")) topwindow(mf, c, p); else
	{   JLayeredPane lp=mf.getLayeredPane(); lp.add(c); lp.setLayer(c, JLayeredPane.POPUP_LAYER); c.setLocation(p);  }
    }
    
    public static void topwindow(Window w, JComponent c, Point p) {
	Rectangle cap=new Rectangle(p.x, p.y, c.getSize().width+10, c.getSize().height+10);
	JWindow win=new capwin(w, cap);
	win.add(c);
	try {
	    win.setAlwaysOnTop(true);
	} catch (SecurityException e) { e.printStackTrace(); }
	win.setLocation(p);
	win.pack(); win.show();
    } //topcircmen
    
    
} //end showpan class
//*************************

class capwin extends JWindow {
    public capwin(Window w, Rectangle cap) {
	super(w);
	try {
	    Robot ro = new Robot();
	    final Image back=ro.createScreenCapture(cap );
	    setContentPane(new JPanel() {
		public void paintComponent(Graphics g) { g.drawImage(back, 0, 0, this);    }
	    });
	} catch (Exception e) { System.out.println("can't capture background"); e.printStackTrace();   }
	//note both awt Exception and security exception possible
    }
}








