

package jcm.gui.nav;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import javax.swing.*;
import javax.swing.event.*;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.*;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;


public class paramValueChooser extends Box implements plotlink, ActionListener  {
    
    param p;
    jcmslider jcms;
    JLabel lab1=new JLabel(), lab2=new JLabel();
    JTextField tf=new JTextField("      ");
    Box horizbox=new Box(BoxLayout.X_AXIS);
    int sliderlength=200;
    
    public paramValueChooser(final param p, Object ... args) {
	super(BoxLayout.Y_AXIS);
	
	this.p=p;
	//p.units.checkunitfac(p.max-p.min); //duplicate param setup
	lab1.setText(p.getLabel());
	if (p.units.units!="")  lab2.setText(" ("+labman.getShort(p.units.units)+")");
	lab1.setForeground(p.color);
	
	
	tf.setPreferredSize(new Dimension(40,16));
	Component gap=Box.createRigidArea(new Dimension(10,0));
	horizbox.add(tf);  horizbox.add(gap);  horizbox.add(lab1);   horizbox.add(lab2); horizbox.add(Box.createHorizontalGlue());
	add(horizbox);
	jcms=new jcmslider(); add(jcms);
	
	tf.addActionListener(this);
	for (Component c : getComponents()) c.setBackground(Color.white);
	setToolTipText(p.getinfo());
	new contextMenu(this, p);
	register.addlink(this, p);
	//if (getPreferredSize().width<sliderlength)
    }
    
    public void doplot() {
	//if (p.changed) loop.golater();
	String s=p.units.round(p.val, p.dp) ;
	tf.setText(s);
	setToolTipText(p.getinfo());
	jcms.repaint();
	// tf.setMinimumSize(new Dimension(getGraphics().getFontMetrics().stringWidth(s)+10, 16));
	// horizbox.doLayout(); revalidate(); getParent().validate();
    }
    
    
    public void actionPerformed(ActionEvent e) { p.set(p.units.unround(Double.valueOf(tf.getText()))); }
    
    public void addNotify() {super.addNotify(); doplot();  }
    
    class jcmslider extends JPanel implements MouseMotionListener, MouseListener {
	
	int x, xd, w, h;
	
	public jcmslider() {
	    setPreferredSize(new Dimension(sliderlength,12));
	    addMouseMotionListener(this); addMouseListener(this);
	}
	//prevent other listeners from intefering with slider
	//public void addMouseMotionListener(MouseMotionListener l) {    if (l==this) super.addMouseMotionListener(l);}
	
	void setx() {
	    x=(int)(w*(p.val-p.min)/(p.max-p.min));  xd=(int)(w*(p.defval-p.min)/(p.max-p.min));
	}
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g);
	    w=sliderlength; h=getHeight(); setx(); draw(g, false);
	}
	
	void draw(Graphics g, boolean pending) {
	    //g.clearRect(0,0, w,h);
	    Color
		    m=p.color,
		    d=new Color(m.getRed()/2, m.getGreen()/2, m.getBlue()/2),
		    l=new Color(255-(255-m.getRed())/2, 255-(255-m.getGreen())/2, 255-(255-m.getBlue())/2);
	    g.setColor(m);
	    g.drawRoundRect(2, h-8, w-4, 4, 3, 3);
	    g.setColor(l);
	    g.fillRoundRect(2, h-7, x-3, 3, 3, 3);
	    g.setColor(Color.black);
	    g.fillRoundRect(x-5, 1, 10, h-2, 2, 2);
	    g.drawRect(xd-2, 2, 4, h-4);
	    g.setColor(pending ? Color.white : l);
	    g.fillRoundRect(x-3, h/2-3, 7, 7, 1, 1);
	    g.setColor(pending ? Color.gray : d);
	    g.fillRoundRect(x-3-1, h/2-3-1, 7, 7, 1, 1);
	    g.setColor(pending ? Color.white : m);
	    g.fillRoundRect(x-3, h/2-3, 6, 6, 1, 1);
	}
	
	void move(int ex) {
	    x=ex;
	    draw(getGraphics(), true);
	    p.set((double) (p.min+((p.max-p.min)*x)/w ));
	}
	
	public void mouseDragged(MouseEvent e) { move(e.getX()); }
	public void mouseClicked(MouseEvent e) { move(e.getX()); }
	public void mouseReleased(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	
    } //jcmslider
    
} //end class

