/*
 static methods to make a menu, based on world root
 */

package jcm.gui.nav;
import java.awt.event.ActionEvent;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.swing.*;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.*;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.iconFinder;
import jcm.script.calcscript;
import jcm.gui.doc.labman;


public class menuMaker extends JMenu implements plotlink, MenuListener {
    
    
    infob root;
    String filter;
    
    //called when world structure or complexity changes
    //remove all and reconstruct since JMenu wasn't designed to be dynamic
    //in principle this should be garbage collected so old references in it don't matter
    public void doplot() { 	removeAll(); construct();    }
    
    public menuMaker(infob th) { root=th; filter=null; construct(); }
    public menuMaker(infob th, String s) { root=th; filter=s; construct(); }
    
    public void construct() {
	String n= (filter !=null) ? filter : root.getLabel();
	setText(n); setIcon(iconFinder.findIcon(n));
	menutreeloop(root, filter, this);
	if (dependenabled(filter)) addMenuListener(this); //will always remake itself, if filterenabled
	if (filter!="Source" && filter!="Data" && filter !="Script") { //because these don't change
	    register.addlink(this, complexity.defaultcomplexity);
	    register.addlink(this, labman.language);
	}
    }
    
    static boolean dependenabled(String filter){ return filter=="Params" || filter=="Worlds"; }
    
    public void menuSelected(MenuEvent e) { if (treeMaker.filterenabled.istrue()) { removeAll(); construct(); }}
    public void menuDeselected(MenuEvent e) {}
    public void menuCanceled(MenuEvent e) {}
    
    
    static  JMenuItem menutreeloop(final infob th, String filter) { return menutreeloop(th, filter, null); }
    
    public static  JMenuItem menutreeloop(final infob th, String filter, JMenu m) {
	List Obs=  th.getEnabledObs(true,  (dependenabled(filter) && treeMaker.filterenabled.istrue()) ? true : false);
	
	if (Obs!=null ||  ((infob)th).actions!=null) {
	    if (m==null) {
		m=new JMenu(th.getLabel());
		if (m.getIcon()==null) m.setIcon(th.getIcon());
		m.setForeground(th.getColor());
	    }
	    
	    JMenuItem jmi=getMenuItem(th, filter); if (jmi!=null) m.add(jmi);
	    
	    if (Obs!=null) for (Object o : Obs)  {
		if (o instanceof infob && ( filter!="Worlds" || o instanceof world)) {
		    JMenuItem mi=menutreeloop((infob)o, filter);
		    if (mi!=null ) m.add(mi);
		}
	    }
	    
	    if (th instanceof infob &&  ((infob)th).actions!=null ) for (Action a : ((infob)th).actions)  {
		if (filter==null || filter=="Worlds") m.add(a);
		else if (a.getValue(a.NAME).equals(filter)) {
		    JMenuItem m2=new JMenuItem(a); m2.setIcon(th.getIcon()); m.add(m2);
		}
		
	    }
//		else if (a.getValue(a.NAME).equals(filter))  {    JMenuItem j=new JMenuItem(a); j.setText(th.getLabel());  return j;  }
	    
	    if (m.getMenuComponentCount()>1) return m;
	    if (m.getMenuComponentCount()==1) {
		JMenuItem mi=m.getItem(0);
		if (!mi.getText().equals(th.getLabel())) mi.setText(th.getLabel()+" > "+mi.getText());
		return mi;
	    }
//	    return null;
	}
	return getMenuItem(th, filter);
    }
    
    static JMenuItem getMenuItem(final infob th, String filter) {
	if (filter=="Script" || filter=="Source") return sslink(th, filter);
	if (filter=="Params" && th instanceof param) return ((param)th).getMenuItem();
	if (filter=="Data") {
	    String f=world.getPath(th).replace(".", "/"); int i=f.lastIndexOf("/"); if (i>0 && i<f.length()) f=f.substring(0,i)+"."+f.substring(i+1,f.length());
	    return new JMenuItem(showpan.pan(th.getName(), sourceview.class, f));
	}
	return null;
    }
    
    static JMenuItem sslink(infob th, String filter) {
	String ss=world.getPath(th);
	try {
	    final Class c=Class.forName(ss) ;
	    if (filter=="Script" && calcscript.class.isAssignableFrom(c)) {
		return new JMenuItem(new AbstractAction(c.getSimpleName()) {	public void actionPerformed(ActionEvent e) {
		    try {
			((calcscript)c.newInstance()).start();
		    } catch (Exception ex) { System.err.println("Problem Instantiating Script"); ex.printStackTrace(); }
		}});
	    }
	    if (filter=="Source" && Modifier.isPublic(c.getModifiers())) return new JMenuItem(showpan.pan(th.getName(), sourceview.class, "source/"+ss.replace(".", "/")+".java"));
	} catch (ClassNotFoundException e) {  }
	return null;
    }
    
} //end class

//final JComponent c=th.getComponent("menu");	    jm.setLayout(null);    jm.add(c);     c.revalidate();     c.setLocation(0,0);     c.setSize(c.getPreferredSize());     jm.setPreferredSize(c.getPreferredSize()); 	    jm.setArmed(false);

		/*
		if (filter==null && o instanceof param) {
		    m.add(((param)o).getComponent());
					This, or alt below, doesn't work because when the menu disappears, calls removeNotify, the linkiob is lost
		 and reshowing the menu doesn't make a new component
		 The only way is to call loop.go if param changed, as ages ago...,
		 and make doplot call from within param, and instead of removing the plotlink on removenotify, just check if visible
		}	 */
