package jcm.gui.gen;

import jcm.core.*;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;
import javax.swing.plaf.metal.*;
import jcm.gui.nav.showpan;

public class lookandfeel {
    
    static final MetalTheme ocean=MetalLookAndFeel.getCurrentTheme(), metal=new DefaultMetalTheme();
    
    //woule be better to load this from a configuration file
    static String[][] elfs ={
        {"Ocean",  "javax.swing.plaf.metal.MetalLookAndFeel" },
        {"Walnut", "my.client.plnf.wp.wood.WoodLookAndFeel"},
        {"Liquid", "com.birosoft.liquid.LiquidLookAndFeel"},
        {"Napkin", "napkin.NapkinLookAndFeel"},
        {"Substance", "org.jvnet.substance.SubstanceLookAndFeel"}
        //{"Synth",  "javax.swing.plaf.synth.SynthLookAndFeel"}
    };
    
    static {
        for (String[] elf  : elfs) try {
            UIManager.installLookAndFeel(elf[0], elf[1]);
        } catch  ( Exception ex) {	System.out.println("l&f err"+ex); }
    }
    
    static UIManager.LookAndFeelInfo systemlf;
    
    static {
        for  (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels())
            if (lafi.getClassName().equals(UIManager.getSystemLookAndFeelClassName())) systemlf=lafi;
    }
    
    public static param lookAndFeelParam=new param("lookandfeelmenu", UIManager.getInstalledLookAndFeels(), systemlf ) {
        public void precalc() { if (chosen!=null) setlf((UIManager.LookAndFeelInfo) getchosen()); }
    };
    static {  register.setAlwaysOutput(lookAndFeelParam);  }
    
    
    static void setlf(UIManager.LookAndFeelInfo lfi) {
        if (lfi!=null) {
            if (lfi.getName().startsWith("Metal")) MetalLookAndFeel.setCurrentTheme(metal);
            if (lfi.getName()=="Ocean") MetalLookAndFeel.setCurrentTheme(ocean);
            setlf( lfi.getClassName());
        }
    }
    static void setlf(String classname) {
        try {
            UIManager.setLookAndFeel(classname);
            SwingUtilities.updateComponentTreeUI(showpan.mf);
        } catch ( Exception ex) {	System.out.println("l&f err"+ex); }
    }
    
    
    
    
    
    //final JFrame mf;
    
        /* extends startJCM
         try {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch  ( Exception ex) {	System.out.println("l&f err"+ex); }
         */
    
    /*
    public lookfeelmenu(final JFrame mf)  {
        setText("Look and Feel");
        this.mf=mf;
     
     
     
        JMenu javathemes=new JMenu("Java");
        JMenu windows=new JMenu("Windows");
     
        for (final UIManager.LookAndFeelInfo lfi : UIManager.getInstalledLookAndFeels() ) {
            String lfname=lfi.getName();
            if (lfname=="Metal") {
                javathemes.add( new AbstractAction("Java5 Ocean") { public void actionPerformed(ActionEvent e) {
                    MetalLookAndFeel.setCurrentTheme(ocean); setlf(lfi);
                }});
                javathemes.add( new AbstractAction("Metal Default") { public void actionPerformed(ActionEvent e) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme()); setlf(lfi);
                }});
                add(javathemes);
            } else {
                if (lfname.startsWith("Windows")) windows.add(new AbstractAction(lfname) {  public void actionPerformed(ActionEvent e) { setlf(lfi); }} ) ;
                else add( new AbstractAction(lfname) {  public void actionPerformed(ActionEvent e) { setlf(lfi); }} ) ;
            }
        } //loop
        if (windows.getItemCount()>0) add(windows);
     
     
    } //constructor
     */
    
    
}

            /*
            P1 TIDY more L&F experiments
             
             //for (LookAndFeel l :  UIManager.getAuxiliaryLookAndFeels());
             
             import  com.oyoaha.swing.plaf.oyoaha.*;
            JMenu oyoaha=new JMenu("oyoaha");
            for (final File f : new File("../pack/l&f/zotm/").getAbsoluteFile().listFiles() ) {
                oyoaha.add( new AbstractAction(f.getName()) { public void actionPerformed(ActionEvent e) {
                    OyoahaLookAndFeel lnf = new OyoahaLookAndFeel(); lnf.setOyoahaTheme(f);
                    try {
                        UIManager.setLookAndFeel(lnf);
                        //setlf("com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel");}} );
                        SwingUtilities.updateComponentTreeUI(mf);
                    } catch ( Exception ex) {	System.out.println("no oyoaha"+ex); }
                }} );
            }
            add(oyoaha);
             
             SynthLookAndFeel synth = new SynthLookAndFeel();
              Class aClass = SynthTest.class;
              InputStream is = aClass.getResourceAsStream("file1.xml");
              synth.load(is, aClass);
              UIManager.setLookAndFeel(synth);
             
             */


