/*
*********  Interacmap Todo  *********
P3 ENH BIG make interacmap useful for presentations and selections:
    draggable items
    modules have icons (of package if not of module) 
    persistence: save setup - (position of items)

 P2 ENH various Interacmap improvements (see also guidoc.todo)
 simplify option, add icons, 
 right click on item to open plot/table/param (as tree), 
 show time of calc (from loop perfomance) 
 drag items, and save layout
 group together layout params (lang, complex, linkx etc.) with one owner
 group by worlds/packages - make into dynamic zooming flowchart 
 */

package jcm.gui.gen;

import jcm.core.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import static jcm.gui.gen.colfont.*;	

public class interacmap extends JPanel implements Runnable  {
    
    Map<interacob, node> map=new HashMap();
    int z=1000;
    boolean running=false;
    node centre=new node();
    
    static interacmap cfc;
    
    public interacmap() {
	setName("JCM Interactions");
	setBackground(Color.white);
	setPreferredSize(new Dimension(600,600));
	//setOpaque(false);
	
	cfc=this;
	add(new JButton(new AbstractAction("start") { public void actionPerformed(ActionEvent e) {  running=true; new Thread(cfc).start(); }}));
	add(new JButton(new AbstractAction("stop") { public void actionPerformed(ActionEvent e) { running=false; }}));
	add(new JButton(new AbstractAction("step") { public void actionPerformed(ActionEvent e) { step(); repaint(); }}));
	add(new JButton(new AbstractAction("loop-go") { public void actionPerformed(ActionEvent e) { loop.go(); }})); //loop.go will call reset after setinteractions
	
	loop.go();
	//running=true; SwingUtilities.invokeLater(new Thread(this));
    }
    
    //JLabel fglabel=new JLabel("*********"); //add(fglabel);  //fglabel.setText(""+g+" "+fg);
    
    public void removeNotify() { running=false; if (cfc==this) cfc=null; }//called when plot is closed
    public void hide() {  if (cfc==this) cfc=null; super.hide();  }
    public void show() { cfc=this; super.show(); }
    
    public static void reset() { //called after loop interactions
	
	if (cfc!=null) {
	    System.out.println("reset flowchart");
	    cfc.running=false;
	    cfc.setup(); cfc.step(); cfc.repaint();
	}
    }
    
    public void setup() {
	for (interacob i : register.alliobs)
	    if ( !(map.containsKey(i)) 	) map.put(i, new node(i));
	//complex line below avoids Concurrent Modification Exception
	for (Iterator<interacob> it=map.keySet().iterator(); it.hasNext() ; )  { interacob i=it.next(); if (i== null || i.disposed) it.remove();}
    }
    
    public void run() {
	while (running) {
	    step();
	    nstep++; nstep%=50;
	    if (nstep==0) { repaint(); }
	}
    }
    
    //float fg=110; int nstep=0;
    float fg=70000; int nstep=0;
    Font bold=new Font("Arial", Font.BOLD, 16), plain=new Font("Arial", Font.PLAIN, 12), italic=new Font("Arial", Font.ITALIC, 12);
    
    void step() {
	for (node n : map.values()) n.random((50-nstep));
	for (node n : map.values()) for (interacob i : n.i.vaffectedby) { node m = map.get(i); if (m!=null)  n.pull(m, 2); }
	for (node n : map.values()) for (node m : map.values()) if (n!=m) n.push(m, 1000); //note for f<0, divide by d^2
	//for (node n : map.values()) n.pull(centre, fg);
	for (node n : map.values()) n.edgepush(fg);
	for (node n : map.values()) n.move(100);
	for (node n : map.values()) n.edge();
	//adjust pull to centre to keep average distance 300
	float g=0; for (node n : map.values()) g+=n.dist(centre); g/=map.size();
	//fg+=10*(g-300)/300;
	fg+=10000*(g-350)/350;
	//System.out.println("g: "+g+"fg: "+fg);
	
    }
    
    public void paintComponent(Graphics g) {
	int w=getSize().width, h=getSize().height;
	super.paintComponent(g);
	//g.clearRect(20,20,w-40,h-40);
	//g.setColor(getBackground()); g.fillOval(0,0,w,h);
	for (node n : map.values())  for (interacob i : n.i.vaffectedby)  {
	    node m= map.get(i); if (m!=null) {
		if (n.i.affects(m.i))  {
		    g.setColor(orange); g.drawLine(n.x*w/z, n.y*h/z,m.x*w/z, m.y*h/z) ;
		} else {
		    int x2=(n.x+m.x)*w/(z*2), y2= (n.y+m.y)*h/(z*2);
		    g.setColor(red);    g.drawLine(n.x*w/z, n.y*h/z, x2, y2);
		    g.setColor(yellow);    g.drawLine(x2, y2, m.x*w/z, m.y*h/z);
		}
	    }
	}
	for (node n : map.values()) {
	    String s=n.i.name;
	    if (n.i instanceof module ) s=((module)n.i).order+" "+s;
	    g.setFont((n.i instanceof module) ? bold : (n.i instanceof qtset) ? italic : plain);
	    // g.setColor(new Color(127*(n.i.output ? 1 : 0), 255*(n.i.needed ? 1 : 0), 255*(n.i.changed ? 1 : 0) ));
	    g.setColor(
		    n.i.output ? n.i.changed ?  magenta : red
		    : n.i.needed ? n.i.changed ? cyan : green
		    : n.i.changed ? ltblue : grey
		    );
	    g.drawString(s, n.x*w/z, n.y*h/z );
	}
    }
    
/*
 principle - like springs:
 repulsion proportional to 1/distance
 attraction proportional to distance
 */
    
    class node {
	float dx, dy;
	int x,y;
	interacob i;
	node(interacob i) {
	    this.i=i;
	    x=(int)(z*Math.random());
	    y=(int)(z*Math.random());
	    dx=0; dy=0;
	}
	node() { //centre
	    x=z/2; y=z/2; dx=0; dy=0;
	}
	
	float dist(node m) {
	    return (float)Math.sqrt((m.x-x)*(m.x-x)+(m.y-y)*(m.y-y));
	}
	
	void pull(node m, float f) {
	    dx+=f*(m.x-x); m.dx-=f*(m.x-x);
	    dy+=f*(m.y-y);  m.dy-=f*(m.y-y);
	}
	
	void push(node m, float f) {
	    float d=  ((m.x-x)*(m.x-x)+(m.y-y)*(m.y-y));
	    if (d>0) {
		dx-=(f/d)*(m.x-x); m.dx+=(f/d)*(m.x-x);
		dy-=(f/d)*(m.y-y);  m.dy+=(f/d)*(m.y-y);
	    }
	}
	
	void random(float f) {
	    x+=(float)(f*(Math.random()-0.5));
	    y+=(float)(f*(Math.random()-0.5));
	}
	
	void edgepush(float f){
	    if (x<z/2 && x>0) dx+=f/x;
	    if (x>z/2 && x<z) dx-=f/(z-x);
	    if (y<z/2 && y>0) dy+=f/y;
	    if (y>z/2 && y<z) dy-=f/(z-y);
	}
	
	
	void edge() {
	    int d=20, d2=20;
	    if (x<d) x=d; if (x>z-d) x=z-d; if (y<d+d2) y=d+d2; if (y>z-d+d2) y=z-d+d2;
	    //x=x%z; y=y%z;
	}
	
	
	void move(float f) {
	    x+=dx/f; y+=dy/f;
	    dx/=2; dy/=2;
	}
    }
   
} //end flowchart

