/*
P1 ENH prettify sourceview - markup with html colors etc.
P1 IDEA sourceview could  compile and make package (by importing ant classes? or wait for Java 6 Mustang)
 */

package jcm.gui.doc;

import java.awt.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.text.html.HTMLDocument;
import jcm.tls.*;

public class sourceview extends JScrollPane {
    
    static String[] keywords= {   "public ", "static ", "void ", "class ", "interface ", "enum ",    "float ", "double ", "byte ", "short ",  "int ", "long ", "char ",    "if", "for", "while", "do" ,   "import ", "extends ", "package ", "abstract ", "try ", "catch ", "instanceof ", "new ", "return " 	};
    static String[] braks={ "{", "}", "[", "]", "(", ")"}, ops= {"+", "-", "*", "/", "=", "|", "&", ".", ",", ";", ":", "?", "%"};
    static String[] seps={":", ",", ";"};
    
    static String note=    "<br><font color=blue>(C) Please note copyright in JCM documentation</font><p>"+
	    "<i><font color=green>To explore the source code in depth, it is recommended to use an IDE such as Netbeans</font></i><hr>";
    
    static String header1="<h3>JCM5 source code ", header2="</h3>"+ new Date(System.currentTimeMillis()).toGMTString();
    
    
    public sourceview(String name) {
	JEditorPane ta= new JEditorPane();
	
	setName(name);
	setPreferredSize(new Dimension(300,400));
	
//	if (name.endsWith("java") || name.endsWith("html") || name.endsWith("png")) {
	ta.setContentType("text/html;");
	try{
	    ((HTMLDocument) ta.getDocument()).setBase(getClass().getResource("/png/"));
	} catch (Exception e) {	System.out.println(e); }
	
	ta.setText(gettext(name));
	setViewportView(ta);
    }
    
    
    String gettext(String name) {
	
	if (name.endsWith(".png")) return "<h3>"+name+"</h3><hr><img src=../"+name+" >";
	
	System.out.println("loading "+name);
	String f=fileio.loadstring(name);
	
	if (f=="") return "<font color=red><i>Problem loading  "+name+ "</i></font>";
	
	
	cs s=new cs(f);
	
	if (name.endsWith("java")) {
	    s.swap("<","").swap(">", "");
	    
	    s.surround("//", "<i> @@@@ " , "\n<@@i>", "\n"); //must be before remove \n
	    s.surround("/*", "<i> @@ " , " @@ <@@i>", "*/");
	    
	    for (String k: ops) s.simplesurround(k, "<font colorred>", "<@@font>");
	    s.swap("", "*").swap("", "=").swap("@@", "/").swap("", "<font color=red>&lt;</font>").swap("", "<font color=red>&gt;</font>");;
	    
	    for (String k: keywords) s.simplesurround(k, "<font color=green>", "</font>");
	    for (String k: braks) s.simplesurround(k, "<font color=blue>", "</font>");
	    
	    s.swap("\n\n", "</nobr><p><nobr>");
	    s.swap("\n", "</nobr><br><nobr>");
	    s.swap("\t","<font color=white>TAB</font>" );
	    
	    return header1+name+header2+note+s.toString();
	} else {
	    s.swap("\n\n", "</nobr><p><nobr>");
	    s.swap("\n", "</nobr><br><nobr>");
	    if (s.s.length()<100000) {//causes memory out of heap space for some big data files
		s.swap("\t","<font color=white>TAB</font> " );
		for (String k : seps) s.simplesurround(k,  "<font color=red>", "</font>");
	    }
	    return "<h3>"+name+"</h3><hr>"+s.toString();
	}
	
    }
    
}
