 /*
LABMAN: label manager
loads and interprets the label/doc files
  */

package jcm.gui.doc;
import java.awt.event.ActionEvent;
import jcm.core.*;

import java.io.*;
import java.util.*;
import javax.swing.*;
import jcm.gui.gen.processdialog;
import jcm.tls.*;
import static jcm.gui.doc.label.*;
import jcm.gui.doc.label.langcode;
import jcm.gui.doc.label.smd;

public class labman {
    
    
    public static  Map <String, label> ldm=new TreeMap();     //Map of the individual labels, sorted by keys
    //use treemap for faster log(n) lookup when hundreds of labels
    static Map<langcode, Set<String>> loaded=new EnumMap(langcode.class);     //Map of categories loaded for each language
    public  static Set<String> category=new HashSet();
    static int sy=1; //syntax type
    
    public static param<langcode> language=new param("languagemenu", label.langcode.values(), label.langcode.en);
    public static boolean recordchanged=false;
    
    static {   register.setAlwaysOutput( labman.language); }
    
    //*******ACTIONS for Edit Menu***********************************************
    //maybe by keeping the filechooser, wouldn't have to reselect directory each time?
    
    public static Action loadchangesaction=new  AbstractAction("Load") {  public void actionPerformed(ActionEvent e)  {
	loadFromDirectory(fileio.getFileFromDialog( "", "Choose Directory for Loading LabDoc Changes", "load"));
    }};
    
    public static Action savechangesaction=new  AbstractAction("Save Changes") {  public void actionPerformed(ActionEvent e)  {
	savedoc(fileio.getFileFromDialog( "", "Choose Directory for Saving LabDoc Changes", "save") , true );
    }};
    
    public static Action savecopyaction=new  AbstractAction("Save All") {  public void actionPerformed(ActionEvent e)  {
	SwingUtilities.invokeLater(new Runnable() { public void run() {
	    loadAllJar();
	    savedoc(fileio.getFileFromDialog( "", "Choose Directory for Saving LabDoc", "save") , false );
	}});
    }};
    
    //**** DEFAULT LOAD / SAVE********
    public static File defaultstore=new File("labdocchanges");
    public static void saveonexit() { savedoc(defaultstore, true); }
    
    public static void loaddefaultchanges() {
	try { //note checking file exists will give a security exception in "safe mode""
	    if (defaultstore.exists() && defaultstore.isDirectory() && defaultstore.listFiles().length>0) {
		//loadAllJar(); //have to load all first before loading changes!
		loadFromDirectory(defaultstore);
	    }
	} catch (Exception e) { e.printStackTrace(); } 
    }
    
    
    //******* LOAD*************************
    
    public static void loadFromDirectory(File f) {
	loadFromJar(langcode.en, ""); //first load english labels, if not done
	if (f.isDirectory()) { System.err.println("Updating labels from "+f); for (File ff : f.listFiles()) loadFromDirectory(ff); } else  try {
	    String fn=f.getName(); int a=fn.indexOf("_"), b=fn.lastIndexOf("_");
	    String cat = ((a==b) ? "" : fn.substring(a+1, b) );
	    langcode lang=langcode.valueOf(fn.substring(b+1,b+3));
	    if (lang==null) System.err.println("couldn't identify language of "+fn);
	    loadFromJar(lang, cat); //important to load the original from Jar  first (if not already done), since changes will be added onto this
	    interpret(fileio.loadstring(f, "UTF8"), lang, cat);
	} catch (Exception e) { System.err.println("couldn't load file "+f); e.printStackTrace(); }
    }
    
    //load ALL labels & doc from existing JAR
    public static void loadAllJarWithDialog() {
	new processdialog("Loading Labels", new JLabel("Please  wait while loading labels"), new Runnable() { public void run() { loadAllJar(); }});
    }
    
    public static void loadAllJar() {
	for (langcode lang : langcode.values()) {
	    loadFromJar(lang, "");
	    for (String cat : category) loadFromJar(lang, cat);
	}
    }
    
    
    //LOAD one lang/cat from existing jar
    public static void loadFromJar(langcode lang, String cat) {
	//check if already loaded: note this must be fast, because called in every label look-up!
	if ( loaded.get(lang)==null) loaded.put(lang, new HashSet());
	else if ( loaded.get(lang).contains(cat)) return; //already loaded it
	loaded.get(lang).add(cat); //won't load again
	
	String filename=(cat=="" ? "lab" : "doc_"+cat);
	String ls= (lang==langcode.it ?  fileio.loadstring("labdoc/"+filename +"_"+lang+".txt") : fileio.loadstring("labdoc/"+filename +"_"+lang+".txt", "UTF8"));
	
	recordchanged=false;
	interpret(ls, lang, cat);
	recordchanged=true;
    }
    
    //**************************************************************
    static void interpret(String ls, langcode lang, String cat) {
	if (ls.length()<1) return;
	System.err.println("Loading Labels "+lang+ " "+cat);
	
	//split file by # which is used to separate items
	String[] items=txt.split(ls, "#");
	
	String key, dat;
	category.add(cat);
	
	int nt=smd.values().length;
	int[] split=new int[nt +1];
	
	for (String item : items) {
	    try {
		//identify category headings
		if (item.indexOf("===>")>=0) {
		    cat=item.substring(item.indexOf("===>")+4, item.indexOf("<===")).trim();
		    category.add(cat);
		    key="";
		} else key=txt.tonextspace(item,0);
		
		label lab=ldm.get(key); //could be more efficient to skip this lookup for the first lab_en file
		if (lab==null) {
		    if (lang!=langcode.en) System.err.println(lang+" added "+key); //warning, since key unlikely to be used, if not in english
		    lab=new label(key, cat);
		    ldm.put(key, lab);
		}
		if (lab.cat !=cat) lab.cat=cat; //added to cope with category changes
		
		for (smd t : smd.values()) split[t.ordinal()]=item.indexOf(t.getcode()); split[nt]=item.length();
		for (int j=nt-1; j>=0; j--) {
		    if (split[j]==-1 || split[j]>=split[j+1]) 	split[j]=split[j+1];
		    else {
			dat=item.substring(split[j]+1, split[j+1]).trim();
			if (j==0) lab.set(lang, smd.i, dat);  //used to be only for new labels - check no problem lose info!
			if (j==1) lab.set(lang, smd.s, dat);
			if (j==2) lab.set(lang, smd.m, dat);
			if (j==3) lab.set(lang, smd.d, autodoc.convertold(dat));
			if (j==4) lab.icon=dat;
		    }
		}
	    } catch (Exception e) { System.err.println("Problem parsing "+item); }
	} //items
	System.gc();
	//System.err.println("loaded labels "+lang+" "+cati);
    }
    
    
    
    //***** SAVE *************************************************
    //make this anonymous class outside method, otherwise it doesn't load until want to save, and can fail if jar changed
    static Comparator<label> labcomp=new Comparator<label>() {  public int compare(label a, label b) { return a.fo.compareTo(b.fo); }};
    
    public static void savedoc(File f, boolean filterchanged) {
	
	List<label> savelist=new ArrayList(ldm.values());
	Collections.sort(savelist, labcomp);
	
	Set<langcode> langs= EnumSet.complementOf(EnumSet.of(langcode.sc));
	
	String oldcat="dummy", iks, newcathead;
	
	Map<langcode, Map<String, StringBuffer>> docsb= new EnumMap(langcode.class);
	for (langcode l : langs) if (l!=langcode.sc) { docsb.put(l, new HashMap()); for (String c : category) docsb.get(l).put(c, new StringBuffer()); }
	Set<langcode> newcat= EnumSet.noneOf(langcode.class);
	
	//StringBuffer csv=new StringBuffer();
	
	for (label lab : savelist) {
	    //cat=""; for (String c : category) if (c!="" && lab.cat.startsWith(c)) cat=c; //still need startswith?
	    //csv.append("\n"+(oldcat!=cat ? cat : "")+"\t"+ntb(lab.key)+"\t"; +ntb(lab.info));
	    
	    if (!oldcat.equals(lab.cat)) { oldcat=lab.cat; for (langcode l : langs)  newcat.add(l); } //set all to new cat
	    newcathead=opencat[sy] +lab.cat+closecat[sy];
	    iks=openkey[sy]+ ntb(lab.key)+  closekey[sy];
	    
	    for (langcode l : langs)  {
		iks+= lab.savetext(l, smd.i, sy) ;
		if (
			(!filterchanged || lab.getchanged(l, smd.s)>0 || lab.getchanged(l, smd.m)>0 )
			&& (l==langcode.en || lab.getorig(l, smd.s)!=null || lab.getorig(l, smd.m)!=null ) //note - include if got either sho or med or saving english (since need even for doc lookup)
			) {
		    if (newcat.contains(l)) { docsb.get(l).get("").append(newcathead); newcat.remove(l);  }
		    docsb.get(l).get("").append( "\n"+iks+lab.savetext(l, smd.s, sy)+lab.savetext(l, smd.m, sy)+closeentry[sy] );
		}
		if ((!filterchanged || lab.getchanged(l, smd.d)>0 )  && lab.getorig(l, smd.d)!=null)
		    docsb.get(l).get(lab.cat).append("\n\n"+iks + lab.savetext(l, smd.d, sy)+ closeentry[sy]  );
		// note used to apply convertbreaksback()
		//csv.append("\t"+ntb(lab.getorig(l, smd.s))+"\t"+ntb(lab.getorig(l, smd.m))+"\t"+ntb(lab.getorig(l, smd.d)));
	    }
	}
	
	//should also save the changed info!
	//fileio.savetextfile(f, "jcmlabdoctab.txt", csv.toString(), "UTF8");
	
	if (!f.exists()) f.mkdir();
	for (String c : category) for (langcode l : langs)   if (docsb.get(l).get(c).length()>0) {
	    System.err.println("saving "+l+" "+c);
	    fileio.savetextfile(f, (c=="" ? "lab" : "doc_"+c)+"_"+l+filesuffix[sy],  head[sy] +docsb.get(l).get(c).toString()+foot[sy], "UTF8");
	}
    }
    
    //***** SYNTAX ***************************
    
    static String
	    meta="<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>",
	    style="<style> cat { color: orange font: bold 120% } dt { color: red} lab { color: brown } pop { color: green  } link { color: blue } note { font: italic 70% } icon, info { color: magenta; font: italic  } </style>",
	    extlink="This is part of the labels / documentation for <a href='http://jcm.chooseclimate.org'>Java Climate Model</a><hr/>";
    
    static String[]    opencat= {"</dl><hr/><dl compact><cat>" , "\n\n#! ===>"},  closecat={"</cat>" , "<==="};
    static String[]    openkey={"<dt>" , "#"},   closekey={"</dt><dd> ",  ""};
    static String[]    closeentry={"</dd>", ""};
    static String[]    filesuffix= { ".html" , ".txt"};
    static String[]    head= { "<html><head>"+meta+style+"</head><body>"+extlink+"<dl  compact>", extlink};
    static String[]	foot= { "</dl></html>", ""};
    
    
    //********************************
    //FETCH LABELS
    
    public static String getShort(String requestkey) {	return getlabel(requestkey, smd.s); }
    public static String getTitle(String requestkey) {	return getlabel(requestkey, smd.m); }
    
    public static String getTitleIfDifferent(String requestkey) {
	String popup=getTitle(requestkey);
	if (!popup.equals(getShort(requestkey)) && !popup.equals(getDoc(requestkey))) return "("+popup+") ";
	else return "";
    }
    public static String getShortIfDifferent(String requestkey) {
	String popup=getShort(requestkey);
	if (!popup.equals(getTitle(requestkey)) && !popup.equals(getDoc(requestkey))) return "("+popup+") ";
	else return "";
    }
    
    public static String getDoc(String requestkey) {
	if (requestkey.equals("doclist")) return doclist();
	if (requestkey.equals("docsearch")) return docsearch();
	return getlabel(requestkey, smd.d);
    }
    
    public static String getlabel(String requestkey, String typecode) {
	for (smd t : smd.values()) if (t.getcode().equals(typecode)) return getlabel(requestkey, t);
	return getlabel(requestkey, smd.s);
    }
    
    public static param<langcode> currentlangchooser=language; //pointer to a language param, used by docview
    public static String getlabel(String requestkey, smd t) { try {
	return getlabel(requestkey, t, currentlangchooser.chosen );
    } catch (Exception e) { return   getlabel(requestkey, t, langcode.en) ;   } //because the param setup can call getlabel!
    }
    public static String getlabel(String requestkey, smd t, langcode lang) {
	try {
	    if (lang==langcode.sc && t!= smd.d) return requestkey;
	    if (requestkey=="") return "";
	    
	    //note, this is not very efficient!
	    loadFromJar(langcode.en, ""); //first load english labels, if not done
	    loadFromJar(lang, ""); //then load labels for specific country (in case labels with & are listed separately in this lang), if not done
	    
	    label lab=ldm.get(requestkey);
	    
	    //if don't find the key...
	    if (lab==null) {
		int split=requestkey.indexOf("&");
		if (split<0) return ((t!= smd.d) ? requestkey : ""); //return requestkey for short/medium, nothing for doc
		else {	//interpret multi-component labels separated by "&"
		    if (split>=requestkey.length()-1)  return getlabel(requestkey.substring(0,split), t); //ignore trailing &
		    String label1=getlabel(requestkey.substring(0,split), t), label2=getlabel(requestkey.substring(split+1), t);
		    return label1+(label1.length()>1 ? " " : "") +label2;
		}
	    }
	    
	    if (t== smd.d) { loadFromJar(langcode.en, lab.cat); loadFromJar(lang, lab.cat); } //load doc file (if needed) - note need english for default
	    return lab.get(lang, t);
	    
	} catch (RuntimeException e ) { System.err.println(" getlabel "+t+" "+requestkey+" : "+e);  return  ((t!= smd.d) ? "!" : "can't find ") +requestkey; }
    }
    
    public static  String ntb(String s) {	return s==null ? "" : s; }
    
//P2 CHECK labinf icon working or still needed?
    public static Icon icon(String iconkey) {
	label lab=ldm.get(iconkey); if (lab!=null && lab.icon!=null) iconkey=lab.icon;
	try { return new ImageIcon(fileio.getURL("struc/png/"+iconkey+".png")); } catch (Exception e) {}
	return null;
    }
    
    
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
//********************************
//SEARCH
    
    //public static String search(String s) {searchstring=s; return searchresults(); }
    
    public static void search(String s, boolean a, boolean t) {
	searchstring=s; anywords=a; titlesonly=t;
	//showwebpage.showinfo(autodoc.makedoc("docsearch"));
    }
    
    public static String docsearch() { 	return searchresults();    } //searchbox()+
    
//P2 need to fix this button to work without javascript
    public static String searchbox() {
	return "<form><input id=searchbox type=text size=30 style='font:75%' value='"+searchstring+"'  >"
		+" <br> @docsearch  searchresults ";
    }
    //			+" `anywords <input id=andor type=checkbox "+(anywords ? "checked" : "")+" > "
    //			+" `onlytitles <input id=incdoc disabled type=checkbox "+(titlesonly ? "checked" : "")+" > "
    //+" <input id=go type=button size=30style='font:75%' value='GO'  >" //`searchgo   onclick=\"jcm.search(searchbox.value, false, false); \"
    //andor.checked, incdoc.checked
    
    
    public static String searchstring="";
    public static boolean anywords=false, titlesonly=false;
    
    public static String searchresults() {
	if (searchstring.equals("")) return "aboutsearch";
	boolean include, found, f;
	float score, score2;
	Map<Float, String> rs=new TreeMap(); //using Treeset, it will be sorted automatically
	String[] ss=txt.split(searchstring.trim()," ", true);
	String p, q;
	
	for (label lab : ldm.values()) {
	    include=!anywords; score=1;
	    try{
		for (int j=0; j<ss.length; j++)	{
		    q=ss[j].toLowerCase();
		    found=false; score2=0;
		    
		    Set<langcode> langs= EnumSet.complementOf(EnumSet.of(langcode.sc));
		    for (smd t : smd.values()) if (t!=smd.i && !(titlesonly && t==smd.d)) 	{
			p=(t!=smd.d ? getlabel(lab.key, t) : autodoc.parse(getlabel(lab.key, t), register.findiob(lab.key), false)).toLowerCase();
			if (p.length()>0) for (int r=-1; (r=p.indexOf(q, r+1))>0; ) {	found=true; score2+=10f/Math.pow(1000+p.length(),0.33); }
		    }
		    if (anywords)  include |=found; else include &=found;
		    score*=score2;
		}
		if (include) {
		    //<!--"+(1000-(int)score)+"-->("+(score<100 ? " " : "")+(score<10 ? " " : "")
		    rs.put(100-score, "<li>"+"("+(int)score+") @"+lab.key+" "+getTitleIfDifferent(lab.key));
		}
	    } catch (RuntimeException e) {	System.out.println("Search error"+lab.key+": "+e); }
	}
	
	StringBuffer out=new StringBuffer(" aboutsearch ==`searchresults : "+searchstring+ " =="  ); for (String r : rs.values()) out.append(r); return out.toString();
	
    } //search
    
    
//******************************************************
//DOCLIST
    
    
    public static String doclist() {
	langcode lang= language.chosen;
	loadFromJar(lang, "");
	for (String cat : category) loadFromJar(lang, cat);
	
	Set<String> rs=new TreeSet(); //automatically sorted (note: used to be sorted by getshortfordoc, looks better)
	String u;
	for (label lab : ldm.values()) {
	    try {
		if (!lab.key.startsWith("!") && !lab.key.equals("doclist") && lab.key.length()>1) {
		    u=" "+(getTitleIfDifferent(lab.key) !=getShort(lab.key) ? getTitleIfDifferent(lab.key)+" " : "" );
		    rs.add((lab.get(lang.en, smd.d)!=null)  ? autodoc.link(lab.key)+u : ""+ getShort(lab.key)+u+"");
		}
	    } catch (Exception e) {	 System.err.println("doclist problem with key "+lab.key+": "+e); }
	}
	
	StringBuffer s=new StringBuffer("doclistinfo ");
	for (String r : rs) if (r!=null)  s.append("<li>"+r);
	return  s.toString();
	
    }
    
    
} //end class


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//NOT CURRENTLY USED

//************************************
//LOAD from big TABLE
    /*
    public static void loadtab() {
     
	String ls=fileio.loadstring("labdoc/jcmlabdoctab.txt", "UTF8");
	String[] items=txt.split(ls, "\n");
	int nk=items.length;
	category=new String[0];
	String curcat="";
	String[] subit;
	label=new label[nk];
	int l, m;
	for (int k=0; k<nk; k++) {
	    label[k]=new label();
	    subit=txt.split(items[k], "\t");
	    try {
		for (int i=0; i<subit.length; i++) if (subit[i].length()>0) {
		    switch (i) {
			case 0:	category=(String[]) ref.add(category, subit[0]); curcat=subit[0]; break;
			case 1:		label[k].key=subit[1]; break;
			case 2:		label[k].info=subit[2]; break;
			default:	l=i/3-1; m= i%3;
			if (m==0)  label[k].sho[l]=subit[i];
			if (m==1)  label[k].med[l]=subit[i];
			if (m==2) label[k].doc[l]= txt.swap(subit[i], "\\", "\n");
		    }
		}
	    } catch (Exception e) {	System.out.println(e+" "+k+"  "+items[k]); }
	    label[k].cat=curcat;
	    label[k].fo=new Integer(k);
	}
	sortkey();
     
    }
     */

