//LABEL: all info about one item (one key)

package jcm.gui.doc;
import java.awt.Color;
import java.util.*;
import jcm.core.infob;
import jcm.core.register;
import static jcm.gui.gen.colfont.*;

public class label {
    
    //************* ENUMS **********************
    public enum langcode {
	en, fr, de, es, pt, nl, ru, dk, no, it, zh, sc;
	static Color[] langcol=new Color[] { dkgrey, dkgreen, dkbrown, yellow, orange, purple, dkblue,  dkred, brown, green, blue, grey };
	public Color getcol() { return langcol[this.ordinal()]; }
    }
    
    public enum smd {
	i("info", ""), s("sho", "`"), m("med", "~"),  d("doc", "");
	public String[] tags;
	smd(String ... a) {tags=a; }
	public String getcode() { return tags[1]; }
	public String open(int sy) {  switch (sy) {case 0: return "<"+tags[0]+">"; case 1: return "\t\t"+tags[1];  default: return ""; } }
	public String close(int sy) {  switch (sy) {case 0: return "</"+tags[0]+">"; case 1: return ""; default: return ""; } }
    }
    
    EnumSet<smd> smdo=EnumSet.allOf(smd.class);//.of(smd.s, smd.m, smd.d);
    
    //*********** FIELDS ***********************
    static int order=0;
    
    public	String key, cat, icon; //key, category, extra-info
    
    public	infob jcmob; //associated object (eg module, qtset etc.), could also add package?
    
    public	Integer fo; // to restore original order in file, after sorting
    
    //make these private forces other code to use get, set, therefore can easily change internal structure, and changed is always noted
    private Map<smd, Map<langcode, String>> text=new EnumMap(smd.class);
    private Map<smd, Map<langcode, Long>> changed=new  EnumMap(smd.class); //records time of last change
    
    //**********************************************
    //constructor
    public label(String k, String c) {
	key=k; cat=c;
	labman.category.add(c); //inefficient, but needed for save new labels
	fo=order; order++;
	for (smd s : smdo) { text.put(s, new EnumMap(langcode.class)); changed.put(s, new EnumMap(langcode.class)); }
	jcmob= register.findiob(key); //note: might be better associate with label?
    }
    
//date/time last edit (for each lang), could also add by whom edit - note use Date(long) to view it
    private Map<langcode, Boolean> fixme=new  EnumMap(langcode.class);
    
    public void set(langcode lang, smd t, String s) {
	if ((s==null && text.get(t).get(lang)!=null)  ||  !s.equals(text.get(t).get(lang))) {
	    //if (labman.recordchanged) System.err.println("set "+key+" "+t+" "+lang);
	    if (labman.recordchanged)  setchanged(lang, t);
	    //if (labman.recordchanged) addinfo(lang, " addJCM5"); else addinfo(lang, " oldJCM4"); //enable this just before saveall to incorporate labdocchanges into jar
	    text.get(t).put(lang, s);
	}
    }
    
    public void addinfo(langcode lang, String s) {
	if (text.get(smd.i).get(lang)==null)  text.get(smd.i).put(lang, s);
	else  if ( !(text.get(smd.i).get(lang).contains(s)  ) )  text.get(smd.i).put(lang, text.get(smd.i).get(lang)+s);
    }
    public void setchanged() { setchanged(langcode.en, smd.s); } //used for indicate change to category
    public void setchanged(langcode lang, smd t) {  changed.get(t).put(lang, System.currentTimeMillis());  }
    
    public String savetext(langcode l, smd t, int sy) {  return (getorig(l, t)!=null ? t.open(sy)+getorig(l, t)+t.close(sy) : ""); }
    
    public long getchanged(langcode lang, smd t) { if (changed.get(t).get(lang)==null) return 0; else return changed.get(t).get(lang);   }
    
    public String getorig(langcode lang, smd t) { return text.get(t).get(lang); }
    
    public String get(langcode lang, smd t) {
	String s= text.get(t).get(lang); if (s!=null) return s;
	if (t==smd.d) { s= text.get(t).get(lang.en); if (s!=null) return autodoc.fd+s+autodoc.fe; else return ""; }   //if only in english, make text.get(smd.d) grey
	s= text.get(t==smd.s ? smd.m : smd.s).get(lang); if (s!=null) return s;	    //try swap m & s
	s= text.get(t).get(lang.en); if (s!=null) return s;					   //try english
	s= text.get(t==smd.s ? smd.m : smd.s).get(lang.en); if (s!=null) return s;  //try english, swap m & s
	return key;
    }
    
    
} //end class

