

package jcm.gui.doc;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.text.html.HTMLDocument;

import jcm.core.*;
import jcm.gui.*;
import jcm.gui.nav.showpan;
import jcm.tls.*;
import static jcm.gui.gen.colfont.*;
import static jcm.gui.doc.label.*;

public class  labdoctable extends JScrollPane  {
    
    labelTM tm;
    JTable tab;
    int row, col;
    
    public labdoctable() {
	setName("Label-Table");
	setPreferredSize(new Dimension(300,400));
	labman.loadAllJarWithDialog();
	tm=new labelTM();
	tab=new JTable(tm);
	setupcolumns();
	addsorter();
	adddetectcell();
	tab.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	setViewportView(tab);
    }
    
    void adddetectcell() {
	tab.setCellSelectionEnabled(true);
	tab.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	//tab.addMouseListener(new MouseListener() {     public void 	});
	tab.getSelectionModel().addListSelectionListener(new ListSelectionListener() { public void valueChanged(ListSelectionEvent e) { row=e.getLastIndex(); tm.select(row, col); }});
	tab.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener() { public void valueChanged(ListSelectionEvent e) { col=e.getLastIndex(); tm.select(row, col); }});
    }
    
    
    void setupcolumns() {
	for (int c=0; c<tm.getColumnCount(); c++) {
	    TableColumn column=tab.getColumnModel().getColumn(c);
	    final Color color=tm.getcolor(c);
	    column.setCellRenderer(new DefaultTableCellRenderer() {
		public void setValue(Object value) { setForeground(color); super.setValue(value); }
	    });
//	    column.setCellEditor(new ce());
	}
    }
    
    
    void addsorter() {
	tab.getTableHeader().addMouseListener( new MouseAdapter() {
	    public void mouseClicked(MouseEvent e) {
		int column = tab.convertColumnIndexToModel( tab.getColumnModel().getColumnIndexAtX(e.getX()));
		if (e.getClickCount() == 1 && column != -1) {
		    //System.out.println("Sorting ...");
		    int shiftPressed = e.getModifiers()&InputEvent.SHIFT_MASK;
		    boolean ascending = (shiftPressed == 0);
		    tm.sort(column, ascending);
		}
	    }
	});
    }
    
    
} //end labeditor class


//***************TABLE-MODEL***************

class labelTM extends AbstractTableModel {
    
    static int xc=5;
    static langcode lc(int col) {return langcode.values()[(col-xc)/3]; }
    static smd lt(int col) {return smd.values()[1+(col-xc)%3]; }
    
    
    java.util.List<label> sortedlabels=new ArrayList(labman.ldm.values());
    
    Color getcolor(int col) {
	return  col==0 ? black : col==1 ? cyan  : col==2 ?  dkcyan : col==3 ? black : col==4 ? black :
	    lt(col)==smd.s ? lc(col).getcol().brighter() : lt(col)==smd.m ? lc(col).getcol() : lc(col).getcol().darker()  ;
    }
    
    public String getColumnName(int col) {
	return col==0 ? "keycode" : col==1 ?  "category"   : col==2 ?  "info"  :  col==3 ? "order" : col==4 ? "iob" :
	    labman.getTitle(lc(col).toString()) + " "+lt(col).tags[0] ;
    }
    
    public int getRowCount()  {  return sortedlabels.size();}
    public int getColumnCount() { return xc+(langcode.values().length-1)*3; }
    
    public Object getValueAt(int row, int col) {
	label l= sortedlabels.get(row);
	return col==0 ? l.key : col==1 ? l.cat :  col==2 ? l.getorig(langcode.en, smd.i) : col==3 ? l.fo :
	    col==4 ?  register.findiobinfo(l.key)  :
		l.getorig(lc(col), lt(col));
    }
    
    void select(int row, int col) {
	String key=sortedlabels.get(row).key;
	System.err.println(key+" "+col);
	if (docview.current==null || (docview.current!=null && !docview.current.isShowing()) )  {   showpan.makepan(docview.class, key); }
	if (col>xc) docview.current.language.chosen=lc(col);
	docview.current.setpage(key);
    }
    
    
    public boolean isCellEditable(int row, int col) { 	return true;  }
//maybe this should be true for the short/med and not for doc?
    
    //below should be checked
    public void setValueAt(Object value, int row, int col) {
	if (value!=null) {
	    label l= sortedlabels.get(row);
	    String s=value.toString();
	    if (col==0)  l.key=s;
	    if (col==1)  l.cat=s;
	    if (col==2)  l.set(langcode.en, smd.i,  s);
	    if (col>=xc) l.set(lc(col), lt(col),  s);
	    fireTableCellUpdated(row, col);
	}
    }
    
    
    
    //*************SORT***************
    public enum sorttype { key, cat, info, fo, none };
    sorttype currentsort=sorttype.fo;
    int direction=1;
    Comparator<label> labelcomparator =new Comparator<label>() {
	public int compare(label a, label b) {
	    switch (currentsort) {
		case key: return direction* a.key.compareTo(b.key);
		case cat: return direction*a.cat.compareTo(b.cat);
		//case info: return direction*a.info.compareTo(b.info);
		case fo: return direction*a.fo.compareTo(b.fo);
		default: return 0;
	    }
	}
    };
    
    void sort(int col, boolean ascending ) { sort(sorttype.values()[col], ascending); }
    
    void sort(sorttype st, boolean ascending ) {
	currentsort=st; direction=ascending ? 1 : -1;
	Collections.sort(sortedlabels, labelcomparator);
	fireTableDataChanged();
    }
    
    
} //endTM  class

//************* OLD **************************************

//    JPopupMenu popup= new contextmenu(tab);
//	//check (if still needed), this may no longer work
//	popup.add(new AbstractAction("Add Rows") {  public void actionPerformed(ActionEvent e)  {
//	    label newlab=new label("new"+System.currentTimeMillis(), "new");
//	    newlab.fo=0; //note: need to fix fo if used!
//	    labman.ldm.put(newlab.key, newlab);
//	    tm.sort(tm.currentsort, false);
//	}});

//    public void removeNotify() { super.removeNotify(); 	sort.sort(labinf.label, "key");	  } //called when plot is closed

  /*
    //*************************** CELL EDITOR*********************************
    class ce extends AbstractCellEditor implements TableCellEditor {
   
    //this doesn't work - it puts docview.current into the box, whereas we simply want to trigger it to change
    public Component getTableCellEditorComponent(JTable tab, Object value, boolean isSelected, int row, int col) {
	String s= value==null ? "" : value.toString();
	final String key=sortedlabels.get(row).key;
	if (docview.current==null) 	 {
	    final Point p=tab.getCellRect(row, col, false).getLocation(), q=tab.getLocation(), r=tab.getRootPane().getParent().getLocation();
	    p.x+=q.x+r.x+40; p.y+=q.y+r.y;
	    SwingUtilities.invokeLater(new Runnable(){ public void run() { showpan.show(new docview(key) ,  p); }});
	}
   
	docview.current.language.chosen=lc(col);
	docview.current.setpage(key);
	return docview.current;
    }
   
    public Object getCellEditorValue() { return "edit using doc viewer"; }
   
    } //end ce  class
   */

