package jcm.gui.doc;
import jcm.core.*;
import jcm.core.plotlink;
import jcm.gui.gen.contextMenu;
import jcm.gui.nav.showpan;
import jcm.tls.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import static jcm.gui.doc.label.*;
import jcm.gui.doc.label.langcode;
import jcm.gui.doc.label.smd;
import jcm.gui.nav.menuFiller;

public class docview extends JPanel implements DocumentListener, plotlink, menuFiller {
    
    public String page="mainmenu";
    public static docview current; //so "help mode" will find most recently opened docview
    public param<langcode> language=new param("languagemenu", label.langcode.values(), labman.language.chosen);
    
    JSplitPane jsp=new JSplitPane();
    JTextField search=new JTextField(),  key=new JTextField(), tfs=new JTextField(), tfm=new JTextField(), tfc=new JTextField(), tfi=new JTextField();
    JLabel jlc= new JLabel(" cat "), jli=new JLabel(" info "), jls= new JLabel(" sho "), jlm= new JLabel(" med "), jld=new JLabel(" chg ");
    JLabel changeddate=new JLabel("");
    JTextArea tal=new JTextArea(), tal2=new JTextArea();
    JCMEditorPane ep=new JCMEditorPane();
    JPanel edit=new JPanel(new GridBagLayout());
    Stack<String> history=new Stack();
    label curlab;
    label.langcode lang;
    
    
    boolean changepage=true, showedit=false, showhtml=false;
    
    
    //********* CONSTRUCT ***************
    public docview() { this("welcome"); }
    public docview(Object o) { this(o.toString()); }
    //note: showpan doesn't find constructors unless exactly same type (not subtype)
    
    public docview(String startpage) {
	setLayout(new BorderLayout());
	jsp.setName("JCM5 Documentation");
	jsp.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	jsp.setPreferredSize(new Dimension(400,600));
	add(jsp, BorderLayout.CENTER);
	setPreferredSize(new Dimension(400,600));
	
	tfs.getDocument().addDocumentListener(this); tfm.getDocument().addDocumentListener(this);
	tfc.getDocument().addDocumentListener(this); tfi.getDocument().addDocumentListener(this);
	tfc.setPreferredSize(new Dimension(50,16));
	
	tal.getDocument().addDocumentListener(this);
	tal.setLineWrap(true); tal.setWrapStyleWord(true); tal.setFont(jcm.gui.gen.colfont.normalfont);
	tal2.setEditable(false); tal2.setForeground(jcm.gui.gen.colfont.brown);
	tal2.setLineWrap(true); tal.setWrapStyleWord(true); tal.setFont(jcm.gui.gen.colfont.normalfont);
	
	JSplitPane editsp=new JSplitPane(JSplitPane.VERTICAL_SPLIT, new JScrollPane(tal), new JScrollPane(tal2) );
	editsp.setResizeWeight(0.7);
	
	GridBagConstraints c = new GridBagConstraints();
	c.gridy=0;   c.fill=c.HORIZONTAL;
	c.gridx=0;  edit.add(jlc, c); c.gridx=1; edit.add(tfc, c);  c.gridx=2; edit.add(jli, c); c.gridx=3; edit.add(tfi,c);
	c.gridy=1;  c.gridx=0;  edit.add(jls, c); c.gridx=1; c.gridwidth=c.REMAINDER; edit.add(tfs, c);
	c.gridy=2; c.gridx=0;  edit.add(jlm, c);  c.gridx=1; edit.add(tfm, c);
	c.gridy=3; c.gridx=0;   edit.add(jld, c); c.gridx=1; edit.add(changeddate, c);
	c.gridy=4; c.weightx=1; c.weighty=1;  c.fill=c.BOTH;
	c.gridx=0; edit.add(editsp, c);
	
	JPanel docpan=new JPanel(new BorderLayout());
	JCMEditorPane top=new JCMEditorPane();
	top.setText(autodoc.maketopmenu());
	docpan.add(top, BorderLayout.NORTH);
	docpan.add(new JScrollPane(ep), BorderLayout.CENTER);
	
	jsp.setLeftComponent(docpan);
	jsp.setRightComponent(edit);
	jsp.setResizeWeight(1);
//    public void setSize(Dimension d) { super.setSize(d); setDividerLocation(-1); }
	
	current=this;
	page=startpage;
	setpage(page);
	register.addlink(this, complexity.defaultcomplexity);
	language.register(); //check, will this mean it never disposes resource?
	register.addlink(this, language);
	new contextMenu(tal, this); new contextMenu(tal2, this);
	makemenus();
    }
    
    public void removeNotify() { if (current==this) current=null;    }
    
    
    //************* MENUS*************
    void makemenus() {
	final JMenuBar mb =new JMenuBar();
	mb.add(language.getMenuItem());
	mb.add(complexity.defaultcomplexity.getMenuItem());

	JMenu editmenu=new JMenu("Edit Doc");
	editmenu.add(new JCheckBoxMenuItem(new AbstractAction("Edit Doc Source") { public void actionPerformed(ActionEvent e) {
	    showedit=!showedit; if (showedit) { edit.setVisible(true); jsp.setDividerLocation(0.6); setpage(page); } else edit.setVisible(false); /* else setDividerLocation(-1); */
	}}));
	editmenu.add(labman.loadchangesaction);
	editmenu.add(labman.savechangesaction);
	editmenu.add(labman.savecopyaction);
	editmenu.add(showpan.pan(labdoctable.class));
	editmenu.add(showpan.pan("New Doc Window", docview.class, page));
	
	editmenu.add(new JCheckBoxMenuItem(new AbstractAction("Show HTML") { public void actionPerformed(ActionEvent e) {
	    showhtml=!showhtml; ep.setContentType("text/"+(showhtml ? "plain;" : "html;")); ep.setup(); showpage();
	}}));
	
	editmenu.add(new AbstractAction("Change Key") { public void actionPerformed(ActionEvent e) {
	    String newkey=JOptionPane.showInputDialog(ep, "New name for this label/doc item?", curlab.key);
	    label blank=new label(curlab.key, curlab.cat); blank.set(langcode.en, smd.i, "old key!");  blank.setchanged(); labman.ldm.put(curlab.key, blank);
	    curlab.key=newkey; curlab.setchanged(); labman.ldm.put(newkey, curlab);
	    setpage(newkey);
	}});
	editmenu.add(showpan.pan("Help about Edit-Doc", docview.class, "EditDoc"));
	
	mb.add(editmenu);
	key.setPreferredSize(new Dimension(120,16));
	
	mb.add(new JLabel("key"));  	mb.add(key);
	key.addActionListener(new AbstractAction("Goto Item") { public void actionPerformed(ActionEvent e) {   setpage(key.getText()); }});
	//JOptionPane.showInputDialog(ep, "Go to / make label/doc with code:", curlab.key)
	mb.add(new JLabel("search"));  	mb.add(search);
	search.addActionListener(new AbstractAction("Search") { public void actionPerformed(ActionEvent e) {   labman.search(search.getText(), false, false); setpage("docsearch"); }});
	//JOptionPane.showInputDialog(ep, "Go to / make label/doc with code:", curlab.key)
	
	
	SwingUtilities.invokeLater(new Runnable() { public void run() {   edit.setVisible(false);  add(mb, BorderLayout.NORTH);  }});
    }
    
    
    //********** JCMEditorPane ******************
    public class JCMEditorPane extends JEditorPane implements HyperlinkListener, MouseListener {
	public JCMEditorPane() {
	    setContentType("text/html;");
	    setup();
	}
	
	void setup() {
	    setEditable(false);
	    addHyperlinkListener(this);
	    addMouseListener(this);
	    try{
		((HTMLDocument) getDocument()).setBase(register.class.getResource("/png/"));
	    } catch (Exception e) {	System.out.println(e); }
	}
	
	public void mouseExited(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {
//	    Element elem = ((HTMLDocument) getDocument()).getCharacterElement(viewToModel(e.getPoint()) ); //getParagraphElement
//	   System.out.println(elem);
	}
	
	
	//  HTMLDocument.Iterator i=((HTMLDocument) getDocument()).getIterator(new HTML.Tag("Ben"));
	
	//********** LINK  / ACTION *********************
	public void hyperlinkUpdate(HyperlinkEvent e) {
	    if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) System.out.println(e.getDescription());
	    if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) {
		String s=e.getDescription();
		if (s.startsWith("#")) {  ep.scrollToReference(e.getDescription().substring(1)); return; }
		if (s.indexOf("!")>0) {
		    String[] ss= txt.split(s, "!");
		    if (ss[0].equals("source")) showpan.makepan(sourceview.class, "source/"+ss[1].replace(".", "/")+".java");
		    return;
		}
		setpage(s);
	    }
	}
    }
    
//****** EDIT ********************************
    
    
    public void changedUpdate(DocumentEvent e) {  updatedoc(e);  }
    public void removeUpdate(DocumentEvent e) {  updatedoc(e); }
    public void insertUpdate(DocumentEvent e) {  updatedoc(e); }
    
    public void updatedoc(DocumentEvent e) {
	if (curlab!=null && !changepage) {
	    if (curlab.cat=="new")  labman.ldm.put(page, curlab);
	    Document doc=e.getDocument();
	    if (e.getDocument()==tal.getDocument() ) curlab.set(lang, smd.d, nullifempty(tal.getText()));
	    else if (doc== tfm.getDocument()) curlab.set(lang, smd.m, nullifempty(tfm.getText()));
	    else if (doc== tfs.getDocument()) curlab.set(lang, smd.s, nullifempty(tfs.getText()));
	    else if (doc== tfi.getDocument()) curlab.set(lang, smd.i, nullifempty(tfi.getText()));
	    else if (doc== tfc.getDocument()) { curlab.cat=tfc.getText(); curlab.setchanged(); labman.category.add(tfc.getText());} //beware adds new cat for every character edited!
	    showpage();
	}
    }
    
    String nullifempty(String s) { return s.equals("") ? null : s; }
    
//****** SET / SHOW PAGE********************************
    public void setpage(String newpage) {
	if (newpage.equals("back")) { if (!history.isEmpty()) page=history.pop(); } else { history.push(page);  page=newpage; autodoc.visited.add(newpage); String ss=""; for (String s : history) ss+=s+" ";  }
	
//if (history.isEmpty() ||  !p.equals(history.peek()))
	if (register.getargs(this)!=null) register.getargs(this).set(0,page);
	System.err.println("show doc page "+page);
	curlab=labman.ldm.get(page);
	
	if (curlab==null) curlab=new label(page, "new" );     //note, we don't register in labman.ldm unless it's edited
	
	changepage=true;
	labman.currentlangchooser=language;
	
	tfs.setText(curlab.getorig(language.chosen, smd.s)); 	//tfs.setText(labman.getshort(page));
	tfm.setText(curlab.getorig(language.chosen, smd.m)); 	//tfm.setText(labman.getlabel(page));
	tfi.setText(curlab.getorig(language.chosen, smd.i));
	tfc.setText(curlab.cat);
	
	tal.setText(curlab.getorig(language.chosen, smd.d)); //tal.setText(labman.ldm.getdoc(page));
	infob i= autodoc.findob(page); tal2.setText((i==null) ? "" :  i.getExtraDoc());
	
	key.setText(page);
	changepage=false;
	
	setName(page);
	
	showpage();
    }
    
    
    
//called when the param changes
    public void doplot() { setpage(page); }
    
    public void showpage() {
	lang=(label.langcode)language.chosen;
	long changed=0; for (smd t : smd.values()) changed=Math.max(changed, curlab.getchanged(lang, t));
	changeddate.setText(changed==0 ? "" : new Date(changed).toGMTString());
	
	labman.currentlangchooser=language;
	ep.setText(autodoc.makedoc(page));
	labman.currentlangchooser=labman.language;
	
	final Rectangle r= changepage ? new Rectangle(1,1,1,1) : new Rectangle(ep.getVisibleRect()) ; r.x=0; r.width=ep.getWidth()-10;
	SwingUtilities.invokeLater(new Runnable() { public void run() {      ep.scrollRectToVisible(r);  }});
    }
    
    public void fillMenu(JPopupMenu popup) {
	String text=((JTextArea)popup.getInvoker()).getText();
	popup.add("goto subcomponent: ");
	cs s=new cs(text);
	int i=0, j; while ((i=s.s.indexOf("", i)+2)>1) {
	    j= s.nextspace(i);
	    final String link=s.s.substring(i,j);
	    popup.add(new AbstractAction(link) { public void actionPerformed(ActionEvent e) {   setpage(link); }});
	    i=j;
	}
    }
    
} //end class
