package jcm.gui.doc;
import java.util.HashSet;
import java.util.Set;
import jcm.core.*;
import jcm.tls.*;
import static jcm.gui.doc.label.smd;
import static jcm.gui.doc.label.langcode;
import jcm.gui.doc.label.smd;
import jcm.gui.gen.iconFinder;
import jcm.mod.reg.regman;

public class autodoc {
    
    static String htmlheader="<html><head><link rel='stylesheet' href='std.css' type='text/css'></head>\n";
    static String tailer="\n</html>";
    public static  Set<String> visited=new HashSet();
    
    //*************** MAKE DOC ***********************************************************
    public static String makedoc(String name) {
	try {
	    contents=""; //clear it
	    infob i=findob(name);
	    String doc= parse( labman.getDoc(name)+"<hr>"+ (i==null ?  javacodeforclass(name) : i.getExtraDoc() ), i, true);
	    //note have to parse doc before can get contents in header
	    return htmlheader+ header(name)+doc+tailer;
	} catch (Exception e) {	e.printStackTrace(); return "makedoc problem "+e; }
    }
    
    public static infob findob(String name) {
	if (name.equals("Worlds")) return world.worldsob;
	if (name.equals("root")) return world.root;
	infob i=register.findiob(name);
	if (i==null) { Object o=world.worldsob.find(name); if (o instanceof infob) i=(infob)o; }
	if (i==null) { Object o=world.root.find(name); if (o instanceof infob) i=(infob)o; }
	//NOTE worldsob finds real modules, root only finds infobs
	if (i==null)  i=regman.allreg.findo(name);
	if (i==null) { try {
	    i=(infob)((infob) world.worldsob.find(docview.current.history.get(docview.current.history.size()-1)) ).find(name);
	} catch (Exception e) { i=null; }     }
	return i;
    }
    
//******** HEADER & CONTENTS **********************************************************************
    
    public static String header(String name) 	{
	String title=icon(name)+labman.getTitle(name); //+typefordoc(name);
	return	parse(/*labman.getdoc("topmenu")+*/ (!title.equals("") ? /* "<hr>"+*/ "<h2>" + title +"</h2>" : "" ), null, true)
	+(!name.equals("docsearch") ?  getcontents() : "" );
    }
    
    public static String maketopmenu() {
	return htmlheader+parse(labman.getDoc("topmenu"), null, true)+tailer;
    }
    
    static String contents="";
    public static String getcontents() { return ((contents.length()>0)  ? "<small>" +contents+"</small> <hr>" : ""); }
    public static void addcontents(String c) {	 contents+=(contents.length()>0 ? " | " : "")+linkbkmk(c);  }
    
    
//******** OLD-DOC  ***************************************************************************
    
//convert old jcm doc syntax into newer wiki-syntax - run on loading labels
    public static String convertold(String input) {
	cs s=new cs(input);
	s.swap("", "").swap("","%%").surround("","---- ===", "===", true);
//	s.swap("", ">").swap("^", "*");
//s.swap("<li>", "\n<li>").swap("","\n"); - accumulates each time!
	return s.toString();
    }
    
    
//********** COLORS *****************
    public static String hexcolor(java.awt.Color c) {
	return " -{#"+tdhex(c.getRed())+tdhex(c.getGreen())+tdhex(c.getBlue()) +" ";
    }
    public static String tdhex(int i) {	String s=Integer.toHexString(i); if (s.length()==1) s="0"+s; return s; } //make two digit as needed by html font
    
//used for greying out english text when translation not available
    public static String fd="-{gray ", fe="}-";
    
//******** PARSE ***************************************************************************
    
    public static String parse(String input, infob dociob, boolean format) { return parserec(input, dociob, format, 0, true);    }
// 	recursive - will start parse from top with sub-labdoc
    public static String parserec(String input, infob dociob, boolean format, int check, boolean continueparsing) {
	try {
	    cs s=new cs(input+ " ");
	    
	    s.swap("@", "@");
	    check++;   s=sublab(s, dociob, true, check, check<10 && continueparsing);
	    //			s=txt.surround(s, "@", "<script>link('" , "')</script> ", false);
	    if (format) {
		s.swap("\r", "").swap("\n\n\n\n", "<p>").swap("\n\n", "<p>" ).swap( "\n", "<br>" );
		s.swap( "----", "<hr>"); s.swap("<br><br>", "<br>").swap("<p><p>", "<p>");
		s.swap( "<br><hr>", "<hr>").swap( "<hr><hr>", "<hr>").swap("<br><li>", "<li>");
		s.surround( "", "<img border=0  src=" , ".png> ", false); //width=22 height=22
		s.surround( "=====", "<h1>" , "</h1> ", true);
		s.surround( "====", "<h2>" , "</h2> ", true);
		s.surround( "===", "<h3>" , "</h3> ", true);
		s.surround( "==", "<h4>" , "</h4> ", true);
		s.surround( "%%", "<small>" , "</small> ", true);
		s.surround( "//", "<i>" , "</i> ", true);
		s.surround( "**", "<b>" , "</b> ", true);
		s.surround( "--", "<s>" , "</s> ", true);
		s.surround( "__", "<u>" , "</u> ", true);
		s.surround( ",,", "<sub>" , "</sub> ", true);
		s.surround( "^^", "<sup>" , "</sup> ", true);
		s.surround( "-{", "<font color=" , "> ", false).swap("}-", "</font>");
	    }
	    return s.toString();
	} catch (Exception e) {	e.printStackTrace(); return e+"\n"+input; }
    }
    
//******** SUBLAB ***************************************************************************
//sublab replaces replaces labelcode with contents of label if followed by  `/~//> or docinfo(what) if followed by  * or play a script if followed by !
// makes header of the `field followed by doc (for sewing together paragraphs)
//beware recursive parsing, make sure don't include ref to self!
    
    public static cs sublab(cs s, infob dociob, boolean format, int check, boolean continueparsing) {
	StringBuilder p=s.s;
	String type, result, openflag="", di, key;
	int i, j=0, ofl=openflag.length();
	try {
	    search: while (( i= p.indexOf(openflag, j))>=0) {
		j=s.nextspace(i+ofl+1);
		type=p.substring(i+ofl, i+ofl+1);
		key=p.substring(i+ofl+1, j);
		try {
		    result=null; findresult: {
			if (type.equals("@")) { result=link(key); break findresult; }
			if (type.equals(smd.s.toString())) { result = labman.getShort(key);  break findresult; }
			if (type.equals(smd.m.toString())) { result = labman.getTitle(key); break findresult; }
			if (!continueparsing) { result=null;  break findresult; } //stop further sublab - due to summary (or too much recursion)
			if (type.equals(smd.d.toString())) { result = labman.getDoc(key); break findresult; }
			if (type.equals("^")) { di=dociob.getSpecificDoc(key); if (di.length()>2) { result=bookmark(key)+di; addcontents(key);    }; break findresult; }
			if (type.equals("")) {	result=subsection(key); break findresult;} //adds title before doc, also adds bookmark at top
			if (type.equals("%")) {	result=summary(key); break findresult; } //adds only own doc, setting check=9 will prevent any further subsection processing
			if (type.equals("!")) { result=scriptbutton(key); break findresult; }
			result=labman.getlabel(key, type); //finds `, ~or  (insert direct) - isn't this duplicated above?
		    }
		    boolean folded=p.lastIndexOf(fd, i)>p.lastIndexOf(fe, i);
		    boolean continueparsingnext=continueparsing && !(type.equals("%"));
		    if (result!=null) result=(folded ? fe : "")+parserec(result, dociob, format, check, continueparsingnext)+(folded ? fd : "");
		    else result="";
		} catch (Exception e) {	result="<b>!"+openflag+type+key+"</b>"; }
		p.replace(i,j, result); j=i+result.length();
	    }
	}	catch (Exception e) {	e.printStackTrace(); p.append("\n\n<b>"+e+"</b>\n\n"); }
	return s;
    }
    
    
    public static String subsection(String key) {
	String title= labman.getTitle(key);
	if (!title.equals(key) && title.length()>2) {	title=bookmark(key)+" ==="+icon(key)+title+"==="; addcontents(key); } //+labman.getTitleIfDifferent(key)
	return  title+"<br>"+labman.getDoc(key);
    }
    
    
    public static String summary(String key) {
	cs c=new cs( labman.getDoc(key));
	c.remove("%%", "%%"); //remove comments
	c.remove("<img", ">"); //remove images
	int cut=500, cut2=c.s.indexOf("<hr>"), cut3=c.s.indexOf("----"); //cut at any hr, or 500 chars
	if (cut2>0 && cut2<cut) cut=cut2; if (cut3>0 && cut3<cut) cut=cut3;
	if (c.s.length()>cut) {c.s.delete(cut, c.s.length()); c.s.append( link(key, "[continued...] ")); }
	return "<br>%%"+ c.s.toString()+"%%<br>";
    }
    
//******** LINKS ***************************************************************************
    static String la="<nobr><a href='", lc="'",  ldv = " style=' color : #00dd44 ' ", ldr=" style=' color : #dd0044 ' " , ldd=" >", le="</a></nobr>";
    public static String link(String name) {
	int i=name.indexOf("+"); //this is used for the toppmenu icons, could be elsewhere
	if (i>1) return link(name.substring(0,i), name.substring(i+1));
	else	return link(name,  icon(name)+labman.getShort(name));
    }
    public static String link(infob i) {	return link(i.name, icon(i.name)+i.getLabel()); }
    
    public static String link(String name, String linktext) { return la+name+lc+ linkcolor(name) +ldd+linktext+le;  }
    
    static String linkcolor(String name) {return ( labman.ldm.containsKey(name) ? visited.contains(name) ? ldv : "" : ldr); }
    
    static String bookmark(String name) {	return "<a name="+name+" ></a> "; }
    static String linkbkmk(String name) {	return "<nobr><a href='#"+name+lc+linkcolor(name)+ldd+ icon(name)+labman.getShort(name)+ le; }
    static String linkcode(String cn, String linktext) {return  "<a href='source!"+cn+"' > "+linktext+" </a> "; }
//return "<a href='' onclick=\"jcm.getcode('"+cn+"'); return false; \" > "+linktext+" </a> "; }
    
    
    
//********** CODE INFO ***********************************************************************
    public static String javacodeheader=" %%==`javacode ==";
    public static String javacodeforclass(String name) {  Class c=ref.findclass(name); return (c==null)  ? "" : "<hr>"+ javacodeheader+ javacode(c); } 
    public static String javacode(infob i) { 	return javacodeheader+javacode(i.owner.getClass())+"%%";    }
    public static String javacode(Class c) {
	if (c==null) return "";
	return 	"%%<nobr> list code: "+ linkcode(c.getName(), c.getName())
		+(c.isInterface() ? "<br>(java interface " :  "<br>(extends: "+ link(c.getSuperclass().getSimpleName(), c.getSuperclass().getName()) )
		+" , package: "+link(c.getPackage().getName())+" )  </nobr> %%";
    }
    
//    try {
//	if (c==null) return "";
//	String 	cfn=c.getName(), 	cn=cfn.substring(cfn.lastIndexOf(".")+1);
//	int g=cfn.indexOf(".", cfn.indexOf(".")+1);
//	String pn=(g>0) ? cfn.substring(cfn.indexOf(".")+1, g) : "" ;
//	Class sc=c.getSuperclass(); String scfn, scn, extend;
//	if (sc!=null) {	scfn=sc.getName(); scn=scfn.substring(scfn.lastIndexOf(".")+1); extend="(extends:"+link(scn, scn)+") "; } else extend="";
//	return "%%<nobr> cogs "+ linkcode(c.getName(), "[ `javacode ]")+link("struccode", "jcm")+"/"	+link(pn, pn) +(pn!="" ? "/" : "") + "<b>"+link(cn, cn) + "</b>  </nobr> "+extend+"  %% <hr>";
//    } catch (Exception e) {	return ""+e; }
//}
    
    public static String icon(infob i) {   String s=iconFinder.findAlias(i); return (s!=null) ? ""+s+" " : "";  }
    public static String typeIcon(infob i) { String s=iconFinder.findAlias(i.type());  return (s!=null) ? ""+s+" " : "";  }
    public static String icon(String name) { String s=iconFinder.findAlias(name); return (s!=null) ? ""+s+" " : "";    }
    
//******************** SCRIPT **************************************
    public static String scriptbutton(String name) {
	String method = (name.endsWith("js") ? "js" : "");
	return
		"<form>"+ labman.getShort(name)+"<br>"
		+ " <input type='button' value='start' onclick=\"jcm.play"+method+"file('script/"+name+".txt'); \" >"
		+" <input type='button' value='stop' onclick=\"jcm.stopplay"+method+"(); \" >"
		+" <input type='button' value='code' onclick=\"window.open('../script/"+name+".txt', 'script', '' ); \" > "
		+"  </form>";
    }
    
} //end class

//********* END ************************

