

package jcm.core;


import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.*;
import java.util.jar.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import static jcm.gui.gen.colfont.*;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;
import jcm.tls.fileio;

	/*
       OK P2 swapped order of module initsetup and register, in order that initsetup can refer to other worlds and result will be registered
       P2 STRUC BIG Part-Shared parallel worlds, split before/after anywhere
	    share some parameters
	    check for impossible dependencies
	    show ensemble ranges on plot
	P1 IDEA Reset one world not to entire register? (indiv modules && params could have a reset method too?)
	 P1 STRUC        should world be an interacob?
	 */

public class world extends infob  {
    
    public static List<world> worlds=new LinkedList(); //used by loop to run mods, and by plot to find divideby options
    public static infob root=new infob("JCM5"); // the "static" list of available classes (including modules)
    public static infob    worldsob=new infob("Worlds"); // as root, but excluding  non-world items eg source-code
    public static Set<String> packages=new HashSet();
    static Icon wi=iconFinder.findIcon("world");
    
    //********** WORLD FIELDS *******************
    
    public List<module> mods=new LinkedList(); //for loop calculation order
    Map<Class, module> modmap=new LinkedHashMap();  // for modules to  lookup other modules (see get methods)
    //(note mods and modmap separate because use Collections.sort)
    
    //********** CONSTRUCT WORLD ***************
    
    public world(String worldname) {
	name=worldname;
	if (name=="World 1") color=Color.black; //otherwise use infob rcol();
	worlds.add(this);
	worldsob.addOb(this);
	root.addOb(this);
	obs=( (infob)  worldtree((infob)(root.find("jcm.mod"))) ).obs;
	
	jcm.mod.data.loaddata.getdata(this); //aim to remove this eventually
	for (module mod : mods)	{  System.out.println("setting up mod: "+mod); mod.initsetup(); mod.register();  } //note register moved
	
	addAction(new AbstractAction("Remove World", wi) {          public void actionPerformed(ActionEvent e) { dispose();   }  });
	addAction(new AbstractAction("Change World Name", wi) {
	    public void actionPerformed(ActionEvent e) { name=JOptionPane.showInputDialog(null, "Enter new name for "+name);   }
	});
	addTreeAction();
	addDocAction();
    }
    
	/* note re setup order:
	 putting initsetup in constructor  doesn't work because it's called before the params etc exist so they don't get their owners set
	 but in some cases we want to call register AFTER initsetup (so initsetup can make references to other worlds)
	 
	 also  initsetup must be after loaddata, should not depend on mod order
	 also making  plot/table menu after initsetup allows dynamically created qtsets to be found
	 */
	/*add check?
		out.message("Run Model :..."); modlist.sealevel.output=true; loop.go(); //alternatively, could just make loaddata run, do rest when see what plots visible?
		out.message("Check Sealevel 2100="+modlist.sealevel.total.a[350]);
	 */
    
    //***************** ADD WORLD ************
    
    public static Action addWorld() {
	return new AbstractAction("Add World", wi) {          public void actionPerformed(ActionEvent e) {
	    String name=JOptionPane.showInputDialog(null, "Enter name for new world ");
	    new world(name);
	    showpan.makepan(treeMaker.class, "["+name+"]", wi);
	    complexity.defaultcomplexity.changed=true; loop.go(); //complexity changed forces menus and trees to replot
	}  };
    }
    //************************ DISPOSE WORLD *******************
    public void dispose() {
	dispose(this);
	worldsob.obs.remove(this); root.obs.remove(this);
	worlds.remove(this);
	loop.go();
	complexity.defaultcomplexity.changed=true; loop.go(); //complexity changed forces menus and trees to replot
    }
    
//P3 FIX dispose world should only dispose non-static iobs!
//recursively clears all children interacobs from the register -beware infinite loops if not tree structure!
    void dispose(infob o) {
	if (o.obs!=null)  for (Object oo : o.obs) if (oo instanceof infob) dispose((infob)oo);
	if (o instanceof interacob) ((interacob)o).dispose();
//Modifier.isStatic(o.owner.getClass().getField(o.get).getModifiers());
    }
    
    //****************** MODULES ****************
    void setmodorder() {
	boolean changed=false;  int nit=0;
	do {  changed=false; nit++;
	for (module m : mods) for (module mf : m.follows) if (m.order<=mf.order) { m.order=mf.order+1; changed=true; }
	} while (changed && nit<=100);
	if (nit>100) System.err.println("Circular module dependencies! "); //stops infinite loop
	Collections.sort(mods);
	//String s="Module order: "; for (module m : mods) {s+=m+" ( F:  "; for (module mf : m.follows) s+=mf+", "; s+=") "; } System.out.println(s);
    }
    
    //***************** GET *****************
    //get module or world
    
    public world get(String name) { 	for (world w : worlds) if (w.name.equals(name)) return w; return null;   }
    
    public <T extends module> T  get(Class<T> c) { return  (T) modmap.get(c);    }
    
    //************** WORLD TREE ***********
    //worldtree copies root, but referring to specific module instances, creating as necessary
    
    public hasinfo worldtree(hasinfo orig) {
	
	if (orig.getObs()!=null) { //implies orig was a directory (package)
	    
	    infob copy=new infob(orig.getName(), (orig instanceof infob ? ((infob)orig).color : infob.rcol()) , ((infob)orig).priority);
	    copy.addDocAction();
	    copy.addTreeAction();
	    
	    for (Object o : orig.getObs())  {
		if (o instanceof hasinfo) {
		    hasinfo hh=worldtree((hasinfo)o);
		    if (hh!=null && (hh instanceof module || ( hh.getObs()!=null && hh.getObs().size()>0)))  copy.addOb(hh);
		    if (hh instanceof module) ((module)hh).color=copy.color;
		} else copy.addOb(o);
	    }
	    copy.mincomplexity();
	    
	    return copy;
	}
	
	//if orig was not a directory, it's a real object, continue here...
	String ss=getPath(orig);
	module mod;
	try {
	    mod= get( (Class<? extends module>) Class.forName(ss) );
	    if (mod!=null) return mod;
	} catch (ClassNotFoundException e) {   e.printStackTrace();   } //should never be thrown, while we search a JAR made of classes
	
	try {
	    Class c=getClass().getClassLoader().loadClass(ss);
	    if (module.class.isAssignableFrom(c)) {
		mod= (module)(c.newInstance());
		mod.world=this;
		mod.checkinfo();
		//mod.register(); moved AFTER  initsetup
		mods.add(mod);
		modmap.put(mod.getClass(), mod);
		return mod;
	    }
	} catch (Exception e) {  e.printStackTrace(); }
	return null; //new infob(ss);
    }
    
    
    //******************* PATH ***************
    public static String getPath(hasinfo th) {
	String ss=th.getName();
	// below no longer necessary, since the infob name now stores the dots
//	//hasinfo h=th; while (h.getOwner()!=root) { h=h.getOwner(); ss=h.getName()+"."+ss; }
	return ss;
    }
    
    //************* MAKE ROOT ************
    //called only at startup, to fill root by searching through jar for classes
    
    public static void makeroot() {
	Enumeration<JarEntry> jes=fileio.getJarEntries(world.class.getResource("/jcm/StartJCM.class"));
	
	while ( jes.hasMoreElements() )  {
	    JarEntry je=jes.nextElement();
	    String s= je.getName();
	    if (je.isDirectory()) { packages.add(s.replace("/", ".")); System.out.println("unapacking "+s); }
	    if (!je.isDirectory() && !(je.getName().contains("$")))  { // note $ implies inner class
		addtree(root, s);
	    }
	}
	worldsob.addAction(addWorld());
	worldsob.addTreeAction();
	worldsob.addDocAction();
	
	root.color=Color.black;
    }
    
    public static void addtree(hasinfo th, String s) {
	if (s.startsWith("png")) return;
	int i=s.indexOf("/");
	String s1, s2;
	if (i>0) {
	    s1=s.substring(0,i); s2=s.substring(i+1);
	    if (th.getObs()!=null) for (Object o : th.getObs()) {
		if (o instanceof hasinfo && ((hasinfo)o).getName().equals(s1)) {
		    addtree(((hasinfo)o), s1+"."+s2);  return; //CHANGE was just S2
		}
	    }
	    hasinfo hh= new infob(s1, th);
	    addtree(hh, s1+"."+s2); //CHANGE was just S2
	    if (hh.getObs()!=null) {  ((infob)th).addOb(hh); }
	    return;
	} //i>0
	
	((infob)th).addOb(new infob( s.replace(".class", ""), th));
    }
    
    
} //end class

