

package jcm.core;

import jcm.gui.doc.labman;

public class units {
    
    public String units;
    public double scales, scaleu;
    
    //***************************
    //CONSTRUCTOR
    public units(String s) { this(s, 1.0); }
    public units(String s, double d) { this(s, d, 1.0); }
    public units(String s, double a, double b) { units=s; scales=a; scaleu=b; }
    
    //***************************
    static String[] qs={	"femto", "pico", "nano", "micro", "milli", "###", "kilo", "mega", "giga", "tera", "peta", "exa", "kiloexa"};
    static int[] 	qi= {	-15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21};
    
    
    
    public void checkunitfac(double range) {
//        System.err.println(units+" "+scales +" "+scaleu+" in");
        
        scales=Math.pow(10.0, Math.floor(
                (Math.log(range)/Math.log(10.0)) -0.3
                ) );
        //changes mega to giga and divide by 1000 etc.
        if (units!="") {
            int oou=5, fac=5, nu;
            for (int i=0; i<qs.length; i++) if (units.startsWith(qs[i])) oou=i;
            int ou=oou-(int)(Math.log(scaleu)/Math.log(1000.0));
            for (int i=0; i<qi.length; i++) if (scales>=Math.pow(10.0, qi[i])) fac=i;
            
            scaleu=Math.pow(10.0,qi[fac]);
            nu=ou+fac-5;
            units=(nu==5 ? "" : qs[nu])+units.substring(oou==5 ? 0 : qs[oou].length());
//            System.err.println(units+" "+scales+" "+scaleu+" "+ou);
        }
    }
    
    //cancels megaton per megaperson, or ton/yr per dollar/yr , for example
    //assumes dividing two quantities with multipliers on denominators
    public void checkunitcancel() {
        int i,j,k,p,q,pp, qq, r;
        //cancel yr/yr
        i=units.indexOf("&per&yr"); if (i>0) {	j=units.indexOf("&per&yr", i+1); if (j>0) {
            units=units.substring(0,i)+units.substring(i+5,j)+units.substring(j+5);
        }}
        
        p=units.length(); pp=-1; for (j=0; j<qs.length; j++) {	k=units.indexOf(qs[j]); if (k>-1 && k<p) {	p=k; pp=j; }}
        if (p<units.length()) {
            q=-1; qq=-1; for (j=0; j<qs.length; j++) {	k=units.indexOf(qs[j], p+1); if (k>q) {	q=k; qq=j; }}
            if (q>-1) {
                r=5+ pp-qq;
                if (r>-1 && r<qs.length) {
                    String newfac=qs[r]+"&"; if (newfac.equals("###&")) newfac="";
                    units=units.substring(0,p)+newfac+units.substring(p+qs[pp].length()+1,q)+units.substring(q+qs[qq].length()+1);
                }}}
        
    } //checkunits
    
    //**********************
    //INFO  
    
    public String round(double v) { return round(v, scaleu, 1); }
    public String round(double v, int dp) { return round(v, scaleu, dp); }
    public double unround(double v) { return v*scaleu; }
    
    public static String round(double v, double u, int dp) {
        int d=(int)Math.pow(10, dp);
        if ((double)((int)(v/u))==(v/u)) return String.valueOf((int)(v/u));
        else return String.valueOf((double)((int)((v>=0 ? 1.0 : -1.0)* 0.0000001+d*v/u))/d);
    }
    
    public double minstep(double min) { return  scales*(int)(0.8+(min / scales)); }
    
}
