/*
PERSISTENCE OF JCM SETUP (BOTH PARAMETERS AND WINDOWS)

 SETUP / PERSISTENCE
swap size/loc order (intuitive wrt rectangle) 
P3  Use multiple arg plot setup to save  scales  etc.
P3 IDEA Save snapshots for global dialogue - add a simple html editor to include messages with the setup
P2 FIX Persistence - saving setup within java webstart sandbox -using jnlp methods
P2 eventually for demo setup, all size/loc could be scaled by screen size (compared to previous screensize)?
P2 CHECK Setup with multiple worlds, do they go in worlds menu?
P1 ?? CHECK persistence <=>interactions/interacmap
P1 persistence of loc of internalframes (add another loc to components in jdp)
P1 persistence of frames outside mainframe (ditto)
P1 IDEA Alternative to setup use use serialization to save a world (also gui components)? Note also "Hibernate"
 
 */

package jcm.core;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.showpan;
import jcm.tls.fileio;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.*;
import java.lang.ref.WeakReference;
import jcm.gui.doc.labman;

public class setup {
    
    //******************************************************
    
    public static void fillMenu(JMenu setupm) {
	JMenu stan=new JMenu("Standard Setups");
	for (Object o : ((infob)world.root.find("defsetup")).getObs() ) {
	    final String s=o.toString().substring(9); //remove defsetup.
	    stan.add(new AbstractAction(s)  {	public void actionPerformed(ActionEvent e) {loadsetup(fileio.loadtab("defsetup/"+s, "\t")); }} );
	}
	setupm.add(stan);
	setupm.add(new AbstractAction("Load Setup") {	public void actionPerformed(ActionEvent e) {	loadsetupdialog();  }});
	setupm.add(new AbstractAction("Save Setup") {	public void actionPerformed(ActionEvent e) {	savesetupdialog();  }});
	setupm.add(new AbstractAction(labman.getShort("Reset Parameters")) {	public void actionPerformed(ActionEvent e) {	register.resetall(); loop.go(true); }});
    }
    
    
    //******************************************************
    //LOAD :
    
    public static boolean  loadsetupdefault() {
	return loadsetup(new File(savedir+File.separator+current)) ? true :  loadsetup(fileio.loadtab("defsetup/default.txt", "\t"));
    }
    
    //note won't work in java-webstart sandbox!
    public static boolean  loadsetupdialog() { return loadsetup(fileio.getFileFromDialog(showpan.mf, savedir, current, "Load Setup", "load" )); }
    
    public static boolean  loadsetup(File file) {
	try {
	    return loadsetup(fileio.loadtab(file, "\t"));
	} catch (Exception e) { System.err.println("cannot find file "+file); return false; }
    }
    
    public static boolean  loadsetup( String[][] list) {
	
	if (list.length==0) return false;
	System.err.println("setup start");
	//close open windows
	try {
	    for ( WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get()!=null) showpan.dispose(wrc.get());
	} catch (Exception ex) { System.err.println("setup dispose error "+ex); }
	
	//reset params and run loop (in case any affect window layout etc.)
	register.resetall(); loop.go();
	
	for (final String[] s: list) {
	    if (SwingUtilities.isEventDispatchThread() ) setup(s);
	    else try {
		SwingUtilities.invokeAndWait(new Runnable() { public void run() { setup(s);}});
	    } catch (Exception ex) { String a=""; for (String ss : s) a+=ss; System.err.println("setup error "+a +" "+ex);  }
	}
	
	try {
	    loop.go();
	} catch (Exception ex) { System.err.println("setup loop go error "+ex); }
	return true;
    }
    
    
    static void setup(final String[] s) {
	
	interacob i; param p;
	String all="setup: "; for (String ss : s) all+="\t"+ss; System.err.println(all);
	
	try {
	    
	    if (s[0].equals("worlds")) for (int j=1; j<s.length;j++) {
		boolean newworld=true; for (world w : world.worlds) if (s[j].equals(w.getName())) newworld=false; //avoid creating duplicates
		if (newworld)  new world(s[j]);
	    }
	    
	    if (s[0].equals("param") && (i=register.findiobfullname(s[1]) )!=null) {
		((param)i).load(s[2]);
		System.err.println(s[1]+" set to "+s[2]);
		showpan.mf.validate();
	    }
	    
	    if (s[0].equals("split")) unsplit(s, 1, (JSplitPane) showpan.mf.getContentPane());
	    
	    if (s[0].equals("window")) {
		Point loc= new Point(Integer.parseInt(s[4]), Integer.parseInt(s[5])); Dimension siz=new Dimension(Integer.parseInt(s[2]), Integer.parseInt(s[3]));
		if (s[1].equals("Main"))  setsizeloc(showpan.mf, siz, loc);
		else try {
		    int nargs=s.length-6;
		    Object args;
		    if (nargs>1) {
			Object[] args2=new Object[nargs];
			for (int a=0; a<nargs; a++)  args2[a]=findob(s[6+a]);
			args=args2;
		    } else args=findob(s[6]);
		    
		    loc=new Point(loc.x-showpan.mf.getX(), loc.y-showpan.mf.getY());
		    JComponent co=showpan.findContainer(loc);
		    JComponent c =showpan.makepan((Class<JComponent>)Class.forName(s[1]), args, co);
		    c.setPreferredSize(siz);
		} catch (ClassNotFoundException e ) { System.err.println("setup window error"+ e); }
	    } //window
	} catch (Exception e) { System.err.println("setup  setup error " +e); }
    }
    
    static Object findob(String s) {
	Object o=register.findiobfullname(s);
	return o!=null ? o : s.equals("null") ? null : s;
    }
    
//******************************************************
//SAVE: note won't work in java-web-start sandbox
    
    static String savedir="setup", current="current.txt";
    
    public static void savesetupdialog() { savesetup(fileio.getFileFromDialog(showpan.mf, savedir, current, "Save Setup", "save" )); }
    public static void savesetupdefault() {
	
	//if doesn't exist, make setup directory and copy over defaults from jar
	if (!new File(savedir).isDirectory()) {
	    new File(savedir).mkdir();
	    
	}
	savesetup(new File(savedir+File.separator+current));
    }
    
    public static void savesetup(File file) {
	
	String list="";
	list+="worlds"; for (world w : world.worlds) list+="\t"+w.getName(); list+="\n";
	for (interacob i : register.alliobs) if (i instanceof param && !((param)i).isdefault()  ) list+="param\t"+((param)i).save();
	
	list+="window\tMain"+sizeloc(showpan.mf)+"\n";
	
	list+=recordSplit((JSplitPane) showpan.mf.getContentPane())+"\n";
	
	for ( WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get()!=null && wrc.get().getParent()!=null) {
	    //isShowing() || )  { //otherwise lose hidden tabs
	    
	    JComponent c=wrc.get();
	    // if (!c.isShowing()) showpan.toFront(c);
	    
	    list+="window\t"+c.getClass().getName();
	    list+=sizeloc( c) ;
	    
	    for (Object o : register.winmap.get(wrc)) {
		if (o instanceof WeakReference) o=((WeakReference)o).get();
		if (o instanceof Object[]) for (Object oo : (Object[])o) list+="\t"+getname(oo);
		else list+="\t"+getname(o);
	    }
	    list+="\n";
	}
	fileio.savetextfile(file, list);
    }
    
    //****************************************************
    static String getname(Object o) { return o==null ? "null" : (o instanceof infob) ? ((infob)o).getFullName() : o.toString(); }
    
    static String sizeloc(Component c) {
	Dimension d=c.getSize();
	Point p =	(c.isShowing())  ? c.getLocationOnScreen() :
	    c.getParent()==null ? new Point(0,0) :
		new Point(c.getLocation().x+c.getParent().getLocationOnScreen().x, c.getLocation().y+c.getParent().getLocationOnScreen().y);
	if (p.x<0) p.x=0; if (p.y<0) p.y=0;
	return "\t"+d.width+"\t"+d.height+"\t"+p.x+"\t"+p.y;
    }
    //    public static Component getsizecomp(JComponent c) {
//	return (c instanceof treemaker) ? c : c.getRootPane().getParent();
//    }
    
    
    //************* SIZELOC ******************
//SIZELOC called from setup
    
    //also called from calcscript
    public static void setsizeloc(JComponent c,  Dimension d, Point p) {
	JTabbedPane jtp=showpan.findTabbedPane(c);
	if (jtp!=null)  {
	    c.setPreferredSize(d);
//	    jsp.setDividerLocation(-1);
	    jtp.getParent().validate();
	} else setsizeloc(c.getRootPane().getParent(), d, p );
    }
    
    
    public static void setsizeloc(Container c,  Dimension d, Point p) {
	c.setLocation(p);
	c.setSize(d);
	showpan.mf.validate();
	Thread.currentThread().yield();
    }
    
    
    //**************************** SPLIT ****************
    static String recordSplit(JSplitPane jsp) {
	String s="split\t"+jsp.getOrientation()+"\t"+jsp.getDividerLocation();
	Component c=jsp.getTopComponent();
	s+=  "\t"+ ((c instanceof JSplitPane) ?recordSplit( (JSplitPane)c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
	c=jsp.getBottomComponent();
	s+=   "\t"+((c instanceof JSplitPane) ?recordSplit( (JSplitPane)c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
	return s;
    }
    
    static int unsplit(String[] s, int i, JSplitPane jsp) {
	jsp.setOrientation(Integer.parseInt(s[i]));  jsp.setDividerLocation(Integer.parseInt(s[i+1]));
	i+=2;
	if (s[i].equals("split")) { JSplitPane jsp2=new JSplitPane(); jsp2.setResizeWeight(0.5); jsp.setTopComponent(jsp2); i=unsplit(s, i+1, jsp2); } else  {  jsp.setTopComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp()); i++; }
	if (s[i].equals("split")) { JSplitPane jsp2=new JSplitPane(); jsp2.setResizeWeight(0.5);  jsp.setBottomComponent(jsp2); i=unsplit(s, i+1, jsp2); } else  {  jsp.setBottomComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp()); i++; }
	return i;
    }
    
    
    
    /*
	     try {
	    ObjectOutputStream oos=new ObjectOutputStream(new FileOutputStream(file));
	    oos.writeObject(c); oos.close();
	    } catch (IOException e) { e.printStackTrace(); }
     */
    
    
    
} //end class
