 /*
 set of QTs with common units, from which a plot or table may be created
  
P1 STRUC qtset could be simplified by extending map if iob replaced by interfaces? but have to add a lot
P1 ENH ?? Qtset could also add getsmall - a small box with these options, + doclink? - put it in tree, circmenu, and modview
P2 STRUC PLAN Multi-dimensional qtset to handle combinations of region, sector, biome, gas, scenario etc. Start with multidimensional map-key Object?
P1 STRUC consider distinguish qtsets created only for output on demand, with those needed for input to other modules
  
 P2 STRUC Consider construction of  forking (pointing) qtset:
source qtsets, dates (is branch always fsy?), conditions (a param?)
 P2 STRUC Calc on demand: relationship between qt and qtset could be simpler, especially when the key set (region-set) changes
 Note also duplication here with derivate methods, constructor and reg method, however for plots we still need to fill in the current set of regions
  
OK P3 CHECK interactions of ratio qtsets in plot -seems OK now but occasionally fails
OK P3 sum and difference calc-on-demand qt / qtset types and generators for use in shares module etc.
OK P2 CHECK /FIX Qtsets with Object lists keep growing - old keys never removed ?  especially a problem in plots, after change Objectset, also potential memory leak - this was fixed using regqtset in socreg (rather clumsy code)
OK P3 Problem with emit abate getmin() - because creating regions in derived qtset before in source
  
  */

package jcm.core;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import jcm.gui.doc.autodoc;

import jcm.gui.nav.showpan;
import jcm.gui.plot.*;
import jcm.gui.doc.labman;
import static  jcm.gui.gen.colfont.*;
import jcm.gui.nav.menuFiller;

public class qtset extends interacob implements time, plotlink,  menuFiller {
    
    public Map<Object, qt> map=new LinkedHashMap();
    public qt  total=null;
    public qt current=null;
    public int sy=gsy, ey=gey, xstep=1; //duplicating qt!
    public String units="";
    boolean setcomplexity=false, setcolor=false;
    public qt.Type type=qt.Type.normal;
    public qtset qqa, qqb; //similar use as qa and qb in qt
    //public Object Objectset;
    
    //********************
    //constructor
    public qtset(Object ...args) {
	
	int sc=0, ic=0;
	color=null;
	for (Object o : args) {
	    
	    if (o instanceof qtset) {
		if (qqa==null) {
		    qqa=(qtset)o;
		    color=qqa.color; name=qqa.name; units=qqa.units;
		    sy=qqa.sy; ey=qqa.ey; xstep=qqa.xstep;
		} else qqb=(qtset)o;
		setaffectedby((qtset)o);
	    }
	    if (o instanceof Color) { color=(Color)o; }
	    if (o instanceof interacob) { owner=(interacob) o; setaffectedby((interacob) o); name=owner.name;    }
	    if (o instanceof complexity) { mycomplexity=(complexity)o; setcomplexity=true; }
	    if (o instanceof qt.Type) type=(qt.Type)o;
	    
	    if (o instanceof qt[]) for (qt q : (qt[])o) add(q);
	    if (o instanceof qt) add((qt)o);
	    if (o instanceof String) {
		switch (sc) {
		    case 0: name=(String)o; break;
		    case 1: units=(String)o; break;
		}
		sc++;
	    }
	    if (o instanceof Number) { //duplicating qt!
		int i=((Number) o).intValue();
		switch (ic) {
		    case 0: sy=i; break;
		    case 1: ey=i; break;
		    case 2: xstep=i; break;
		}
		ic++;
	    }
	} //o
	
	
	if (!setcomplexity && map.size()>0) mincomplexity(map.values());
	if (color==null) color= rcol(owner.color);
	
	addAction(showpan.pan("Plot", lineplot.class, this));
	addAction(showpan.pan("Plot %change/yr", lineplot.class, new Object[]{this, "rate"}));
	addAction(showpan.pan("Table", datable.class, this));
	addDocAction();
    }
    
    public Object find(String name) { //used by autodoc
	Object o=super.find(name); if (o!=null) return o;
	for (Object oo : map.keySet()) if (oo.toString().equals(name)) return map.get(oo);
	return null;
    }
    
    
    
//**********************ADD**************************
    public void add(Object o, qt q) {
	map.put(o, q);
	if (o==jcm.mod.reg.regman.world && q.type==qt.Type.normal) q.type=qt.Type.total;
	if (total==null && q.type==qt.Type.total) total=q; //note total is set to the first qt of type=total
	if (!setcomplexity) mincomplexity(map.values());
	q.owner=this;
    }
    
    public void add(qt ... qq) { for (qt q : qq) add(q.name, q);  }
//public void addextra(qt q, String s) { map.put(s, q); setaffectedby((interacob)q.owner); }
    
//********************GET SET ***************
    
    public qt reg(Object r)  {
	if (map.containsKey(r)) return map.get(r);
	
	qt q=null;
	switch (type) {
	    case difference :    case sum :  case ratio : q =new qt(qqa.map.get(r), qqb.map.get(r), type ); break;
	    //System.err.println("creating qt for "+r+" in "+name+" "+qqa.map.get(r) );
	    case rate : ; //not yet used!
	    default :
		if (r instanceof hasinfo) { hasinfo ri=(hasinfo)r; q =new qt(ri.getName(), ri.getColor(), sy, ey, xstep, this);   } else q =new qt(r.toString(), Color.black, sy, ey, xstep, this);
	}
	add(r, q); return q;
    }
//be careful: get can add a new region to map when not intended => mystery errors, should throw exception!
    
    public float get(Object r, int year) { return reg(r).get(year); }
    public float get(Object r) {return reg(r).get();}
    public float get(int year) {return current.get(year);}
    public float get() {return current.get();}
    
    public void set(Object r, int year, float f) { reg(r).set(year, f); }
    public void set(int year, float f) { current.set(year, f); }
    public void set(Object r,  float f) { reg(r).set( f); }
    public void set(float f) { current.set(f); }
    public void setreg(Object r) { current=reg(r); }
    
//****************************
//SCALE, MINMAX, TOTAL
    
    public String getunits() {	return units; }
    public param getxscale() {
	return new param(param.Type.Xscale,  "Xscale", "year", 0, Math.max(sy,1800), Math.min(ey,2200), 50);
    }
    public param getyscale() { 	return new  param(param.Type.Yscale,  "Yscale", units,  0, getmin(), getmax(), 1); }
    
    float getmax() {	float max=Float.MIN_VALUE; for (qt q : map.values()) if (q.checkcomplexity()) max=Math.max(max, q.getmax()); return max; }
    float getmin() { float min=Float.MAX_VALUE; for (qt q : map.values()) if (q.checkcomplexity()) min=Math.min(min, q.getmin()); return min; }
    
    public float getmax(boolean stacked) { //used by lineplot for scaling stacked plot: note this may be rather slow!
	if (!stacked) return getmax();
	float max=Float.MIN_VALUE; for (int year=sy; year<ey; year+=xstep) {
	    float tot=0; for (qt q : mapwithouttotal().values()) tot+=q.get(year); if (tot>max) max=tot;
	}
	return max;
    }
    
//note - used by futurebasescen
    public float calctot() { return calctot(module.year); }
    public float calctot(int year) {
	if (total==null) total=reg(jcm.mod.reg.regman.world);
	total.set(year, 0); for (qt q : mapwithouttotal().values()) total.set(year, total.get(year)+q.get(year));
	return total.get(year);
    }
    
    public Map<Object, qt> mapwithouttotal() {
	Map<Object, qt>  m=new LinkedHashMap();
	//note some qtsets eg aerosol have more than one total
	for (Map.Entry<Object, qt> me : map.entrySet()) if (me.getValue().type!=qt.Type.total) m.put(me.getKey(), me.getValue());
	return m;
    }
    
    
//*****************************
//DERIVATIVE QTSETS
    
    
    public qtset combinewith(qtset other, qt.Type type, String name, String units) {
	qtset cw=new qtset(this, other, type, name, units);
	for (Object k : map.keySet()) if (other.map.containsKey(k))  cw.add(k, new qt(map.get(k), other.map.get(k), type ) );
	cw.setaffectedby(this); cw.setaffectedby(other);
	cw.register();
	return cw;
    }
    
    public qtset divby(qtset other) { return combinewith(other, qt.Type.ratio, name+"&per&"+other.name, units+"&per&"+other.units);   }
    public qtset addto(qtset other) { return combinewith(other, qt.Type.sum, name+"&plus&"+other.name, units);   }
    public qtset subtract(qtset other) { return combinewith(other, qt.Type.difference, name+"&minus&"+other.name, units);   }
    
    public qtset differentiate() {
	qtset dydx = new qtset(name+"&rate", units+"&percent&per&year");
	for (Object k : map.keySet()) dydx.add(k, new qt(map.get(k), qt.Type.rate  ) );
	dydx.setaffectedby(this);
	dydx.register();
	dydx.type=qt.Type.rate;
	return dydx;
    }
    
//** AUTO-DOC *********************************
    
    public String getExtraDoc() {
	return docUnits()+docCurves()+"----"+docInteracs()+autodoc.javacode(this);
    }
    
    
    public String docUnits() {
	String s="==Units==";
	s+="units: "+labman.getTitle(units)+"<br>";
	s+="timescale (years) "+sy+"-"+ey +" (step "+xstep+")<br>";
	return s;
    }
    
    public String docCurves() {
	String s="==Curves==";
	if (type!=type.normal && type!=type.total) s+=labman.getTitle(type+"&of&")+qqa.docSummary()+"<br>";
	else if (map.size()==0) s+="nocurvesyet";
	//s+=type+"<br>"; for non-normal type should link to qtset qqa and qqb instead?
	s+="<ul>"; for (qt q : map.values()) s+="<li>"+q.docSummary(); s+="</ul>";
	return s;
    }
    
    
//************************** MENUS FOR DERIVED PLOTS **********************
      /*
     OK P2 STRUC move divbymenu etc. into qtset
     P2 ENH lineplot divbymenu  should also check complexity,
     P1 FIX ?? integrate methods of addcurve inc show world
     P2 CHECK making new qtset within divbymenu menu could cause a problem with garbage collection of qtsets in disposed worlds?
       */
    //************************* MENUS ****************
    
    public void fillMenu(JPopupMenu pop) {
	pop.addSeparator();
	super.fillMenu(pop); //actions, if appropriate
	pop.addSeparator();
	if (potdivby==null) { potdivby=new HashMap();  findpotdivby(); }
	if (potdivby.size()>0) {
	    pop.add(divbymenu(lineplot.class));
	    pop.add(divbymenu(histoplot.class));
	    pop.add(divbymenu(scatterplot.class));
	}
	pop.add(refresh);
	pop.addSeparator();
	if (world.worlds.size()>1) pop.add(compareworldmenu());
	pop.addSeparator();
	pop.add(datable.savetablemenu(this));
    }
    
//for temporary plotlink to self, to force calc, is this the best way?
    public boolean isShowing() { return true; }
    public void doplot() {}
    public void forcecalc() { if (changed) {  register.addlink(this, this); loop.go(); register.removelink(this, this); } }
    
    Action refresh=new AbstractAction("Refresh Options") {  public void actionPerformed(ActionEvent e) { forcecalc(); findpotdivby();  }};
    Map<module, Set<qtset>> potdivby ;
    
    void findpotdivby() {
	potdivby.clear();
	for (world w : world.worlds)  for (final module m : w.mods) {
	    Set<qtset> fit=new HashSet();
	    for (final qtset qqd : m.qtsets)  if (!qqd.equals(qtset.this)) {
		checkoverlap : for (Object o : qqd.map.keySet()) if (map.containsKey(o)) { fit.add(qqd);  break checkoverlap; }
	    }
	    if (fit.size()>0) potdivby.put(m,fit);
	}
    }
    
    JMenu divbymenu(final Class type) {
	JMenu dbm=new JMenu();
	dbm.setText(type.getSimpleName() + " per... ");
	for (module m : potdivby.keySet()) {
	    JMenu submenu=new JMenu(m.getLongTitle());
	    //note: lineplot constructor will call differentiate to make a new qtset (avoid making this just for display menu)
	    for (qtset qqd : potdivby.get(m)) submenu.add( showpan.pan(qqd.getLabel(), type, new Object[]{qtset.this, "ratio", qqd} ) );
	    if (submenu.getMenuComponentCount()==1)  dbm.add(submenu.getMenuComponent(0)); else dbm.add(submenu);
	}
	return dbm;
    }
    
    
    public JMenu compareworldmenu() {
	JMenu cwm=new JMenu(" Compare Worlds... ");
	qtset wq=new qtset(name);
	for (final qt q : map.values())   cwm.add(new AbstractAction(q.name) {
	    public void actionPerformed(ActionEvent e) {  compareworld(q); }
	});
	return cwm;
    }
    
    void compareworld(qt q) {
	System.err.println(q.name);
	qtset cwq=new qtset(q.name, units);
	cwq.register();
	for (world w : world.worlds)  for (module m :w.mods)  for (qtset mq : m.qtsets)  if (mq.name.equals(name))  {
	    cwq.add(w.name, new qt(mq.map.get(q.name).a, w.name, w.color));
	    cwq.setaffectedby(m);
	}
	showpan.makepan(lineplot.class, cwq);
    }
    
    
    
    
} //end class

/* no longer used
	    if (o instanceof Object) Objectset=(Object)o;
	    if (o instanceof float[][]) {
		System.out.println("\nusing float[][] constructor of qtset\n");
		try {
		    int nr=0; for (float[] f : ((float[][]) o)) {  map.put(Objectset.reg.get(nr), new qt(f) ); nr++; }
		} catch (NullPointerException e) { System.out.println("Objectal qt - Objectset null!"); }
	    }
 */

  /*
    public JMenu addcurvemenu(final qtset qq) {
	JMenu addcurve=new JMenu(" Add Curve... ");
	for (world w : world.worlds) {
	    for (final module m :w.mods)  {
		JMenu submenu=new JMenu(m.getfullname());
		for (final qtset qqd : m.qtsets)  if (!qqd.equals( qq) && qq.units.equals(qqd.units)) {
		    JMenu submenu2=new JMenu(qq.getName());
		    for (final qt q : qqd.map.values()) {
			final String name=(m.world!=qq.getworld() ? m.world.name : "")+"&"+q.name;
			submenu2.add(new AbstractAction(name) {
			    public void actionPerformed(ActionEvent e) {
				qq.addextra(q, name); loop.go(); doplot();
			    }
			});
		    }
		    submenu.add(submenu2);
		}
		if (submenu.getMenuComponentCount()>1) addcurve.add(submenu);
		if (submenu.getMenuComponentCount()==1)  addcurve.add(submenu.getMenuComponent(0));
	    }
	}
	return addcurve;
    }
   */

