

 /*
   qt= quantity timeseries
 see also qtset, module
  
  About qt types:
  A normal-type qt just stores data in an array.
  Type total also stores data, but is excluded from "map without total" used for some calcs and stacked plots, also can auto-calc total if needed
  Difference, sum, ratio or rate qts store only references to other qts (qa and qb) and calculate on demand (see get method)
  This can save memory and makes code simpler but increases calculation work if repeated often,
  (therefore better to use for occasional end-of-pipe (eg plots) rather than for inner-loop qts)
  Note: poss alternative to calc-on-demand could be for qtset to implement interacob/module calc methods
  */

/*
 
    P2 STRUC make qt get more efficient as  called very frequently
    P1 STRUC also not always efficient to recalc ratios or rates rather than store it,  e.g. if a graph resizes the underlying data doesn't change
 
    P1 IDEA "Enabled" flag for qts- will depend on regions parameters (need to call method), and maybe user choice (selecting curves)...(see also param)
    P1 STRUC extend QT to generic type for supporting ints/shorts instead of float?
    P1 STRUC "total" qt could be a calc-on-demand type like the ratio and difference (although in some cases more efficient to keep the data)
 
 */

package jcm.core;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.tls.*;
import jcm.mod.reg.region;
import java.awt.Color;
import java.util.*;


public class qt extends infob implements time {
    
    //*****************************
    //FIELDS
    
    public float[] a; //main array to store data
    
    public int sy=gsy, ey=gey, xstep=1; //start and end years, x-step (could replace with an x-scale?)
    public static float dud=-999; //flag for no valid data
    
    
    public enum Type {normal, difference, sum, rate, ratio, total }
    public Type type=Type.normal;
    qt qa, qb;
    
    
    
    //*****************************
    //CONSTRUCTOR
    public qt(Object ...args) {
	int  ic=0;
	mycomplexity=complexity.normal;
	boolean clone=false;
	
	argloop: for (Object o : args) {
	    if (o instanceof qt) {
		if (qa==null) {
		    qa=(qt)o;
		    color=qa.color; name=qa.name;
		    sy=qa.sy; ey=qa.ey; xstep=qa.xstep;
		} else qb=(qt)o;
		continue argloop;
	    }
	    if (o instanceof Boolean) { clone=(Boolean) o; }
	    if (o instanceof interacob) { owner=(interacob) o; }
	    if (o instanceof float[]) {	a=(float[])o; }
	    if (o instanceof Color) {	color=(Color) o; }
	    if (o instanceof complexity) { mycomplexity=(complexity) o; }
	    if (o instanceof String) { name=(String)o; }
	    
	    if (o instanceof Number) {
		int i=((Number) o).intValue();
		switch (ic) {
		    case 0: sy=i; break;
		    case 1: ey=i; break;
		    case 2: xstep=i; break;
		}
		ic++;
	    }
	    if (o instanceof Type) type=(Type)o;
	} //args
	
	if (a==null && (type==Type.normal || type==Type.total)) a=new float[1+(ey-sy)/xstep];
	if (clone) {
	    if ((type==Type.normal || type==Type.total) && qa.xstep==xstep) System.arraycopy(qa.a, (sy-qa.sy)/xstep, a, 0, a.length);
	    else for (int y=sy; y<=ey; y+=xstep) set(y, qa.get(y));
	}
    }
    
    //*****************************
    public qt clone(Object ... args) {
	Object[] args2=new Object[args.length+2]; args2[0]=true; args2[1]=this; System.arraycopy(args,0,args2,2,args.length);
	
	return new qt(args2);
//        return new qt(true, this, args);
    }
    //this copies the qt, and it's data. Resulting type is always normal, links to qa,qb or owner are not copied, thus it is independent of the original.
    
    
    //*****************************
    
    
    public String curveinfo() {
	return "<li>"+autodoc.hexcolor(color)+labman.getShort(name)+(labman.getTitle(name) !=labman.getShort(name) ? " "+labman.getTitle(name) : "")+"}- %% >>"+name+" %%";
    }
    
    //GET, SET
    
    public float get(int year) {
	switch (type) {
	    case difference :  { return (qa.get(year)!=dud && qb.get(year)!=dud  ) ?  qa.get(year) - qb.get(year) : dud; }
	    case sum :  { return (qa.get(year)!=dud && qb.get(year)!=dud  ) ?  qa.get(year) + qb.get(year) : dud; }
	    case ratio : { return (qa.get(year)!=dud && qb.get(year)!=dud && qb.get(year)!=0 ) ?  qa.get(year)/qb.get(year) : dud; }
	    case rate :  { return (qa.get(year)!=dud && qa.get(year-xstep)!=dud && qa.get(year-xstep)!=0 ) ?  (100f*qa.get(year)/qa.get(year-xstep) -100f)/xstep  : dud; }
	    default : if (year>=sy && year <=ey)  return a[(year-sy)/xstep];   else return dud;
	}
    }
    public float get() {return get(module.year); }
    
    public void set(int year, float f) { if (year>=sy && year <=ey) 	a[(year-sy)/xstep]=f; }
    public void set(float f) { set(module.year, f); }
    
    public boolean gotdata(int year) {	return year>=sy && year<=ey && get(year)!=dud && !Float.isNaN(get(year)) && !Float.isInfinite( get(year)); }
    
    public int getyear(int n) {	return sy+xstep*n; }
    public int getn(int year) {	return (year-sy)/xstep; }
    
    public float[] geta() {	return a; }
    
    float getmax() {
	float max=Float.MIN_VALUE;
	for (int y=sy; y<ey; y+=xstep) if ( get(y)>max  && get(y)!=dud) max=get(y);
	return max;
    }
    
    float getmin() {
	float min=Float.MAX_VALUE;
	for (int y=sy; y<ey; y+=xstep) if ( get(y)<min  && get(y)!=dud) min=get(y);
	return min;
    }
    
    public int getlength() { return type==Type.normal  || type==Type.total?  a.length : qa.a.length ;    }
    
    //****************** AUTO DOC************
    
    public String getLabel(){  return labman.getTitle(name); } //note for qt switched from short form (very short, for legend) to medium form
    
    public String docSummary() { return  hashcolor()+ autodoc.link(name, getTitle()+labman.getShortIfDifferent(name))+  "</font> " + "%"+name+"<br>"; }
    //" <br>%%"+ getIcon()+ labman.getDoc(name)+"%%<br>"; } //problem is that doesn't stop further parsing
    public String getExtraDoc() { return  docOwner()+autodoc.javacode(owner) ;     }
    
} //end class






