 /*
Class param holds user-adjustable parameters
  
P2 STRUC List params should have different complexity level for each item
  
  
P2 IDEA: could check if params have same units as curve to suggest control on plot
  
P1 STRUC maybe should split param into subclasses,
P1 TIDY param removing old doc/info/script methods not used or duplicated!
  
P1 STRUC simplify view by generify getComponent (the args could be a type parameter?)
     ?? getSmall should include Doc/Code -Icon, and expand, and tear-off?
     ?? See old parammenu - used to have popup to doc, and tooltip getinfo() which changed
     ??  would prefer a general component that implements plotlink and the addnotify etc.,, but then can't be also a JMenuItem etc.
  */



package jcm.core;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.paramMenu;
import jcm.gui.nav.paramOption;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.nav.treeMaker;
import jcm.tls.*;
import jcm.gui.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import jcm.script.calcscript;


public class param<T> extends interacob {
    
    //*****************************
    //VARIABLES
    
    public enum Type {	menu, option, value, Xscale, Yscale, trigger}
    public Type type;
    
    //specific to types of param
    public T[] menulist; public T chosen, defchosen;   public int numitems; public Class listtype;
    public boolean flag, defflag; //for options
    public double val, defval, max, min; public int dp=2;
    
    public units units;
    
    public param pair; public boolean pairof=false; //for values
    public static boolean reportchange=true;
    
    
    //***************************
    //CONSTRUCTORS
    
    
    public param(Object ... args) {
	int dc=0, sc=0; //counters
	mycomplexity=complexity.normal;
	priority=1.1; //to put params above qtets in tree
	argloop: for (Object a : args) {
	    
	    // for a menu param, first array argument sets the list, next argument instance of (original) array-type becomes the default choice
	    
	    if (a instanceof Object[]) {
		type=type.menu;
		listtype=a.getClass().getComponentType();
		menulist=(T[]) a; //note objects are same, not copies, but arraytype is simple Object
		numitems=menulist.length;
		continue argloop;
	    }
	    if (menulist!=null && chosen==null && listtype.isInstance(a))  {
		chosen=(T)a; defchosen=(T)a;
		//System.out.println(name+" ("+listtype.getSimpleName()+")  def="+a.toString());
		continue argloop;
	    }
	    
	    if (a instanceof Type) { this.type=(Type)a; }
	    if (a instanceof Color) {	this.color=(Color) a; }
	    if (a instanceof Boolean) {	this.flag=(Boolean) a; defflag=flag; type=type.option; }
	    if (a instanceof complexity) { mycomplexity=(complexity)a;  }
	    if (a instanceof param)	{	((param) a).pair= this; this.pairof=true; }
	    
	    if (a instanceof Number) {
		if (type==null) type=type.value;
		double d=((Number) a).doubleValue();
		if (dc==0) {	val=d; defval=val; min=Double.MAX_VALUE; max=Double.MAX_VALUE; }
		if (dc==1) min=d;
		if (dc==2) max=d;
		if (dc==3) units.scales=d;
		if (dc==4) units.scaleu=d;
		dc++;
	    }
	    
	    if (a instanceof String) {
		String s=a.toString();
		if (sc==0) name=s;
		//if (sc==0) {	String[] ss=txt.split(s,"&"); name=ss[0]; if (ss.length>1) name2= "&"+ss[1]; }
		if (sc>=1)   units=new units(s);
		sc++;
	    }
	}
	if (units !=null) {
	    units.checkunitcancel();
	    units.checkunitfac(max-min);
	}
	register();
	
	addDocAction();
//output=true; //temporary experiment - not good - if only one param affected by a module (eg costs) then triggers all needed
    }
    
    //**************************
    //CHANGE
    
    public boolean isdefault() {
	if (type==type.menu) return chosen==defchosen;
	if (type==type.option) return flag==defflag;
	if (type==type.value) return val==defval;
	return true;
    }
    
    public String save() {
	return getFullName()+"\t"+ ((type==type.menu) ? getchosenindex()+"\t"+chosen :  (type==type.option) ? flag : (type==type.value) ? val : "")+"\n";
    }
    
    public void load(String s) {
	if (type==type.menu) choose(Integer.parseInt(s));
	if (type==type.option) flag= s.equals("true");
	if (type==type.value) val=Double.valueOf(s).doubleValue();
	changed=true;
    }
    
    public void reset() {
	if (type==type.menu && chosen!=defchosen) {	chosen=defchosen; changed=true; }
	if (type==type.option && flag!=defflag) {	flag=defflag; changed=true; }
	if (type==type.value && val!=defval) {	val=defval; changed=true; }
	if (type==type.trigger) flag=defflag;
    }
    
    public void choose(int i) { if (type==type.menu)	chosen=menulist[i];    }
    public void choose(Object c) {
	if (c.equals("next")) {	choose( (getchosenindex()+1) % numitems); return; }
	if (c.equals("prev")) {	choose( (numitems +getchosenindex()-1) % numitems); return; }
	for (T o : menulist) if (c.equals(o)) chosen=o; return;
    }
    
    public void setval(double val) {	this.val=val; }
    public void setflag(boolean b) {	flag=b; }
    
    public void set(double d) {	    loop.changeinteractions=false; val=d; if(val<min) val=min; else if(val>max) val=max;  doscript(); }
    public void set(boolean b) {	flag=b; doscript(); }
    public void set(T o) {	choose(o); doscript(); }
    public void set(int i) {	if (type==type.value) set((double)i); else {	choose(i); doscript(); }}
    
    public void doscript() {
	//if (scriptmode.chosen.equals("demo")) getholder().demopreloop();
	respond(!calcscript.delayloop());
	//if (scriptmode.chosen.equals("demo")) getholder().demopostloop();
    }
    
    
    public void respond(boolean domodloop) {
	if (reportchange) System.out.println(getFullName()+" "+getstringval());
	changed=true;
	if (domodloop)   SwingUtilities.invokeLater(new Runnable(){ 	public void run()  { loop.go(); }   } );
	// if (domodloop) loop.go(true); //true = new thread
    }
    
    //see player and genscript
    public void doscript(String s) {
	if (type==type.option) {	if (s.equals("false") || s.equals("f") || s.equals("F") || s.equals("off") || s.equals("dis") || s.equals("disabled")) flag=false; else flag=true; }
	if (type==type.menu) choose(s);
	if (type==type.value) setval(Double.valueOf(s).doubleValue()); //beware not take into account units scaling factor!
	doscript();
    }
    
    //***** LOOP and ENABLED *************
    
    public void precalc() {}
    //note this will be called by loop, if param needed and changed, before any module precalcs
    
    public boolean checkenabled() { return register.checkneededforplotexcept(this, treeMaker.class); }
    
    //****************
    //QUERY
    
    //used for interactions/enabled criteria
    public T getchosen() { return chosen; }
    
    public String getstringval() {	return ""+((type==type.option) ? ""+flag : (type==type.menu) ? chosen.toString() :  (type==type.value) ? ""+units.round(val) : ""); }
    
    public double getval() {	return val; }
    public double getdef() {	return defval; }
    public double getfrac() {	return val/defval; }
    public boolean istrue() {	return flag; }
    
    public float min() {	return (float)min; }
    public float  max() {	return (float)max; }
    public float  range() {	return (float)(max-min); }
    
    
    public boolean isnotdefault() {
	if (type==type.menu) return chosen!=defchosen;
	if (type==type.value) return val!=defval;
	if (type==type.option) return flag!=defflag;
	return false;
    }
    
    public String chosenname() { 	return chosen.toString();    }
    public String getname(int i) {	return menulist[i].toString(); }
    public String getname(Object o) {
	if (o instanceof String) return (String)o;
	try {return o.getClass().getField("name").get(o).toString(); } catch (Exception e) {}
	try {return o.getClass().getMethod("getName").invoke(o).toString(); } catch (Exception e) {}
	if (o instanceof interacob) return ((interacob) o).name;
	if (o instanceof Enum) return ((Enum)o).name() ;
	return o.getClass().getSimpleName();
    }
    
    public int getchosenindex() {
	int i=0; for (int j=0; j<menulist.length; j++) if ( chosen.equals(menulist[j])) i=j; return i;
    }
    
    
    
    //************************************
    //LAB / DOC
    
    
    public String getinfo() {  return getLabel() +getstate() +addunits();    }
    
    public String addunits() { 	return  (type==type.value)? " \t\t"+ labman.getShort(units.units) : "";    }
    
    public String getstate() {
	if (type==type.menu) return (" \t\t"+labman.getTitle(chosen.toString())+" (def="+labman.getTitle(defchosen.toString())+") \n");
	if (type==type.option) return (" \t\t: "+(flag ? labman.getTitle("ena") : labman.getTitle("dis") )+" (def="+(defflag ? labman.getTitle("ena") : labman.getTitle("dis") )+") \n");
	if (type==type.value) return (" val="+units.round(val, dp)+ " (def="+ units.round(defval, dp)+") \n")	;
	if (type==type.Xscale || type==type.Yscale) return type+": "+units.round(min)+" - "+units.round(max) +" "+labman.getShort(units.units)+labman.getTitleIfDifferent(units.units);
	return "";
    }
    
    public String docSummary() {
	//should add the Slider / Box etc. here - how?
	return hashcolor()+(checkenabled() ? "" : " //(inactive)// ")+ autodoc.link(this) +"</font> "+ "%"+name+"<br>";
    }
    
    public String getExtraDoc() {
	if (type==type.Xscale || type==type.Yscale) return getinfo();
	return getInput()+moreinfo()+"<hr>"+docInteracs()+autodoc.javacode(this);
    }
    
    public String getInput() {
	String pi=" <br>%%adju paraminterac %%<br>";
	if	(type==type.option) return  " <input type=checkbox "+(flag ? "checked" : "" )+" > " +pi;
	if   (type==type.value) return 	" <input type=text value="+ units.round(val, dp)+" > "
		+ ((units!=null) ? labman.getTitle(units.units) : "")
		+(isnotdefault() ? " (<i>`default : "+ units.round(defval, dp)+"</i>) "  : "")+pi;
	
	if  (type==type.menu) {
	    String info=" <select>";
	    for (int i=0; i<numitems; i++) info+="<option "+getname(i)+(i==getchosenindex() ? " selected" : "")+" >"+ labman.getTitle(getname(i));
	    return info+"</select>"+pi;
	}
	if (type==type.trigger) return  " <input type=button value='"+labman.getShort(name)+"' > "+pi;
	return "";
    }
    
    public String moreinfo() {
	if (type==type.menu) {
	    String info2=""; for (int i=0; i<numitems; i++)   info2+="<li>"+ autodoc.link(getname(i))+" %"+getname(i);
	    return "<hr> `moreinfo <ul>"+info2+"</ul>";
	}
	if (type==type.value && pair!=null) return   "<hr>"+pair.getExtraDoc();
	return "";
    }
    
    
//******* COMPONENT, MENUITEM ***********
//is it possible to combine getComponent and getMenuItem?
//used mainly in trees
    public JComponent getComponent(Object ... args) {
	if (type==type.menu)  return new paramMenu(this, args);
	if (type==type.value)  return new paramValueChooser(this, args);
	if (type==type.option) return new paramOption(this, args);
	return super.getComponent();
    }
    
//used by startJCM menus, menuMaker, mapplot, docView
    public JMenuItem getMenuItem() {
	if (type==type.menu) {
	    JMenu pm= new JMenu(getLabel());
	    ButtonGroup group = new ButtonGroup();
	    for (final T o : menulist) {
		JRadioButtonMenuItem rbmi=new JRadioButtonMenuItem(
			new AbstractAction( labman.getTitle(getname(o)) ) {
		    public void actionPerformed(ActionEvent e) {	set(o); }
		}
		);
		group.add(rbmi);
		pm.add(rbmi);
		if (o==chosen) rbmi.setSelected(true);
	    }
	    return pm;
	}
	if (type==type.option) {   return new cb(this); }
	
	if (type==type.value) {
	    JMenuItem jm= new JMenuItem();
	    JComponent c= getComponent("menu");
	    jm.setLayout(null);  jm.setArmed(false); jm.setEnabled(true);
	    jm.add(c);    c.revalidate();
	    c.setLocation(0,0);     c.setSize(c.getPreferredSize());     jm.setPreferredSize(c.getPreferredSize());
	    return jm;
	}
	return null;
    }
    
    class cb extends JCheckBoxMenuItem implements plotlink, ChangeListener {
	
	public cb(param p) {
	    setText(p.getLabel()); setSelected(istrue()); setForeground(getColor());
	    addChangeListener(this); register.addlink(this, p);
	}
	public void doplot() {  if (changed) loop.golater(); setSelected(istrue());  setToolTipText(getinfo()); }
	public void stateChanged(ChangeEvent e) {	if (istrue() !=isSelected())  set(isSelected()); setText(param.this.getLabel()); setToolTipText(getinfo()); }
	public void addNotify() {super.addNotify();  doplot();  }
    }
    
    
}//end param class




