 /*
 module: superclass of all the main science calculation modules
 is an owner of params and qtsets
 has loop methods (maybe move to interface?)
  
  ******************************
 P2 Save memory by creating some qts on demand for visible qtset (to save memory)
 -i.e. distinguish qt that are needed by other modules, and those only needed for plotting
 one way is to make plot interactions work via qts?
  
 P1 STRUC  eventually intend to separate processes (mod-loop), state variables (qtsets) and param-holders -notes below
 (moving to system-dynamics structure)
  In some cases (eg fgas popn) makes sense to keep together
 In others (shares, mitign) it doesn't  what matters is calcn order
  note not all current modules have loop methods, some are just used as holders
?? P1 IDEA STRUC  Specify implementing interfaces (and split modloop =>startstate/save99 sep), easier for make menus, interacmap etc.
OK P1 IDEA STRUC get rid of defaultqtset? -used only by glotemp, ??
  
//OK P1 STRUC remove defqtset and getunits: check usages of getunits: used by oceantemp, glotemp, sealevel, radfor, atchem, aerosol
  */

package jcm.core;

import java.util.*;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.gen.iconFinder;


public class module extends interacob implements time, modloop,  Comparable<module> {
    
    
    //FIELDS
    public world world;
    public boolean affectsfutureonly=false;
    
    public boolean err; //used by loop to flag RuntimeExceptions
    
    public static int ns=0, year=0; //time variable changed before loop calcstep - shared by all modules
    
    public Vector<qtset> qtsets=new Vector();
    public Vector<param> allparam=new Vector();
    
    public String getFullName() {	return  world.name+"&"+name; }
    
    //****************************
    //REGISTER
    //extends register to find fields of qtsets, params etc.
    
    
    
    public void register() {
	super.register();
	
	Set s= jcm.tls.ref.getallobs(this);
	
	for (Object o : s) {
	    if (o instanceof infob)  ((infob) o).owner=this;
	    if (o instanceof interacob  && o!=this) {
		((interacob)o).register();
		//if (o instanceof param) params.addOb(o); else
		addOb(o);
	    }
	    if (o instanceof qtset)  { qtsets.add((qtset)o); ((qtset)o).setaffectedby(this);  }
	    if (o instanceof param) { allparam.add((param)o); ((param)o).setaffects(this); }
	}
	
	/*
	 This causes too much trouble with the documentation of intermediate infobs, and also with the hideenabledobs
	//if contains both params and curves, make sub_infobs for tree
	if (allparam.size()>3 && qtsets.size()>0) {
	    infob params = new infob(name+"&Params");
	    for (param p : allparam) { removeOb(p); params.addOb(p); }
	    params.mincomplexity();
	    addOb(params);
	}
	if (qtsets.size()>3 && allparam.size()>2) {
	    infob  curves= new infob(name+"&Curves") ; //for trees and menus
	    for (qtset qq : qtsets) { removeOb(qq); curves.addOb(qq); }
	    curves.mincomplexity();
	    addOb(curves);
	}
	*/
	mincomplexity();
	
	addDocAction();
	addTreeAction();
	
    } //register
    
    
    public boolean checkenabled() { //used by tree (via infob) to decide whether to include this module in tree
	for (param p : allparam) if (p.checkcomplexity() && p.checkenabled()) return true;
	for (qtset q : qtsets) if (q.checkcomplexity()) return true;
	if (this instanceof jcm.mod.reg.regcli) return true; //for the map link
	return needed;
    }
    
    //*******************************
    //MODLOOP methods
    
    public void initsetup() {	} //only called once, at beginning
    
    //before main calc loop
    public void precalc() {} //note some params also have a precalc method, which runs before any modules
    public void startstate(int startyear) {}
    
    //calc just one timestep in time loop
    public void calcstep() {}
    
    //save state in 1999 for calc future only
    public void save99() {}
    
    //after main loop
    public void postcalc() {}
    
    //*******************************
    //refer to other modules
    
    public <T extends module> T    get(Class<T> c) { return world.get(c); }
    
    
    //*******************************
    //set order
    Set<module> follows=new HashSet();
    public int order=0; //calculation order
    
    public void setaffectedby(Class c) { setaffectedby(get(c)); }
    public void setaffectedby(Class c, boolean b) { setaffectedby(get(c), b); }
    public void follows(Class c) { follows(get(c), true); }
    public void follows(Class c, boolean b) { follows(get(c), b); }
    
    public void follows(module m) { follows(m, true); }
    public void follows(module m, boolean b) {
	if (b) follows.add(m); else follows.remove(m);
	setaffectedby((interacob)m, b);
    }
    
    public int compareTo(module m) {
	return (order-m.order);
    }
    
    public static void debug(Object ... args) { String s=""; for (Object o : args) s+="\t\t"+o.toString(); System.err.println(s); }
    
    // ********* CHECK TIME SPENT ***************
    static long time = System.currentTimeMillis(), oldtime = time;
    
    public  static void reporttime(String info){
	time = System.currentTimeMillis();
	System.err.println(info+": time since last report "+(time - oldtime)+" ms"); oldtime = time;
    }
    
    // *********** AUTO DOC ****************
    public String getExtraDoc() {
	return docQtsets()+docParams()+"----"+docInteracs()+autodoc.javacode(this);
	//note removed treeinfo which gives "curves" and "params" but should put somewhere link to package
    }
    
    public String docQtsets() {
	String s="";
	for (qtset qq : qtsets) if (qq.checkcomplexity())  { s+="<li> "+qq.docSummary();   }
	return s.length()>0 ? "==CurveSets== <ul> "+s+ " </ul>" : "";
    }
    
    public String docParams() {
	String s="";
	for (param p : allparam) if (p.checkcomplexity()) {  s+="<li> "+p.docSummary(); }
	return s.length()>0 ? "==Params== </ul> "+s+ " </ul>" : "";
    }
    
} //end module


//******************************

/*SUBMODULE
not currently used
P1 STRUC / TIDY replace submodule by paramset similar to qtset, for better organising menus?
 
   /*
public Vector<module> submod=new Vector();
if (o instanceof module && o!=this) submod.add((module)o); //not currently used
 
    public module(Object ... args) {
	for (Object a : args) {
	    if (a instanceof module) {	owner=(iob) a; }
	    if (a instanceof param[]) {	for (param p : (param[])a) allparam.add(p); }
	    if (a instanceof Color) {	color=(Color) a; }
	    if (a instanceof complexity) { mycomplexity=(complexity) a; }
	    if (a instanceof String) {  name=(String)a; }
	}
	register();
	//		initsetup(); -getiobs in constructor crashes startup!
    }
 */



