/*
 Main calculation loop through iobs, modules, etc.
 */

package jcm.core;
import javax.swing.SwingUtilities;
import static jcm.core.register.*;
import jcm.gui.nav.treeMaker;


public class loop  implements  time  {
    
    
    //***********************************
    public static boolean
	    ready=false, inmainloop=false, waiting=false,
	    
	    //waiting flag ensures that only one loop call can be queued
	    
	    repeat=false, scin=false, //used for iteration
	    changeinteractions=true,
	    calcfutureonly=false, //affects both pans and mods -may be set true by controls
	    checkmemory=false;
    
    public static param checkperform=new param("loopinfo", false);
    
    
    static long inttime=0, tottime=0, oldtime=0, newtime=0, timediff=0, timelastgc=0;
    static String info="";
    
     /*
      itc and itn were to stop output plotting during iterations
      not currently used but might be later
      */
    public static interacob[] itc, itn;
    
    static int i; //static so dispose can adjust this from within loop! - may no longer be needed since we have no more iobloop
    
    //*****************
    //GO
    
    
    public static void go() { go(false); }
    
    public static void go(boolean newthread) {
	if (newthread) new runner().start(); // experimental - not currently used
	else if (!inmainloop)  mainloop();
    }
    
    //if one gui-event results in loop being called several times, it will only go once
    //this only works if all loops called from event despatching thread!
    static boolean settogo=false;
    public static void golater() {
	settogo=true;
	SwingUtilities.invokeLater(new Runnable() { public void run() { if (settogo) mainloop(); settogo=false; }});
    }
    
    //*****************
    // MAIN CALCULATION LOOP
    
    public static void mainloop() {
	inmainloop=true;
	
	if (checkperform.istrue()) {
	    startcheckperform();
	    inttime=System.currentTimeMillis();
	}
	
	
	if (repeat || scin) setchangedifneeded(itc, itn);
	else setallinteractions();
	jcm.gui.gen.interacmap.reset();
	
	if (checkperform.istrue()) inttime= System.currentTimeMillis() - inttime;
	
	for (interacob i : alliobs) if ( (i instanceof param) && i.needed && i.changed && !i.skip) {
	    try {
		((param)i).precalc();
		if (checkperform.istrue()) checktimespent(i);
	    } catch (RuntimeException e) {	catcher(e, 1, i, false); }
	}
	
	
	for (world w : world.worlds)  {
	    
	    w.setmodorder();
	    
	    /*
	 calcfutureonly is only for efficiency, but not currently working correctly:
	 currently only sres, shares and stabilisation set affectsfutureonly=true
	should check this between needed and changed loops? -ie should depend only on the trigger of the change, if needed
	     */
	    calcfutureonly=true; for (module m : w.mods) if (m.needed && m.changed) calcfutureonly&=m.affectsfutureonly;
	    int startyear=(calcfutureonly ? 2000 : 1750);
	    //if (calcfutureonly)	System.out.println("calcfutureonly");
	    
	    //main loop of modules through timesteps
	    for (module m : w.mods) m.err=false;
	    
	    for (module m : w.mods) if (m.needed && m.changed)
		try {
		    m.precalc();
		    if (checkperform.istrue()) checktimespent(m);
		} catch (RuntimeException e) {	catcher(e, 2, m, false); }
	    
	    
	    for (int ns=(startyear-gsy); ns<=glos; ns++) {
		module.ns=ns; module.year=ns+gsy;
		for (module m : w.mods) if (m.needed &&m.changed){
		    try {
			if (ns==(startyear-gsy)) m.startstate(startyear);
			m.calcstep();
			if ((ns+gsy)==1999) m.save99();
			if (checkperform.istrue()) checktimespent(m);
		    } catch (RuntimeException e) {	if (!m.err) {	m.err=true; catcher(e, 2000+module.ns, m, false); }}
		    if 	(module.year!=module.ns+gsy) System.out.println("! ns="+module.ns+" year="+module.year+" mod="+m.name);
		}
	    }
	    
	    for (module m : w.mods) if (m.needed && m.changed)
		try {
		    m.postcalc();
		    if (checkperform.istrue()) checktimespent(m);
		} catch (RuntimeException e) {	catcher(e, 2, m, false); }
	    
	}
	
	
	doplots(); //plot plotlinks -see register
	
	//cancel iobs changed since all done
	if (!waiting) for (interacob i : alliobs) if (i.needed && i.changed && !i.skip) i.changed=false;
	
	if (checkperform.istrue()) reporttimespent();
	
	if (checkmemory) info=("memory: free="+(int)(100.0*Runtime.getRuntime().freeMemory()/Runtime.getRuntime().totalMemory())+"%");
	
	//force garbage collect, but not too frequently (eg when dragging param)
	long time=System.currentTimeMillis(); if ((time-timelastgc)>5000) { System.gc();  timelastgc=time; }
	
	if (checkmemory) System.out.println(info+" after-gc= "+(int)(100.0*Runtime.getRuntime().freeMemory()/Runtime.getRuntime().totalMemory())+"%");
	
	calcfutureonly=false;
	inmainloop=false;
	changeinteractions=true;
	if (repeat) go();
	
    } //mainloop
    
    
    static void catcher(RuntimeException e, int stage, interacob i, boolean owneff) {
	String problem="runtime exception in loop stage "+stage+" "+i.owner.name+(owneff ? " effectof " : ".")+i.name+" => "+e;
	System.out.println(problem);
	System.err.println(problem); e.printStackTrace();
    }
    
    //		try {	System.out.println("waiting for input"); System.in.read(); } catch (Exception e) {	}
    
    
    //***************************************************
    //PERFORMANCE
    
    
    static void startcheckperform() {
	oldtime=System.currentTimeMillis(); tottime=oldtime;
	for (interacob i : alliobs) i.timespent=0;
    }
    
    static void checktimespent(interacob i) {
	newtime=System.currentTimeMillis();
	i.timespent+=newtime-oldtime;
	oldtime=newtime;
	if (i.timespent==0) i.timespent=-1; //so report
    }
    
    static void reporttimespent()  {
	tottime=System.currentTimeMillis()-tottime;
	info="LOOP (time /ms)  total: "+tottime+ " interactions: "+inttime+" ";
	for (interacob i : alliobs) 	if (i.timespent!=0) {
	    info+=( (i.owner.getName()==i.name ? "" : i.owner.getName()+".") + i.name+": "+i.timespent+" ");
	}
	System.out.println(info);
	startcheckperform();
    }
    
    //************************************************
} //end loop class

// experimental - not currently used - see notes below
class runner extends Thread {
    
    public void run() {
	if (!loop.inmainloop) {  loop.mainloop(); return; }
	if (loop.inmainloop && !loop.waiting) {
	    loop.waiting=true;
	    setPriority(Thread.MIN_PRIORITY);
	    while (loop.inmainloop) try { sleep(100); } catch (InterruptedException e) { }
	    loop.waiting=false;
	    loop.mainloop();
	}
    }//run
    
}//end runner

	/*
	 P1 STRUC Rethink Loop / Event Dispatching thread : see notes below
	should do this in the event despatching thread
	but invokeAndWait shouldn't be called frrom it!
	 
	 note: if use invokeLater - sometimes plot doesn't correspond to param,
	 whereas if use invokeAndWait,  doesn't work if loop called from EDT
	 
	 could make options for testing?
	 
	 try { //AndWait
	    SwingUtilities.invokeLater(new Runnable() {  public void run() { iobloop(4); }});
	} catch (Exception e) { System.out.println("plot  interrupted"); }
	 */


	/*
	&& Could put all loop calls into separate (non event-dispatching) thread
	(partly done: works for params but not opening plots)
	re opening plots: should let the menu respond, but not much use to show the plot before its ready
	ie need a "preparing" method in setup
	Aha - invokeLater solves most of the problem!
	 
	but then gui object constructors can't rely on them completing,
	and loop (ie mainplot) should not make any new gui objects
	 also beware optimisation/stabilisation threads
	 also what if multiple calls? - should implement an eventqueue
	 
	 Current calls of loop.go():
	 
	mod: optimisation.optloop, also gowithin in responsibility and stabilisation
	reg: regcli, regseacli
	script: various
	gui: datable, lineplot, mapplot
	 
	Callers of param-respond doscript, set:
	scaleview, mappplot (respond), parammenu, modview, startjcm-set
	script (various -set)
	 */


