/*
INTERACTION OBJECT CLASS
 Extends infob to add  interaction between model components
  Extended by: module(s), param,  qtset
 
P1 STRUC Use more interfaces to further split infob/interacob? -hasdoc, hasinteractions, loopoutput, loopmodel, paramset, qtset, isscript
 flags and vectors could store in register instead (as a map) - so make it easier to convert to interface
 in this case, couldn't register keep this info about ANY object? - don't even need the interface!
 think about using WeakHashMap to avoid memory leaks?
 */



package jcm.core;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.tls.*;
import static jcm.core.register.*;

public class interacob extends infob {
    
    
    //****************************
    //FLAGS
    public boolean
	    
	    changed=true,	//set true when parameter adjusted, all interacobs affectedby this will be set changed too, reset false by loop after recalcuated
	    
	    output=false, 	//needed for direct output, e.g. visible plot, table or parameter (which may need to replot in after loop calcs)
	    
	    needed=false,	//needed (maybe indirectly) because of output (and likewise everything which this is *affected by*)
	    
	    checked=false, 	//used within changed loop
	    disposed=false,	//if true, no longer active, should be ignored
	    skip=false;		    //if true, loop will skip calcs for this, will remain changed
    
    
    long timespent; //for checking performance
    
    //*****************************
    //COLLECTIONS
    
    // all the other iobs this interacts with
    public Vector<interacob> vaffectedby =new Vector(), vaffects =new Vector();
    
    //*****************************
    //CONSTRUCTORS
    
    public interacob() { }
    public interacob(String n) {	name=n; }
    public interacob(String n, interacob i) {	name=n; owner=i; } //for iobs simply used as cause-effect logic links
    
    
    //****************************
    //INTERACTIONS
    
    //but could use flag methods below to distinguish temporary and permanent interactions
    
    
    //permanent effects
    public void setaffectedby(interacob ... iobs) { for (interacob i : iobs) setaffectedby(i); }
    public void setaffectedby(interacob iob) {	if (!vaffectedby.contains(iob)) {	vaffectedby.addElement(iob); iob.vaffects.addElement(this); }}
    public void setaffects(interacob ... iobs) { for (interacob i : iobs) setaffects(i); }
    public void setaffects(interacob iob) {	if (!vaffects.contains(iob)) {	vaffects.addElement(iob); iob.vaffectedby.addElement(this); }}
    public void setnotaffectedby(interacob iob) {	vaffectedby.removeElement(iob); iob.vaffects.removeElement(this); }
    public void setnotaffects(interacob iob) {	vaffects.removeElement(iob); iob.vaffectedby.removeElement(this); }
    
    public void setaffectedby(interacob iob, boolean flag) {	if (flag) setaffectedby(iob); else setnotaffectedby(iob); }
    public void setaffects(interacob iob, boolean flag) {	if (flag) setaffects(iob); else setnotaffects(iob); }
    
    public boolean affectedby(interacob iob) {	return vaffectedby.contains(iob); }
    public boolean affects(interacob iob) {	return vaffects.contains(iob); }
    
    //setinteractions() of all modules and panels: called by loop,    this should contain affected, affectedby interactions as needed
    public void setinteractions() {	}
    
    //interacinfo not currently used but  maybe still useful for debugging
    public String interacinfo() {	String s= (output ? "O" : "") + (needed ? "N" : "") + (changed ? "C" : "") + " ";
    for (interacob i : vaffects) s+=">"+i.name+" ";
    for (interacob i : vaffectedby) s+="<"+i.name+" ";
    return s;
    }
    
    //************************************
    //REGISTER
    public void register(){
	if (!alliobs.contains(this)) {
	    alliobs.addElement(this);
	    
	    //System.out.println("R: "+(owner.getname().equals(name) ? "" : owner.getname()+"~")+name+" ");
				/*
				if (owner.getname()!=on) {	on=owner.getname(); if (checkreg) System.out.print("\n O:"+on+" "); }
				newcn=getClass().getName().substring(8);
				if (!newcn.equals(cn)) {	cn=newcn; *if (checkreg) { if (cn.equals(on)) System.out.print("(C) "); else System.out.print("\n (C:"+cn+") "); } }
				if (on!=name)  if (checkreg) System.out.println(owner.getname()+"~"+name+" ");
				 */
	}
    }
    
    //************************************
    //DISPOSE
    public void dispose() {
	SwingUtilities.invokeLater(new Runnable(){ public void run() { disposethis(); }});
	//using invoke later makes sure this isn't called from inside a loop.go()
    }
    
    void disposethis() { //beware this will also remove refs to static iobs!
	for (int i=0; i<alliobs.size(); i++) {	interacob ii=(interacob)alliobs.elementAt(i) ; if (ii.owner==this) {
	    for (interacob j : alliobs) {	j.setnotaffectedby(ii); j.setnotaffects(ii); }
	    if (ii!=this) {	ii.dispose(); if (i<=loop.i) loop.i--; i--; } //recursive! note the i-- to step back because alliobs has changed!
	}}
	//if (checkreg) System.out.println( "disposing "+name);
	alliobs.removeElement(this); name+="&disposed"; disposed=true;
	plotlinkmap.remove(this);
	try {	finalize(); }catch (Throwable e) {	System.out.println(e); }
    }
    
    //****************************
    //DOC
    
    public String getExtraDoc() {
	return labman.getDoc(name)+"----"+docInteracs()+autodoc.javacode(this);
    }
    
 
    public String docInteracs() {
	String affinfo= docaffectedby()+docaffects(); if (affinfo.length()>5) affinfo+="interacs ";
	return "%% ==`interacs ==" +docOwner()+affinfo+"%%";
    }
    public String docaffects() {
	String info=""; int c=0;
	for (interacob io : vaffects) if (io.owner==io && io.owner!=owner  && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.link(io.owner); }
	return (c>0 ? "<nobr>%%cogs `affects : "+info+" %%</nobr><br>" : "");
    }
    public String docaffectedby() {
	String info=""; int c=0;
	for (interacob io : vaffectedby)  if (io.owner==io /*&& io!=holder.owner*/ && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.link(io.owner); }
	return (c>0 ? "<nobr>%%cogs `affectedby : "+ info+" %%</nobr><br>" : "");
    }
    
    
    
} //end class

