 /*
 This class is extended by many objects that have name, color, documentation, complexity etc.
 including all iobs (modules, params, qtsets) but also others (qts, regions)
  */

package jcm.core;

import java.util.*;
import javax.swing.*;
import java.awt.Color;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;
import jcm.gui.nav.menuFiller;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;

public class infob implements hasinfo, menuFiller  {
    
    
    
    //****************************
    //FIELDS
    // data about this infob - keep to a minimum as there are many infobs - eg all curves, all regions!
    
    public String name=getClass().getSimpleName();
    /*
   name should be same as #codes in labdoc files, used for labels, documentation and scripting
   note names not necessarily unique, but owner.getname()+name usually unique
     */
    
    public infob owner=this;
    
    //these affect the display of a component
    public complexity mycomplexity=complexity.simplest; //but set to default for qtset and param;
    public Color color=rcol();
    public Set obs;
    public List<Action> actions;
    
    public double priority=1; //higher number displayed higher in tree/menu
    
    //******************************
    static Object[][] setupinfo=new Object[][] {
	{"mod", 2.0},
	{"obj", 6.0, dkblue}, { "soc", 5.0, brown}, {"carbon", 4.0, black}, {"ogas", 3.0, dkgreen}, { "cli", 2.0, dkred}, { "reg", 1.0, dkpurple},
	{"socreg", 2.0}, {"controller", 2.0}, {"costs", 0.8},  {"optimisation", 0.8},  {"othgasemit", 2.0 }, {"carboncycle", 2.0}, {"carbonatechemistry", 0.8},
	{"radfor", 2.5}, {"glotemp", 2.0}, { "udebclimod", 1.5}
    };
    public void checkinfo() {
	for (Object[] oo : setupinfo) if (removepackagename(name).equals((String)oo[0])) { priority=(Double)oo[1]; if (oo.length==3) color=(Color)oo[2]; return; }
    }
    
//******************************
    //CONSTRUCTOR
    public infob() { color=rcol(); } //a basic constructor to prevent superclasses calling below, even if they have own (Object ... args) constructor
    
    public infob(Object... args) {
	color=null;
	for (Object o : args) {
	    if (o instanceof infob) { owner=(infob)o; if (color==null)  color=rcol(owner.color); }
	    if (o instanceof String) { 	name=(String)o; checkinfo();  }
	    if (o instanceof Color) color=(Color)o;
	    if (o instanceof Number) priority=((Number)o).floatValue();
	}
	if (color==null) color=rcol();
    }
    
    //standard actions: make only as needed (not for qt, region) but avoid duplicating, also aid identifying
    public Action docaction, treeaction;
    public void addDocAction() { if (docaction==null) docaction=showpan.pan("Doc", docview.class, name); addAction(docaction); }
    public void addTreeAction() { if (treeaction==null)  treeaction=showpan.pan("Tree",  treeMaker.class, "["+this+"]"); addAction(treeaction); }
    
    
//********COMPLEXITY**********************
    void mincomplexity() { mincomplexity(getObs()); }
    void mincomplexity(Collection obs) { //sets complexity according to minimum of containing obs
	if (obs!=null) {
	    mycomplexity=experimental;
	    for (Object o : obs) if (o instanceof hasinfo) mycomplexity=((hasinfo)o).getComplexity().compareTo(mycomplexity)<0 ? ((hasinfo)o).getComplexity() : mycomplexity ;
	}
    }
    
    public complexity getComplexity(){ return mycomplexity ; }
    public boolean checkcomplexity() { return complexity.check(getComplexity()); }
    
    public boolean checkenabled() {return true; } //overridden by param which returns needed, and module, which returns true if needed or any needed params
    
//******** WORLD **********************
    public world getworld() {
	if (owner instanceof world) return (world)owner;
	if (owner ==this) return null;
	return owner.getworld();
    }
    
    public module getmodule() {
	if (owner instanceof module) return (module)owner;
	if (owner ==this) return null;
	return owner.getmodule();
    }
    
//********* RELATIONSHIPS *******************
    public hasinfo getOwner(){  return owner; }
    public Set getObs(){  return obs; }
    
    public List getEnabledObs(boolean checkcomplexity, boolean checkenabled){
	List eo=new ArrayList();
	if (obs==null) return null;
	for (Object o : obs) if (
		!(o instanceof infob)
		|| (
		( !checkcomplexity || ((infob)o).checkcomplexity() )
		&& (!checkenabled ||  ((infob)o).checkenabled())
		) ) eo.add(o);
	if (eo.size()>0) return eo; else return null;
    }
    
    public void addOb(Object h) {
	if (getObs()==null) obs=new TreeSet(new Comparator() {
	    public int compare(Object a, Object b) {
		if (a instanceof infob && b instanceof infob) {
		    int i= (int)Math.signum(((infob)b).priority-((infob)a).priority);
		    if (i==0) i=((infob)a).name.compareTo(((infob)b).name);
		    return i;
		} else return a.getClass().getName().compareTo(b.getClass().getName());
	    }
	});
	getObs().add(h);
    }
    
    public void removeOb(Object h) { getObs().remove(h); }
    
    public void addAction(Action a) {
	if (actions==null) actions=new LinkedList();
	actions.add(a);
    }
    
    public Object find(String s) { return find(this, s); }
    public Object find(Object orig, String s) {
	if (obs!=null) {
	    for (Object o : obs) if (o.toString().equals(s)) return o;
	    for (Object o : obs) if (o instanceof infob && o !=orig) { Object oo=((infob)o).find(orig, s); if (oo!=null) return oo; } //recursive, beware loops!
	}
	return null;
    }
    
//***********COLOR ***************
    
    public Color getColor() { return color; }
    public String hashcolor() {   return hashcolor(getColor()); }   //color for html use in Jlabels
    public static String hashcolor(Color c) {   return "<font color=#"+hex2(c.getRed())+hex2(c.getGreen())+hex2(c.getBlue())+" >";    }
    public static String hex2(int x) { return (x<16 ? "0" : "")+Integer.toHexString(x); }
    public static Color rcol() {	return new Color((int)(255*Math.random()),(int)(255*Math.random()),(int)(255*Math.random())); }
    public static Color rcol(Color b) {	if (b==null) return rcol();
    else          return new Color((int)(127*Math.random())+b.getRed()/2,(int)(127*Math.random())+b.getGreen()/2,(int)(127*Math.random())+b.getBlue()/2);
    }
    
//************* NAME AND DOC ***************
    
    public String toString() {return getName(); }
    public String getName(){  return name; }
    public String getFullName() {	return  (owner != this ? owner.getFullName()+"&" : "") +name; }
//return ((getworld() != null ? getworld().name : "") +"&"+(getmodule() != null ? getmodule().name : "")+"&"+name); }
    public static String removepackagename(String s) {	int i= s.indexOf("."); return i>0 ? removepackagename(s.substring(i+1)) : s ; }
    public String type() { return getClass().getSimpleName(); } //for modules, same as name, but for params and qtsets different
    
    public String getLabel(){  return labman.getShort(name); } //note for qt, switched to getTitle as the short form is very short (for legend)
    public String getTitle(){  return labman.getTitle(name); }
    public String getLongTitle() {	return labman.getTitle( getFullName()); }
    
    public String getExtraDoc() { return  docPackageInfo();    }
    
    public String getSpecificDoc(Object ... args) {
	return "<p><b>!specific doc request "+args[0] +" for "+name+" no longer implemented!</b><p> ";
    }
    
    public String docSummary() {
	String n2;
	try {
	    getClass().forName(name);  n2=removepackagename(name);  return autodoc.link(n2)+  "</font> " + "%"+n2+"<br>";
	} catch (ClassNotFoundException e) {  return autodoc.link(this)+  "</font> " + "%"+name+"<br>";  }
    }
    
    public String docPackageInfo() {
	String s= "  ==`packageinfo ==";
	List c=getEnabledObs(true, false); if (c!=null) { s+="<ul> "; for (Object o : c) s+=(o instanceof infob ?  ((infob)o).docSummary() : o) ; }
	return s +"</ul><hr>" +docOwner() + "%%cogs package name="+name+"%%";
    }
    
    public String docOwner() {
	return (owner!=this) ? "<nobr>%%cogs `memberof  "+ autodoc.link(owner.name)+"%%</nobr><br>" : "";
    }
    
    //****** NOTE BELOW COULD MOVE TO GUI PACKAGE? **********
//************ COMPONENT  & MENU & ICON ********************************
    
    public JComponent getComponent(Object ... args) {
	//used by treemaker, circmenu, qtset, param, overridden by param
	Box b=Box.createHorizontalBox();
	new contextMenu(b, this);
	JLabel jl=new JLabel(getLabel(), getIcon(), SwingConstants.LEFT);
	jl.setForeground(getColor());
	b.add(jl);
	b.addMouseListener(showpan.moulist);
	b.addMouseMotionListener(showpan.moulist);
	showpan.moulist.cimap.put(b, this);
	return b;
	
    }
    
    public void fillMenu(JPopupMenu popup) {
	if (actions!=null) for (Action a : actions)  {
	    //only want docaction if helpmode off, and only want treeaction if not called from a tree.
	    if (! ( (popup.getInvoker() instanceof JTree) && (a==treeaction || treeMaker.helpmode.istrue() && a==docaction) ))
		popup.add(a);
	}
    }
    
    
    public Icon getIcon() { return iconFinder.findIcon(this); }
    
    //OLD CODE ADD ACTION BUTTONS
//	//if (!a.getValue(Action.NAME).equals("Table") )
//	if (actions!=null) for (Action a : actions)  {
//	    JButton jb=new JButton(a); if (a.getValue(Action.SMALL_ICON)!=null)  jb.setText("");
//	    jb.setMargin(new Insets(0,0,0,0));
//	    jb.setEnabled(checkcomplexity());
//	    b.add(jb); b.add(Box.createHorizontalStrut(8));
//	}
    
    
    
    
} //end class
