/*
 Start JCM class
Opens the main frame, Makes main menus, Initiates modules
 */

package jcm;
import jcm.core.*;
import jcm.gui.doc.docview;
import jcm.gui.doc.labdoctable;
import jcm.gui.doc.labman;
import jcm.gui.gen.contextMenu;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.interacmap;
import jcm.gui.gen.lookandfeel;
import jcm.gui.gen.processdialog;
import jcm.gui.gen.sysout;
import jcm.gui.nav.circmenu;
import jcm.gui.nav.menuMaker;
import jcm.gui.nav.showpan;
import jcm.gui.nav.treeMaker;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.lang.ref.WeakReference;
import jcm.gui.nav.menuFiller;

public class StartJCM {
    
    //*************** STARTUP INFO  *******************
    static JLabel message= new JLabel("<html><h2>Welcome to Java Climate Model v5</h2>" );
    static JLabel startinf=		new JLabel("<html><font color=red>Please wait while loading data and initialising model" +
	    "<p><font color=red><i>in case of delay look in Tools - System.out</i></html>");
    static JLabel proginf=new JLabel( " making doc /label/view menus .. ");
    static JProgressBar progbar=new JProgressBar(0, 15);
    
    //******** /some shortcuts used below *********
    static String getLabel(String s) { return labman.getShort(s); }
    static JMenu makeMenu(String s) {
	JMenu m= new JMenu(getLabel(s)); m.setIcon(iconFinder.findIcon(s));
	proginfMenu(s);
	return m;
    }
    static void proginfMenu(String s) {  proginf.setText(getLabel("Making Menu&"+s)); progbar.setValue(progbar.getValue()+1); };
    
    // ********** MAIN **********
    public static void main(String[] args) {
	
	
	//temporarily moved to start, to check menus
	labman.loaddefaultchanges(); //should do before show any doc with setup!
	
	//******************** STARTUP *******************
	//Make main frame visible quickly, and add tools, so can check sysout if problem during startup
	
	sysout.capsysout.precalc(); //captures System.out from now on
	
	final JFrame mf=showpan.setuppan();
	
	final processdialog  startdialog= new processdialog(getLabel("JCM5 Startup Info"), message, startinf, proginf, progbar);
	
	JMenuBar mb =new JMenuBar();
	mf.setJMenuBar(mb);
	
	//*************** TOOLS MENU *******************
	JMenu tools=makeMenu("Tools");
	
	JMenu soe=makeMenu("sysout");
	soe.add(showpan.pan(sysout.class));
	soe.add(sysout.capsysout.getMenuItem());
	soe.add(sysout.capsyserr.getMenuItem());
	soe.add(loop.checkperform.getMenuItem());
	
	tools.add(soe);
	mb.add(tools);
	
	mf.validate();
	
	tools.add(showpan.pan(docview.class, "mainmenu"));
	tools.add(showpan.pan(labdoctable.class));
	tools.add(showpan.pan(interacmap.class));
	tools.revalidate();
	
	//*************** VIEW MENU *******************
	
	//View menu
	JMenu view=makeMenu("View");
	view.add(labman.language.getMenuItem());
	view.add(complexity.defaultcomplexity.getMenuItem());
	lookandfeel.lookAndFeelParam.precalc();
	view.add( lookandfeel.lookAndFeelParam.getMenuItem());
	view.add( treeMaker.helpmode.getMenuItem());
	view.add( treeMaker.filterenabled.getMenuItem());
	view.add(showpan.pan(docview.class, "About&View"));
	
	//view.add(showpan.pantype.getMenuItem());
	mb.add(view);
	
	mf.validate();
	
	
	
	//*************** CREATE WORLD *******************
	proginf.setText("Explore Package"); progbar.setValue(progbar.getValue()+1);
	world.makeroot();
	
	JMenu sup=makeMenu("Setup");
	setup.fillMenu(sup);
	sup.add(showpan.pan(docview.class, "About&Setup"));
	
	mb.add(sup);
	mf.validate();
	
	proginf.setText("Initialise World 1"); progbar.setValue(progbar.getValue()+1);
	world w=new world("World 1");
	mb.add(new menuMaker(world.worldsob, "Worlds"));
	
	tools.add(showpan.pan(treeMaker.class));
	mf.validate();
	
	
	
	// **************** FILTER MENUS ***************
	
	proginfMenu("Panel Filter"); progbar.setValue(progbar.getValue()+1);
	mb.add(new menuMaker(world.root, "Tree"));
	mb.add(new menuMaker(world.root, "Doc"));
	mb.add(new menuMaker(world.root, "Params"));
	mb.add(new menuMaker(world.root, "Plot"));
	mb.add(new menuMaker(world.root, "Table"));
	mb.add(new menuMaker(world.root, "Map"));
	mf.validate();
	
	//************** SOURCE AND SCRIPTS MENUS **************
	
	proginfMenu("Source");
	JMenu source=new menuMaker((infob)world.root.find("jcm"), "Source");
	source.add(new menuMaker((infob)world.root.find("data"), "Data"));
	source.add(showpan.pan(docview.class, "About&Source"));
	mb.add(source);
	
	proginfMenu("Script");
	JMenu script=new menuMaker((infob)world.root.find("jcm"), "Script");
	script.add(showpan.pan(docview.class, "About&Script"));
	mb.add(script);
	
	mf.validate();
	
	
	//************************* CIRC MENU *************************
	proginfMenu("Circle");
	tools.add(new AbstractAction(getLabel("CircMenu"), iconFinder.findIcon("CircMenu")){ public void actionPerformed(ActionEvent e)  { //new JButton(
	    showpan.addwindow(new circmenu(world.worldsob) );
	}});
	tools.add(showpan.pan(docview.class, "About&Tools"));
	
	//************************* WIN MENU *************************
	final JMenu winmenu=new JMenu("Window");
	winmenu.addMenuListener(new MenuListener() {
	    public void menuSelected(MenuEvent e){
		winmenu.removeAll();
		for (final WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get()!=null && wrc.get().isShowing())
		    winmenu.add(new AbstractAction(wrc.get().getName()) {public void actionPerformed(ActionEvent e)  {
			showpan.toFront(wrc.get());
		    }} );
	    }
	    public void menuCanceled(MenuEvent e){}
	    public void menuDeselected(MenuEvent e){}
	} );
	
	mb.add(winmenu);
	
	//************* RESTORE SETUP ****************************
	
	proginf.setText("Restoring Previous Setup"); progbar.setValue(progbar.getValue()+1);
	//moved up temporarily
	
	//could pass the startdialog to the setup, to add info about what's going on?
	setup.loadsetupdefault();
	mf.validate();
	
	showpan.show(startdialog.b, "JCM5 Startup Info"); //used to call "toFront', but now layout has changed this doesn't work
	if (register.getComponentsOfType(treeMaker.class).size()==0) showpan.makepan(treeMaker.class, null);
	if (register.getComponentsOfType(docview.class).size()==0) showpan.makepan(docview.class, null);
	
	//************* POPUP MENU ****************************
	new contextMenu(mf, new menuFiller() { public void fillMenu(JPopupMenu popup) {
	    popup.add(imagesaver.copyaction(mf));
	    popup.add(imagesaver.saveimagemenu(mf, "JCM-all"));
	    popup.add(new AbstractAction("CircMenu"){ public void actionPerformed(ActionEvent e)  { showpan.addwindow(new circmenu(world.worldsob) );  }});
	}});
	
	
	//************* LAZY LOADING****************************
	/*
	 The point of below is to stimulate download of the other jars
	  (especially if using JWS),
	 */
	startinf.setText("<html><font color=yellow>JCM is now ready to use<p> Meanwhile some extra data will continue to load" );
	
	proginf.setText("Finished setup"); progbar.setValue(progbar.getValue()+1);
	
	proginf.setText("Loading labels"); progbar.setValue(progbar.getValue()+1);
	System.out.println("preloaded: "+register.class.getResource("/labdoc/doc_base_en.txt").getPath());
	proginf.setText("Loading source"); progbar.setValue(progbar.getValue()+1);
	System.out.println("preloaded: "+register.class.getResource("/source/jcm/StartJCM.java").getPath());
	proginf.setText("Loading GCM-data"); progbar.setValue(progbar.getValue()+1);
	System.out.println("preloaded: "+register.class.getResource("/data/gcmdata/basehad3.pre.dat").getPath());
	
	
	//************ REMOVE STARTUP ********************
	try {
	    proginf.setText(""); progbar.setValue(progbar.getValue()+1);
	    startinf.setText("<html><font color=green>JCM setup finished successfully"
		    +"<ul>Hints: " +
		    "<li>Look in Tools menu, <li>Drag items from the Tree, <li>Check Welcome Documentation."
		    );
	    new Thread() { public void run() {
		try { sleep(8000); }catch (InterruptedException e) {}
		showpan.dispose(startdialog.b); //remove the startup window
	    }}.start();
	    
	    //
	} catch (Exception e) { System.err.println("remove startup error " +e); }
	
	mf.validate();
	
    } //end main
    
    
    
}//end class








