/*
 * Decompiled with CFR 0.152.
 */
package jcm.tls;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import javax.swing.JFileChooser;
import jcm.core.register;
import jcm.gui.nav.showpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fileio {
    public static URL getURL(String filename) {
        return register.class.getResource("/" + filename);
    }

    public static Enumeration<JarEntry> getJarEntries(URL u) {
        try {
            JarURLConnection j = (JarURLConnection)u.openConnection();
            return j.getJarFile().entries();
        }
        catch (Exception e) {
            System.out.println("Can't find Jar of : " + u);
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getStream(String filename) {
        return register.class.getResourceAsStream("/" + filename);
    }

    public static InputStream getStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedInputStream getBuffStream(String filename) {
        return new BufferedInputStream(fileio.getStream(filename));
    }

    public static DataInputStream getDIS(String filename) {
        return new DataInputStream(fileio.getBuffStream(filename));
    }

    public static LineNumberReader getLNR(String filename) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(fileio.getStream(filename))));
    }

    public static String[][] loadtab(String filename, String separator) {
        return fileio.loadtab(new LineNumberReader(new BufferedReader(new InputStreamReader(fileio.getStream(filename)))), separator);
    }

    public static String[][] loadtab(File file, String separator) {
        return fileio.loadtab(new LineNumberReader(new BufferedReader(new InputStreamReader(fileio.getStream(file)))), separator);
    }

    public static String[][] loadtab(LineNumberReader lnr, String separator) {
        ArrayList<String[]> as = new ArrayList<String[]>();
        try {
            String s;
            while ((s = lnr.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, separator);
                ArrayList<String> a = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    a.add(st.nextToken().trim());
                }
                as.add(a.toArray(new String[a.size()]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (String[][])as.toArray((T[])new String[as.size()][]);
    }

    public static String loadstring(String filename) {
        return fileio.loadstring(filename, null);
    }

    public static String loadstring(String filename, String encoding) {
        return fileio.loadstring(fileio.getBuffStream(filename), filename, encoding);
    }

    public static String loadstring(File file) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), null);
    }

    public static String loadstring(File file, String encoding) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), encoding);
    }

    public static String loadstring(BufferedInputStream bis, String filename, String encoding) {
        StringBuffer sb = new StringBuffer();
        try {
            new InputStreamReader((InputStream)bis, encoding);
        }
        catch (Exception e) {
            encoding = null;
        }
        try {
            if (encoding != null) {
                int db;
                InputStreamReader isr = new InputStreamReader((InputStream)bis, encoding);
                while ((db = isr.read()) != -1) {
                    sb.append((char)db);
                }
                isr.close();
            } else {
                int db;
                while ((db = bis.read()) != -1) {
                    sb.append((char)db);
                }
                bis.close();
            }
        }
        catch (IOException e) {
            if (fileio.getURL(filename) == null) {
                System.out.println("Couldn't locate file: " + filename);
                return "";
            }
            System.out.println("IO Error loading " + filename + "\n" + e);
            e.printStackTrace();
            return "";
        }
        return sb.toString();
    }

    static int readnext(InputStreamReader isr) {
        try {
            return isr.read();
        }
        catch (IOException e) {
            System.out.println(" " + e.getMessage());
            try {
                isr.skip(1L);
            }
            catch (IOException e2) {
                System.out.println("noskip " + e2.getMessage());
            }
            return 0;
        }
    }

    public static String loadtextfile(String filename) {
        try {
            int db;
            StringBuffer sb = new StringBuffer();
            FileReader fr = new FileReader(filename);
            while ((db = fr.read()) != -1) {
                sb.append((char)db);
            }
            fr.close();
            return sb.toString();
        }
        catch (IOException e) {
            System.out.println("IO Error loading " + filename + "\n" + e);
            return "";
        }
    }

    public static float[] loadfloat(String a, int len) {
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(new File(a)));
            float[] f = new float[len];
            for (int i = 0; i < len; ++i) {
                f[i] = dis.readFloat();
            }
            dis.close();
            return f;
        }
        catch (IOException e) {
            System.out.println("loadfloat: " + a + " " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static File getFileFromDialog(String filename, String title, String message) {
        return fileio.getFileFromDialog("user", filename, title, message);
    }

    public static File getFileFromDialog(String dirpath, String filename, String title, String message) {
        return fileio.getFileFromDialog(showpan.mf, dirpath, filename, title, message);
    }

    public static File getFileFromDialog(Component c, String dirpath, String filename, String title, String message) {
        JFileChooser fc = dirpath == "user" ? new JFileChooser() : new JFileChooser(dirpath);
        fc.setDialogTitle(title);
        fc.setSelectedFile(new File(filename));
        if (filename.equals("")) {
            fc.setFileSelectionMode(1);
        }
        int result = message == "save" ? fc.showSaveDialog(c) : (message == "load" ? fc.showOpenDialog(c) : fc.showDialog(c, message));
        return result == 0 ? fc.getSelectedFile() : null;
    }

    public static void savetextfile(String name, String text) {
        try {
            fileio.savetextfile(new FileWriter(new File("").getPath() + name), text);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void savetextfile(File file, String text) {
        try {
            fileio.savetextfile(new FileWriter(file), text);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void savetextfile(File dir, String name, String text, String encoding) {
        try {
            fileio.savetextfile(new OutputStreamWriter((OutputStream)new FileOutputStream(dir.getPath() + "/" + name), encoding), text);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void savetextfile(OutputStreamWriter f, String text) {
        try {
            for (int a = 0; a < text.length(); a += 100) {
                int b = text.length() - a;
                f.write(text, a, b > 100 ? 100 : b);
                f.flush();
            }
            System.out.println("saved file successfully");
            f.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

