/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import jcm.core.loop;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.core.units;
import jcm.mod.carbon.CalcLucEmit;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.reg.region;
import jcm.mod.reg.regman;
import jcm.mod.soc.responsibility;
import jcm.mod.soc.socreg;
import jcm.script.calcscript;

public class contribtemp
extends calcscript {
    berncarbon bc = this.get(berncarbon.class);
    carboncycle cc = this.get(carboncycle.class);
    CalcLucEmit cl = this.get(CalcLucEmit.class);
    responsibility rs = this.get(responsibility.class);
    qtset curves1 = new qtset("Brazil. relative", 1850, 2005, 5);
    qtset curves2 = new qtset("USA relative", 1850, 2005, 5);
    qtset curves3 = new qtset("India relative", 1850, 2005, 5);
    qt tot = new qt("surftemp", "degcbase");
    qt r1 = new qt(new Object[0]);
    qt r2 = new qt(new Object[0]);
    qt r3 = new qt(new Object[0]);
    String p = "";
    region regset;

    public void run() {
        this.link(this.rs.surftemp);
        this.get(socreg.class).regions.choose(regman.allreg.find("JCM25"));
        this.regset = (region)this.get(socreg.class).regions.chosen;
        for (String lu : this.cl.lucsources) {
            this.cl.lucsource.set(lu);
            if (this.cl.lucsource.chosen.equals("Houghton")) {
                for (double cor = 1700.0; cor <= 2500.0; cor += 458.0) {
                    this.cl.landuseemit.set(cor);
                    System.err.println("Houghton emission in 2000 " + cor);
                    this.calc();
                }
                continue;
            }
            if (!this.cl.lucsource.chosen.equals("IVIGmodel")) continue;
            for (Object o : this.cl.biomeclass.menulist) {
                this.cl.biomeclass.set(o);
                System.err.print("IVIGmodel land use " + o);
                for (double vc = 0.8; vc <= 1.2; vc += 0.2) {
                    this.cl.vegetationCarbon.set(vc);
                    System.err.print(" veg carbon error " + vc);
                    for (double sa = 0.1; sa <= 0.3; sa += 0.1) {
                        this.cl.soillossagric.set(sa);
                        System.err.print(" agric soil loss " + sa);
                        for (double sp = 0.05; sp <= 0.1; sp += 0.025) {
                            this.cl.soillosspast.set(sp);
                            System.err.println(" past soil loss " + sp);
                            this.p = units.round(vc, 1.0, 1) + " " + units.round(sa, 1.0, 1) + " " + units.round(sp, 1.0, 2) + "_";
                            this.calc();
                        }
                    }
                }
            }
        }
        this.plot(this.curves2);
        this.plot(this.curves3);
        this.end();
        System.err.println("End of script contribtemp");
        this.cl.lucsource.choose("IVIGmodel");
    }

    public void calc() {
        for (double beta = 0.56; beta >= 0.0; beta -= 0.28) {
            this.bc.beta.set(beta);
            for (double respq10 = 1.0; respq10 <= 1.6; respq10 += 0.3) {
                this.bc.respq10.set(respq10);
                for (double diffu = 1.75; diffu >= 0.5; diffu -= 0.5) {
                    this.bc.diffufac.set(diffu);
                    this.checkbut();
                    loop.go();
                    String err = units.round(this.cc.error, 1.0, 0);
                    String c = " ";
                    c = this.cl.lucsource.chosen.equals("IVIGmodel") ? (this.cl.biomeclass.chosen.equals("A") ? "-A_" : "-B_") + this.p : "_" + this.cl.landuseemit.getval() + "_";
                    String name = this.cl.lucsource.chosen + c + err + "_" + beta + " " + respq10 + " " + diffu;
                    if (this.cc.error <= 700.0) {
                        this.report(name);
                        for (int y = 1850; y <= 2005; ++y) {
                            this.tot.set(y, 0.0f);
                        }
                        for (region r : this.regset.reg) {
                            for (int y = 1850; y <= 2005; ++y) {
                                this.tot.set(y, this.tot.get(y) + this.rs.surftemp.get(r, y));
                            }
                        }
                        for (int y = 1850; y <= 2005; ++y) {
                            this.r1.set(y, this.rs.surftemp.get(this.regset.find("Brazil."), y) * 100.0f / this.tot.get(y));
                            this.r2.set(y, this.rs.surftemp.get(this.regset.find("United States"), y) * 100.0f / this.tot.get(y));
                            this.r3.set(y, this.rs.surftemp.get(this.regset.find("India"), y) * 100.0f / this.tot.get(y));
                        }
                        Color col = Color.black;
                        try {
                            col = new Color(255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen.equals("A") ? 1 : 0), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen.equals("A") ? 0 : 1), (int)(5000.0 / (this.cc.error - 450.0)));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.curves1.add(this.r1.clone(1850, 2005, 5, name, col));
                        this.curves2.add(this.r2.clone(1850, 2005, 5, name, col));
                        this.curves3.add(this.r3.clone(1850, 2005, 5, name, col));
                        continue;
                    }
                    System.err.println(name + " Bypassed, error > 700!");
                }
            }
        }
    }
}

