/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import jcm.core.interacob;
import jcm.core.loop;
import jcm.core.module;
import jcm.core.param;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carbonatechemistry;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.cli.udebclimod;
import jcm.mod.obj.controller;
import jcm.mod.ogas.aerosol;
import jcm.mod.ogas.atchem;
import jcm.mod.ogas.fgas;
import jcm.mod.ogas.othgasemit;
import jcm.mod.reg.region;
import jcm.mod.soc.shares;
import jcm.mod.soc.socreg;

public class responsibility
extends module {
    public param method = new param("attmeth", new String[]{"timeslice", "normarg", "tracer"}, "tracer");
    public param differential = new param("differential", false);
    public param simplecarbon = new param("simplecarbon", false);
    public param startyear = new param("startyear", "", 1850, 1850, 2000);
    public param endyear = new param("endyear", "", 2002, 1990, 2100);
    public qtset atco2 = new qtset("atco2", "ppm");
    public qtset atch4 = new qtset("atch4", "ppb");
    public qtset atn2o = new qtset("atn2o", "ppb");
    public qtset rfco2 = new qtset("rfco2", "w&per&m2");
    public qtset rfch4 = new qtset("rfch4", "w&per&m2");
    public qtset rfn2o = new qtset("rfn2o", "w&per&m2");
    public qtset rftot = new qtset("rftot", "w&per&m2");
    public qtset surftemp = new qtset("surftemp", "degcbase");
    public qtset sealevte = new qtset("sealevte", "metres");
    boolean attrib = false;
    public int nregs;
    public int oldnregs = 0;
    public int nemit;
    public int nrf;
    public int oth;
    static final int ncb = 43;
    static final int nhb = 35;
    float[] ls;
    float[] hs;
    float[] so;
    float[] hu;
    float[][] ciq;
    float[][][] hiq;
    float[][] acccbox;
    public boolean intimesliceloop = false;
    String debug = "";
    region unattreg = new region("Before start/After End", colfont.dkgrey);
    region othgasreg = new region("F-gases+Ozone+others", colfont.greygreen);
    region aerosolreg = new region("Aerosols", colfont.cyan);
    region solvolreg = new region("Solar and Volcano", colfont.yellow);
    float sink;
    float atinc;
    float lsinc;
    float hsinc;
    float fracat;
    float fracls;
    float frachs;
    float totls;
    float toths;
    float totat;
    float npinc;
    float dls;
    float dhs;
    float dnp;
    float dat;
    float soinc;
    float huinc;
    float fracso;
    float frachu;
    float totso;
    float tothu;
    float dso;
    float dhu;
    float extrach4;
    float extran2o;
    float fracn2o;
    float dc;
    float qin;
    float qinold;
    float dqin;
    float[] rff = new float[2];
    float[] sf = new float[2];
    float[] mlt = new float[2];
    float[] boxtemp = new float[4];
    float[] fossilorig;
    float[] lucforig;
    float[] methorig;
    float[] n2oorig;
    float[] indicorig;
    float[][] indic;
    Object mitigorig;

    public void setinteractions() {
        this.follows(this.get(socreg.class));
        this.follows(this.get(shares.class));
        this.follows(this.get(radfor.class));
        this.follows(this.get(glotemp.class));
    }

    public void precalc() {
        for (qtset qq : this.qtsets) {
            this.get(socreg.class).clearoldregions(qq);
        }
        this.makearrays();
        if (!this.intimesliceloop) {
            if (this.changed && this.needed) {
                loop.calcfutureonly = false;
                this.get(carboncycle.class).changed = true;
                this.get(glotemp.class).changed = true;
            }
            if (this.startyear.getval() < 1850.0) {
                this.startyear.setval(1850.0);
            }
            if (this.endyear.getval() > 2100.0) {
                this.endyear.setval(2100.0);
            }
            this.debug = "";
        }
    }

    public void calcstep() {
        if (!this.intimesliceloop && this.method.chosen.equals("tracer")) {
            if (year > 2100) {
                return;
            }
            this.carbonstep();
            this.atchemstep();
            this.rfstep();
            this.glotempstep();
        }
    }

    public void postcalc() {
        if (!this.intimesliceloop && (this.method.chosen.equals("timeslice") || this.method.chosen.equals("normarg"))) {
            this.intimesliceloop = true;
            this.starttimeslice();
            System.out.println("timeslicing ");
            int tsy = (int)this.startyear.getval();
            while ((double)tsy <= this.endyear.getval()) {
                this.timeslicescenario(tsy);
                ++tsy;
            }
            this.endtimeslice();
            System.out.println("attributing ");
            this.attribute();
            this.intimesliceloop = false;
        }
        if (this.method.chosen.equals("tracer")) {
            System.out.println(this.debug);
        }
    }

    region reg(int nr) {
        if (nr < this.nregs) {
            return ((region)this.get(socreg.class).regions.chosen).reg.get(nr);
        }
        if (nr == this.nregs) {
            return this.unattreg;
        }
        if (nr == this.nregs + 1) {
            return this.othgasreg;
        }
        if (nr == this.nregs + 2) {
            return this.aerosolreg;
        }
        if (nr == this.nregs + 3) {
            return this.solvolreg;
        }
        return null;
    }

    public void makearrays() {
        this.nregs = ((region)this.get(socreg.class).regions.chosen).reg.size();
        if (this.nregs != this.oldnregs) {
            this.oldnregs = this.nregs;
            this.nemit = this.nregs + 1;
            this.nrf = this.nregs + 4;
            this.oth = this.nregs;
            this.ciq = new float[this.nrf][43];
            this.ls = new float[this.nrf];
            this.hs = new float[this.nrf];
            this.so = new float[this.nrf];
            this.hu = new float[this.nrf];
            this.acccbox = new float[this.nrf][4];
            this.hiq = new float[this.nrf][2][35];
        }
    }

    boolean attrib(int y) {
        return (double)y >= this.startyear.getval() && (double)y <= this.endyear.getval();
    }

    float totco2emit(region r, int y) {
        if (y < 1750) {
            return 0.0f;
        }
        if (r == this.unattreg) {
            return this.attrib(y) ? 0.0f : this.get(carboncycle.class).fossil.get(y) + this.get(carboncycle.class).lucf.get(y);
        }
        if (r == this.othgasreg || r == this.aerosolreg || r == this.solvolreg) {
            return 0.0f;
        }
        return this.attrib(y) ? this.get(socreg.class).emitfosbase.get(r, y) + this.get(socreg.class).emitlucbase.get(r, y) : 0.0f;
    }

    float ch4emit(region r, int y) {
        if (r == this.unattreg) {
            return this.attrib(y) ? 0.0f : this.get(othgasemit.class).ch4emit.get(y);
        }
        return this.attrib(y) ? this.get(socreg.class).emitch4.get(r, y) : 0.0f;
    }

    float n2oemit(region r, int y) {
        if (r == this.unattreg) {
            return this.attrib(y) ? 0.0f : this.get(othgasemit.class).n2oemit.get(y);
        }
        return this.attrib(y) ? this.get(socreg.class).emitn2o.get(r, y) : 0.0f;
    }

    void carbonstep() {
        int nr;
        if (this.get(carboncycle.class).accccarbon.istrue()) {
            if (ns == 0) {
                for (int i = 0; i < 4; ++i) {
                    this.acccbox[this.oth][i] = this.get(carboncycle.class).acccbox[i];
                    for (int nr2 = 0; nr2 < this.nregs; ++nr2) {
                        this.acccbox[nr2][i] = 0.0f;
                    }
                }
            }
            for (int nr3 = 0; nr3 < this.nrf; ++nr3) {
                this.atco2.set(this.reg(nr3), this.get(carboncycle.class).acccmod(this.acccbox[nr3], this.totco2emit(this.reg(nr3), year)));
            }
            return;
        }
        for (nr = 0; nr < this.nrf; ++nr) {
            float f;
            float fc;
            float f2;
            float ft;
            region r = this.reg(nr);
            if (ns == 0) {
                for (int n = 0; n < 43; ++n) {
                    this.ciq[nr][n] = nr == this.oth ? (float)this.get(berncarbon.class).ciq[n] : 0.0f;
                }
            }
            float f3 = ft = ns > 0 && ((double)this.get(glotemp.class).avchange.get(year - 1) > 0.1 || (double)this.get(glotemp.class).avchange.a[ns - 1] < -0.1) ? this.surftemp.get(r, year - 1) / this.get(glotemp.class).avchange.get(year - 1) : 0.0f;
            if (ns > 0 && this.get(carbonatechemistry.class).chemfeedback.istrue()) {
                float f4 = this.get(carboncycle.class).co2atppm.get(year - 1);
                this.get(carboncycle.class);
                f2 = 0.0016f * (f4 - 278.0f);
            } else {
                f2 = fc = 1.0f;
            }
            if (ns > 0) {
                float f5 = this.atco2.get(r, year - 1);
                float f6 = this.get(carboncycle.class).co2atppm.get(year - 1);
                this.get(carboncycle.class);
                f = f5 / (f6 - 278.0f);
            } else {
                f = 0.0f;
            }
            this.fracat = f;
            this.fracls = ns > 0 ? fc * this.ls[nr] / this.totls + (1.0f - fc) * ft : 0.0f;
            this.frachs = ns > 0 ? fc * this.hs[nr] / this.toths + (1.0f - fc) * ft : 0.0f;
            this.fracso = ft;
            this.frachu = ft;
            this.atco2.set(r, 0.0f);
            this.ls[nr] = 0.0f;
            this.hs[nr] = 0.0f;
            this.so[nr] = 0.0f;
            this.hu[nr] = 0.0f;
            this.lsinc = (float)this.get(berncarbon.class).oldlsinc * this.fracls;
            this.hsinc = (float)this.get(berncarbon.class).oldhsinc * this.frachs;
            this.npinc = (float)this.get(berncarbon.class).oldnpinc * this.fracat;
            this.soinc = (float)this.get(berncarbon.class).oldsoinc * this.fracso;
            this.huinc = (float)this.get(berncarbon.class).oldhuinc * this.frachu;
            this.atinc = this.totco2emit(r, year - 1) - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
            this.dls = (float)this.get(berncarbon.class).dls * this.fracls;
            this.dhs = (float)this.get(berncarbon.class).dhs * this.frachs;
            this.dnp = (float)this.get(berncarbon.class).dnp * this.fracat;
            this.dso = (float)this.get(berncarbon.class).dso * this.fracso;
            this.dhu = (float)this.get(berncarbon.class).dhu * this.frachu;
            this.dat = this.totco2emit(r, year) - this.totco2emit(r, year - 1) - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
            for (int n = 0; n < 43; ++n) {
                this.ciq[nr][n] = (float)((double)this.ciq[nr][n] * this.get(berncarbon.class).cpropf[n] + this.get(berncarbon.class).scicAT[n] * (double)this.atinc + this.get(berncarbon.class).scicLS[n] * (double)this.lsinc + this.get(berncarbon.class).scicHS[n] * (double)this.hsinc + this.get(berncarbon.class).scicNP[n] * (double)this.npinc + this.get(berncarbon.class).rcicAT[n] * (double)this.dat + this.get(berncarbon.class).rcicLS[n] * (double)this.dls + this.get(berncarbon.class).rcicHS[n] * (double)this.dhs + this.get(berncarbon.class).rcicNP[n] * (double)this.dnp + this.get(berncarbon.class).scicSO[n] * (double)this.soinc + this.get(berncarbon.class).rcicSO[n] * (double)this.dso + this.get(berncarbon.class).scicHU[n] * (double)this.huinc + this.get(berncarbon.class).rcicHU[n] * (double)this.dhu);
                this.atco2.set(r, this.atco2.get(r) + (float)this.get(berncarbon.class).crAT[n] * this.ciq[nr][n]);
                int n2 = nr;
                this.ls[n2] = this.ls[n2] + (float)this.get(berncarbon.class).crLS[n] * this.ciq[nr][n];
                int n3 = nr;
                this.hs[n3] = this.hs[n3] + (float)this.get(berncarbon.class).crHS[n] * this.ciq[nr][n];
                int n4 = nr;
                this.so[n4] = this.so[n4] + (float)this.get(berncarbon.class).crSO[n] * this.ciq[nr][n];
                int n5 = nr;
                this.hu[n5] = this.hu[n5] + (float)this.get(berncarbon.class).crHU[n] * this.ciq[nr][n];
            }
            float f7 = this.atco2.get(r);
            this.get(carboncycle.class);
            this.atco2.set(r, f7 * 4.71E-4f);
        }
        this.totls = 0.0f;
        this.toths = 0.0f;
        this.totat = 0.0f;
        this.totso = 0.0f;
        this.tothu = 0.0f;
        for (nr = 0; nr < this.nrf; ++nr) {
            this.totls += this.ls[nr];
            this.toths += this.hs[nr];
            this.totat += this.atco2.get(this.reg(nr));
            this.totso += this.so[nr];
            this.tothu += this.hu[nr];
        }
    }

    void atchemstep() {
        if (ns == 0) {
            for (int nr = 0; nr < this.nregs; ++nr) {
                this.atch4.set(this.reg(nr), 0.0f);
                this.atn2o.set(this.reg(nr), 0.0f);
            }
            float f = this.get(atchem.class).ch4conc.get();
            this.get(atchem.class);
            this.atch4.set(this.unattreg, f - atchem.ch4prein);
            this.atch4.set(this.othgasreg, 0.0f);
            this.atn2o.set(this.unattreg, this.get(atchem.class).n2oconc.get() - this.get(atchem.class).n2oprein);
        } else {
            for (int nr = 0; nr < this.nemit; ++nr) {
                region r = this.reg(nr);
                float f = this.atch4.get(r, year - 1) * (1.0f - 1.0f / this.get(atchem.class).ch4life(ns));
                this.get(atchem.class);
                this.atch4.set(r, f + atchem.ppbpmtch4 * this.ch4emit(r, year));
                this.atn2o.set(r, this.atn2o.get(r, year - 1) * (1.0f - 1.0f / this.get(atchem.class).n2olife(ns)) + this.get(atchem.class).ppbpmtn * this.n2oemit(r, year));
            }
            this.get(atchem.class);
            float f = atchem.ppbpmtch4 * this.get(atchem.class).ch4emitnat();
            this.get(atchem.class);
            this.extrach4 = f - atchem.ch4prein / this.get(atchem.class).ch4life(ns);
            this.atch4.set(this.othgasreg, this.atch4.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.get(atchem.class).ch4life(ns)) + this.extrach4);
            this.extran2o = this.get(atchem.class).ppbpmtn * this.get(atchem.class).n2oemitnat() - this.get(atchem.class).n2oprein / this.get(atchem.class).n2olife(ns);
            this.atn2o.set(this.othgasreg, this.atn2o.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.get(atchem.class).n2olife(ns)) + this.extran2o);
        }
    }

    void rfstep() {
        int nr;
        for (nr = 0; nr < this.nrf; ++nr) {
            region r = this.reg(nr);
            if (this.differential.istrue() && (double)year > this.startyear.getval() + 1.0) {
                int yy = year > 1750 ? year - 1 : 1750;
                this.dc = this.get(carboncycle.class).co2atppm.get() - this.get(carboncycle.class).co2atppm.get(yy);
                this.rfco2.set(r, yy, this.rfco2.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (this.get(carboncycle.class).co2rf.get() - this.get(carboncycle.class).co2rf.get(yy)) * (this.atco2.get(r) - this.atco2.get(r, yy)) / this.dc : 0.0f));
                if (nr >= this.nemit + 1) continue;
                this.dc = this.get(atchem.class).n2oconc.get() - this.get(atchem.class).n2oconc.get(yy);
                this.rfn2o.set(r, this.rfn2o.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (this.get(atchem.class).n2orf.get() - this.get(atchem.class).n2orf.get(yy)) * (this.atn2o.get(r) - this.atn2o.get(r, yy)) / this.dc : 0.0f));
                this.dc = this.get(atchem.class).ch4conc.get() - this.get(atchem.class).ch4conc.get(yy);
                this.rfch4.set(r, this.rfch4.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (this.get(atchem.class).ch4rf.get() - this.get(atchem.class).ch4rf.get(yy)) * (this.atch4.get(r) - this.atch4.get(r, yy)) / this.dc : 0.0f));
                continue;
            }
            float f = this.get(carboncycle.class).co2atppm.get();
            this.get(carboncycle.class);
            this.dc = f - 278.0f;
            this.rfco2.set(r, this.atco2.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? this.get(carboncycle.class).co2rf.get() / this.dc : 0.0f));
            if (nr >= this.nemit + 1) continue;
            this.dc = this.get(atchem.class).n2oconc.get() - this.get(atchem.class).n2oprein;
            this.rfn2o.set(r, this.atn2o.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? this.get(atchem.class).n2orf.get() / this.dc : 0.0f));
            float f2 = this.get(atchem.class).ch4conc.get();
            this.get(atchem.class);
            this.dc = f2 - atchem.ch4prein;
            this.rfch4.set(r, this.atch4.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? this.get(atchem.class).ch4rf.get() / this.dc : 0.0f));
        }
        for (nr = 0; nr < this.nemit; ++nr) {
            this.rftot.set(this.reg(nr), this.rfco2.get(this.reg(nr)) + this.rfch4.get(this.reg(nr)) + this.rfn2o.get(this.reg(nr)));
        }
        this.rftot.set(this.othgasreg, this.rfco2.get(this.othgasreg) + this.rfch4.get(this.othgasreg) + this.rfn2o.get(this.othgasreg) + this.get(fgas.class).cfcrf.get() + this.get(fgas.class).hfcrf.get() + this.get(atchem.class).strath2orf.get() + this.get(atchem.class).tropo3rf.get() + this.get(fgas.class).strato3rf.get());
        this.rftot.set(this.aerosolreg, this.rfco2.get(this.aerosolreg) + this.get(aerosol.class).aerorf.get());
        this.rftot.set(this.solvolreg, this.rfco2.get(this.solvolreg) + this.get(aerosol.class).natvrf.get());
    }

    void udebclimodsetup() {
        for (int o = 0; o < 2; ++o) {
            this.rff[o] = (float)(1.0 + this.get(udebclimod.class).frac[o * 3] / this.get(udebclimod.class).frac[o + 1] * this.get(udebclimod.class).klo / (this.get(udebclimod.class).kls * this.get(udebclimod.class).frac[o * 3] + this.get(udebclimod.class).klo));
            this.sf[o] = (float)(this.get(udebclimod.class).spaceflux[o] * this.get(udebclimod.class).qpt * this.get(udebclimod.class).tstart);
            for (int n = 0; n < 35; ++n) {
                for (int nr = 0; nr < this.nrf; ++nr) {
                    this.hiq[nr][o][n] = (float)(nr == this.oth ? this.get(udebclimod.class).hiq[o][n] : this.get(udebclimod.class).hiqstart[o][n]);
                }
            }
        }
    }

    void glotempstep() {
        if (ns == 0) {
            this.udebclimodsetup();
        }
        for (int nr = 0; nr < this.nrf; ++nr) {
            region r = this.reg(nr);
            this.surftemp.set(r, 0.0f);
            this.sealevte.set(r, 0.0f);
            for (int o = 0; o < 2; ++o) {
                this.mlt[o] = 0.0f;
                this.qinold = this.sf[o] + (ns > 0 ? this.rftot.get(r, year - 1) : 0.0f) * this.rff[o];
                this.qin = this.sf[o] + this.rftot.get(r) * this.rff[o];
                this.dqin = this.qin - this.qinold;
                for (int n = 0; n < 35; ++n) {
                    this.hiq[nr][o][n] = (float)(this.get(udebclimod.class).hpropf[o][n] * (double)this.hiq[nr][o][n] + this.get(udebclimod.class).shicML[o][n] * (double)this.qinold + this.get(udebclimod.class).rhicML[o][n] * (double)this.dqin);
                    int n2 = o;
                    this.mlt[n2] = this.mlt[n2] + (float)this.get(udebclimod.class).hrML[o][n] * this.hiq[nr][o][n];
                    this.sealevte.set(r, this.sealevte.get(r) + (float)this.get(udebclimod.class).hrsl[o][n] * this.hiq[nr][o][n]);
                }
                this.mlt[o] = (float)((double)this.mlt[o] / this.get(udebclimod.class).qpt - this.get(udebclimod.class).tstart);
            }
            this.sealevte.set(r, this.sealevte.get(r) - (float)this.get(udebclimod.class).sealevteinit);
            this.boxtemp[0] = (float)(((double)this.mlt[0] * this.get(udebclimod.class).cice * this.get(udebclimod.class).klo + this.get(udebclimod.class).frac[0] * (double)this.rftot.get(r)) / (this.get(udebclimod.class).kls * this.get(udebclimod.class).frac[0] + this.get(udebclimod.class).klo));
            this.boxtemp[3] = (float)(((double)this.mlt[1] * this.get(udebclimod.class).cice * this.get(udebclimod.class).klo + this.get(udebclimod.class).frac[3] * (double)this.rftot.get(r)) / (this.get(udebclimod.class).kls * this.get(udebclimod.class).frac[3] + this.get(udebclimod.class).klo));
            this.boxtemp[1] = (float)((double)this.mlt[0] * this.get(udebclimod.class).cice);
            this.boxtemp[2] = (float)((double)this.mlt[1] * this.get(udebclimod.class).cice);
            for (int i = 0; i < 4; ++i) {
                this.surftemp.set(r, this.surftemp.get(r) + (float)((double)this.boxtemp[i] * this.get(udebclimod.class).frac[i]));
            }
        }
    }

    void starttimeslice() {
        this.fossilorig = (float[])this.get(carboncycle.class).fossil.a.clone();
        this.lucforig = (float[])this.get(carboncycle.class).lucf.a.clone();
        this.methorig = (float[])this.get(othgasemit.class).ch4emit.a.clone();
        this.n2oorig = (float[])this.get(othgasemit.class).n2oemit.a.clone();
        this.indicorig = (float[])this.get(glotemp.class).avchange.a.clone();
        this.indic = new float[1 + (int)(this.endyear.getval() - this.startyear.getval())][];
        if (this.method.chosen.equals("timeslice")) {
            for (int ns = (int)this.startyear.getval() - 1750; ns <= 650; ++ns) {
                this.get(carboncycle.class).lucf.a[ns] = 0.0f;
                this.get(carboncycle.class).fossil.a[ns] = 0.0f;
            }
        }
        this.mitigorig = this.get(controller.class).objective.chosen;
        this.get(controller.class).objective.chosen = "donothing";
        loop.itc = new interacob[]{this.get(carboncycle.class)};
        loop.itn = new interacob[]{this};
    }

    void timeslicescenario(int tsy) {
        int ts = tsy - 1750;
        if (this.method.chosen.equals("timeslice")) {
            this.get(carboncycle.class).fossil.a[ts] = this.fossilorig[ts];
            this.get(carboncycle.class).lucf.a[ts] = this.lucforig[ts];
        } else {
            this.get(carboncycle.class).fossil.a[ts] = 0.0f;
            this.get(carboncycle.class).fossil.a[ts - 1] = this.fossilorig[ts - 1];
            this.get(carboncycle.class).lucf.a[ts] = 0.0f;
            this.get(carboncycle.class).lucf.a[ts - 1] = this.lucforig[ts - 1];
        }
        this.get(carboncycle.class).changed = true;
        this.indic[tsy - (int)this.startyear.getval()] = (float[])this.get(glotemp.class).avchange.a.clone();
    }

    void endtimeslice() {
        for (int ns = (int)this.startyear.getval() - 1750; ns <= 650; ++ns) {
            this.get(carboncycle.class).fossil.a[ns] = this.fossilorig[ns];
            this.get(carboncycle.class).lucf.a[ns] = this.lucforig[ns];
        }
        this.get(controller.class).objective.chosen = this.mitigorig;
        this.get(carboncycle.class).changed = true;
        loop.scin = false;
    }

    void attribute() {
        System.out.println("attributing ");
        for (int ns = 0; ns <= 650; ++ns) {
            String d = "" + (ns + 1750) + " ";
            for (int nr = 0; nr < this.nregs; ++nr) {
                this.surftemp.set(this.reg(nr), 0.0f);
            }
            for (int tsy = (int)this.startyear.getval(); tsy < (int)this.endyear.getval() && tsy < ns + 1750; ++tsy) {
                float change = this.method.chosen.equals("timeslice") ? this.indic[1 + tsy - (int)this.startyear.getval()][ns] - this.indic[tsy - (int)this.startyear.getval()][ns] : this.indicorig[ns] - this.indic[tsy - (int)this.startyear.getval()][ns];
                for (int nr = 0; nr < this.nregs; ++nr) {
                    region r = ((region)this.get(socreg.class).regions.chosen).reg.get(nr);
                    float frac = (this.get(socreg.class).emitfosbase.get(r, tsy) + this.get(socreg.class).emitlucbase.get(r, tsy)) / (this.get(carboncycle.class).fossil.get(tsy) + this.get(carboncycle.class).lucf.get(tsy));
                    this.surftemp.set(this.reg(nr), this.surftemp.get(this.reg(nr)) + change * frac);
                }
                d = d + "\t\t" + change;
            }
            System.out.println(d);
        }
    }
}

