/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.soc;

import java.awt.Color;
import jcm.core.complexity;
import jcm.core.interacob;
import jcm.core.module;
import jcm.core.qt;
import jcm.core.qtset;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.CalcLucEmit;
import jcm.mod.carbon.carboncycle;
import jcm.mod.data.histdata;
import jcm.mod.data.interpolator;
import jcm.mod.data.matchdata;
import jcm.mod.data.sres;
import jcm.mod.reg.region;
import jcm.mod.soc.socreg;

public class history
extends module {
    qtset emitfos;
    qtset emitluc;
    qtset emitch4;
    qtset emitn2o;
    qtset pop;
    qtset gdp;
    qtset energy;
    region regset;
    public static qtset fosCO2 = new qtset(new Object[]{"fosCO2", "mega&ton&carbon", 1750, 2002, complexity.expert});
    public static qtset hydepop = new qtset(new Object[]{"pop", "kilo&person", 1700, 2002, complexity.expert});
    public static float[][] jcm12pop;
    public static float[][] jcm12gdp;
    public static float[][] jcm12en;
    public qtset aviaship = new qtset(new Object[]{"aviaship", "mega&ton&carbon", 1750, 2002, complexity.expert});

    public void initsetup() {
        this.follows(this.get(CalcLucEmit.class));
        this.setaffectedby((interacob)this.get(socreg.class));
        this.makegdpen();
        this.aviaship();
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.get(carboncycle.class), this.get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") || this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton"));
    }

    public void precalc() {
        socreg socreg2 = this.get(socreg.class);
        this.emitfos = socreg2.emitfosbase;
        this.emitluc = socreg2.emitlucbase;
        this.emitch4 = socreg2.emitch4;
        this.emitn2o = socreg2.emitn2o;
        this.pop = socreg2.pop;
        this.gdp = socreg2.gdp;
        this.energy = socreg2.energy;
        this.regset = (region)socreg2.regions.chosen;
        interpolator.fillregdata(hydepop, this.pop, this.regset, 0.001f);
        new interpolator(new Object[]{jcm12gdp, "JCM12", 1900, 1, false}).fill(this.gdp, this.regset, 1900, 2000, hydepop);
        new interpolator(new Object[]{jcm12en, "JCM12", 1900, 1, false}).fill(this.energy, this.regset, 1900, 2000, hydepop);
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) {
            this.get(CalcLucEmit.class);
            interpolator.fillregdata(CalcLucEmit.edgarff, this.emitfos, this.regset, 0.001f);
        } else {
            interpolator.fillregdata(fosCO2, this.emitfos, this.regset, 0.001f);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton")) {
            float scalefactor = (float)this.get(CalcLucEmit.class).landuseemit.getval() / 2158.09f;
            Object[] objectArray = new Object[4];
            this.get(CalcLucEmit.class);
            objectArray[0] = CalcLucEmit.lucCO2Houghton;
            objectArray[1] = 1950;
            objectArray[2] = Float.valueOf(1.0f);
            objectArray[3] = Float.valueOf(scalefactor * 0.001f);
            interpolator interpolator2 = new interpolator(objectArray);
            this.get(CalcLucEmit.class);
            interpolator2.fill(this.emitluc, this.regset, 1850, 2000, CalcLucEmit.lucCO2CAIT);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) {
            this.get(CalcLucEmit.class);
            interpolator.fillregdata(CalcLucEmit.edgarluc, this.emitluc, this.regset, 0.001f);
        }
        if (this.get(CalcLucEmit.class).lucsource.chosen.equals("IVIGmodel")) {
            interpolator.fillregdata(this.get(CalcLucEmit.class).lucemit, this.emitluc, this.regset, 0.001f);
        }
        new interpolator(new Object[]{matchdata.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true}).fill(this.emitch4, this.regset, 1890, 1970, hydepop);
        new interpolator(new Object[]{matchdata.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitch4, this.regset, 1971, 2000, hydepop);
        new interpolator(new Object[]{matchdata.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true}).fill(this.emitn2o, this.regset, 1890, 1970, hydepop);
        new interpolator(new Object[]{matchdata.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true}).fill(this.emitn2o, this.regset, 1971, 2000, hydepop);
    }

    public void calcstep() {
        qt fossil = this.get(carboncycle.class).fossil;
        qt lucf = this.get(carboncycle.class).lucf;
        qt totemit = this.get(carboncycle.class).totemit;
        socreg socreg2 = this.get(socreg.class);
        if (year < 2003) {
            this.emitfos.set("bunker", this.aviaship.get("tot_in"));
            socreg2.emitfosquota.set("bunker", this.emitfos.get("bunker"));
            for (region r : this.regset.reg) {
                socreg2.emitfosquota.set(r, socreg2.emitfosbase.get(r));
                socreg2.emitlucquota.set(r, socreg2.emitlucbase.get(r));
            }
            fossil.set(this.get(socreg.class).emitfosbase.calctot());
            this.pop.calctot();
            this.gdp.calctot();
        }
        if (ns > 5 && (this.get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year < 2005 || this.get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") && year < 1850)) {
            this.get(carboncycle.class).inverseluc();
        } else if (year < 2003) {
            lucf.set(this.get(socreg.class).emitlucbase.calctot());
        }
        if (year < 2003) {
            totemit.set(fossil.get() + lucf.get());
        }
    }

    void makegdpen() {
        for (int i = 0; i < 13; ++i) {
            int j;
            for (j = 70; j < 101; ++j) {
                float[] fArray = jcm12gdp[i];
                int n = j;
                fArray[n] = fArray[n] * (0.001f * jcm12pop[i][j]);
            }
            for (j = 71; j < 101; ++j) {
                float[] fArray = jcm12en[i];
                int n = j;
                fArray[n] = fArray[n] * jcm12pop[i][j];
            }
            for (j = 0; j < 11; ++j) {
                for (int sc = 0; sc < 6; ++sc) {
                    int scg;
                    int scp = sc == 3 ? 1 : (sc == 5 ? 2 : 0);
                    int n = scg = sc > 2 ? sc - 2 : 0;
                    if (sc == 0 || sc > 2) {
                        float[] fArray = sres.jcm12gdppc[i][scg];
                        int n2 = j;
                        fArray[n2] = fArray[n2] * (0.001f * sres.jcm12pop[i][scp][j]);
                    }
                    float[] fArray = sres.jcm12enpc[i][sc];
                    int n3 = j;
                    fArray[n3] = fArray[n3] * sres.jcm12pop[i][scp][j];
                }
            }
        }
    }

    void aviaship() {
        int i;
        float r = 0.27272728f;
        String[] names = new String[]{"av_A1_in", "av_DC_in", "ma_A1_in", "ma_DC_in", "av_A1_do", "av_DC_do", "ma_A1_do", "ma_DC_do", "tot_in", "tot_do", "tot_av", "tot_ship"};
        Color[] cols = new Color[]{colfont.dkred, colfont.dkorange, colfont.dkblue, colfont.dkcyan, colfont.pink, colfont.orange, colfont.ltblue, colfont.cyan, colfont.black, colfont.grey, colfont.red, colfont.blue};
        float[] e = new float[]{205.0f * r, 123.00001f * r, 204.0f * r, 244.8f * r, 240.0f * r, 144.0f * r, 100.0f * r, 120.00001f * r, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] c1 = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 2.0f};
        float[] c2 = new float[]{4.0f, 6.0f, 0.0f, 2.0f, 4.0f, 6.0f, 0.0f, 2.0f};
        for (int i2 = 0; i2 < 12; ++i2) {
            this.aviaship.reg((Object)names[i2]).color = cols[i2];
            if (i2 <= 7) continue;
            this.aviaship.reg((Object)names[i2]).type = qt.Type.total;
        }
        float cf = 0.0f;
        for (i = 0; i < 4; ++i) {
            cf += e[i];
        }
        cf = fosCO2.calctot(2002) * 0.001f * 0.033f / cf;
        i = 0;
        while (i < 8) {
            int n = i++;
            e[n] = e[n] * cf;
        }
        for (int y = 2002; y >= 1750; --y) {
            int i3;
            float[] c = y >= 2000 ? c1 : c2;
            float rtot = fosCO2.calctot(y) / fosCO2.calctot(y + 1);
            if (y < 2002) {
                for (i3 = 0; i3 < 8; ++i3) {
                    int n = i3;
                    e[n] = e[n] * (100.0f / (100.0f + c[i3]) * rtot);
                }
            }
            e[8] = e[0] + e[1] + e[2] + e[3];
            e[9] = e[4] + e[5] + e[6] + e[7];
            e[10] = e[0] + e[1] + e[4] + e[5];
            e[11] = e[2] + e[3] + e[6] + e[7];
            for (i3 = 0; i3 < 12; ++i3) {
                this.aviaship.set(names[i3], y, e[i3]);
            }
        }
    }

    static {
        histdata.loaddata(fosCO2, "cdiacrows.csv", ",", false, 1.0f, 1750, 2000, 1750);
        histdata.oldsplit(fosCO2);
        histdata.loaddata(fosCO2, "eia_co2_emission.csv", "\t", false, 1.0f, 1980, 2002, 2001);
        histdata.loaddata(fosCO2, "UNFCCC_CO2emit.csv", ",", false, 0.27272728f, 1990, 2002, 1990);
        histdata.loaddata(hydepop, "HYDE_pop_kkg.csv", "\t", true, 1.0f, 1700, 1995, 1700);
        histdata.loaddata(hydepop, "pop2002.csv", "\t", false, 1.0f, 2002, 2002, 2002);
        interpolator.linearinterp(hydepop, 1995, 2002);
        jcm12pop = new float[14][101];
        jcm12gdp = new float[14][101];
        jcm12en = new float[14][101];
    }
}

